package nl.jixxed.eliteodysseymaterials.domain.ships.hardpoint;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.hardpoints.MultiCannonBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintGrade;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultiCannon extends HardpointModule {
    public static final MultiCannon MULTI_CANNON_1_F_F = new MultiCannon("MULTI_CANNON_1_F_F", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_1, ModuleClass.F, false, Mounting.FIXED, 9500, "Hpt_MultiCannon_Fixed_Small", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.0), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.28), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 8.615), Map.entry(HorizonsModifier.DAMAGE, 1.12), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.06), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.09), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 22.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 7.692), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.13), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 100.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 1.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_1_G_G = new MultiCannon("MULTI_CANNON_1_G_G", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_1, ModuleClass.G, false, Mounting.GIMBALLED, 14250, "Hpt_MultiCannon_Gimbal_Small", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.0), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.37), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 6.833), Map.entry(HorizonsModifier.DAMAGE, 0.82), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.07), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.1), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 22.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 8.333), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.12), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 90.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 0.7), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_1_G_T = new MultiCannon("MULTI_CANNON_1_G_T", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_1, ModuleClass.G, true, Mounting.TURRETED, 81600, "Hpt_MultiCannon_Turret_Small", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.0), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.26), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 4.0), Map.entry(HorizonsModifier.DAMAGE, 0.56), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.03), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.04), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 22.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 7.143), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.14), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 90.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 0.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon ADVANCED_MULTI_CANNON_1_F_F = new MultiCannon("ADVANCED_MULTI_CANNON_1_F_F", HorizonsBlueprintName.ADVANCED_MULTI_CANNON, ModuleSize.SIZE_1, ModuleClass.F, false, Mounting.FIXED, 9500, "Hpt_MultiCannon_Fixed_Small_Advanced", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.0), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.28), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 8.615), Map.entry(HorizonsModifier.DAMAGE, 1.12), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.06), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.09), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 22.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 7.692), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.13), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 100.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 1.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_2_E_F = new MultiCannon("MULTI_CANNON_2_E_F", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_2, ModuleClass.E, false, Mounting.FIXED, 38000, "Hpt_MultiCannon_Fixed_Medium", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.0), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.46), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 15.643), Map.entry(HorizonsModifier.DAMAGE, 2.19), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.11), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.18), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 37.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 7.143), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.14), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 100.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 2.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_2_F_G = new MultiCannon("MULTI_CANNON_2_F_G", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_2, ModuleClass.F, false, Mounting.GIMBALLED, 57000, "Hpt_MultiCannon_Gimbal_Medium", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.0), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.64), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 12.615), Map.entry(HorizonsModifier.DAMAGE, 1.64), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.14), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.2), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 37.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 7.692), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.13), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 90.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 1.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_2_F_T = new MultiCannon("MULTI_CANNON_2_F_T", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_2, ModuleClass.F, true, Mounting.TURRETED, 1292800, "Hpt_MultiCannon_Turret_Medium", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.0), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.5), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 7.313), Map.entry(HorizonsModifier.DAMAGE, 1.17), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.06), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.09), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 37.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 6.25), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.16), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 90.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 1.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon ADVANCED_MULTI_CANNON_2_E_F = new MultiCannon("ADVANCED_MULTI_CANNON_2_E_F", HorizonsBlueprintName.ADVANCED_MULTI_CANNON, ModuleSize.SIZE_2, ModuleClass.E, false, Mounting.FIXED, 38000, "Hpt_MultiCannon_Fixed_Medium_Advanced", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.0), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.46), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 15.643), Map.entry(HorizonsModifier.DAMAGE, 2.19), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.11), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.18), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 37.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 7.143), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.14), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 100.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 2.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_3_C_F = new MultiCannon("MULTI_CANNON_3_C_F", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_3, ModuleClass.C, false, Mounting.FIXED, 140400, "Hpt_MultiCannon_Fixed_Large", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.0), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.64), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 23.088), Map.entry(HorizonsModifier.DAMAGE, 3.925), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.18), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.28), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 54.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 5.882), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.17), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 100.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 3.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_3_C_G = new MultiCannon("MULTI_CANNON_3_C_G", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_3, ModuleClass.C, false, Mounting.GIMBALLED, 578440, "Hpt_MultiCannon_Gimbal_Large", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.0), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.97), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 18.933), Map.entry(HorizonsModifier.DAMAGE, 2.84), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.25), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.34), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 54.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 6.667), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.15), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 90.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 2.6), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_3_E_T = new MultiCannon("MULTI_CANNON_3_E_T", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_3, ModuleClass.E, true, Mounting.TURRETED, 3794600, "Hpt_MultiCannon_Turret_Large", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.0), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.86), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 11.737), Map.entry(HorizonsModifier.DAMAGE, 2.23), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.16), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.19), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 54.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 5.263), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.19), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 90.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 2.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_4_A_F = new MultiCannon("MULTI_CANNON_4_A_F", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_4, ModuleClass.A, false, Mounting.FIXED, 1177600, "Hpt_MultiCannon_Fixed_Huge", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.0), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.73), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 28.03), Map.entry(HorizonsModifier.DAMAGE, 4.625), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.24), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.39), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 68.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 3.03), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.33), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 100.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 2.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 4.2), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_4_A_G = new MultiCannon("MULTI_CANNON_4_A_G", HorizonsBlueprintName.MULTI_CANNON, ModuleSize.SIZE_4, ModuleClass.A, false, Mounting.GIMBALLED, 6377600, "Hpt_MultiCannon_Gimbal_Huge", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.0), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.22), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 23.3), Map.entry(HorizonsModifier.DAMAGE, 3.46), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.37), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.51), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 68.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 3.367), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.297), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 90.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 2.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 3.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon ENFORCER_CANNON_1_F_F = new MultiCannon("ENFORCER_CANNON_1_F_F", HorizonsBlueprintName.ENFORCER_MULTI_CANNON, ModuleSize.SIZE_1, ModuleClass.F, Origin.POWERPLAY, false, Mounting.FIXED, 14250, "Hpt_MultiCannon_Fixed_Small_Strong", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.0), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.28), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 12.391), Map.entry(HorizonsModifier.DAMAGE, 2.85), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.12), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.18), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 30.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4500.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1800.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 4.348), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.23), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 60.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 1000.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 2.6), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0)));
    public static final MultiCannon MULTI_CANNON_2_E_F_PRE = new MultiCannon("MULTI_CANNON_2_E_F_PRE", HorizonsBlueprintName.MULTI_CANNON_PRE, ModuleSize.SIZE_2, ModuleClass.E, false, Mounting.FIXED, 0, "Hpt_MultiCannon_Fixed_Medium", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.0), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.46), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 15.642858), Map.entry(HorizonsModifier.DAMAGE, 2.19), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.11), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.18), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 37.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1600.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, 7.142857), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.14), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 100.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 2.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2000.0), Map.entry(HorizonsModifier.JITTER, 0.0), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING, false), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED, false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL, false), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED, false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS, false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED, false), Map.entry(HorizonsModifier.AMMO_COST, 1.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT,1.0)));

    static {
        MULTI_CANNON_2_E_F_PRE.getModifications().add(
                new Modification(HorizonsBlueprintType.RAPID_FIRE_MODIFICATION_PHASING_SEQUENCE, 1.0, HorizonsBlueprintGrade.GRADE_5)
        );
    }

    public static final List<MultiCannon> MULTI_CANNONS = List.of(
            MULTI_CANNON_1_F_F,
            MULTI_CANNON_1_G_G,
            MULTI_CANNON_1_G_T,
            ADVANCED_MULTI_CANNON_1_F_F,
            MULTI_CANNON_2_E_F,
            MULTI_CANNON_2_F_G,
            MULTI_CANNON_2_F_T,
            ADVANCED_MULTI_CANNON_2_E_F,
            MULTI_CANNON_3_C_F,
            MULTI_CANNON_3_C_G,
            MULTI_CANNON_3_E_T,
            MULTI_CANNON_4_A_F,
            MULTI_CANNON_4_A_G,
            ENFORCER_CANNON_1_F_F,
            MULTI_CANNON_2_E_F_PRE
    );

    public MultiCannon(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public MultiCannon(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public MultiCannon(MultiCannon multiCannon) {
        super(multiCannon);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        if (isPreEngineered()) {
            return Collections.emptyList();
        }
        return MultiCannonBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        if (isPreEngineered()) {
            return Collections.emptyList();
        }
        return ExperimentalEffectBlueprints.MULTI_CANNON.keySet().stream().toList();
    }

    @Override
    public MultiCannon Clone() {
        return new MultiCannon(this);
    }

    @Override
    public String getClarifier() {
        if (ENFORCER_CANNON_1_F_F.equals(this)) {
            return " " + LocaleService.getLocalizedStringForCurrentLocale(getName().getLocalizationKey());
        }
        return super.getClarifier();
    }

    @Override
    public boolean isPreEngineered() {
        return HorizonsBlueprintName.MULTI_CANNON_PRE.equals(this.getName());
    }

    @Override
    public boolean isAdvanced() {
        return ADVANCED_MULTI_CANNON_1_F_F.equals(this) || ADVANCED_MULTI_CANNON_2_E_F.equals(this);
    }

    @Override
    public boolean isCGExclusive() {
        return isPreEngineered();
    }

    @Override
    public int getGrouping() {
        return switch (getId()) {
            case "MULTI_CANNON_1_F_F", "ADVANCED_MULTI_CANNON_1_F_F" -> 1;
            case "MULTI_CANNON_1_G_G", "MULTI_CANNON_1_G_T" -> 2;
            case "ENFORCER_CANNON_1_F_F" -> 3;
            case "MULTI_CANNON_2_E_F", "ADVANCED_MULTI_CANNON_2_E_F" -> 4;
            case "MULTI_CANNON_2_F_G", "MULTI_CANNON_2_F_T" -> 5;
            case "MULTI_CANNON_2_E_F_PRE" -> 6;
            case "MULTI_CANNON_3_C_F", "MULTI_CANNON_3_C_G", "MULTI_CANNON_3_E_T" -> 7;
            case "MULTI_CANNON_4_A_F", "MULTI_CANNON_4_A_G" -> 8;
            default -> 0;
        };
    }
}
