package nl.jixxed.eliteodysseymaterials.domain.ships.hardpoint;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.hardpoints.FragmentCannonBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.List;
import java.util.Map;

public class FragmentCannon extends HardpointModule {
    public static final FragmentCannon FRAGMENT_CANNON_1_E_F       = new FragmentCannon("FRAGMENT_CANNON_1_E_F"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_1, ModuleClass.E, false, Mounting.FIXED    ,      36000, "Hpt_Slugshot_Fixed_Small"      , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.45), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 95.333), Map.entry(HorizonsModifier.DAMAGE,  1.430), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.210), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.41), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 5.556), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.180), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  1.3), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_1_E_G       = new FragmentCannon("FRAGMENT_CANNON_1_E_G"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_1, ModuleClass.E, false, Mounting.GIMBALLED,      54720, "Hpt_Slugshot_Gimbal_Small"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.59), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 71.294), Map.entry(HorizonsModifier.DAMAGE,  1.010), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.260), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.44), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 5.882), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.170), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  0.9), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_1_E_T       = new FragmentCannon("FRAGMENT_CANNON_1_E_T"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_1, ModuleClass.E, true , Mounting.TURRETED ,     182400, "Hpt_Slugshot_Turret_Small"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.42), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 39.429), Map.entry(HorizonsModifier.DAMAGE,  0.690), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.100), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.20), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 4.762), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.210), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  0.6), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_2_A_F       = new FragmentCannon("FRAGMENT_CANNON_2_A_F"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_2, ModuleClass.A, false, Mounting.FIXED    ,     291840, "Hpt_Slugshot_Fixed_Medium"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.74), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 179.100), Map.entry(HorizonsModifier.DAMAGE,  2.985), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.370), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.74), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  30.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 5.000), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.200), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  2.7), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_2_D_G       = new FragmentCannon("FRAGMENT_CANNON_2_D_G"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_2, ModuleClass.D, false, Mounting.GIMBALLED,     437760, "Hpt_Slugshot_Gimbal_Medium"    , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.03), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 143.621), Map.entry(HorizonsModifier.DAMAGE,  2.274), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.490), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.84), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  30.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 5.263), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.190), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  2.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_2_D_T       = new FragmentCannon("FRAGMENT_CANNON_2_D_T"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_2, ModuleClass.D, true , Mounting.TURRETED ,    1459200, "Hpt_Slugshot_Turret_Medium"    , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.79), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 87.130), Map.entry(HorizonsModifier.DAMAGE,  1.670), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.210), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.41), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  30.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 4.348), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.230), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  1.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_3_C_F       = new FragmentCannon("FRAGMENT_CANNON_3_C_F"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_3, ModuleClass.C, false, Mounting.FIXED    ,    1167360, "Hpt_Slugshot_Fixed_Large"      , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.02), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 249.273), Map.entry(HorizonsModifier.DAMAGE,  4.570), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.570), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.13), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  45.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 4.545), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.220), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  4.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_3_C_G       = new FragmentCannon("FRAGMENT_CANNON_3_C_G"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_3, ModuleClass.C, false, Mounting.GIMBALLED,    1751040, "Hpt_Slugshot_Gimbal_Large"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.55), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 215.429), Map.entry(HorizonsModifier.DAMAGE,  3.770), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.810), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.40), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  45.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 4.762), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.210), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  3.4), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon FRAGMENT_CANNON_3_C_T       = new FragmentCannon("FRAGMENT_CANNON_3_C_T"     , HorizonsBlueprintName.FRAGMENT_CANNON         , ModuleSize.SIZE_3, ModuleClass.C, true , Mounting.TURRETED ,    5836800, "Hpt_Slugshot_Turret_Large"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.29), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 143.280), Map.entry(HorizonsModifier.DAMAGE,  2.985), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.370), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.74), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  45.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 2000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  667.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 4.000), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.250), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  2.7), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 5.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 1800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final FragmentCannon PACIFIER_FRAG_CANNON_3_C_F  = new FragmentCannon("PACIFIER_FRAG_CANNON_3_C_F", HorizonsBlueprintName.PACIFIER_FRAGMENT_CANNON, ModuleSize.SIZE_3, ModuleClass.C, Origin.POWERPLAY, false, Mounting.FIXED    ,    1751040, "Hpt_Slugshot_Fixed_Large_Range", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.02), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 216.000), Map.entry(HorizonsModifier.DAMAGE,  3.960), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.570), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.13), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  45.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1000.0), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 4.545), Map.entry(HorizonsModifier.BURST_INTERVAL, 0.220), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  3.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  180.0), Map.entry(HorizonsModifier.ROUNDS_PER_SHOT, 12.0), Map.entry(HorizonsModifier.BURST_SIZE, 1.0), Map.entry(HorizonsModifier.RELOAD_TIME, 5.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,  3.6), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.80), Map.entry(HorizonsModifier.JITTER, 1.7), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 2800.0), Map.entry(HorizonsModifier.AMMO_COST, 17.0), Map.entry(HorizonsModifier.TARGET_ARMOR_HARDNESS_REDUCED,false), Map.entry(HorizonsModifier.EFFECTIVENESS_INCREASE_AGAINST_MUNITIONS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_THERMAL,false), Map.entry(HorizonsModifier.TARGET_SENSOR_ACUITY_REDUCED,false), Map.entry(HorizonsModifier.TARGET_SPEED_REDUCED,false)));
    public static final List<FragmentCannon> FRAGMENT_CANNONS = List.of(
            FRAGMENT_CANNON_1_E_F,
            FRAGMENT_CANNON_1_E_G,
            FRAGMENT_CANNON_1_E_T,
            FRAGMENT_CANNON_2_A_F,
            FRAGMENT_CANNON_2_D_G,
            FRAGMENT_CANNON_2_D_T,
            FRAGMENT_CANNON_3_C_F,
            FRAGMENT_CANNON_3_C_G,
            FRAGMENT_CANNON_3_C_T,
            PACIFIER_FRAG_CANNON_3_C_F
    );

    public FragmentCannon(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public FragmentCannon(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public FragmentCannon(FragmentCannon fragmentCannon) {
        super(fragmentCannon);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return FragmentCannonBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return ExperimentalEffectBlueprints.FRAGMENT_CANNON.keySet().stream().toList();
    }

    @Override
    public FragmentCannon Clone() {
        return new FragmentCannon(this);
    }
    @Override
    public String getClarifier() {
        if(PACIFIER_FRAG_CANNON_3_C_F.equals(this)){
            return " " + LocaleService.getLocalizedStringForCurrentLocale(getName().getLocalizationKey());
        }
        return super.getClarifier();
    }
}
