package nl.jixxed.eliteodysseymaterials.domain.ships.hardpoint;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.hardpoints.CannonBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.List;
import java.util.Map;

public class Cannon extends HardpointModule {
    public static final Cannon CANNON_1_D_F = new Cannon("CANNON_1_D_F", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_1, ModuleClass.D, false, Mounting.FIXED    ,   21100, "Hpt_Cannon_Fixed_Small"  ,Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.34), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 11.250), Map.entry(HorizonsModifier.DAMAGE, 22.500), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.460), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.38), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1200.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.500), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.000), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  6.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  120.0), Map.entry(HorizonsModifier.RELOAD_TIME, 3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 21.4), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 3000.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_1_E_G = new Cannon("CANNON_1_E_G", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_1, ModuleClass.E, false, Mounting.GIMBALLED,   42200, "Hpt_Cannon_Gimbal_Small" ,Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.38), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  8.292), Map.entry(HorizonsModifier.DAMAGE, 15.920), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.480), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.25), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1000.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.521), Map.entry(HorizonsModifier.BURST_INTERVAL, 1.920), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  5.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 15.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 3000.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_1_F_T = new Cannon("CANNON_1_F_T", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_1, ModuleClass.F, true , Mounting.TURRETED ,  506400, "Hpt_Cannon_Turret_Small" ,Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.32), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  5.528), Map.entry(HorizonsModifier.DAMAGE, 12.770), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.220), Map.entry(HorizonsModifier.THERMAL_LOAD, 0.67), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3000.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1000.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.433), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.310), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  5.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 12.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 3000.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_2_D_F = new Cannon("CANNON_2_D_F", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_2, ModuleClass.D, false, Mounting.FIXED    ,  168430, "Hpt_Cannon_Fixed_Medium" ,Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.49), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 16.993), Map.entry(HorizonsModifier.DAMAGE, 36.875), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.700), Map.entry(HorizonsModifier.THERMAL_LOAD, 2.11), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  50.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3500.0), Map.entry(HorizonsModifier.SHOT_SPEED, 1051.051), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.461), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.170), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  6.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  120.0), Map.entry(HorizonsModifier.RELOAD_TIME, 3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 35.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 3500.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_2_D_G = new Cannon("CANNON_2_D_G", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_2, ModuleClass.D, false, Mounting.GIMBALLED,  337600, "Hpt_Cannon_Gimbal_Medium",Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.54), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 12.274), Map.entry(HorizonsModifier.DAMAGE, 25.530), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.750), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.92), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  50.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3500.0), Map.entry(HorizonsModifier.SHOT_SPEED,  875.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.481), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.080), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  5.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 24.3), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 3500.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CONCORD_CANNON_2_D_G = new Cannon("CONCORD_CANNON_2_D_G", HorizonsBlueprintName.CONCORD_CANNON, ModuleSize.SIZE_2, ModuleClass.D, Origin.POWERPLAY, false, Mounting.GIMBALLED,  337600, "Hpt_Cannon_Gimbal_Medium_Burst",Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.64), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 15.9), Map.entry(HorizonsModifier.DAMAGE, 15.9), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.750), Map.entry(HorizonsModifier.THERMAL_LOAD, Double.NaN), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  42.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3500.0), Map.entry(HorizonsModifier.SHOT_SPEED,  1300.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 1.1), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 4.0), Map.entry(HorizonsModifier.BURST_INTERVAL, Double.NaN), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  9.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  300.0), Map.entry(HorizonsModifier.RELOAD_TIME, Double.NaN),  Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 3500.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_2_E_T = new Cannon("CANNON_2_E_T", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_2, ModuleClass.E, true , Mounting.TURRETED , 4051200, "Hpt_Cannon_Turret_Medium",Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.45), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  7.916), Map.entry(HorizonsModifier.DAMAGE, 19.790), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.340), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.03), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  50.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 3500.0), Map.entry(HorizonsModifier.SHOT_SPEED,  875.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.400), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.500), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  5.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 18.8), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 3500.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_3_C_F = new Cannon("CANNON_3_C_F", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_3, ModuleClass.C, false, Mounting.FIXED    ,  675200, "Hpt_Cannon_Fixed_Large"  ,Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.67), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 23.372), Map.entry(HorizonsModifier.DAMAGE, 55.625), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 1.070), Map.entry(HorizonsModifier.THERMAL_LOAD, 3.20), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  70.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  959.233), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.420), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.380), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  6.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  120.0), Map.entry(HorizonsModifier.RELOAD_TIME, 3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 52.8), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 4000.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_3_C_G = new Cannon("CANNON_3_C_G", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_3, ModuleClass.C, false, Mounting.GIMBALLED, 1350400, "Hpt_Cannon_Gimbal_Large" ,Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.75), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 16.485), Map.entry(HorizonsModifier.DAMAGE, 37.421), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 1.140), Map.entry(HorizonsModifier.THERMAL_LOAD, 2.93), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  70.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  800.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.441), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.270), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  5.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 35.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 4000.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_3_D_T = new Cannon("CANNON_3_D_T", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_3, ModuleClass.D, true , Mounting.TURRETED ,16204800, "Hpt_Cannon_Turret_Large" ,Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.64), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 11.154), Map.entry(HorizonsModifier.DAMAGE, 30.340), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 0.530), Map.entry(HorizonsModifier.THERMAL_LOAD, 1.58), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  70.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4000.0), Map.entry(HorizonsModifier.SHOT_SPEED,  800.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.368), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.720), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  5.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 28.8), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 4000.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_4_B_F = new Cannon("CANNON_4_B_F", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_4, ModuleClass.B, false, Mounting.FIXED    , 2700800, "Hpt_Cannon_Fixed_Huge"   ,Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.92), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 31.606), Map.entry(HorizonsModifier.DAMAGE, 83.125), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 1.610), Map.entry(HorizonsModifier.THERMAL_LOAD, 4.83), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  90.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4500.0), Map.entry(HorizonsModifier.SHOT_SPEED,  900.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.380), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.630), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  6.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  120.0), Map.entry(HorizonsModifier.RELOAD_TIME, 3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 79.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 4500.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));
    public static final Cannon CANNON_4_B_G = new Cannon("CANNON_4_B_G", HorizonsBlueprintName.CANNON, ModuleSize.SIZE_4, ModuleClass.B, false, Mounting.GIMBALLED, 5401600, "Hpt_Cannon_Gimbal_Huge"  ,Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.03), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 22.636), Map.entry(HorizonsModifier.DAMAGE, 56.590), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW, 1.720), Map.entry(HorizonsModifier.THERMAL_LOAD, 4.43), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  90.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE, 4500.0), Map.entry(HorizonsModifier.SHOT_SPEED,  750.0  ), Map.entry(HorizonsModifier.RATE_OF_FIRE, 0.400), Map.entry(HorizonsModifier.BURST_INTERVAL, 2.500), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE,  5.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM,  100.0), Map.entry(HorizonsModifier.RELOAD_TIME, 4.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 53.8), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.90), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO, 1.0), Map.entry(HorizonsModifier.EXPLOSIVE_DAMAGE_RATIO, 0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START, 4500.0), Map.entry(HorizonsModifier.AMMO_COST, 20.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_PUSHED_OFF_COURSE,false), Map.entry(HorizonsModifier.NO_DAMAGE_TO_UNTARGETED_SHIPS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_EXPLOSIVE,false), Map.entry(HorizonsModifier.TARGET_GIMBAL_TURRET_TRACKING_REDUCED,false), Map.entry(HorizonsModifier.SHIELDED_TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.AUTO_RELOAD_WHILE_FIRING,false)));

    public static final List<Cannon> CANNONS = List.of(
            CANNON_1_D_F,
            CANNON_1_E_G,
            CANNON_1_F_T,
            CANNON_2_D_F,
            CANNON_2_D_G,
            CANNON_2_E_T,
            CANNON_3_C_F,
            CANNON_3_C_G,
            CANNON_3_D_T,
            CANNON_4_B_F,
            CANNON_4_B_G,
            CONCORD_CANNON_2_D_G
    );
    public Cannon(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public Cannon(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public Cannon(Cannon cannon) {
        super(cannon);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        if(CONCORD_CANNON_2_D_G.equals(this)) {
            return List.of();
        }
        return CannonBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        if(CONCORD_CANNON_2_D_G.equals(this)) {
            return List.of();
        }
        return ExperimentalEffectBlueprints.CANNON.keySet().stream().toList();
    }

    @Override
    public Cannon Clone() {
        return new Cannon(this);
    }
    @Override
    public String getClarifier() {
        if(CONCORD_CANNON_2_D_G.equals(this)){
            return " " + LocaleService.getLocalizedStringForCurrentLocale(getName().getLocalizationKey());
        }
        return super.getClarifier();
    }
}
