package nl.jixxed.eliteodysseymaterials.domain.ships.hardpoint;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.hardpoints.BurstLaserBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.List;
import java.util.Map;

public class BurstLaser extends HardpointModule {
    public static final BurstLaser BURST_LASER_1_F_F               = new BurstLaser("BURST_LASER_1_E_F"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_1, ModuleClass.F,                  false, Mounting.FIXED    ,       4400, "Hpt_PulseLaserBurst_Fixed_Small"        , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.65), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 8.147), Map.entry(HorizonsModifier.DAMAGE, 1.720), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.250), Map.entry(HorizonsModifier.THERMAL_LOAD,0.38), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,4.737), Map.entry(HorizonsModifier.BURST_INTERVAL,0.500), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,15.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 1.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_1_G_G               = new BurstLaser("BURST_LASER_1_E_G"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_1, ModuleClass.G,                  false, Mounting.GIMBALLED,       8600, "Hpt_PulseLaserBurst_Gimbal_Small"       , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.64), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 6.448), Map.entry(HorizonsModifier.DAMAGE, 1.220), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.240), Map.entry(HorizonsModifier.THERMAL_LOAD,0.34), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,5.285), Map.entry(HorizonsModifier.BURST_INTERVAL,0.450), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,17.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 1.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_1_G_T               = new BurstLaser("BURST_LASER_1_F_T"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_1, ModuleClass.G,                  true , Mounting.TURRETED ,      52800, "Hpt_PulseLaserBurst_Turret_Small"       , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.60), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 4.174), Map.entry(HorizonsModifier.DAMAGE, 0.870), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.139), Map.entry(HorizonsModifier.THERMAL_LOAD,0.19), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,4.798), Map.entry(HorizonsModifier.BURST_INTERVAL,0.520), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,19.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 0.4), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_2_E_F               = new BurstLaser("BURST_LASER_2_D_F"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_2, ModuleClass.E,                  false, Mounting.FIXED    ,      23000, "Hpt_PulseLaserBurst_Fixed_Medium"       , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,1.05), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,13.045), Map.entry(HorizonsModifier.DAMAGE, 3.530), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.500), Map.entry(HorizonsModifier.THERMAL_LOAD,0.78), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,3.695), Map.entry(HorizonsModifier.BURST_INTERVAL,0.630), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,11.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 3.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_2_F_G               = new BurstLaser("BURST_LASER_2_D_G"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_2, ModuleClass.F,                  false, Mounting.GIMBALLED,      48500, "Hpt_PulseLaserBurst_Gimbal_Medium"      , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,1.04), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,10.296), Map.entry(HorizonsModifier.DAMAGE, 2.450), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.490), Map.entry(HorizonsModifier.THERMAL_LOAD,0.67), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,4.203), Map.entry(HorizonsModifier.BURST_INTERVAL,0.560), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,13.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 2.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_2_F_T               = new BurstLaser("BURST_LASER_2_E_T"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_2, ModuleClass.F,                  true , Mounting.TURRETED ,     162800, "Hpt_PulseLaserBurst_Turret_Medium"      , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.98), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 6.760), Map.entry(HorizonsModifier.DAMAGE, 1.720), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.275), Map.entry(HorizonsModifier.THERMAL_LOAD,0.38), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,3.930), Map.entry(HorizonsModifier.BURST_INTERVAL,0.630), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,15.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 0.9), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_3_D_F               = new BurstLaser("BURST_LASER_3_C_F"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_3, ModuleClass.D,                  false, Mounting.FIXED    ,     140400, "Hpt_PulseLaserBurst_Fixed_Large"        , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY,64.0), Map.entry(HorizonsModifier.POWER_DRAW,1.66), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,20.785), Map.entry(HorizonsModifier.DAMAGE, 7.730), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,1.110), Map.entry(HorizonsModifier.THERMAL_LOAD,1.70), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 52.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,2.689), Map.entry(HorizonsModifier.BURST_INTERVAL,0.830), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 7.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 3.9), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_3_E_G               = new BurstLaser("BURST_LASER_3_C_G"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_3, ModuleClass.E,                  false, Mounting.GIMBALLED,     281600, "Hpt_PulseLaserBurst_Gimbal_Large"       , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY,64.0), Map.entry(HorizonsModifier.POWER_DRAW,1.65), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,16.605), Map.entry(HorizonsModifier.DAMAGE, 5.160), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,1.030), Map.entry(HorizonsModifier.THERMAL_LOAD,1.42), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 52.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,3.218), Map.entry(HorizonsModifier.BURST_INTERVAL,0.710), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 9.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 4.4), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_3_E_T               = new BurstLaser("BURST_LASER_3_D_T"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_3, ModuleClass.E,                  true , Mounting.TURRETED ,     800400, "Hpt_PulseLaserBurst_Turret_Large"       , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY,64.0), Map.entry(HorizonsModifier.POWER_DRAW,1.57), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,11.010), Map.entry(HorizonsModifier.DAMAGE, 3.530), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.560), Map.entry(HorizonsModifier.THERMAL_LOAD,0.78), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 52.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,3.119), Map.entry(HorizonsModifier.BURST_INTERVAL,0.780), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,11.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 1.8), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.60), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_4_E_F               = new BurstLaser("BURST_LASER_4_A_F"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_4, ModuleClass.E,                  false, Mounting.FIXED    ,     281600, "Hpt_PulseLaserBurst_Fixed_Huge"         , Map.ofEntries(Map.entry(HorizonsModifier.MASS,16.00), Map.entry(HorizonsModifier.INTEGRITY,80.0), Map.entry(HorizonsModifier.POWER_DRAW,2.58), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,32.259), Map.entry(HorizonsModifier.DAMAGE,20.610), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,2.980), Map.entry(HorizonsModifier.THERMAL_LOAD,4.53), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 65.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,1.565), Map.entry(HorizonsModifier.BURST_INTERVAL,1.250), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 3.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,17.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser BURST_LASER_4_E_G               = new BurstLaser("BURST_LASER_4_A_G"              , HorizonsBlueprintName.BURST_LASER              , ModuleSize.SIZE_4, ModuleClass.E,                  false, Mounting.GIMBALLED,    1245600, "Hpt_PulseLaserBurst_Gimbal_Huge"        , Map.ofEntries(Map.entry(HorizonsModifier.MASS,16.00), Map.entry(HorizonsModifier.INTEGRITY,64.0), Map.entry(HorizonsModifier.POWER_DRAW,2.59), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,25.907), Map.entry(HorizonsModifier.DAMAGE,12.090), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,2.410), Map.entry(HorizonsModifier.THERMAL_LOAD,3.33), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 65.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,2.143), Map.entry(HorizonsModifier.BURST_INTERVAL,1.000), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE, 5.0), Map.entry(HorizonsModifier.BURST_SIZE,3.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,10.3), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,500.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final BurstLaser CYTOSCRAMBLER_BURST_LASER_1_F_F = new BurstLaser("CYTOSCRAMBLER_BURST_LASER_1_E_F", HorizonsBlueprintName.CYTOSCRAMBLER_BURST_LASER, ModuleSize.SIZE_1, ModuleClass.F, Origin.POWERPLAY,false, Mounting.FIXED    ,       8800, "Hpt_PulseLaserBurst_Fixed_Small_Scatter", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.80), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,27.429), Map.entry(HorizonsModifier.DAMAGE, 3.600), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,0.310), Map.entry(HorizonsModifier.THERMAL_LOAD,0.28), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  1.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,1000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,7.619), Map.entry(HorizonsModifier.BURST_INTERVAL,0.700), Map.entry(HorizonsModifier.BURST_RATE_OF_FIRE,20.0), Map.entry(HorizonsModifier.BURST_SIZE,8.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 3.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE, 0.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE, 0.0), Map.entry(HorizonsModifier.JITTER, 1.70), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.KINETIC_DAMAGE_RATIO,0.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.DAMAGE_PARTIALLY_KINETIC,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final List<BurstLaser> BURST_LASERS = List.of(
        BURST_LASER_1_F_F,
        BURST_LASER_1_G_G,
        BURST_LASER_1_G_T,
        BURST_LASER_2_E_F,
        BURST_LASER_2_F_G,
        BURST_LASER_2_F_T,
        BURST_LASER_3_D_F,
        BURST_LASER_3_E_G,
        BURST_LASER_3_E_T,
        BURST_LASER_4_E_F,
        BURST_LASER_4_E_G,
        CYTOSCRAMBLER_BURST_LASER_1_F_F
    );
    public BurstLaser(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public BurstLaser(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public BurstLaser(BurstLaser burstLaser) {
        super(burstLaser);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return BurstLaserBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return ExperimentalEffectBlueprints.BURST_LASER.keySet().stream().toList();
    }

    @Override
    public BurstLaser Clone() {
        return new BurstLaser(this);
    }
    @Override
    public String getClarifier() {
        if(CYTOSCRAMBLER_BURST_LASER_1_F_F.equals(this)){
            return " " + LocaleService.getLocalizedStringForCurrentLocale(getName().getLocalizationKey());
        }
        return super.getClarifier();
    }
}
