package nl.jixxed.eliteodysseymaterials.domain.ships.hardpoint;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.hardpoints.BeamLaserBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.List;
import java.util.Map;

public class BeamLaser extends HardpointModule {
    public static final BeamLaser BEAM_LASER_1_E_F            = new BeamLaser("BEAM_LASER_1_E_F"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_1, ModuleClass.E,                   false, Mounting.FIXED    ,     37430, "Hpt_BeamLaser_Fixed_Small"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.62), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 9.820), Map.entry(HorizonsModifier.DAMAGE, 9.820), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,1.940), Map.entry(HorizonsModifier.THERMAL_LOAD, 3.53), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 18.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 7.9), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_1_E_G            = new BeamLaser("BEAM_LASER_1_E_G"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_1, ModuleClass.E,                   false, Mounting.GIMBALLED,     74650, "Hpt_BeamLaser_Gimbal_Small"    , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.60), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 7.680), Map.entry(HorizonsModifier.DAMAGE, 7.680), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,2.110), Map.entry(HorizonsModifier.THERMAL_LOAD, 3.65), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 18.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 6.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_1_F_T            = new BeamLaser("BEAM_LASER_1_F_T"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_1, ModuleClass.F,                   true , Mounting.TURRETED ,    500000, "Hpt_BeamLaser_Turret_Small"    , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.57), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 5.400), Map.entry(HorizonsModifier.DAMAGE, 5.400), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,1.320), Map.entry(HorizonsModifier.THERMAL_LOAD, 2.40), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 18.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 4.3), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_2_D_F            = new BeamLaser("BEAM_LASER_2_D_F"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_2, ModuleClass.D,                   false, Mounting.FIXED    ,    299520, "Hpt_BeamLaser_Fixed_Medium"    , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY,51.0), Map.entry(HorizonsModifier.POWER_DRAW,1.01), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,15.960), Map.entry(HorizonsModifier.DAMAGE,15.960), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,3.160), Map.entry(HorizonsModifier.THERMAL_LOAD, 5.11), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,12.8), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_2_D_G            = new BeamLaser("BEAM_LASER_2_D_G"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_2, ModuleClass.D,                   false, Mounting.GIMBALLED,    500600, "Hpt_BeamLaser_Gimbal_Medium"   , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY,51.0), Map.entry(HorizonsModifier.POWER_DRAW,1.00), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,12.520), Map.entry(HorizonsModifier.DAMAGE,12.520), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,3.440), Map.entry(HorizonsModifier.THERMAL_LOAD, 5.32), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,10.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_2_E_T            = new BeamLaser("BEAM_LASER_2_E_T"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_2, ModuleClass.E,                   true , Mounting.TURRETED ,   2099900, "Hpt_BeamLaser_Turret_Medium"   , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY,51.0), Map.entry(HorizonsModifier.POWER_DRAW,0.93), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 8.830), Map.entry(HorizonsModifier.DAMAGE, 8.830), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,2.160), Map.entry(HorizonsModifier.THERMAL_LOAD, 3.53), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 7.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_3_C_F            = new BeamLaser("BEAM_LASER_3_C_F"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_3, ModuleClass.C,                   false, Mounting.FIXED    ,   1177600, "Hpt_BeamLaser_Fixed_Large"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY,64.0), Map.entry(HorizonsModifier.POWER_DRAW,1.62), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,25.780), Map.entry(HorizonsModifier.DAMAGE,25.780), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,5.100), Map.entry(HorizonsModifier.THERMAL_LOAD, 7.22), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 50.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,20.6), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_3_C_G            = new BeamLaser("BEAM_LASER_3_C_G"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_3, ModuleClass.C,                   false, Mounting.GIMBALLED,   2396160, "Hpt_BeamLaser_Gimbal_Large"    , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY,64.0), Map.entry(HorizonsModifier.POWER_DRAW,1.60), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,20.300), Map.entry(HorizonsModifier.DAMAGE,20.300), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,5.580), Map.entry(HorizonsModifier.THERMAL_LOAD, 7.61), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 50.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,16.2), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_3_D_T            = new BeamLaser("BEAM_LASER_3_D_T"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_3, ModuleClass.D,                   true , Mounting.TURRETED ,  19399600, "Hpt_BeamLaser_Turret_Large"    , Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY,64.0), Map.entry(HorizonsModifier.POWER_DRAW,1.51), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,14.360), Map.entry(HorizonsModifier.DAMAGE,14.360), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,3.510), Map.entry(HorizonsModifier.THERMAL_LOAD, 5.11), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 50.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,11.5), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_4_A_F            = new BeamLaser("BEAM_LASER_4_A_F"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_4, ModuleClass.A,                   false, Mounting.FIXED    ,   2396160, "Hpt_BeamLaser_Fixed_Huge"      , Map.ofEntries(Map.entry(HorizonsModifier.MASS,16.00), Map.entry(HorizonsModifier.INTEGRITY,80.0), Map.entry(HorizonsModifier.POWER_DRAW,2.61), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,41.380), Map.entry(HorizonsModifier.DAMAGE,41.380), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,8.190), Map.entry(HorizonsModifier.THERMAL_LOAD, 9.93), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 60.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,33.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser BEAM_LASER_4_A_G            = new BeamLaser("BEAM_LASER_4_A_G"           , HorizonsBlueprintName.BEAM_LASER, ModuleSize.SIZE_4, ModuleClass.A,                   false, Mounting.GIMBALLED,   8746160, "Hpt_BeamLaser_Gimbal_Huge"     , Map.ofEntries(Map.entry(HorizonsModifier.MASS,16.00), Map.entry(HorizonsModifier.INTEGRITY,80.0), Map.entry(HorizonsModifier.POWER_DRAW,2.57), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,32.680), Map.entry(HorizonsModifier.DAMAGE,32.680), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,8.990), Map.entry(HorizonsModifier.THERMAL_LOAD,10.62), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 60.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE,26.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));
    public static final BeamLaser RETRIBUTOR_BEAM_LASER_1_E_F = new BeamLaser("RETRIBUTOR_BEAM_LASER_1_E_F", HorizonsBlueprintName.RETRIBUTOR_BEAM_LASER, ModuleSize.SIZE_1, ModuleClass.E, Origin.POWERPLAY, false, Mounting.FIXED    ,     56145, "Hpt_BeamLaser_Fixed_Small_Heat", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY,40.0), Map.entry(HorizonsModifier.POWER_DRAW,0.62), Map.entry(HorizonsModifier.BOOT_TIME,0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND, 4.910), Map.entry(HorizonsModifier.DAMAGE, 4.910), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,2.520), Map.entry(HorizonsModifier.THERMAL_LOAD, 2.70), Map.entry(HorizonsModifier.ARMOUR_PIERCING, 18.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE, Double.POSITIVE_INFINITY), Map.entry(HorizonsModifier.BURST_INTERVAL,0.0), Map.entry(HorizonsModifier.BREACH_DAMAGE, 3.9), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,0.40), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,0.80), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,600.0), Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false), Map.entry(HorizonsModifier.DAMAGE_INCREASES_WITH_HEAT_LEVEL,false), Map.entry(HorizonsModifier.TARGET_WING_SHIELDS_REGENERATED,false), Map.entry(HorizonsModifier.HEAT_REDUCED_WHEN_STRIKING_A_TARGET,false)));

    public static final List<BeamLaser> BEAM_LASERS = List.of(
            BEAM_LASER_1_E_F,
            BEAM_LASER_1_E_G,
            BEAM_LASER_1_F_T,
            BEAM_LASER_2_D_F,
            BEAM_LASER_2_D_G,
            BEAM_LASER_2_E_T,
            BEAM_LASER_3_C_F,
            BEAM_LASER_3_C_G,
            BEAM_LASER_3_D_T,
            BEAM_LASER_4_A_F,
            BEAM_LASER_4_A_G,
            RETRIBUTOR_BEAM_LASER_1_E_F
    );
    public BeamLaser(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public BeamLaser(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, boolean multiCrew, Mounting mounting, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, mounting, basePrice, internalName, attributes);
    }

    public BeamLaser(BeamLaser beamLaser) {
        super(beamLaser);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return BeamLaserBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return ExperimentalEffectBlueprints.BEAM_LASER.keySet().stream().toList();
    }

    @Override
    public BeamLaser Clone() {
        return new BeamLaser(this);
    }
    @Override
    public String getClarifier() {
        if(RETRIBUTOR_BEAM_LASER_1_E_F.equals(this)){
            return " " + LocaleService.getLocalizedStringForCurrentLocale(getName().getLocalizationKey());
        }
        return super.getClarifier();
    }
}
