package nl.jixxed.eliteodysseymaterials.domain.ships.core_internals;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.core_internals.ThrusterBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.CoreModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.List;
import java.util.Map;

public class Thrusters extends CoreModule {
    public static final Thrusters THRUSTERS_2_E_FREE = new Thrusters("THRUSTERS_2_E_FREE", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_2, ModuleClass.E, 0, "Int_Engine_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 46.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.00), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 24.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 48.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 72.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_2_E = new Thrusters("THRUSTERS_2_E", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_2, ModuleClass.E, 1980, "Int_Engine_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 46.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.00), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 24.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 48.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 72.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_2_D = new Thrusters("THRUSTERS_2_D", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_2, ModuleClass.D, 5930, "Int_Engine_Size2_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.00), Map.entry(HorizonsModifier.INTEGRITY, 41.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.25), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 27.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 54.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 81.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 86.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 106.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_2_C = new Thrusters("THRUSTERS_2_C", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_2, ModuleClass.C, 17800, "Int_Engine_Size2_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.50), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 30.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 60.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 90.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 110.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_2_B = new Thrusters("THRUSTERS_2_B", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_2, ModuleClass.B, 53410, "Int_Engine_Size2_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY, 61.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.75), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 33.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 66.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 99.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 93.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 113.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_2_A = new Thrusters("THRUSTERS_2_A", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_2, ModuleClass.A, 160220, "Int_Engine_Size2_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 56.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.00), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 36.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 72.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 108.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 96.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 116.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_3_E = new Thrusters("THRUSTERS_3_E", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_3, ModuleClass.E, 6270, "Int_Engine_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 58.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.48), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 40.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 80.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 120.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_3_D = new Thrusters("THRUSTERS_3_D", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_3, ModuleClass.D, 18810, "Int_Engine_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.79), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 45.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 90.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 135.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 86.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 106.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_3_C = new Thrusters("THRUSTERS_3_C", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_3, ModuleClass.C, 56440, "Int_Engine_Size3_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.10), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 50.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 150.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 110.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_3_B = new Thrusters("THRUSTERS_3_B", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_3, ModuleClass.B, 169300, "Int_Engine_Size3_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.41), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 55.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 110.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 165.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 93.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 113.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_3_A = new Thrusters("THRUSTERS_3_A", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_3, ModuleClass.A, 507910, "Int_Engine_Size3_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 70.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.72), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 60.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 120.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 180.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 96.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 116.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_4_E = new Thrusters("THRUSTERS_4_E", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_4, ModuleClass.E, 19880, "Int_Engine_Size4_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 72.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.28), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 140.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 280.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 420.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_4_D = new Thrusters("THRUSTERS_4_D", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_4, ModuleClass.D, 59630, "Int_Engine_Size4_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.69), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 158.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 315.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 473.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 86.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 106.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_4_C = new Thrusters("THRUSTERS_4_C", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_4, ModuleClass.C, 178900, "Int_Engine_Size4_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.10), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 175.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 350.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 525.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 110.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_4_B = new Thrusters("THRUSTERS_4_B", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_4, ModuleClass.B, 536690, "Int_Engine_Size4_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.51), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 193.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 385.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 578.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 93.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 113.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_4_A = new Thrusters("THRUSTERS_4_A", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_4, ModuleClass.A, 1610080, "Int_Engine_Size4_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 88.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.92), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 210.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 420.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 630.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 96.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 116.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_5_E = new Thrusters("THRUSTERS_5_E", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_5, ModuleClass.E, 63010, "Int_Engine_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 86.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.08), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 280.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 560.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 840.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_5_D = new Thrusters("THRUSTERS_5_D", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_5, ModuleClass.D, 189040, "Int_Engine_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.59), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 315.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 630.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 945.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 86.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 106.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_5_C = new Thrusters("THRUSTERS_5_C", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_5, ModuleClass.C, 567110, "Int_Engine_Size5_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 5.10), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 350.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 700.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 1050.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 110.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_5_B = new Thrusters("THRUSTERS_5_B", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_5, ModuleClass.B, 1701320, "Int_Engine_Size5_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.INTEGRITY, 115.0), Map.entry(HorizonsModifier.POWER_DRAW, 5.61), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 385.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 770.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 1155.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 93.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 113.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_5_A = new Thrusters("THRUSTERS_5_A", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_5, ModuleClass.A, 5103950, "Int_Engine_Size5_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 106.0), Map.entry(HorizonsModifier.POWER_DRAW, 6.12), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 420.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 840.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 1260.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 96.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 116.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_6_E = new Thrusters("THRUSTERS_6_E", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_6, ModuleClass.E, 199750, "Int_Engine_Size6_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 102.0), Map.entry(HorizonsModifier.POWER_DRAW, 5.04), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 480.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 960.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 1440.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_6_D = new Thrusters("THRUSTERS_6_D", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_6, ModuleClass.D, 599240, "Int_Engine_Size6_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 5.67), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 540.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1080.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 1620.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 86.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 106.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_6_C = new Thrusters("THRUSTERS_6_C", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_6, ModuleClass.C, 1797730, "Int_Engine_Size6_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 113.0), Map.entry(HorizonsModifier.POWER_DRAW, 6.30), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 600.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1200.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 1800.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 110.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_6_B = new Thrusters("THRUSTERS_6_B", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_6, ModuleClass.B, 5393180, "Int_Engine_Size6_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.00), Map.entry(HorizonsModifier.INTEGRITY, 136.0), Map.entry(HorizonsModifier.POWER_DRAW, 6.93), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 660.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1320.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 1980.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 93.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 113.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_6_A = new Thrusters("THRUSTERS_6_A", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_6, ModuleClass.A, 16179530, "Int_Engine_Size6_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 124.0), Map.entry(HorizonsModifier.POWER_DRAW, 7.56), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 720.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1440.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 2160.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 96.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 116.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_7_E = new Thrusters("THRUSTERS_7_E", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_7, ModuleClass.E, 633200, "Int_Engine_Size7_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 118.0), Map.entry(HorizonsModifier.POWER_DRAW, 6.08), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 720.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1440.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 2160.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_7_D = new Thrusters("THRUSTERS_7_D", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_7, ModuleClass.D, 1899600, "Int_Engine_Size7_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.INTEGRITY, 105.0), Map.entry(HorizonsModifier.POWER_DRAW, 6.84), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 810.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1620.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 2430.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 86.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 106.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_7_C = new Thrusters("THRUSTERS_7_C", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_7, ModuleClass.C, 5698790, "Int_Engine_Size7_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 131.0), Map.entry(HorizonsModifier.POWER_DRAW, 7.60), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 2700.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 110.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_7_B = new Thrusters("THRUSTERS_7_B", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_7, ModuleClass.B, 17096370, "Int_Engine_Size7_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 128.00), Map.entry(HorizonsModifier.INTEGRITY, 157.0), Map.entry(HorizonsModifier.POWER_DRAW, 8.36), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 990.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 1980.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 2970.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 93.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 113.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_7_A = new Thrusters("THRUSTERS_7_A", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_7, ModuleClass.A, 51289110, "Int_Engine_Size7_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 144.0), Map.entry(HorizonsModifier.POWER_DRAW, 9.12), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 1080.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 2160.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 3240.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 96.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 116.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_8_E = new Thrusters("THRUSTERS_8_E", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_8, ModuleClass.E, 2007240, "Int_Engine_Size8_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 135.0), Map.entry(HorizonsModifier.POWER_DRAW, 7.20), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 1120.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 2240.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 3360.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 83.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 103.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_8_D = new Thrusters("THRUSTERS_8_D", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_8, ModuleClass.D, 6021720, "Int_Engine_Size8_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.00), Map.entry(HorizonsModifier.INTEGRITY, 120.0), Map.entry(HorizonsModifier.POWER_DRAW, 8.10), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 1260.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 2520.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 3780.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 86.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 106.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_8_C = new Thrusters("THRUSTERS_8_C", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_8, ModuleClass.C, 18065170, "Int_Engine_Size8_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 150.0), Map.entry(HorizonsModifier.POWER_DRAW, 9.00), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 1400.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 2800.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 4200.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 110.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_8_B = new Thrusters("THRUSTERS_8_B", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_8, ModuleClass.B, 54195500, "Int_Engine_Size8_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 256.00), Map.entry(HorizonsModifier.INTEGRITY, 180.0), Map.entry(HorizonsModifier.POWER_DRAW, 9.90), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 1540.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 3080.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 4620.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 93.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 113.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters THRUSTERS_8_A = new Thrusters("THRUSTERS_8_A", HorizonsBlueprintName.THRUSTERS, ModuleSize.SIZE_8, ModuleClass.A, 162586490, "Int_Engine_Size8_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 165.0), Map.entry(HorizonsModifier.POWER_DRAW, 10.80), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 1680.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 3360.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 5040.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 96.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 100.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 116.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3)));
    public static final Thrusters ENHANCED_THRUSTERS_2_A = new Thrusters("ENHANCED_THRUSTERS_2_A", HorizonsBlueprintName.ENHANCED_THRUSTERS, ModuleSize.SIZE_2, ModuleClass.A, 1610080, "Int_Engine_Size2_Class5_Fast", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.00), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 50.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 60.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 120.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 115.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 137.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 2.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER_SPEED, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER_SPEED, 125.0), Map.entry(HorizonsModifier.MAXIMUM_MULTIPLIER_SPEED, 160.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER_ACCELERATION, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER_ACCELERATION, 110.0), Map.entry(HorizonsModifier.MAXIMUM_MULTIPLIER_ACCELERATION, 120.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER_ROTATION, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER_ROTATION, 110.0), Map.entry(HorizonsModifier.MAXIMUM_MULTIPLIER_ROTATION, 130.0)));
    public static final Thrusters ENHANCED_THRUSTERS_3_A = new Thrusters("ENHANCED_THRUSTERS_3_A", HorizonsBlueprintName.ENHANCED_THRUSTERS, ModuleSize.SIZE_3, ModuleClass.A, 5103950, "Int_Engine_Size3_Class5_Fast", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 55.0), Map.entry(HorizonsModifier.POWER_DRAW, 5.00), Map.entry(HorizonsModifier.BOOT_TIME, 0.0), Map.entry(HorizonsModifier.ENGINE_MINIMUM_MASS, 70.0), Map.entry(HorizonsModifier.ENGINE_OPTIMAL_MASS, 90.0), Map.entry(HorizonsModifier.MAXIMUM_MASS, 200.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER, 115.0), Map.entry(HorizonsModifier.MAXIMUM_MULIPLIER, 137.0), Map.entry(HorizonsModifier.ENGINE_THERMAL_LOAD, 1.3), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER_SPEED, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER_SPEED, 125.0), Map.entry(HorizonsModifier.MAXIMUM_MULTIPLIER_SPEED, 160.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER_ACCELERATION, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER_ACCELERATION, 110.0), Map.entry(HorizonsModifier.MAXIMUM_MULTIPLIER_ACCELERATION, 120.0), Map.entry(HorizonsModifier.MINIMUM_MULTIPLIER_ROTATION, 90.0), Map.entry(HorizonsModifier.OPTIMAL_MULTIPLIER_ROTATION, 110.0), Map.entry(HorizonsModifier.MAXIMUM_MULTIPLIER_ROTATION, 130.0)));

    public static final List<Thrusters> THRUSTERS = List.of(
            THRUSTERS_2_E_FREE,
            THRUSTERS_2_E,
            THRUSTERS_2_D,
            THRUSTERS_2_C,
            THRUSTERS_2_B,
            THRUSTERS_2_A,
            THRUSTERS_3_E,
            THRUSTERS_3_D,
            THRUSTERS_3_C,
            THRUSTERS_3_B,
            THRUSTERS_3_A,
            THRUSTERS_4_E,
            THRUSTERS_4_D,
            THRUSTERS_4_C,
            THRUSTERS_4_B,
            THRUSTERS_4_A,
            THRUSTERS_5_E,
            THRUSTERS_5_D,
            THRUSTERS_5_C,
            THRUSTERS_5_B,
            THRUSTERS_5_A,
            THRUSTERS_6_E,
            THRUSTERS_6_D,
            THRUSTERS_6_C,
            THRUSTERS_6_B,
            THRUSTERS_6_A,
            THRUSTERS_7_E,
            THRUSTERS_7_D,
            THRUSTERS_7_C,
            THRUSTERS_7_B,
            THRUSTERS_7_A,
            THRUSTERS_8_E,
            THRUSTERS_8_D,
            THRUSTERS_8_C,
            THRUSTERS_8_B,
            THRUSTERS_8_A,
            ENHANCED_THRUSTERS_2_A,
            ENHANCED_THRUSTERS_3_A
    );

    private Thrusters(final String id, final HorizonsBlueprintName name, final ModuleSize moduleSize, final ModuleClass moduleClass, final long basePrice, final String internalName, final Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, basePrice, internalName, attributes);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return ThrusterBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return ExperimentalEffectBlueprints.THRUSTERS.keySet().stream().toList();
    }

    public Thrusters(final Thrusters thrusters) {
        super(thrusters);
    }

    @Override
    public Thrusters Clone() {
        return new Thrusters(this);
    }

    @Override
    public String getClarifier() {
        return this == ENHANCED_THRUSTERS_2_A || this == ENHANCED_THRUSTERS_3_A ? " " + LocaleService.getLocalizedStringForCurrentLocale("blueprint.horizons.name.enhanced_thrusters") : "";
    }

    @Override
    public int getGrouping() {
        return getModuleSize().intValue() * 10 + (this.equals(ENHANCED_THRUSTERS_2_A) || this.equals(ENHANCED_THRUSTERS_3_A) ? 1 : 0);
    }

    public boolean isSelectable() {
        return !THRUSTERS_2_E_FREE.equals(this);
    }
}
