package nl.jixxed.eliteodysseymaterials.domain.ships.core_internals;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.core_internals.PowerDistributorBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.CoreModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.domain.ships.Origin;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PowerDistributor extends CoreModule {
    public static final PowerDistributor POWER_DISTRIBUTOR_1_E_FREE = new PowerDistributor("POWER_DISTRIBUTOR_1_E_FREE", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_1, ModuleClass.E, 0, "Int_PowerDistributor_Size1_Class1_free", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 36.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.32), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 10.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.20), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 8.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.40), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 8.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.40)));
    public static final PowerDistributor POWER_DISTRIBUTOR_1_E = new PowerDistributor("POWER_DISTRIBUTOR_1_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_1, ModuleClass.E, 520, "Int_PowerDistributor_Size1_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 36.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.32), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 10.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.20), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 8.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.40), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 8.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.40)));
    public static final PowerDistributor POWER_DISTRIBUTOR_1_D = new PowerDistributor("POWER_DISTRIBUTOR_1_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_1, ModuleClass.D, 1290, "Int_PowerDistributor_Size1_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.50), Map.entry(HorizonsModifier.INTEGRITY, 32.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.36), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 11.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.40), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 9.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.50), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 9.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.50)));
    public static final PowerDistributor POWER_DISTRIBUTOR_1_C = new PowerDistributor("POWER_DISTRIBUTOR_1_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_1, ModuleClass.C, 3230, "Int_PowerDistributor_Size1_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.40), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 12.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.50), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 10.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.50), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 10.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.50)));
    public static final PowerDistributor POWER_DISTRIBUTOR_1_B = new PowerDistributor("POWER_DISTRIBUTOR_1_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_1, ModuleClass.B, 8080, "Int_PowerDistributor_Size1_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY, 48.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.44), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 13.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.70), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 11.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 11.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_1_A = new PowerDistributor("POWER_DISTRIBUTOR_1_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_1, ModuleClass.A, 20200, "Int_PowerDistributor_Size1_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 44.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.48), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 14.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.80), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 12.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 12.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_2_E = new PowerDistributor("POWER_DISTRIBUTOR_2_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_2, ModuleClass.E, 1450, "Int_PowerDistributor_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 46.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.36), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 12.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.40), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 10.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 10.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_2_D = new PowerDistributor("POWER_DISTRIBUTOR_2_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_2, ModuleClass.D, 3620, "Int_PowerDistributor_Size2_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.00), Map.entry(HorizonsModifier.INTEGRITY, 41.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.41), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 14.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.60), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 11.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 11.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_2_C = new PowerDistributor("POWER_DISTRIBUTOR_2_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_2, ModuleClass.C, 9050, "Int_PowerDistributor_Size2_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.45), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 15.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.80), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 12.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.70), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 12.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.70)));
    public static final PowerDistributor POWER_DISTRIBUTOR_2_B = new PowerDistributor("POWER_DISTRIBUTOR_2_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_2, ModuleClass.B, 22620, "Int_PowerDistributor_Size2_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY, 61.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.50), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 17.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.00), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 13.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.80), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 13.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.80)));
    public static final PowerDistributor POWER_DISTRIBUTOR_2_A = new PowerDistributor("POWER_DISTRIBUTOR_2_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_2, ModuleClass.A, 56550, "Int_PowerDistributor_Size2_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 56.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.54), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 18.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.20), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 14.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.80), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 14.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.80)));
    public static final PowerDistributor POWER_DISTRIBUTOR_3_E = new PowerDistributor("POWER_DISTRIBUTOR_3_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_3, ModuleClass.E, 4050, "Int_PowerDistributor_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 58.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.40), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 16.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 1.80), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 12.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.90), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 12.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.90)));
    public static final PowerDistributor POWER_DISTRIBUTOR_3_D = new PowerDistributor("POWER_DISTRIBUTOR_3_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_3, ModuleClass.D, 10130, "Int_PowerDistributor_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.45), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 18.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.10), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 14.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.00), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 14.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.00)));
    public static final PowerDistributor POWER_DISTRIBUTOR_3_C = new PowerDistributor("POWER_DISTRIBUTOR_3_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_3, ModuleClass.C, 25330, "Int_PowerDistributor_Size3_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.50), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 20.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.30), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 15.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.10), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 15.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.10)));
    public static final PowerDistributor POWER_DISTRIBUTOR_3_B = new PowerDistributor("POWER_DISTRIBUTOR_3_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_3, ModuleClass.B, 63330, "Int_PowerDistributor_Size3_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.55), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 22.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.50), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 17.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.20), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 17.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.20)));
    public static final PowerDistributor POWER_DISTRIBUTOR_3_A = new PowerDistributor("POWER_DISTRIBUTOR_3_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_3, ModuleClass.A, 158330, "Int_PowerDistributor_Size3_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 70.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.60), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 24.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.80), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 18.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.30), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 18.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.30)));
    public static final PowerDistributor POWER_DISTRIBUTOR_4_E = new PowerDistributor("POWER_DISTRIBUTOR_4_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_4, ModuleClass.E, 11350, "Int_PowerDistributor_Size4_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 72.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.45), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 22.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.30), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 15.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.30), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 15.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.30)));
    public static final PowerDistributor POWER_DISTRIBUTOR_4_D = new PowerDistributor("POWER_DISTRIBUTOR_4_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_4, ModuleClass.D, 28370, "Int_PowerDistributor_Size4_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.50), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 24.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.60), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 17.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.40), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 17.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.40)));
    public static final PowerDistributor POWER_DISTRIBUTOR_4_C = new PowerDistributor("POWER_DISTRIBUTOR_4_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_4, ModuleClass.C, 70930, "Int_PowerDistributor_Size4_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.56), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 27.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.90), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 19.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 19.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_4_B = new PowerDistributor("POWER_DISTRIBUTOR_4_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_4, ModuleClass.B, 177330, "Int_PowerDistributor_Size4_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.62), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 30.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.20), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 21.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.80), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 21.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.80)));
    public static final PowerDistributor POWER_DISTRIBUTOR_4_A = new PowerDistributor("POWER_DISTRIBUTOR_4_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_4, ModuleClass.A, 443330, "Int_PowerDistributor_Size4_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 88.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.67), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 32.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.50), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 23.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.90), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 23.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.90)));
    public static final PowerDistributor POWER_DISTRIBUTOR_5_E = new PowerDistributor("POWER_DISTRIBUTOR_5_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_5, ModuleClass.E, 31780, "Int_PowerDistributor_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 86.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.50), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 27.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.90), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 19.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.70), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 19.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.70)));
    public static final PowerDistributor POWER_DISTRIBUTOR_5_D = new PowerDistributor("POWER_DISTRIBUTOR_5_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_5, ModuleClass.D, 79440, "Int_PowerDistributor_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.56), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 31.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.20), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 22.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.90), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 22.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.90)));
    public static final PowerDistributor POWER_DISTRIBUTOR_5_C = new PowerDistributor("POWER_DISTRIBUTOR_5_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_5, ModuleClass.C, 198610, "Int_PowerDistributor_Size5_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.62), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 34.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.60), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 24.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.10), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 24.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.10)));
    public static final PowerDistributor POWER_DISTRIBUTOR_5_B = new PowerDistributor("POWER_DISTRIBUTOR_5_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_5, ModuleClass.B, 496530, "Int_PowerDistributor_Size5_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.INTEGRITY, 115.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.68), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 37.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.00), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 26.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.30), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 26.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.30)));
    public static final PowerDistributor POWER_DISTRIBUTOR_5_A = new PowerDistributor("POWER_DISTRIBUTOR_5_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_5, ModuleClass.A, 1241320, "Int_PowerDistributor_Size5_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 106.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.74), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 41.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.30), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 29.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.50), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 29.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.50)));
    public static final PowerDistributor POWER_DISTRIBUTOR_6_E = new PowerDistributor("POWER_DISTRIBUTOR_6_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_6, ModuleClass.E, 88980, "Int_PowerDistributor_Size6_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 102.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.54), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 34.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.40), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 23.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.20), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 23.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.20)));
    public static final PowerDistributor POWER_DISTRIBUTOR_6_D = new PowerDistributor("POWER_DISTRIBUTOR_6_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_6, ModuleClass.D, 222440, "Int_PowerDistributor_Size6_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.61), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 38.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.90), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 26.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.40), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 26.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.40)));
    public static final PowerDistributor POWER_DISTRIBUTOR_6_C = new PowerDistributor("POWER_DISTRIBUTOR_6_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_6, ModuleClass.C, 556110, "Int_PowerDistributor_Size6_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 113.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.68), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 42.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.30), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 29.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.70), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 29.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.70)));
    public static final PowerDistributor POWER_DISTRIBUTOR_6_B = new PowerDistributor("POWER_DISTRIBUTOR_6_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_6, ModuleClass.B, 1390280, "Int_PowerDistributor_Size6_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.00), Map.entry(HorizonsModifier.INTEGRITY, 136.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.75), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 46.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.70), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 32.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.00), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 32.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.00)));
    public static final PowerDistributor POWER_DISTRIBUTOR_6_A = new PowerDistributor("POWER_DISTRIBUTOR_6_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_6, ModuleClass.A, 3475690, "Int_PowerDistributor_Size6_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 124.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.82), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 50.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 5.20), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 35.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.20), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 35.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.20)));
    public static final PowerDistributor POWER_DISTRIBUTOR_7_E = new PowerDistributor("POWER_DISTRIBUTOR_7_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_7, ModuleClass.E, 249140, "Int_PowerDistributor_Size7_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 118.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.59), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 41.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.10), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 27.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 27.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_7_D = new PowerDistributor("POWER_DISTRIBUTOR_7_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_7, ModuleClass.D, 622840, "Int_PowerDistributor_Size7_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.INTEGRITY, 105.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.67), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 46.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.60), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 31.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.00), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 31.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.00)));
    public static final PowerDistributor POWER_DISTRIBUTOR_7_C = new PowerDistributor("POWER_DISTRIBUTOR_7_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_7, ModuleClass.C, 1557110, "Int_PowerDistributor_Size7_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 131.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.74), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 51.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 5.10), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 34.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.30), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 34.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.30)));
    public static final PowerDistributor POWER_DISTRIBUTOR_7_B = new PowerDistributor("POWER_DISTRIBUTOR_7_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_7, ModuleClass.B, 3892770, "Int_PowerDistributor_Size7_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 128.00), Map.entry(HorizonsModifier.INTEGRITY, 157.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.81), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 56.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 5.60), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 37.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 37.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_7_A = new PowerDistributor("POWER_DISTRIBUTOR_7_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_7, ModuleClass.A, 9731930, "Int_PowerDistributor_Size7_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 144.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.89), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 61.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 6.10), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 41.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 4.00), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 41.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 4.00)));
    public static final PowerDistributor POWER_DISTRIBUTOR_8_E = new PowerDistributor("POWER_DISTRIBUTOR_8_E", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_8, ModuleClass.E, 697580, "Int_PowerDistributor_Size8_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 135.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.64), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 48.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.80), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 32.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.20), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 32.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.20)));
    public static final PowerDistributor POWER_DISTRIBUTOR_8_D = new PowerDistributor("POWER_DISTRIBUTOR_8_D", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_8, ModuleClass.D, 1743960, "Int_PowerDistributor_Size8_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.00), Map.entry(HorizonsModifier.INTEGRITY, 120.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.72), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 54.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 5.40), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 36.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.60), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 36.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.60)));
    public static final PowerDistributor POWER_DISTRIBUTOR_8_C = new PowerDistributor("POWER_DISTRIBUTOR_8_C", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_8, ModuleClass.C, 4359900, "Int_PowerDistributor_Size8_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 150.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.80), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 60.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 6.00), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 40.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 4.00), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 40.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 4.00)));
    public static final PowerDistributor POWER_DISTRIBUTOR_8_B = new PowerDistributor("POWER_DISTRIBUTOR_8_B", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_8, ModuleClass.B, 10899760, "Int_PowerDistributor_Size8_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 256.00), Map.entry(HorizonsModifier.INTEGRITY, 180.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.88), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 66.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 6.60), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 44.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 4.40), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 44.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 4.40)));
    public static final PowerDistributor POWER_DISTRIBUTOR_8_A = new PowerDistributor("POWER_DISTRIBUTOR_8_A", HorizonsBlueprintName.POWER_DISTRIBUTOR, ModuleSize.SIZE_8, ModuleClass.A, 27249390, "Int_PowerDistributor_Size8_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 165.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.96), Map.entry(HorizonsModifier.POWER_BOOST, 0.0), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 72.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 7.20), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 48.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 4.80), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 48.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 4.80)));

    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_1_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_1_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_1, ModuleClass.A, Origin.GUARDIAN, 40956, "Int_GuardianPowerDistributor_Size1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.40), Map.entry(HorizonsModifier.INTEGRITY, 35.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.62), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 10.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 2.50), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 9.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 0.80), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 10.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 0.80), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));
    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_2_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_2_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_2, ModuleClass.A, Origin.GUARDIAN, 111600, "Int_GuardianPowerDistributor_Size2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.60), Map.entry(HorizonsModifier.INTEGRITY, 45.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.73), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 13.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.10), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 11.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.00), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 11.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.00), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));
    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_3_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_3_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_3, ModuleClass.A, Origin.GUARDIAN, 311364, "Int_GuardianPowerDistributor_Size3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.25), Map.entry(HorizonsModifier.INTEGRITY, 56.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.78), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 17.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 3.90), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 14.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 1.70), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 14.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 1.70), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));
    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_4_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_4_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_4, ModuleClass.A, Origin.GUARDIAN, 868706, "Int_GuardianPowerDistributor_Size4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.50), Map.entry(HorizonsModifier.INTEGRITY, 70.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.87), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 22.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 4.90), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 17.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 2.50), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 17.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 2.50), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));
    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_5_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_5_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_5, ModuleClass.A, Origin.GUARDIAN, 2423690, "Int_GuardianPowerDistributor_Size5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 21.00), Map.entry(HorizonsModifier.INTEGRITY, 99.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.96), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 29.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 6.00), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 22.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 3.30), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 22.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 3.30), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));
    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_6_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_6_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_6, ModuleClass.A, Origin.GUARDIAN, 6762091, "Int_GuardianPowerDistributor_Size6", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 42.00), Map.entry(HorizonsModifier.INTEGRITY, 99.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.07), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 35.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 7.30), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 26.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 4.20), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 26.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 4.20), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));
    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_7_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_7_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_7, ModuleClass.A, Origin.GUARDIAN, 18866234, "Int_GuardianPowerDistributor_Size7", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 84.00), Map.entry(HorizonsModifier.INTEGRITY, 115.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.16), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 43.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 8.50), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 31.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 5.20), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 31.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 5.20), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));
    public static final PowerDistributor GUARDIAN_HYBRID_POWER_DISTRIBUTOR_8_A = new PowerDistributor("GUARDIAN_HYBRID_POWER_DISTRIBUTOR_8_A", HorizonsBlueprintName.GUARDIAN_POWER_DISTRIBUTOR, ModuleSize.SIZE_8, ModuleClass.A, Origin.GUARDIAN, 52636792, "Int_GuardianPowerDistributor_Size8", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 168.00), Map.entry(HorizonsModifier.INTEGRITY, 132.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.25), Map.entry(HorizonsModifier.POWER_BOOST, 0.04), Map.entry(HorizonsModifier.BOOT_TIME, 5.0), Map.entry(HorizonsModifier.WEAPONS_CAPACITY, 50.00), Map.entry(HorizonsModifier.WEAPONS_RECHARGE, 10.10), Map.entry(HorizonsModifier.ENGINES_CAPACITY, 36.00), Map.entry(HorizonsModifier.ENGINES_RECHARGE, 6.20), Map.entry(HorizonsModifier.SYSTEMS_CAPACITY, 36.00), Map.entry(HorizonsModifier.SYSTEMS_RECHARGE, 6.20), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE, false)));

    public static final List<PowerDistributor> POWER_DISTRIBUTORS = List.of(
            POWER_DISTRIBUTOR_1_E_FREE,
            POWER_DISTRIBUTOR_1_E,
            POWER_DISTRIBUTOR_1_D,
            POWER_DISTRIBUTOR_1_C,
            POWER_DISTRIBUTOR_1_B,
            POWER_DISTRIBUTOR_1_A,
            POWER_DISTRIBUTOR_2_E,
            POWER_DISTRIBUTOR_2_D,
            POWER_DISTRIBUTOR_2_C,
            POWER_DISTRIBUTOR_2_B,
            POWER_DISTRIBUTOR_2_A,
            POWER_DISTRIBUTOR_3_E,
            POWER_DISTRIBUTOR_3_D,
            POWER_DISTRIBUTOR_3_C,
            POWER_DISTRIBUTOR_3_B,
            POWER_DISTRIBUTOR_3_A,
            POWER_DISTRIBUTOR_4_E,
            POWER_DISTRIBUTOR_4_D,
            POWER_DISTRIBUTOR_4_C,
            POWER_DISTRIBUTOR_4_B,
            POWER_DISTRIBUTOR_4_A,
            POWER_DISTRIBUTOR_5_E,
            POWER_DISTRIBUTOR_5_D,
            POWER_DISTRIBUTOR_5_C,
            POWER_DISTRIBUTOR_5_B,
            POWER_DISTRIBUTOR_5_A,
            POWER_DISTRIBUTOR_6_E,
            POWER_DISTRIBUTOR_6_D,
            POWER_DISTRIBUTOR_6_C,
            POWER_DISTRIBUTOR_6_B,
            POWER_DISTRIBUTOR_6_A,
            POWER_DISTRIBUTOR_7_E,
            POWER_DISTRIBUTOR_7_D,
            POWER_DISTRIBUTOR_7_C,
            POWER_DISTRIBUTOR_7_B,
            POWER_DISTRIBUTOR_7_A,
            POWER_DISTRIBUTOR_8_E,
            POWER_DISTRIBUTOR_8_D,
            POWER_DISTRIBUTOR_8_C,
            POWER_DISTRIBUTOR_8_B,
            POWER_DISTRIBUTOR_8_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_1_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_2_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_3_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_4_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_5_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_6_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_7_A,
            GUARDIAN_HYBRID_POWER_DISTRIBUTOR_8_A
    );

    private PowerDistributor(final String id, final HorizonsBlueprintName name, final ModuleSize moduleSize, final ModuleClass moduleClass, final long basePrice, final String internalName, final Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, basePrice, internalName, attributes);
    }

    private PowerDistributor(final String id, final HorizonsBlueprintName name, final ModuleSize moduleSize, final ModuleClass moduleClass, final Origin origin, final long basePrice, final String internalName, final Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, basePrice, internalName, attributes);
    }

    private PowerDistributor(final PowerDistributor powerDistributor) {
        super(powerDistributor);
    }


    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        if (this.getOrigin() == Origin.GUARDIAN) {
            return PowerDistributorBlueprints.GUARDIAN_BLUEPRINTS.keySet().stream().toList();
        }
        return PowerDistributorBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        if (this.getOrigin() == Origin.GUARDIAN) {
            return Collections.emptyList();
        }
        return ExperimentalEffectBlueprints.POWER_DISTRIBUTOR.keySet().stream().toList();
    }

    @Override
    public PowerDistributor Clone() {
        return new PowerDistributor(this);
    }

    @Override
    public String getClarifier() {
        return this.getOrigin() == Origin.GUARDIAN ? " " + LocaleService.getLocalizedStringForCurrentLocale("blueprint.horizons.name.guardian_power_distributor") : "";
    }

    @Override
    public int getGrouping() {
        return getModuleSize().intValue() * 10 + (getOrigin().equals(Origin.GUARDIAN) ? 1 : 0);
    }

    public boolean isSelectable() {
        return !POWER_DISTRIBUTOR_1_E_FREE.equals(this);
    }
}
