package nl.jixxed.eliteodysseymaterials.domain.ships.core_internals;

import lombok.Getter;
import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.core_internals.ArmourBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.List;
import java.util.Map;
public class Armour extends CoreModule {
    public static final Armour SIDE_WINDER_ARMOUR_GRADE_1 = new Armour("SIDE_WINDER_ARMOUR_GRADE_1", ShipType.SIDE_WINDER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "SideWinder_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour SIDE_WINDER_ARMOUR_GRADE_2 = new Armour("SIDE_WINDER_ARMOUR_GRADE_2", ShipType.SIDE_WINDER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 25600, "SideWinder_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour SIDE_WINDER_ARMOUR_GRADE_3 = new Armour("SIDE_WINDER_ARMOUR_GRADE_3", ShipType.SIDE_WINDER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 80320, "SideWinder_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour SIDE_WINDER_ARMOUR_MIRRORED = new Armour("SIDE_WINDER_ARMOUR_MIRRORED", ShipType.SIDE_WINDER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 132060, "SideWinder_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour SIDE_WINDER_ARMOUR_REACTIVE = new Armour("SIDE_WINDER_ARMOUR_REACTIVE", ShipType.SIDE_WINDER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 139420, "SideWinder_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour EAGLE_ARMOUR_GRADE_1 = new Armour("EAGLE_ARMOUR_GRADE_1", ShipType.EAGLE, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Eagle_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EAGLE_ARMOUR_GRADE_2 = new Armour("EAGLE_ARMOUR_GRADE_2", ShipType.EAGLE, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 26880, "Eagle_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EAGLE_ARMOUR_GRADE_3 = new Armour("EAGLE_ARMOUR_GRADE_3", ShipType.EAGLE, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 90050, "Eagle_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EAGLE_ARMOUR_MIRRORED = new Armour("EAGLE_ARMOUR_MIRRORED", ShipType.EAGLE, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 140090, "Eagle_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour EAGLE_ARMOUR_REACTIVE = new Armour("EAGLE_ARMOUR_REACTIVE", ShipType.EAGLE, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 150390, "Eagle_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour HAULER_ARMOUR_GRADE_1 = new Armour("HAULER_ARMOUR_GRADE_1", ShipType.HAULER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Hauler_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour HAULER_ARMOUR_GRADE_2 = new Armour("HAULER_ARMOUR_GRADE_2", ShipType.HAULER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 42180, "Hauler_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour HAULER_ARMOUR_GRADE_3 = new Armour("HAULER_ARMOUR_GRADE_3", ShipType.HAULER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 185050, "Hauler_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour HAULER_ARMOUR_MIRRORED = new Armour("HAULER_ARMOUR_MIRRORED", ShipType.HAULER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 270300, "Hauler_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour HAULER_ARMOUR_REACTIVE = new Armour("HAULER_ARMOUR_REACTIVE", ShipType.HAULER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 282420, "Hauler_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour ADDER_ARMOUR_GRADE_1 = new Armour("ADDER_ARMOUR_GRADE_1", ShipType.ADDER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Adder_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ADDER_ARMOUR_GRADE_2 = new Armour("ADDER_ARMOUR_GRADE_2", ShipType.ADDER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 35120, "Adder_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 3.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ADDER_ARMOUR_GRADE_3 = new Armour("ADDER_ARMOUR_GRADE_3", ShipType.ADDER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 79030, "Adder_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ADDER_ARMOUR_MIRRORED = new Armour("ADDER_ARMOUR_MIRRORED", ShipType.ADDER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 186770, "Adder_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour ADDER_ARMOUR_REACTIVE = new Armour("ADDER_ARMOUR_REACTIVE", ShipType.ADDER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 206960, "Adder_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour EMPIRE_EAGLE_ARMOUR_GRADE_1 = new Armour("EMPIRE_EAGLE_ARMOUR_GRADE_1", ShipType.EMPIRE_EAGLE, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Empire_Eagle_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_EAGLE_ARMOUR_GRADE_2 = new Armour("EMPIRE_EAGLE_ARMOUR_GRADE_2", ShipType.EMPIRE_EAGLE, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 66500, "Empire_Eagle_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_EAGLE_ARMOUR_GRADE_3 = new Armour("EMPIRE_EAGLE_ARMOUR_GRADE_3", ShipType.EMPIRE_EAGLE, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 222760, "Empire_Eagle_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_EAGLE_ARMOUR_MIRRORED = new Armour("EMPIRE_EAGLE_ARMOUR_MIRRORED", ShipType.EMPIRE_EAGLE, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 346550, "Empire_Eagle_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour EMPIRE_EAGLE_ARMOUR_REACTIVE = new Armour("EMPIRE_EAGLE_ARMOUR_REACTIVE", ShipType.EMPIRE_EAGLE, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 372040, "Empire_Eagle_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour VIPER_ARMOUR_GRADE_1 = new Armour("VIPER_ARMOUR_GRADE_1", ShipType.VIPER_MK_III, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Viper_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VIPER_ARMOUR_GRADE_2 = new Armour("VIPER_ARMOUR_GRADE_2", ShipType.VIPER_MK_III, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 57170, "Viper_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VIPER_ARMOUR_GRADE_3 = new Armour("VIPER_ARMOUR_GRADE_3", ShipType.VIPER_MK_III, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 128640, "Viper_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 9.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VIPER_ARMOUR_MIRRORED = new Armour("VIPER_ARMOUR_MIRRORED", ShipType.VIPER_MK_III, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 304010, "Viper_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 9.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour VIPER_ARMOUR_REACTIVE = new Armour("VIPER_ARMOUR_REACTIVE", ShipType.VIPER_MK_III, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 336890, "Viper_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 9.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour COBRA_MK_III_ARMOUR_GRADE_1 = new Armour("COBRA_MK_III_ARMOUR_GRADE_1", ShipType.COBRA_MK_III, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "CobraMkIII_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour COBRA_MK_III_ARMOUR_GRADE_2 = new Armour("COBRA_MK_III_ARMOUR_GRADE_2", ShipType.COBRA_MK_III, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 139887, "CobraMkIII_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 14.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour COBRA_MK_III_ARMOUR_GRADE_3 = new Armour("COBRA_MK_III_ARMOUR_GRADE_3", ShipType.COBRA_MK_III, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 314746, "CobraMkIII_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 27.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour COBRA_MK_III_ARMOUR_MIRRORED = new Armour("COBRA_MK_III_ARMOUR_MIRRORED", ShipType.COBRA_MK_III, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 734407, "CobraMkIII_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 27.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour COBRA_MK_III_ARMOUR_REACTIVE = new Armour("COBRA_MK_III_ARMOUR_REACTIVE", ShipType.COBRA_MK_III, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 824285, "CobraMkIII_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 27.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour VIPER_MK_IV_ARMOUR_GRADE_1 = new Armour("VIPER_MK_IV_ARMOUR_GRADE_1", ShipType.VIPER_MK_IV, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Viper_MkIV_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VIPER_MK_IV_ARMOUR_GRADE_2 = new Armour("VIPER_MK_IV_ARMOUR_GRADE_2", ShipType.VIPER_MK_IV, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 175180, "Viper_MkIV_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VIPER_MK_IV_ARMOUR_GRADE_3 = new Armour("VIPER_MK_IV_ARMOUR_GRADE_3", ShipType.VIPER_MK_IV, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 394140, "Viper_MkIV_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 9.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VIPER_MK_IV_ARMOUR_MIRRORED = new Armour("VIPER_MK_IV_ARMOUR_MIRRORED", ShipType.VIPER_MK_IV, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 931490, "Viper_MkIV_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 9.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour VIPER_MK_IV_ARMOUR_REACTIVE = new Armour("VIPER_MK_IV_ARMOUR_REACTIVE", ShipType.VIPER_MK_IV, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 1032203, "Viper_MkIV_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 9.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour DIAMOND_BACK_ARMOUR_GRADE_1 = new Armour("DIAMOND_BACK_ARMOUR_GRADE_1", ShipType.DIAMOND_BACK, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "DiamondBack_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DIAMOND_BACK_ARMOUR_GRADE_2 = new Armour("DIAMOND_BACK_ARMOUR_GRADE_2", ShipType.DIAMOND_BACK, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 225730, "DiamondBack_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 13.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DIAMOND_BACK_ARMOUR_GRADE_3 = new Armour("DIAMOND_BACK_ARMOUR_GRADE_3", ShipType.DIAMOND_BACK, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 507900, "DiamondBack_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 26.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DIAMOND_BACK_ARMOUR_MIRRORED = new Armour("DIAMOND_BACK_ARMOUR_MIRRORED", ShipType.DIAMOND_BACK, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 1185100, "DiamondBack_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 26.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour DIAMOND_BACK_ARMOUR_REACTIVE = new Armour("DIAMOND_BACK_ARMOUR_REACTIVE", ShipType.DIAMOND_BACK, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 1330120, "DiamondBack_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 26.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour COBRA_MK_IV_ARMOUR_GRADE_1 = new Armour("COBRA_MK_IV_ARMOUR_GRADE_1", ShipType.COBRA_MK_IV, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "CobraMkIV_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour COBRA_MK_IV_ARMOUR_GRADE_2 = new Armour("COBRA_MK_IV_ARMOUR_GRADE_2", ShipType.COBRA_MK_IV, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 305890, "CobraMkIV_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 14.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour COBRA_MK_IV_ARMOUR_GRADE_3 = new Armour("COBRA_MK_IV_ARMOUR_GRADE_3", ShipType.COBRA_MK_IV, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 688250, "CobraMkIV_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 27.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour COBRA_MK_IV_ARMOUR_MIRRORED = new Armour("COBRA_MK_IV_ARMOUR_MIRRORED", ShipType.COBRA_MK_IV, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 1605910, "CobraMkIV_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 27.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour COBRA_MK_IV_ARMOUR_REACTIVE = new Armour("COBRA_MK_IV_ARMOUR_REACTIVE", ShipType.COBRA_MK_IV, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 1802440, "CobraMkIV_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 27.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_6_ARMOUR_GRADE_1 = new Armour("TYPE_6_ARMOUR_GRADE_1", ShipType.TYPE_6, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Type6_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_6_ARMOUR_GRADE_2 = new Armour("TYPE_6_ARMOUR_GRADE_2", ShipType.TYPE_6, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 418380, "Type6_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 12.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_6_ARMOUR_GRADE_3 = new Armour("TYPE_6_ARMOUR_GRADE_3", ShipType.TYPE_6, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 941350, "Type6_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 23.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_6_ARMOUR_MIRRORED = new Armour("TYPE_6_ARMOUR_MIRRORED", ShipType.TYPE_6, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 2224730, "Type6_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 23.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_6_ARMOUR_REACTIVE = new Armour("TYPE_6_ARMOUR_REACTIVE", ShipType.TYPE_6, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 2465290, "Type6_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 23.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour DOLPHIN_ARMOUR_GRADE_1 = new Armour("DOLPHIN_ARMOUR_GRADE_1", ShipType.DOLPHIN, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Dolphin_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DOLPHIN_ARMOUR_GRADE_2 = new Armour("DOLPHIN_ARMOUR_GRADE_2", ShipType.DOLPHIN, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 534940, "Dolphin_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DOLPHIN_ARMOUR_GRADE_3 = new Armour("DOLPHIN_ARMOUR_GRADE_3", ShipType.DOLPHIN, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 1203600, "Dolphin_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 63.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DOLPHIN_ARMOUR_MIRRORED = new Armour("DOLPHIN_ARMOUR_MIRRORED", ShipType.DOLPHIN, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 2808390, "Dolphin_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 63.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour DOLPHIN_ARMOUR_REACTIVE = new Armour("DOLPHIN_ARMOUR_REACTIVE", ShipType.DOLPHIN, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 3152080, "Dolphin_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 63.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour DIAMOND_BACK_XL_ARMOUR_GRADE_1 = new Armour("DIAMOND_BACK_XL_ARMOUR_GRADE_1", ShipType.DIAMOND_BACK_XL, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "DiamondBackXL_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DIAMOND_BACK_XL_ARMOUR_GRADE_2 = new Armour("DIAMOND_BACK_XL_ARMOUR_GRADE_2", ShipType.DIAMOND_BACK_XL, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 757900, "DiamondBackXL_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 23.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DIAMOND_BACK_XL_ARMOUR_GRADE_3 = new Armour("DIAMOND_BACK_XL_ARMOUR_GRADE_3", ShipType.DIAMOND_BACK_XL, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 1705290, "DiamondBackXL_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 47.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour DIAMOND_BACK_XL_ARMOUR_MIRRORED = new Armour("DIAMOND_BACK_XL_ARMOUR_MIRRORED", ShipType.DIAMOND_BACK_XL, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 3979000, "DiamondBackXL_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 47.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour DIAMOND_BACK_XL_ARMOUR_REACTIVE = new Armour("DIAMOND_BACK_XL_ARMOUR_REACTIVE", ShipType.DIAMOND_BACK_XL, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 4465960, "DiamondBackXL_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 47.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour EMPIRE_COURIER_ARMOUR_GRADE_1 = new Armour("EMPIRE_COURIER_ARMOUR_GRADE_1", ShipType.EMPIRE_COURIER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Empire_Courier_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_COURIER_ARMOUR_GRADE_2 = new Armour("EMPIRE_COURIER_ARMOUR_GRADE_2", ShipType.EMPIRE_COURIER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 1017172, "Empire_Courier_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_COURIER_ARMOUR_GRADE_3 = new Armour("EMPIRE_COURIER_ARMOUR_GRADE_3", ShipType.EMPIRE_COURIER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 2288637, "Empire_Courier_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_COURIER_ARMOUR_MIRRORED = new Armour("EMPIRE_COURIER_ARMOUR_MIRRORED", ShipType.EMPIRE_COURIER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 5408800, "Empire_Courier_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour EMPIRE_COURIER_ARMOUR_REACTIVE = new Armour("EMPIRE_COURIER_ARMOUR_REACTIVE", ShipType.EMPIRE_COURIER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 5993700, "Empire_Courier_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour INDEPENDANT_TRADER_ARMOUR_GRADE_1 = new Armour("INDEPENDANT_TRADER_ARMOUR_GRADE_1", ShipType.INDEPENDANT_TRADER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Independant_Trader_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour INDEPENDANT_TRADER_ARMOUR_GRADE_2 = new Armour("INDEPENDANT_TRADER_ARMOUR_GRADE_2", ShipType.INDEPENDANT_TRADER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 1250460, "Independant_Trader_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 12.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour INDEPENDANT_TRADER_ARMOUR_GRADE_3 = new Armour("INDEPENDANT_TRADER_ARMOUR_GRADE_3", ShipType.INDEPENDANT_TRADER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 2813540, "Independant_Trader_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 23.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour INDEPENDANT_TRADER_ARMOUR_MIRRORED = new Armour("INDEPENDANT_TRADER_ARMOUR_MIRRORED", ShipType.INDEPENDANT_TRADER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 6649330, "Independant_Trader_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 23.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour INDEPENDANT_TRADER_ARMOUR_REACTIVE = new Armour("INDEPENDANT_TRADER_ARMOUR_REACTIVE", ShipType.INDEPENDANT_TRADER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 7368340, "Independant_Trader_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 23.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour ASP_SCOUT_ARMOUR_GRADE_1 = new Armour("ASP_SCOUT_ARMOUR_GRADE_1", ShipType.ASP_SCOUT, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Asp_Scout_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ASP_SCOUT_ARMOUR_GRADE_2 = new Armour("ASP_SCOUT_ARMOUR_GRADE_2", ShipType.ASP_SCOUT, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 1584460, "Asp_Scout_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 21.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ASP_SCOUT_ARMOUR_GRADE_3 = new Armour("ASP_SCOUT_ARMOUR_GRADE_3", ShipType.ASP_SCOUT, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 3565040, "Asp_Scout_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 42.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ASP_SCOUT_ARMOUR_MIRRORED = new Armour("ASP_SCOUT_ARMOUR_MIRRORED", ShipType.ASP_SCOUT, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 8425380, "Asp_Scout_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 42.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour ASP_SCOUT_ARMOUR_REACTIVE = new Armour("ASP_SCOUT_ARMOUR_REACTIVE", ShipType.ASP_SCOUT, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 9336440, "Asp_Scout_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 42.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour VULTURE_ARMOUR_GRADE_1 = new Armour("VULTURE_ARMOUR_GRADE_1", ShipType.VULTURE, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Vulture_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VULTURE_ARMOUR_GRADE_2 = new Armour("VULTURE_ARMOUR_GRADE_2", ShipType.VULTURE, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 1970250, "Vulture_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 17.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VULTURE_ARMOUR_GRADE_3 = new Armour("VULTURE_ARMOUR_GRADE_3", ShipType.VULTURE, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 4433050, "Vulture_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 35.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour VULTURE_ARMOUR_MIRRORED = new Armour("VULTURE_ARMOUR_MIRRORED", ShipType.VULTURE, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 10476780, "Vulture_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 35.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour VULTURE_ARMOUR_REACTIVE = new Armour("VULTURE_ARMOUR_REACTIVE", ShipType.VULTURE, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 11609670, "Vulture_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 35.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour ASP_ARMOUR_GRADE_1 = new Armour("ASP_ARMOUR_GRADE_1", ShipType.ASP, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Asp_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ASP_ARMOUR_GRADE_2 = new Armour("ASP_ARMOUR_GRADE_2", ShipType.ASP, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 2664460, "Asp_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 21.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ASP_ARMOUR_GRADE_3 = new Armour("ASP_ARMOUR_GRADE_3", ShipType.ASP, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 5995040, "Asp_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 42.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ASP_ARMOUR_MIRRORED = new Armour("ASP_ARMOUR_MIRRORED", ShipType.ASP, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 14168270, "Asp_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 42.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour ASP_ARMOUR_REACTIVE = new Armour("ASP_ARMOUR_REACTIVE", ShipType.ASP, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 15700340, "Asp_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 42.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour FEDERATION_DROPSHIP_ARMOUR_GRADE_1 = new Armour("FEDERATION_DROPSHIP_ARMOUR_GRADE_1", ShipType.FEDERATION_DROPSHIP, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Federation_Dropship_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_DROPSHIP_ARMOUR_GRADE_2 = new Armour("FEDERATION_DROPSHIP_ARMOUR_GRADE_2", ShipType.FEDERATION_DROPSHIP, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 5725680, "Federation_Dropship_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 44.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_DROPSHIP_ARMOUR_GRADE_3 = new Armour("FEDERATION_DROPSHIP_ARMOUR_GRADE_3", ShipType.FEDERATION_DROPSHIP, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 12882780, "Federation_Dropship_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_DROPSHIP_ARMOUR_MIRRORED = new Armour("FEDERATION_DROPSHIP_ARMOUR_MIRRORED", ShipType.FEDERATION_DROPSHIP, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 30446310, "Federation_Dropship_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour FEDERATION_DROPSHIP_ARMOUR_REACTIVE = new Armour("FEDERATION_DROPSHIP_ARMOUR_REACTIVE", ShipType.FEDERATION_DROPSHIP, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 33738580, "Federation_Dropship_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_7_ARMOUR_GRADE_1 = new Armour("TYPE_7_ARMOUR_GRADE_1", ShipType.TYPE_7, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Type7_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_7_ARMOUR_GRADE_2 = new Armour("TYPE_7_ARMOUR_GRADE_2", ShipType.TYPE_7, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 6988900, "Type7_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_7_ARMOUR_GRADE_3 = new Armour("TYPE_7_ARMOUR_GRADE_3", ShipType.TYPE_7, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 15725030, "Type7_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 63.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_7_ARMOUR_MIRRORED = new Armour("TYPE_7_ARMOUR_MIRRORED", ShipType.TYPE_7, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 37163480, "Type7_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 63.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_7_ARMOUR_REACTIVE = new Armour("TYPE_7_ARMOUR_REACTIVE", ShipType.TYPE_7, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 41182100, "Type7_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 63.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_X_ARMOUR_GRADE_1 = new Armour("TYPE_X_ARMOUR_GRADE_1", ShipType.TYPE_X, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "TypeX_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_ARMOUR_GRADE_2 = new Armour("TYPE_X_ARMOUR_GRADE_2", ShipType.TYPE_X, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 7752900, "TypeX_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_ARMOUR_GRADE_3 = new Armour("TYPE_X_ARMOUR_GRADE_3", ShipType.TYPE_X, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 17444030, "TypeX_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_ARMOUR_MIRRORED = new Armour("TYPE_X_ARMOUR_MIRRORED", ShipType.TYPE_X, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 41226050, "TypeX_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_X_ARMOUR_REACTIVE = new Armour("TYPE_X_ARMOUR_REACTIVE", ShipType.TYPE_X, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 45683980, "TypeX_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_1 = new Armour("FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_1", ShipType.FEDERATION_DROPSHIP_MK_II, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Federation_Dropship_MkII_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_2 = new Armour("FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_2", ShipType.FEDERATION_DROPSHIP_MK_II, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 7925680, "Federation_Dropship_MkII_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 44.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_3 = new Armour("FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_3", ShipType.FEDERATION_DROPSHIP_MK_II, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 17832780, "Federation_Dropship_MkII_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_DROPSHIP_MK_II_ARMOUR_MIRRORED = new Armour("FEDERATION_DROPSHIP_MK_II_ARMOUR_MIRRORED", ShipType.FEDERATION_DROPSHIP_MK_II, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 42144810, "Federation_Dropship_MkII_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour FEDERATION_DROPSHIP_MK_II_ARMOUR_REACTIVE = new Armour("FEDERATION_DROPSHIP_MK_II_ARMOUR_REACTIVE", ShipType.FEDERATION_DROPSHIP_MK_II, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 46702080, "Federation_Dropship_MkII_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour EMPIRE_TRADER_ARMOUR_GRADE_1 = new Armour("EMPIRE_TRADER_ARMOUR_GRADE_1", ShipType.EMPIRE_TRADER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Empire_Trader_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_TRADER_ARMOUR_GRADE_2 = new Armour("EMPIRE_TRADER_ARMOUR_GRADE_2", ShipType.EMPIRE_TRADER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 8918340, "Empire_Trader_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 30.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_TRADER_ARMOUR_GRADE_3 = new Armour("EMPIRE_TRADER_ARMOUR_GRADE_3", ShipType.EMPIRE_TRADER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 20066270, "Empire_Trader_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour EMPIRE_TRADER_ARMOUR_MIRRORED = new Armour("EMPIRE_TRADER_ARMOUR_MIRRORED", ShipType.EMPIRE_TRADER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 47423290, "Empire_Trader_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour EMPIRE_TRADER_ARMOUR_REACTIVE = new Armour("EMPIRE_TRADER_ARMOUR_REACTIVE", ShipType.EMPIRE_TRADER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 52551340, "Empire_Trader_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_X_2_ARMOUR_GRADE_1 = new Armour("TYPE_X_2_ARMOUR_GRADE_1", ShipType.TYPE_X_2, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "TypeX_2_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_2_ARMOUR_GRADE_2 = new Armour("TYPE_X_2_ARMOUR_GRADE_2", ShipType.TYPE_X_2, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 9146540, "TypeX_2_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_2_ARMOUR_GRADE_3 = new Armour("TYPE_X_2_ARMOUR_GRADE_3", ShipType.TYPE_X_2, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 20579710, "TypeX_2_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_2_ARMOUR_MIRRORED = new Armour("TYPE_X_2_ARMOUR_MIRRORED", ShipType.TYPE_X_2, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 48636710, "TypeX_2_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_X_2_ARMOUR_REACTIVE = new Armour("TYPE_X_2_ARMOUR_REACTIVE", ShipType.TYPE_X_2, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 53895970, "TypeX_2_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_X_3_ARMOUR_GRADE_1 = new Armour("TYPE_X_3_ARMOUR_GRADE_1", ShipType.TYPE_X_3, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "TypeX_3_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_3_ARMOUR_GRADE_2 = new Armour("TYPE_X_3_ARMOUR_GRADE_2", ShipType.TYPE_X_3, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 12188900, "TypeX_3_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_3_ARMOUR_GRADE_3 = new Armour("TYPE_X_3_ARMOUR_GRADE_3", ShipType.TYPE_X_3, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 27425026, "TypeX_3_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_X_3_ARMOUR_MIRRORED = new Armour("TYPE_X_3_ARMOUR_MIRRORED", ShipType.TYPE_X_3, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 64814480, "TypeX_3_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_X_3_ARMOUR_REACTIVE = new Armour("TYPE_X_3_ARMOUR_REACTIVE", ShipType.TYPE_X_3, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 71823097, "TypeX_3_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 78.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour FEDERATION_GUNSHIP_ARMOUR_GRADE_1 = new Armour("FEDERATION_GUNSHIP_ARMOUR_GRADE_1", ShipType.FEDERATION_GUNSHIP, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Federation_Gunship_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_GUNSHIP_ARMOUR_GRADE_2 = new Armour("FEDERATION_GUNSHIP_ARMOUR_GRADE_2", ShipType.FEDERATION_GUNSHIP, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 14325690, "Federation_Gunship_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 44.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_GUNSHIP_ARMOUR_GRADE_3 = new Armour("FEDERATION_GUNSHIP_ARMOUR_GRADE_3", ShipType.FEDERATION_GUNSHIP, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 32232790, "Federation_Gunship_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_GUNSHIP_ARMOUR_MIRRORED = new Armour("FEDERATION_GUNSHIP_ARMOUR_MIRRORED", ShipType.FEDERATION_GUNSHIP, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 76176810, "Federation_Gunship_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour FEDERATION_GUNSHIP_ARMOUR_REACTIVE = new Armour("FEDERATION_GUNSHIP_ARMOUR_REACTIVE", ShipType.FEDERATION_GUNSHIP, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 84414090, "Federation_Gunship_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour KRAIT_LIGHT_ARMOUR_GRADE_1 = new Armour("KRAIT_LIGHT_ARMOUR_GRADE_1", ShipType.KRAIT_LIGHT, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Krait_Light_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour KRAIT_LIGHT_ARMOUR_GRADE_2 = new Armour("KRAIT_LIGHT_ARMOUR_GRADE_2", ShipType.KRAIT_LIGHT, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 14988900, "Krait_Light_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 26.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour KRAIT_LIGHT_ARMOUR_GRADE_3 = new Armour("KRAIT_LIGHT_ARMOUR_GRADE_3", ShipType.KRAIT_LIGHT, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 33725030, "Krait_Light_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour KRAIT_LIGHT_ARMOUR_MIRRORED = new Armour("KRAIT_LIGHT_ARMOUR_MIRRORED", ShipType.KRAIT_LIGHT, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 79703480, "Krait_Light_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour KRAIT_LIGHT_ARMOUR_REACTIVE = new Armour("KRAIT_LIGHT_ARMOUR_REACTIVE", ShipType.KRAIT_LIGHT, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 88322100, "Krait_Light_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour KRAIT_MK_II_ARMOUR_GRADE_1 = new Armour("KRAIT_MK_II_ARMOUR_GRADE_1", ShipType.KRAIT_MK_II, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Krait_MkII_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour KRAIT_MK_II_ARMOUR_GRADE_2 = new Armour("KRAIT_MK_II_ARMOUR_GRADE_2", ShipType.KRAIT_MK_II, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 18325680, "Krait_MkII_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 36.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour KRAIT_MK_II_ARMOUR_GRADE_3 = new Armour("KRAIT_MK_II_ARMOUR_GRADE_3", ShipType.KRAIT_MK_II, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 41232790, "Krait_MkII_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 67.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour KRAIT_MK_II_ARMOUR_MIRRORED = new Armour("KRAIT_MK_II_ARMOUR_MIRRORED", ShipType.KRAIT_MK_II, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 97446810, "Krait_MkII_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 67.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour KRAIT_MK_II_ARMOUR_REACTIVE = new Armour("KRAIT_MK_II_ARMOUR_REACTIVE", ShipType.KRAIT_MK_II, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 107984080, "Krait_MkII_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 67.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour ORCA_ARMOUR_GRADE_1 = new Armour("ORCA_ARMOUR_GRADE_1", ShipType.ORCA, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Orca_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ORCA_ARMOUR_GRADE_2 = new Armour("ORCA_ARMOUR_GRADE_2", ShipType.ORCA, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 19415950, "Orca_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 21.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ORCA_ARMOUR_GRADE_3 = new Armour("ORCA_ARMOUR_GRADE_3", ShipType.ORCA, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 43685900, "Orca_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ORCA_ARMOUR_MIRRORED = new Armour("ORCA_ARMOUR_MIRRORED", ShipType.ORCA, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 103244340, "Orca_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour ORCA_ARMOUR_REACTIVE = new Armour("ORCA_ARMOUR_REACTIVE", ShipType.ORCA, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 114408510, "Orca_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 87.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour FER_DE_LANCE_ARMOUR_GRADE_1 = new Armour("FER_DE_LANCE_ARMOUR_GRADE_1", ShipType.FER_DE_LANCE, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "FerDeLance_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FER_DE_LANCE_ARMOUR_GRADE_2 = new Armour("FER_DE_LANCE_ARMOUR_GRADE_2", ShipType.FER_DE_LANCE, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 20626820, "FerDeLance_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 19.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FER_DE_LANCE_ARMOUR_GRADE_3 = new Armour("FER_DE_LANCE_ARMOUR_GRADE_3", ShipType.FER_DE_LANCE, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 46410340, "FerDeLance_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 38.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FER_DE_LANCE_ARMOUR_MIRRORED = new Armour("FER_DE_LANCE_ARMOUR_MIRRORED", ShipType.FER_DE_LANCE, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 109683090, "FerDeLance_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 38.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour FER_DE_LANCE_ARMOUR_REACTIVE = new Armour("FER_DE_LANCE_ARMOUR_REACTIVE", ShipType.FER_DE_LANCE, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 121543510, "FerDeLance_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 38.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour MAMBA_ARMOUR_GRADE_1 = new Armour("MAMBA_ARMOUR_GRADE_1", ShipType.MAMBA, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Mamba_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour MAMBA_ARMOUR_GRADE_2 = new Armour("MAMBA_ARMOUR_GRADE_2", ShipType.MAMBA, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 22346816, "Mamba_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 19.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour MAMBA_ARMOUR_GRADE_3 = new Armour("MAMBA_ARMOUR_GRADE_3", ShipType.MAMBA, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 50280336, "Mamba_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 38.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour MAMBA_ARMOUR_MIRRORED = new Armour("MAMBA_ARMOUR_MIRRORED", ShipType.MAMBA, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 118829194, "Mamba_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 38.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour MAMBA_ARMOUR_REACTIVE = new Armour("MAMBA_ARMOUR_REACTIVE", ShipType.MAMBA, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 131678613, "Mamba_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 38.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour PYTHON_ARMOUR_GRADE_1 = new Armour("PYTHON_ARMOUR_GRADE_1", ShipType.PYTHON, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Python_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour PYTHON_ARMOUR_GRADE_2 = new Armour("PYTHON_ARMOUR_GRADE_2", ShipType.PYTHON, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 22791270, "Python_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 26.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour PYTHON_ARMOUR_GRADE_3 = new Armour("PYTHON_ARMOUR_GRADE_3", ShipType.PYTHON, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 51280360, "Python_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour PYTHON_ARMOUR_MIRRORED = new Armour("PYTHON_ARMOUR_MIRRORED", ShipType.PYTHON, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 121192590, "Python_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour PYTHON_ARMOUR_REACTIVE = new Armour("PYTHON_ARMOUR_REACTIVE", ShipType.PYTHON, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 134297570, "Python_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour PYTHON_NX_ARMOUR_GRADE_1 = new Armour("PYTHON_NX_ARMOUR_GRADE_1", ShipType.PYTHON_NX, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Python_nx_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour PYTHON_NX_ARMOUR_GRADE_2 = new Armour("PYTHON_NX_ARMOUR_GRADE_2", ShipType.PYTHON_NX, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 27010944, "Python_nx_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 26.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour PYTHON_NX_ARMOUR_GRADE_3 = new Armour("PYTHON_NX_ARMOUR_GRADE_3", ShipType.PYTHON_NX, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 60774623, "Python_nx_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour PYTHON_NX_ARMOUR_MIRRORED = new Armour("PYTHON_NX_ARMOUR_MIRRORED", ShipType.PYTHON_NX, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 143630693, "Python_nx_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour PYTHON_NX_ARMOUR_REACTIVE = new Armour("PYTHON_NX_ARMOUR_REACTIVE", ShipType.PYTHON_NX, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 159161986, "Python_nx_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 53.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_8_ARMOUR_GRADE_1 = new Armour("TYPE_8_ARMOUR_GRADE_1", ShipType.TYPE_8, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Type8_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_8_ARMOUR_GRADE_2 = new Armour("TYPE_8_ARMOUR_GRADE_2", ShipType.TYPE_8, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 15381590, "Type8_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 75.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_8_ARMOUR_GRADE_3 = new Armour("TYPE_8_ARMOUR_GRADE_3", ShipType.TYPE_8, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 34608570, "Type8_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_8_ARMOUR_MIRRORED = new Armour("TYPE_8_ARMOUR_MIRRORED", ShipType.TYPE_8, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 81791588, "Type8_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_8_ARMOUR_REACTIVE = new Armour("TYPE_8_ARMOUR_REACTIVE", ShipType.TYPE_8, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 90636000, "Type8_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_9_ARMOUR_GRADE_1 = new Armour("TYPE_9_ARMOUR_GRADE_1", ShipType.TYPE_9, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Type9_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_9_ARMOUR_GRADE_2 = new Armour("TYPE_9_ARMOUR_GRADE_2", ShipType.TYPE_9, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 30622340, "Type9_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 75.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_9_ARMOUR_GRADE_3 = new Armour("TYPE_9_ARMOUR_GRADE_3", ShipType.TYPE_9, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 68900260, "Type9_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_9_ARMOUR_MIRRORED = new Armour("TYPE_9_ARMOUR_MIRRORED", ShipType.TYPE_9, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 162834280, "Type9_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_9_ARMOUR_REACTIVE = new Armour("TYPE_9_ARMOUR_REACTIVE", ShipType.TYPE_9, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 180442120, "Type9_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour BELUGA_LINER_ARMOUR_GRADE_1 = new Armour("BELUGA_LINER_ARMOUR_GRADE_1", ShipType.BELUGA_LINER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "BelugaLiner_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour BELUGA_LINER_ARMOUR_GRADE_2 = new Armour("BELUGA_LINER_ARMOUR_GRADE_2", ShipType.BELUGA_LINER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 33813120, "BelugaLiner_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 83.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour BELUGA_LINER_ARMOUR_GRADE_3 = new Armour("BELUGA_LINER_ARMOUR_GRADE_3", ShipType.BELUGA_LINER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 76079500, "BelugaLiner_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 165.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour BELUGA_LINER_ARMOUR_MIRRORED = new Armour("BELUGA_LINER_ARMOUR_MIRRORED", ShipType.BELUGA_LINER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 179801200, "BelugaLiner_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 165.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour BELUGA_LINER_ARMOUR_REACTIVE = new Armour("BELUGA_LINER_ARMOUR_REACTIVE", ShipType.BELUGA_LINER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 199243730, "BelugaLiner_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 165.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour TYPE_9_MILITARY_ARMOUR_GRADE_1 = new Armour("TYPE_9_MILITARY_ARMOUR_GRADE_1", ShipType.TYPE_9_MILITARY, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Type9_Military_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_9_MILITARY_ARMOUR_GRADE_2 = new Armour("TYPE_9_MILITARY_ARMOUR_GRADE_2", ShipType.TYPE_9_MILITARY, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 49902130, "Type9_Military_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 75.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_9_MILITARY_ARMOUR_GRADE_3 = new Armour("TYPE_9_MILITARY_ARMOUR_GRADE_3", ShipType.TYPE_9_MILITARY, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 112279810, "Type9_Military_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour TYPE_9_MILITARY_ARMOUR_MIRRORED = new Armour("TYPE_9_MILITARY_ARMOUR_MIRRORED", ShipType.TYPE_9_MILITARY, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 265354610, "Type9_Military_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour TYPE_9_MILITARY_ARMOUR_REACTIVE = new Armour("TYPE_9_MILITARY_ARMOUR_REACTIVE", ShipType.TYPE_9_MILITARY, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 294048340, "Type9_Military_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 150.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour ANACONDA_ARMOUR_GRADE_1 = new Armour("ANACONDA_ARMOUR_GRADE_1", ShipType.ANACONDA, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Anaconda_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ANACONDA_ARMOUR_GRADE_2 = new Armour("ANACONDA_ARMOUR_GRADE_2", ShipType.ANACONDA, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 58787780, "Anaconda_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 30.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ANACONDA_ARMOUR_GRADE_3 = new Armour("ANACONDA_ARMOUR_GRADE_3", ShipType.ANACONDA, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 132272510, "Anaconda_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour ANACONDA_ARMOUR_MIRRORED = new Armour("ANACONDA_ARMOUR_MIRRORED", ShipType.ANACONDA, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 312604020, "Anaconda_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour ANACONDA_ARMOUR_REACTIVE = new Armour("ANACONDA_ARMOUR_REACTIVE", ShipType.ANACONDA, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 346407000, "Anaconda_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour FEDERATION_CORVETTE_ARMOUR_GRADE_1 = new Armour("FEDERATION_CORVETTE_ARMOUR_GRADE_1", ShipType.FEDERATION_CORVETTE, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Federation_Corvette_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_CORVETTE_ARMOUR_GRADE_2 = new Armour("FEDERATION_CORVETTE_ARMOUR_GRADE_2", ShipType.FEDERATION_CORVETTE, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 75187790, "Federation_Corvette_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 30.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_CORVETTE_ARMOUR_GRADE_3 = new Armour("FEDERATION_CORVETTE_ARMOUR_GRADE_3", ShipType.FEDERATION_CORVETTE, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 169172510, "Federation_Corvette_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour FEDERATION_CORVETTE_ARMOUR_MIRRORED = new Armour("FEDERATION_CORVETTE_ARMOUR_MIRRORED", ShipType.FEDERATION_CORVETTE, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 399811020, "Federation_Corvette_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour FEDERATION_CORVETTE_ARMOUR_REACTIVE = new Armour("FEDERATION_CORVETTE_ARMOUR_REACTIVE", ShipType.FEDERATION_CORVETTE, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 443044000, "Federation_Corvette_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour CUTTER_ARMOUR_GRADE_1 = new Armour("CUTTER_ARMOUR_GRADE_1", ShipType.CUTTER, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Cutter_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour CUTTER_ARMOUR_GRADE_2 = new Armour("CUTTER_ARMOUR_GRADE_2", ShipType.CUTTER, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 83587780, "Cutter_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 30.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour CUTTER_ARMOUR_GRADE_3 = new Armour("CUTTER_ARMOUR_GRADE_3", ShipType.CUTTER, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 188072500, "Cutter_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour CUTTER_ARMOUR_MIRRORED = new Armour("CUTTER_ARMOUR_MIRRORED", ShipType.CUTTER, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 444478020, "Cutter_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour CUTTER_ARMOUR_REACTIVE = new Armour("CUTTER_ARMOUR_REACTIVE", ShipType.CUTTER, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 492541000, "Cutter_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 60.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));
    public static final Armour MANDALAY_ARMOUR_GRADE_1 = new Armour("MANDALAY_ARMOUR_GRADE_1", ShipType.MANDALAY, ArmourType.LIGHTWEIGHT_ALLOY, HorizonsBlueprintName.LIGHTWEIGHT_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.C, 0, "Mandalay_Armour_Grade1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, .80), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour MANDALAY_ARMOUR_GRADE_2 = new Armour("MANDALAY_ARMOUR_GRADE_2", ShipType.MANDALAY, ArmourType.REINFORCED_ALLOY, HorizonsBlueprintName.REINFORCED_ALLOY_ARMOUR, ModuleSize.SIZE_1, ModuleClass.B, 0, "Mandalay_Armour_Grade2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, 1.52), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour MANDALAY_ARMOUR_GRADE_3 = new Armour("MANDALAY_ARMOUR_GRADE_3", ShipType.MANDALAY, ArmourType.MILITARY_GRADE_COMPOSITE, HorizonsBlueprintName.MILITARY_GRADE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 0, "Mandalay_Armour_Grade3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.20), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.40)));
    public static final Armour MANDALAY_ARMOUR_MIRRORED = new Armour("MANDALAY_ARMOUR_MIRRORED", ShipType.MANDALAY, ArmourType.MIRRORED_SURFACE_COMPOSITE, HorizonsBlueprintName.MIRRORED_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 0, "Mandalay_Armour_Mirrored", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, -0.75), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.50), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, -0.50)));
    public static final Armour MANDALAY_ARMOUR_REACTIVE = new Armour("MANDALAY_ARMOUR_REACTIVE", ShipType.MANDALAY, ArmourType.REACTIVE_SURFACE_COMPOSITE, HorizonsBlueprintName.REACTIVE_SURFACE_COMPOSITE_ARMOUR, ModuleSize.SIZE_1, ModuleClass.A, 0, "Mandalay_Armour_Reactive", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.00), Map.entry(HorizonsModifier.HULL_BOOST, 2.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0D), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.25), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.40), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.20)));

    public static final List<Armour> ARMOURS = List.of(
            SIDE_WINDER_ARMOUR_GRADE_1,
            SIDE_WINDER_ARMOUR_GRADE_2,
            SIDE_WINDER_ARMOUR_GRADE_3,
            SIDE_WINDER_ARMOUR_MIRRORED,
            SIDE_WINDER_ARMOUR_REACTIVE,
            EAGLE_ARMOUR_GRADE_1,
            EAGLE_ARMOUR_GRADE_2,
            EAGLE_ARMOUR_GRADE_3,
            EAGLE_ARMOUR_MIRRORED,
            EAGLE_ARMOUR_REACTIVE,
            HAULER_ARMOUR_GRADE_1,
            HAULER_ARMOUR_GRADE_2,
            HAULER_ARMOUR_GRADE_3,
            HAULER_ARMOUR_MIRRORED,
            HAULER_ARMOUR_REACTIVE,
            ADDER_ARMOUR_GRADE_1,
            ADDER_ARMOUR_GRADE_2,
            ADDER_ARMOUR_GRADE_3,
            ADDER_ARMOUR_MIRRORED,
            ADDER_ARMOUR_REACTIVE,
            EMPIRE_EAGLE_ARMOUR_GRADE_1,
            EMPIRE_EAGLE_ARMOUR_GRADE_2,
            EMPIRE_EAGLE_ARMOUR_GRADE_3,
            EMPIRE_EAGLE_ARMOUR_MIRRORED,
            EMPIRE_EAGLE_ARMOUR_REACTIVE,
            VIPER_ARMOUR_GRADE_1,
            VIPER_ARMOUR_GRADE_2,
            VIPER_ARMOUR_GRADE_3,
            VIPER_ARMOUR_MIRRORED,
            VIPER_ARMOUR_REACTIVE,
            COBRA_MK_III_ARMOUR_GRADE_1,
            COBRA_MK_III_ARMOUR_GRADE_2,
            COBRA_MK_III_ARMOUR_GRADE_3,
            COBRA_MK_III_ARMOUR_MIRRORED,
            COBRA_MK_III_ARMOUR_REACTIVE,
            VIPER_MK_IV_ARMOUR_GRADE_1,
            VIPER_MK_IV_ARMOUR_GRADE_2,
            VIPER_MK_IV_ARMOUR_GRADE_3,
            VIPER_MK_IV_ARMOUR_MIRRORED,
            VIPER_MK_IV_ARMOUR_REACTIVE,
            DIAMOND_BACK_ARMOUR_GRADE_1,
            DIAMOND_BACK_ARMOUR_GRADE_2,
            DIAMOND_BACK_ARMOUR_GRADE_3,
            DIAMOND_BACK_ARMOUR_MIRRORED,
            DIAMOND_BACK_ARMOUR_REACTIVE,
            COBRA_MK_IV_ARMOUR_GRADE_1,
            COBRA_MK_IV_ARMOUR_GRADE_2,
            COBRA_MK_IV_ARMOUR_GRADE_3,
            COBRA_MK_IV_ARMOUR_MIRRORED,
            COBRA_MK_IV_ARMOUR_REACTIVE,
            TYPE_6_ARMOUR_GRADE_1,
            TYPE_6_ARMOUR_GRADE_2,
            TYPE_6_ARMOUR_GRADE_3,
            TYPE_6_ARMOUR_MIRRORED,
            TYPE_6_ARMOUR_REACTIVE,
            DOLPHIN_ARMOUR_GRADE_1,
            DOLPHIN_ARMOUR_GRADE_2,
            DOLPHIN_ARMOUR_GRADE_3,
            DOLPHIN_ARMOUR_MIRRORED,
            DOLPHIN_ARMOUR_REACTIVE,
            DIAMOND_BACK_XL_ARMOUR_GRADE_1,
            DIAMOND_BACK_XL_ARMOUR_GRADE_2,
            DIAMOND_BACK_XL_ARMOUR_GRADE_3,
            DIAMOND_BACK_XL_ARMOUR_MIRRORED,
            DIAMOND_BACK_XL_ARMOUR_REACTIVE,
            EMPIRE_COURIER_ARMOUR_GRADE_1,
            EMPIRE_COURIER_ARMOUR_GRADE_2,
            EMPIRE_COURIER_ARMOUR_GRADE_3,
            EMPIRE_COURIER_ARMOUR_MIRRORED,
            EMPIRE_COURIER_ARMOUR_REACTIVE,
            INDEPENDANT_TRADER_ARMOUR_GRADE_1,
            INDEPENDANT_TRADER_ARMOUR_GRADE_2,
            INDEPENDANT_TRADER_ARMOUR_GRADE_3,
            INDEPENDANT_TRADER_ARMOUR_MIRRORED,
            INDEPENDANT_TRADER_ARMOUR_REACTIVE,
            ASP_SCOUT_ARMOUR_GRADE_1,
            ASP_SCOUT_ARMOUR_GRADE_2,
            ASP_SCOUT_ARMOUR_GRADE_3,
            ASP_SCOUT_ARMOUR_MIRRORED,
            ASP_SCOUT_ARMOUR_REACTIVE,
            VULTURE_ARMOUR_GRADE_1,
            VULTURE_ARMOUR_GRADE_2,
            VULTURE_ARMOUR_GRADE_3,
            VULTURE_ARMOUR_MIRRORED,
            VULTURE_ARMOUR_REACTIVE,
            ASP_ARMOUR_GRADE_1,
            ASP_ARMOUR_GRADE_2,
            ASP_ARMOUR_GRADE_3,
            ASP_ARMOUR_MIRRORED,
            ASP_ARMOUR_REACTIVE,
            FEDERATION_DROPSHIP_ARMOUR_GRADE_1,
            FEDERATION_DROPSHIP_ARMOUR_GRADE_2,
            FEDERATION_DROPSHIP_ARMOUR_GRADE_3,
            FEDERATION_DROPSHIP_ARMOUR_MIRRORED,
            FEDERATION_DROPSHIP_ARMOUR_REACTIVE,
            TYPE_7_ARMOUR_GRADE_1,
            TYPE_7_ARMOUR_GRADE_2,
            TYPE_7_ARMOUR_GRADE_3,
            TYPE_7_ARMOUR_MIRRORED,
            TYPE_7_ARMOUR_REACTIVE,
            TYPE_X_ARMOUR_GRADE_1,
            TYPE_X_ARMOUR_GRADE_2,
            TYPE_X_ARMOUR_GRADE_3,
            TYPE_X_ARMOUR_MIRRORED,
            TYPE_X_ARMOUR_REACTIVE,
            FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_1,
            FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_2,
            FEDERATION_DROPSHIP_MK_II_ARMOUR_GRADE_3,
            FEDERATION_DROPSHIP_MK_II_ARMOUR_MIRRORED,
            FEDERATION_DROPSHIP_MK_II_ARMOUR_REACTIVE,
            EMPIRE_TRADER_ARMOUR_GRADE_1,
            EMPIRE_TRADER_ARMOUR_GRADE_2,
            EMPIRE_TRADER_ARMOUR_GRADE_3,
            EMPIRE_TRADER_ARMOUR_MIRRORED,
            EMPIRE_TRADER_ARMOUR_REACTIVE,
            TYPE_X_2_ARMOUR_GRADE_1,
            TYPE_X_2_ARMOUR_GRADE_2,
            TYPE_X_2_ARMOUR_GRADE_3,
            TYPE_X_2_ARMOUR_MIRRORED,
            TYPE_X_2_ARMOUR_REACTIVE,
            TYPE_X_3_ARMOUR_GRADE_1,
            TYPE_X_3_ARMOUR_GRADE_2,
            TYPE_X_3_ARMOUR_GRADE_3,
            TYPE_X_3_ARMOUR_MIRRORED,
            TYPE_X_3_ARMOUR_REACTIVE,
            FEDERATION_GUNSHIP_ARMOUR_GRADE_1,
            FEDERATION_GUNSHIP_ARMOUR_GRADE_2,
            FEDERATION_GUNSHIP_ARMOUR_GRADE_3,
            FEDERATION_GUNSHIP_ARMOUR_MIRRORED,
            FEDERATION_GUNSHIP_ARMOUR_REACTIVE,
            KRAIT_LIGHT_ARMOUR_GRADE_1,
            KRAIT_LIGHT_ARMOUR_GRADE_2,
            KRAIT_LIGHT_ARMOUR_GRADE_3,
            KRAIT_LIGHT_ARMOUR_MIRRORED,
            KRAIT_LIGHT_ARMOUR_REACTIVE,
            KRAIT_MK_II_ARMOUR_GRADE_1,
            KRAIT_MK_II_ARMOUR_GRADE_2,
            KRAIT_MK_II_ARMOUR_GRADE_3,
            KRAIT_MK_II_ARMOUR_MIRRORED,
            KRAIT_MK_II_ARMOUR_REACTIVE,
            ORCA_ARMOUR_GRADE_1,
            ORCA_ARMOUR_GRADE_2,
            ORCA_ARMOUR_GRADE_3,
            ORCA_ARMOUR_MIRRORED,
            ORCA_ARMOUR_REACTIVE,
            FER_DE_LANCE_ARMOUR_GRADE_1,
            FER_DE_LANCE_ARMOUR_GRADE_2,
            FER_DE_LANCE_ARMOUR_GRADE_3,
            FER_DE_LANCE_ARMOUR_MIRRORED,
            FER_DE_LANCE_ARMOUR_REACTIVE,
            MAMBA_ARMOUR_GRADE_1,
            MAMBA_ARMOUR_GRADE_2,
            MAMBA_ARMOUR_GRADE_3,
            MAMBA_ARMOUR_MIRRORED,
            MAMBA_ARMOUR_REACTIVE,
            PYTHON_ARMOUR_GRADE_1,
            PYTHON_ARMOUR_GRADE_2,
            PYTHON_ARMOUR_GRADE_3,
            PYTHON_ARMOUR_MIRRORED,
            PYTHON_ARMOUR_REACTIVE,
            PYTHON_NX_ARMOUR_GRADE_1,
            PYTHON_NX_ARMOUR_GRADE_2,
            PYTHON_NX_ARMOUR_GRADE_3,
            PYTHON_NX_ARMOUR_MIRRORED,
            PYTHON_NX_ARMOUR_REACTIVE,
            TYPE_9_ARMOUR_GRADE_1,
            TYPE_9_ARMOUR_GRADE_2,
            TYPE_9_ARMOUR_GRADE_3,
            TYPE_9_ARMOUR_MIRRORED,
            TYPE_9_ARMOUR_REACTIVE,
            BELUGA_LINER_ARMOUR_GRADE_1,
            BELUGA_LINER_ARMOUR_GRADE_2,
            BELUGA_LINER_ARMOUR_GRADE_3,
            BELUGA_LINER_ARMOUR_MIRRORED,
            BELUGA_LINER_ARMOUR_REACTIVE,
            TYPE_9_MILITARY_ARMOUR_GRADE_1,
            TYPE_9_MILITARY_ARMOUR_GRADE_2,
            TYPE_9_MILITARY_ARMOUR_GRADE_3,
            TYPE_9_MILITARY_ARMOUR_MIRRORED,
            TYPE_9_MILITARY_ARMOUR_REACTIVE,
            ANACONDA_ARMOUR_GRADE_1,
            ANACONDA_ARMOUR_GRADE_2,
            ANACONDA_ARMOUR_GRADE_3,
            ANACONDA_ARMOUR_MIRRORED,
            ANACONDA_ARMOUR_REACTIVE,
            FEDERATION_CORVETTE_ARMOUR_GRADE_1,
            FEDERATION_CORVETTE_ARMOUR_GRADE_2,
            FEDERATION_CORVETTE_ARMOUR_GRADE_3,
            FEDERATION_CORVETTE_ARMOUR_MIRRORED,
            FEDERATION_CORVETTE_ARMOUR_REACTIVE,
            CUTTER_ARMOUR_GRADE_1,
            CUTTER_ARMOUR_GRADE_2,
            CUTTER_ARMOUR_GRADE_3,
            CUTTER_ARMOUR_MIRRORED,
            CUTTER_ARMOUR_REACTIVE,
            TYPE_8_ARMOUR_GRADE_1,
            TYPE_8_ARMOUR_GRADE_2,
            TYPE_8_ARMOUR_GRADE_3,
            TYPE_8_ARMOUR_MIRRORED,
            TYPE_8_ARMOUR_REACTIVE,
            MANDALAY_ARMOUR_GRADE_1,
            MANDALAY_ARMOUR_GRADE_2,
            MANDALAY_ARMOUR_GRADE_3,
            MANDALAY_ARMOUR_MIRRORED,
            MANDALAY_ARMOUR_REACTIVE
    );
    @Getter
    private final ShipType shipType;
    @Getter
    private final ArmourType armourType;

    private Armour(final String id, final ShipType shipType, final ArmourType armourType, final HorizonsBlueprintName name, final ModuleSize moduleSize, final ModuleClass moduleClass, final long basePrice, final String internalName, final Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, basePrice, internalName, attributes);
        this.shipType = shipType;
        this.armourType = armourType;
    }

    public Armour(final Armour armour) {
        super(armour);
        this.shipType = armour.shipType;
        this.armourType = armour.armourType;
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return ArmourBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return ExperimentalEffectBlueprints.ARMOUR.keySet().stream().toList();
    }

    @Override
    public Armour Clone() {
        return new Armour(this);
    }

    @Override
    public String getClarifier() {
        return " " + LocaleService.getLocalizedStringForCurrentLocale(this.getArmourType().getLocalizationKey());
    }

    @Override
    public boolean isHiddenStat(HorizonsModifier modifier) {
        if (HorizonsModifier.POWER_DRAW.equals(modifier)) {
            return true;
        }
        return super.isHiddenStat(modifier);
    }

    @Override
    public int getGrouping() {
        return switch (armourType) {
            case LIGHTWEIGHT_ALLOY -> 1;
            case REINFORCED_ALLOY -> 2;
            case MILITARY_GRADE_COMPOSITE -> 3;
            case MIRRORED_SURFACE_COMPOSITE -> 4;
            case REACTIVE_SURFACE_COMPOSITE -> 5;
        };
    }

    @Override
    public String toString() {
        return LocaleService.getLocalizedStringForCurrentLocale(shipType.getLocalizationKey()) + " " + LocaleService.getLocalizedStringForCurrentLocale(getLocalizationKey()) + " " + getModuleSize().intValue() + getModuleClass().name();
    }
}
