package nl.jixxed.eliteodysseymaterials.constants;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import nl.jixxed.eliteodysseymaterials.enums.Asset;
import nl.jixxed.eliteodysseymaterials.enums.Data;
import nl.jixxed.eliteodysseymaterials.enums.Good;
import nl.jixxed.eliteodysseymaterials.enums.OdysseyMaterial;

import java.util.Map;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class BarterConstants {
    private static final Map<OdysseyMaterial, Integer> BARTER_SELLVALUES = Map.ofEntries(
            Map.entry(Asset.AEROGEL, 500),
            Map.entry(Asset.CHEMICALCATALYST, 400),
            Map.entry(Asset.CHEMICALSUPERBASE, 500),
            Map.entry(Asset.EPINEPHRINE, 300),
            Map.entry(Asset.EPOXYADHESIVE, 300),
            Map.entry(Asset.GRAPHENE, 1_300),
            Map.entry(Asset.OXYGENICBACTERIA, 300),
            Map.entry(Asset.PHNEUTRALISER, 300),
            Map.entry(Asset.RDX, 400),
            Map.entry(Asset.VISCOELASTICPOLYMER, 600),
            Map.entry(Asset.CIRCUITBOARD, 500),
            Map.entry(Asset.CIRCUITSWITCH, 200),
            Map.entry(Asset.ELECTRICALFUSE, 300),
            Map.entry(Asset.ELECTRICALWIRING, 500),
            Map.entry(Asset.ELECTROMAGNET, 500),
            Map.entry(Asset.IONBATTERY, 500),
            Map.entry(Asset.METALCOIL, 500),
            Map.entry(Asset.MICROELECTRODE, 900),
            Map.entry(Asset.MICROSUPERCAPACITOR, 300),
            Map.entry(Asset.MICROTRANSFORMER, 400),
            Map.entry(Asset.MOTOR, 300),
            Map.entry(Asset.OPTICALFIBRE, 600),
            Map.entry(Asset.CARBONFIBREPLATING, 600),
            Map.entry(Asset.ENCRYPTEDMEMORYCHIP, 200),
            Map.entry(Asset.MICROHYDRAULICS, 400),
            Map.entry(Asset.MICROTHRUSTERS, 300),
            Map.entry(Asset.MEMORYCHIP, 200),
            Map.entry(Asset.OPTICALLENS, 500),
            Map.entry(Asset.SCRAMBLER, 300),
            Map.entry(Asset.TITANIUMPLATING, 600),
            Map.entry(Asset.TRANSMITTER, 300),
            Map.entry(Asset.TUNGSTENCARBIDE, 600),
            Map.entry(Asset.WEAPONCOMPONENT, 1_000),

            Map.entry(Good.AGRICULTURALPROCESSSAMPLE, 50_000),
            Map.entry(Good.BIOCHEMICALAGENT, 125_000),
            Map.entry(Good.BIOMECHANICALCOMPONENT, 200_000),
            Map.entry(Good.GENETICSAMPLE, 35_000),
            Map.entry(Good.BUILDINGSCHEMATIC, 25_000),
            Map.entry(Good.CALIFORNIUM, 100_000),
            Map.entry(Good.CASTFOSSIL, 35_000),
            Map.entry(Good.CHEMICALPROCESSSAMPLE, 50_000),
            Map.entry(Good.CHEMICALSAMPLE, 35_000),
            Map.entry(Good.COMPACTLIBRARY, 10_000),
            Map.entry(Good.COMPRESSIONLIQUEFIEDGAS, 35_000),
            Map.entry(Good.DEEPMANTLESAMPLE, 25_000),
            Map.entry(Good.DEGRADEDPOWERREGULATOR, 15_000),
            Map.entry(Good.GMEDS, 10_000),
            Map.entry(Good.GENETICREPAIRMEDS, 100_000),
            Map.entry(Good.HEALTHMONITOR, 10_000),
            Map.entry(Good.HUSH, 75_000),
            Map.entry(Good.INERTIACANISTER, 35_000),
            Map.entry(Good.INFINITY, 10_000),
            Map.entry(Good.INORGANICCONTAMINANT, 35_000),
            Map.entry(Good.INSIGHT, 15_000),
            Map.entry(Good.INSIGHTDATABANK, 25_000),
            Map.entry(Good.INSIGHTENTERTAINMENTSUITE, 20_000),
            Map.entry(Good.IONISEDGAS, 35_000),
            Map.entry(Good.LAZARUS, 125_000),
            Map.entry(Good.MICROBIALINHIBITOR, 20_000),
            Map.entry(Good.MUTAGENICCATALYST, 75_000),
            Map.entry(Good.NUTRITIONALCONCENTRATE, 10_000),
            Map.entry(Good.PERSONALCOMPUTER, 15_000),
            Map.entry(Good.PERSONALDOCUMENTS, 10_000),
            Map.entry(Good.PETRIFIEDFOSSIL, 75_000),
            Map.entry(Good.LARGECAPACITYPOWERREGULATOR, 50_000),
            Map.entry(Good.PUSH, 25_000),
            Map.entry(Good.PYROLYTICCATALYST, 35_000),
            Map.entry(Good.REFINEMENTPROCESSSAMPLE, 50_000),
            Map.entry(Good.SABOTAGEDCOMPONENT, 210_000),
            Map.entry(Good.SHIPSCHEMATIC, 25_000),
            Map.entry(Good.SUITSCHEMATIC, 50_000),
            Map.entry(Good.SURVEILLANCEEQUIPMENT, 10_000),
            Map.entry(Good.SYNTHETICGENOME, 100_000),
            Map.entry(Good.SYNTHETICPATHOGEN, 75_000),
            Map.entry(Good.TRUEFORMFOSSIL, 100_000),
            Map.entry(Good.UNIVERSALTRANSLATOR, 10_000),
            Map.entry(Good.VEHICLESCHEMATIC, 70_000),
            Map.entry(Good.WEAPONSCHEMATIC, 35_000),

            Map.entry(Data.ACCIDENTLOGS, 4_000),
            Map.entry(Data.AIRQUALITYREPORTS, 3_000),
            Map.entry(Data.ATMOSPHERICDATA, 7_000),
            Map.entry(Data.AUDIOLOGS, 17_000),
            Map.entry(Data.AXCOMBATLOGS, 24_000),
            Map.entry(Data.BALLISTICSDATA, 12_000),
            Map.entry(Data.BIOLOGICALWEAPONDATA, 35_000),
            Map.entry(Data.BIOMETRICDATA, 24_000),
            Map.entry(Data.BLACKLISTDATA, 14_000),
            Map.entry(Data.BLOODTESTRESULTS, 18_000),
            Map.entry(Data.CAMPAIGNPLANS, 12_000),
            Map.entry(Data.CATMEDIA, 1_000),
            Map.entry(Data.CENSUSDATA, 8_000),
            Map.entry(Data.CHEMICALEXPERIMENTDATA, 12_000),
            Map.entry(Data.CHEMICALFORMULAE, 10_000),
            Map.entry(Data.CHEMICALINVENTORY, 9_000),
            Map.entry(Data.CHEMICALPATENTS, 21_000),
            Map.entry(Data.CHEMICALWEAPONDATA, 34_000),
            Map.entry(Data.CLASSICENTERTAINMENT, 7_000),
            Map.entry(Data.COCKTAILRECIPES, 3_000),
            Map.entry(Data.COMBATANTPERFORMANCE, 8_000),
            Map.entry(Data.COMBATTRAININGMATERIAL, 9_000),
            Map.entry(Data.CONFLICTHISTORY, 15_000),
            Map.entry(Data.CRIMINALRECORDS, 22_000),
            Map.entry(Data.CROPYIELDANALYSIS, 5_000),
            Map.entry(Data.CULINARYRECIPES, 1_000),
            Map.entry(Data.DIGITALDESIGNS, 12_000),
            Map.entry(Data.DUTYROTA, 8_000),
            Map.entry(Data.EMPLOYEEDIRECTORY, 5_000),
            Map.entry(Data.EMPLOYEEEXPENSES, 4_000),
            Map.entry(Data.EMPLOYEEGENETICDATA, 20_000),
            Map.entry(Data.EMPLOYMENTHISTORY, 3_000),
            Map.entry(Data.ENHANCEDINTERROGATIONRECORDINGS, 30_000),
            Map.entry(Data.ESPIONAGEMATERIAL, 29_000),
            Map.entry(Data.EVACUATIONPROTOCOLS, 9_000),
            Map.entry(Data.EXPLORATIONJOURNALS, 10_000),
            Map.entry(Data.EXTRACTIONYIELDDATA, 6_000),
            Map.entry(Data.FACTIONASSOCIATES, 15_000),
            Map.entry(Data.FACTIONDONATORLIST, 14_000),
            Map.entry(Data.FACTIONNEWS, 1_000),//ok
            Map.entry(Data.FINANCIALPROJECTIONS, 6_000),
            Map.entry(Data.FLEETREGISTRY, 17_000),
            Map.entry(Data.GENESEQUENCINGDATA, 17_000),
            Map.entry(Data.GENETICRESEARCH, 21_000),
            Map.entry(Data.GEOLOGICALDATA, 10_000),
            Map.entry(Data.HYDROPONICDATA, 12_000),
            Map.entry(Data.INCIDENTLOGS, 7_000),
            Map.entry(Data.INFLUENCEPROJECTIONS, 1_000),
            Map.entry(Data.INTERNALCORRESPONDENCE, 20_000),
            Map.entry(Data.INTERROGATIONRECORDINGS, 23_000),
            Map.entry(Data.INTERVIEWRECORDINGS, 15_000),
            Map.entry(Data.JOBAPPLICATIONS, 1_000),//ok
            Map.entry(Data.KOMPROMAT, 33_000),
            Map.entry(Data.LITERARYFICTION, 2_000),
            Map.entry(Data.MAINTENANCELOGS, 2_000),
            Map.entry(Data.MANUFACTURINGINSTRUCTIONS, 9_000),
            Map.entry(Data.MEDICALRECORDS, 19_000),
            Map.entry(Data.MEDICALTRIALRECORDS, 24_000),
            Map.entry(Data.MEETINGMINUTES, 1_000),
            Map.entry(Data.MINERALSURVEY, 5_000),
            Map.entry(Data.MININGANALYTICS, 7_000),
            Map.entry(Data.MULTIMEDIAENTERTAINMENT, 3_000),
            Map.entry(Data.NETWORKACCESSHISTORY, 6_000),
            Map.entry(Data.NETWORKSECURITYPROTOCOLS, 23_000),
            Map.entry(Data.NEXTOFKINRECORDS, 13_000),
            Map.entry(Data.NOCDATA, 25_000),
            Map.entry(Data.OPERATIONALMANUAL, 7_000),
            Map.entry(Data.OPINIONPOLLS, 5_000),
            Map.entry(Data.PATIENTHISTORY, 9_000),
            Map.entry(Data.PATROLROUTES, 14_000),
            Map.entry(Data.PAYROLLINFORMATION, 6_000),
            Map.entry(Data.PERSONALLOGS, 6_000),
            Map.entry(Data.PHARMACEUTICALPATENTS, 21_000),
            Map.entry(Data.PHOTOALBUMS, 3_000),
            Map.entry(Data.PLANTGROWTHCHARTS, 5_000),
            Map.entry(Data.POLITICALAFFILIATIONS, 10_000),
            Map.entry(Data.PRISONERLOGS, 19_000),
            Map.entry(Data.PRODUCTIONREPORTS, 11_000),
            Map.entry(Data.PRODUCTIONSCHEDULE, 10_000),
            Map.entry(Data.PROPAGANDA, 17_000),
            Map.entry(Data.PURCHASERECORDS, 8_000),
            Map.entry(Data.PURCHASEREQUESTS, 4_000),
            Map.entry(Data.RADIOACTIVITYDATA, 16_000),
            Map.entry(Data.REACTOROUTPUTREVIEW, 8_000),
            Map.entry(Data.RECYCLINGLOGS, 2_000),
            Map.entry(Data.RESIDENTIALDIRECTORY, 8_000),
            Map.entry(Data.RISKASSESSMENTS, 2_000),
            Map.entry(Data.SALESRECORDS, 7_000),
            Map.entry(Data.SECURITYEXPENSES, 16_000),
            Map.entry(Data.SEEDGENEAOLOGY, 11_000),
            Map.entry(Data.SETTLEMENTASSAULTPLANS, 20_000),
            Map.entry(Data.SETTLEMENTDEFENCEPLANS, 22_000),
            Map.entry(Data.SHAREHOLDERINFORMATION, 17_000),
            Map.entry(Data.SLUSHFUNDLOGS, 27_000),
            Map.entry(Data.SMEARCAMPAIGNPLANS, 26_000),
            Map.entry(Data.SPECTRALANALYSISDATA, 13_000),
            Map.entry(Data.SPYWARE, 25_000),
            Map.entry(Data.STELLARACTIVITYLOGS, 9_000),
            Map.entry(Data.SURVEILLEANCELOGS, 19_000),
            Map.entry(Data.TACTICALPLANS, 18_000),
            Map.entry(Data.TAXRECORDS, 16_000),
            Map.entry(Data.TOPOGRAPHICALSURVEYS, 12_000),
            Map.entry(Data.TRAVELPERMITS, 2_000),
            Map.entry(Data.TROOPDEPLOYMENTRECORDS, 16_000),
            Map.entry(Data.UNIONMEMBERSHIP, 4_000),
            Map.entry(Data.VACCINATIONRECORDS, 4_000),
            Map.entry(Data.VACCINERESEARCH, 13_000),
            Map.entry(Data.VIPSECURITYDETAIL, 18_000),
            Map.entry(Data.VIROLOGYDATA, 14_000),
            Map.entry(Data.VIRUS, 25_000),
            Map.entry(Data.VISITORREGISTER, 6_000),
            Map.entry(Data.WEAPONINVENTORY, 9_000),
            Map.entry(Data.WEAPONTESTDATA, 15_000),
            Map.entry(Data.XENODEFENCEPROTOCOLS, 25_000));


    public static Integer getBarterSellPrice(final OdysseyMaterial odysseyMaterial) {
        return BARTER_SELLVALUES.getOrDefault(odysseyMaterial, -1);
    }
}
