## 在线课程学习系统

### 来自 2019 年的说明

随着后端技术发展，`SSM + JSP` 方式已经十分落后，不建议初学者学习该技术。

可以转而查看使用以下技术的项目（排列顺序为技术发展顺序）：

- SSM + HTML:  [快递代拿系统](https://github.com/jitwxs/express)
- SpringBoot + HTML: [智慧水产养殖系统](https://github.com/jitwxs/breed)
- SpringBoot + Thymeleaf: [Dark Video](https://github.com/jitwxs/dark-video)
- SpringBoot 前后端分离: [基于Docker的PaaS平台](https://github.com/jitwxs/paas)

### 起步

1. 使用 IDEA 导入项目
2. 执行 sql 目录下的`online_study_system.sql` 文件
3. 修改 `mysql.properties` 中数据库连接信息
4. 运行程序

| 用户名| 密码 |
| ------------- |:-------------|
| admin | 123 |
| 李老师 | 123 |
| 张老师 | 123 |
| 刘老师 | 123 |
| 曹老师 | 123 |
| 小红 | 123 |
| 小林 | 123 |

### 使用技术

- IOC容器：Spring

- Web框架：SpringMVC

- ORM框架：Mybatis

- 安全框架：Shiro

- 数据源：C3P0

- 日志：log4j

- 前端框架：Bootstrap

### 运行环境

- 集成开发环境：IntelliJ IDEA

- 项目构建工具：Maven

- 数据库：Mysql

- DK版本：jdk1.8

- Tomcat版本：Tomcat8