/*
 *  Copyright (C) 2010-2024 JPEXS, All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3.0 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.
 */
package com.jpexs.decompiler.flash.types;

/**
 * Blend modes.
 *
 * @author JPEXS
 */
public class BlendMode {

    /**
     * Normal
     */
    public static final int NORMAL = 1;

    /**
     * Layer
     */
    public static final int LAYER = 2;

    /**
     * Multiply
     */
    public static final int MULTIPLY = 3;

    /**
     * Screen
     */
    public static final int SCREEN = 4;

    /**
     * Lighten
     */
    public static final int LIGHTEN = 5;

    /**
     * Darken
     */
    public static final int DARKEN = 6;

    /**
     * Difference
     */
    public static final int DIFFERENCE = 7;

    /**
     * Add
     */
    public static final int ADD = 8;

    /**
     * Subtract
     */
    public static final int SUBTRACT = 9;

    /**
     * Invert
     */
    public static final int INVERT = 10;

    /**
     * Alpha
     */
    public static final int ALPHA = 11;

    /**
     * Erase
     */
    public static final int ERASE = 12;

    /**
     * Overlay
     */
    public static final int OVERLAY = 13;

    /**
     * Hardlight
     */
    public static final int HARDLIGHT = 14;

    /**
     * Constructor.
     */
    private BlendMode() {

    }
}
