/*
 *  Copyright (C) 2010-2024 JPEXS, All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3.0 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.
 */
package com.jpexs.decompiler.flash.importers.svg.css;

/**
 * Css symbol type.
 *
 * @author JPEXS
 */
public enum CssSymbolType {
    /**
     * S
     */
    S,
    /**
     * CDO
     */
    CDO,
    /**
     * CDC
     */
    CDC,
    /**
     * Includes
     */
    INCLUDES,
    /**
     * Dashmatch
     */
    DASHMATCH,
    /**
     * String
     */
    STRING,
    /**
     * Bad string
     */
    BAD_STRING,
    /**
     * Ident
     */
    IDENT,
    /**
     * Hash
     */
    HASH,
    /**
     * Import sym
     */
    IMPORT_SYM,
    /**
     * Page sym
     */
    PAGE_SYM,
    /**
     * Media sym
     */
    MEDIA_SYM,
    /**
     * Charset sym
     */
    CHARSET_SYM,
    /**
     * Important sym
     */
    IMPORTANT_SYM,
    /**
     * EMS
     */
    EMS,
    /**
     * EXS
     */
    EXS,
    /**
     * Length
     */
    LENGTH,
    /**
     * Angle
     */
    ANGLE,
    /**
     * Time
     */
    TIME,
    /**
     * Freq
     */
    FREQ,
    /**
     *  Dimension
     */
    DIMENSION,
    /**
     * Percentage
     */
    PERCENTAGE,
    /**
     * Number
     */
    NUMBER,
    /**
     * URI
     */
    URI,
    /**
     * Bad URI
     */
    BAD_URI,
    /**
     * Function
     */
    FUNCTION,
    /**
     * End of file
     */
    EOF,
    /**
     * Other
     */
    OTHER
}
