/*
 *  Copyright (C) 2010-2024 JPEXS, All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3.0 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.tags.DefineMorphShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineMorphShapeTag;

/**
 * Morph shape importer.
 *
 * @author JPEXS
 */
public class MorphShapeImporter {

    /**
     * Gets morph shape tag type.
     *
     * @param format Format
     * @return Morph shape tag type
     */
    public static int getMorphShapeTagType(String format) {
        int res = 0;
        switch (format) {
            case "morphshape":
                res = DefineMorphShapeTag.ID;
                break;
            case "morphshape2":
                res = DefineMorphShape2Tag.ID;
                break;
        }

        return res;
    }
}
