/* The following code was generated by JFlex 1.6.0 */

/*
 *  Copyright (C) 2010-2016 JPEXS, All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3.0 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.script;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.math.BigInteger;
import macromedia.asc.util.Decimal128;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import com.jpexs.decompiler.flash.abc.types.Float4;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.0
 * from the specification file <tt>C:/Dropbox/Programovani/JavaSE/FFDec/libsrc/ffdec_lib/lexers/actionscript3_script.flex</tt>
 */
public final class ActionScriptLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING = 2;
  public static final int CHARLITERAL = 4;
  public static final int XMLOPENTAG = 6;
  public static final int XMLCLOSETAGFINISH = 8;
  public static final int XMLOPENTAGATTRIB = 10;
  public static final int XMLINSTR = 12;
  public static final int XMLCDATA = 14;
  public static final int XMLCOMMENT = 16;
  public static final int XML = 18;
  public static final int OIDENTIFIER = 20;
  public static final int XMLCDATAALONE = 22;
  public static final int XMLCOMMENTALONE = 24;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\13\1\2\1\114\1\3\1\1\22\0\1\13\1\14\1\34"+
    "\1\65\1\6\1\113\1\110\1\35\1\54\1\56\1\5\1\61\1\55"+
    "\1\15\1\11\1\4\1\36\3\43\1\53\3\43\2\22\1\17\1\106"+
    "\1\12\1\33\1\16\1\24\1\64\1\30\1\20\1\26\1\27\1\57"+
    "\1\20\2\10\1\102\4\10\1\103\5\10\1\31\3\10\1\41\2\10"+
    "\1\25\1\62\1\32\1\112\1\10\1\0\1\51\1\66\1\42\1\45"+
    "\1\60\1\46\1\101\1\75\1\73\1\21\1\70\1\47\1\44\1\72"+
    "\1\50\1\76\1\21\1\67\1\71\1\52\1\37\1\100\1\74\1\40"+
    "\1\77\1\21\1\104\1\111\1\105\1\107\6\0\1\114\41\0\1\63"+
    "\2\0\1\6\12\0\1\6\1\0\1\23\2\0\1\6\5\0\27\6"+
    "\1\0\37\6\1\0\u01ca\6\4\0\14\6\16\0\5\6\7\0\1\6"+
    "\1\0\1\6\21\0\160\7\5\6\1\0\2\6\2\0\4\6\1\0"+
    "\1\6\6\0\1\6\1\0\3\6\1\0\1\6\1\0\24\6\1\0"+
    "\123\6\1\0\213\6\1\0\5\7\2\0\246\6\1\0\46\6\2\0"+
    "\1\6\7\0\47\6\11\0\55\7\1\0\1\7\1\0\2\7\1\0"+
    "\2\7\1\0\1\7\10\0\33\6\5\0\3\6\35\0\13\7\5\0"+
    "\53\6\37\7\4\0\2\6\1\7\143\6\1\0\1\6\7\7\2\0"+
    "\6\7\2\6\2\7\1\0\4\7\2\6\12\7\3\6\2\0\1\6"+
    "\20\0\1\6\1\7\36\6\33\7\2\0\131\6\13\7\1\6\16\0"+
    "\12\7\41\6\11\7\2\6\4\0\1\6\5\0\26\6\4\7\1\6"+
    "\11\7\1\6\3\7\1\6\5\7\22\0\31\6\3\7\104\0\23\6"+
    "\61\0\40\7\66\6\3\7\1\6\22\7\1\6\7\7\12\6\2\7"+
    "\2\0\12\7\1\0\20\6\3\7\1\0\10\6\2\0\2\6\2\0"+
    "\26\6\1\0\7\6\1\0\1\6\3\0\4\6\2\0\1\7\1\6"+
    "\7\7\2\0\2\7\2\0\3\7\1\6\10\0\1\7\4\0\2\6"+
    "\1\0\3\6\2\7\2\0\12\7\2\6\17\0\3\7\1\0\6\6"+
    "\4\0\2\6\2\0\26\6\1\0\7\6\1\0\2\6\1\0\2\6"+
    "\1\0\2\6\2\0\1\7\1\0\5\7\4\0\2\7\2\0\3\7"+
    "\3\0\1\7\7\0\4\6\1\0\1\6\7\0\14\7\3\6\1\7"+
    "\13\0\3\7\1\0\11\6\1\0\3\6\1\0\26\6\1\0\7\6"+
    "\1\0\2\6\1\0\5\6\2\0\1\7\1\6\10\7\1\0\3\7"+
    "\1\0\3\7\2\0\1\6\17\0\2\6\2\7\2\0\12\7\21\0"+
    "\3\7\1\0\10\6\2\0\2\6\2\0\26\6\1\0\7\6\1\0"+
    "\2\6\1\0\5\6\2\0\1\7\1\6\7\7\2\0\2\7\2\0"+
    "\3\7\10\0\2\7\4\0\2\6\1\0\3\6\2\7\2\0\12\7"+
    "\1\0\1\6\20\0\1\7\1\6\1\0\6\6\3\0\3\6\1\0"+
    "\4\6\3\0\2\6\1\0\1\6\1\0\2\6\3\0\2\6\3\0"+
    "\3\6\3\0\14\6\4\0\5\7\3\0\3\7\1\0\4\7\2\0"+
    "\1\6\6\0\1\7\16\0\12\7\20\0\4\7\1\0\10\6\1\0"+
    "\3\6\1\0\27\6\1\0\20\6\3\0\1\6\7\7\1\0\3\7"+
    "\1\0\4\7\7\0\2\7\1\0\2\6\6\0\2\6\2\7\2\0"+
    "\12\7\21\0\3\7\1\0\10\6\1\0\3\6\1\0\27\6\1\0"+
    "\12\6\1\0\5\6\2\0\1\7\1\6\7\7\1\0\3\7\1\0"+
    "\4\7\7\0\2\7\7\0\1\6\1\0\2\6\2\7\2\0\12\7"+
    "\1\0\2\6\16\0\3\7\1\0\10\6\1\0\3\6\1\0\51\6"+
    "\2\0\1\6\7\7\1\0\3\7\1\0\4\7\1\6\10\0\1\7"+
    "\10\0\2\6\2\7\2\0\12\7\12\0\6\6\2\0\2\7\1\0"+
    "\22\6\3\0\30\6\1\0\11\6\1\0\1\6\2\0\7\6\3\0"+
    "\1\7\4\0\6\7\1\0\1\7\1\0\10\7\6\0\12\7\2\0"+
    "\2\7\15\0\60\6\1\7\2\6\7\7\5\0\7\6\10\7\1\0"+
    "\12\7\47\0\2\6\1\0\1\6\2\0\2\6\1\0\1\6\2\0"+
    "\1\6\6\0\4\6\1\0\7\6\1\0\3\6\1\0\1\6\1\0"+
    "\1\6\2\0\2\6\1\0\4\6\1\7\2\6\6\7\1\0\2\7"+
    "\1\6\2\0\5\6\1\0\1\6\1\0\6\7\2\0\12\7\2\0"+
    "\4\6\40\0\1\6\27\0\2\7\6\0\12\7\13\0\1\7\1\0"+
    "\1\7\1\0\1\7\4\0\2\7\10\6\1\0\44\6\4\0\24\7"+
    "\1\0\2\7\5\6\13\7\1\0\44\7\11\0\1\7\71\0\53\6"+
    "\24\7\1\6\12\7\6\0\6\6\4\7\4\6\3\7\1\6\3\7"+
    "\2\6\7\7\3\6\4\7\15\6\14\7\1\6\17\7\2\0\46\6"+
    "\1\0\1\6\5\0\1\6\2\0\53\6\1\0\u014d\6\1\0\4\6"+
    "\2\0\7\6\1\0\1\6\1\0\4\6\2\0\51\6\1\0\4\6"+
    "\2\0\41\6\1\0\4\6\2\0\7\6\1\0\1\6\1\0\4\6"+
    "\2\0\17\6\1\0\71\6\1\0\4\6\2\0\103\6\2\0\3\7"+
    "\40\0\20\6\20\0\125\6\14\0\u026c\6\2\0\21\6\1\0\32\6"+
    "\5\0\113\6\3\0\3\7\10\6\7\0\15\6\1\0\4\6\3\7"+
    "\13\0\22\6\3\7\13\0\22\6\2\7\14\0\15\6\1\0\3\6"+
    "\1\0\2\7\14\0\64\6\40\7\3\0\1\6\4\0\1\6\1\7"+
    "\2\0\12\7\41\0\3\7\2\0\12\7\6\0\130\6\10\0\51\6"+
    "\1\7\1\6\5\0\106\6\12\0\37\6\1\0\14\7\4\0\14\7"+
    "\12\0\12\7\36\6\2\0\5\6\13\0\54\6\4\0\21\7\7\6"+
    "\2\7\6\0\12\7\46\0\27\6\5\7\4\0\65\6\12\7\1\0"+
    "\35\7\2\0\13\7\6\0\12\7\15\0\1\6\10\0\16\7\102\0"+
    "\5\7\57\6\21\7\7\6\4\0\12\7\21\0\11\7\14\0\3\7"+
    "\36\6\15\7\2\6\12\7\54\6\16\7\14\0\44\6\24\7\10\0"+
    "\12\7\3\0\3\6\12\7\44\6\122\0\3\7\1\0\25\7\4\6"+
    "\1\7\4\6\3\7\2\6\1\0\2\7\6\0\300\6\66\7\6\0"+
    "\4\7\u0116\6\2\0\6\6\2\0\46\6\2\0\6\6\2\0\10\6"+
    "\1\0\1\6\1\0\1\6\1\0\1\6\1\0\37\6\2\0\65\6"+
    "\1\0\7\6\1\0\1\6\3\0\3\6\1\0\7\6\3\0\4\6"+
    "\2\0\6\6\4\0\15\6\5\0\3\6\1\0\7\6\3\0\14\0"+
    "\2\0\32\0\1\114\1\114\25\0\2\7\23\0\1\7\33\0\1\0"+
    "\1\6\15\0\1\6\20\0\15\6\63\0\15\7\4\0\1\7\3\0"+
    "\14\7\21\0\1\6\4\0\1\6\2\0\12\6\1\0\1\6\3\0"+
    "\5\6\6\0\1\6\1\0\1\6\1\0\1\6\1\0\4\6\1\0"+
    "\13\6\2\0\4\6\5\0\5\6\4\0\1\6\21\0\43\7\2\6"+
    "\4\7\7\0\u0a70\0\57\6\1\0\57\6\1\0\205\6\6\0\4\6"+
    "\3\7\2\6\14\0\46\6\1\0\1\6\5\0\1\6\2\0\70\6"+
    "\7\0\1\6\17\0\1\7\27\6\11\0\7\6\1\0\7\6\1\0"+
    "\7\6\1\0\7\6\1\0\7\6\1\0\7\6\1\0\7\6\1\0"+
    "\7\6\1\0\40\7\57\0\1\6\u01c0\0\21\0\4\0\2\6\1\7"+
    "\31\0\17\7\1\0\5\6\2\0\3\7\2\6\4\0\126\6\2\0"+
    "\2\7\2\0\3\6\1\0\132\6\1\0\4\6\5\0\51\6\3\0"+
    "\136\6\21\0\33\6\65\0\20\6\u0200\0\u19b6\6\112\0\u51cd\6\63\0"+
    "\u048d\6\103\0\56\6\2\0\u010d\6\3\0\20\6\12\7\2\6\24\0"+
    "\57\6\1\7\4\0\12\7\1\0\37\6\1\0\1\7\106\6\14\7"+
    "\45\0\11\6\2\0\147\6\2\0\4\6\1\0\36\6\2\0\2\6"+
    "\105\0\13\6\1\7\3\6\1\7\4\6\1\7\27\6\5\7\30\0"+
    "\64\6\14\0\2\7\62\6\21\7\13\0\12\7\6\0\22\7\6\6"+
    "\3\0\1\6\4\0\12\7\34\6\10\7\2\0\27\6\15\7\14\0"+
    "\35\6\3\0\4\7\57\6\16\7\16\0\1\6\12\7\6\0\5\6"+
    "\1\7\12\6\12\7\5\6\1\0\51\6\16\7\11\0\3\6\1\7"+
    "\10\6\2\7\2\0\12\7\6\0\27\6\3\0\1\6\3\7\62\6"+
    "\1\7\1\6\3\7\2\6\2\7\5\6\2\7\1\6\1\7\1\6"+
    "\30\0\3\6\2\0\13\6\5\7\2\0\3\6\2\7\12\0\6\6"+
    "\2\0\6\6\2\0\6\6\11\0\7\6\1\0\7\6\1\0\53\6"+
    "\1\0\4\6\4\0\2\6\132\0\43\6\10\7\1\0\2\7\2\0"+
    "\12\7\6\0\u2ba4\6\14\0\27\6\4\0\61\6\4\0\u1800\0\u0900\0"+
    "\u016e\6\2\0\152\6\46\0\7\6\14\0\5\6\5\0\1\6\1\7"+
    "\12\6\1\0\15\6\1\0\5\6\1\0\1\6\1\0\2\6\1\0"+
    "\2\6\1\0\154\6\41\0\u016b\6\22\0\100\6\2\0\66\6\10\0"+
    "\40\0\14\6\4\0\20\7\20\0\16\7\5\0\2\7\30\0\3\7"+
    "\40\0\5\6\1\0\207\6\23\0\12\7\7\0\32\6\4\0\1\7"+
    "\1\0\32\6\13\0\131\6\3\0\6\6\2\0\6\6\2\0\6\6"+
    "\2\0\3\6\41\0\2\0\14\6\1\0\32\6\1\0\23\6\1\0"+
    "\2\6\1\0\17\6\2\0\16\6\42\0\173\6\105\0\65\7\210\0"+
    "\1\7\202\0\35\6\3\0\61\6\17\0\1\7\37\0\40\6\20\0"+
    "\21\6\1\7\10\6\1\7\5\0\46\6\5\7\5\0\36\6\2\0"+
    "\44\6\4\0\10\6\1\0\5\7\52\0\236\6\2\0\12\7\126\0"+
    "\50\6\10\0\64\6\234\0\u0137\6\11\0\26\6\12\0\10\6\230\0"+
    "\6\6\2\0\1\6\1\0\54\6\1\0\2\6\3\0\1\6\2\0"+
    "\27\6\12\0\27\6\11\0\37\6\141\0\26\6\12\0\32\6\106\0"+
    "\70\6\6\0\2\6\100\0\1\6\3\7\1\0\2\7\5\0\4\7"+
    "\4\6\1\0\3\6\1\0\33\6\4\0\3\7\4\0\1\7\40\0"+
    "\35\6\3\0\35\6\43\0\10\6\1\0\34\6\2\7\31\0\66\6"+
    "\12\0\26\6\12\0\23\6\15\0\22\6\156\0\111\6\u03b7\0\3\7"+
    "\65\6\17\7\37\0\12\7\17\0\4\7\55\6\13\7\25\0\31\6"+
    "\7\0\12\7\6\0\3\7\44\6\16\7\1\0\12\7\20\0\43\6"+
    "\1\7\2\0\1\6\11\0\3\7\60\6\16\7\4\6\13\0\12\7"+
    "\1\6\45\0\22\6\1\0\31\6\14\7\170\0\57\6\14\7\5\0"+
    "\12\7\7\0\3\7\1\0\10\6\2\0\2\6\2\0\26\6\1\0"+
    "\7\6\1\0\2\6\1\0\5\6\2\0\1\7\1\6\7\7\2\0"+
    "\2\7\2\0\3\7\11\0\1\7\5\0\5\6\2\7\2\0\7\7"+
    "\3\0\5\7\u010b\0\60\6\24\7\2\6\1\0\1\6\10\0\12\7"+
    "\246\0\57\6\7\7\2\0\11\7\77\0\60\6\21\7\3\0\1\6"+
    "\13\0\12\7\46\0\53\6\15\7\10\0\12\7\u01d6\0\100\6\12\7"+
    "\25\0\1\6\u01c0\0\71\6\u0507\0\u0399\6\147\0\157\7\u0b91\0\u042f\6"+
    "\u33d1\0\u0239\6\7\0\37\6\1\0\12\7\146\0\36\6\2\0\5\7"+
    "\13\0\60\6\7\7\11\0\4\6\14\0\12\7\11\0\25\6\5\0"+
    "\23\6\u0370\0\105\6\13\0\1\6\56\7\20\0\4\7\15\6\u4060\0"+
    "\2\6\u0bfe\0\153\6\5\0\15\6\3\0\11\6\7\0\12\6\3\0"+
    "\2\7\u14c6\0\5\7\3\0\6\7\10\0\10\7\2\0\7\7\36\0"+
    "\4\7\224\0\3\7\u01bb\0\125\6\1\0\107\6\1\0\2\6\2\0"+
    "\1\6\2\0\2\6\2\0\4\6\1\0\14\6\1\0\1\6\1\0"+
    "\7\6\1\0\101\6\1\0\4\6\2\0\10\6\1\0\7\6\1\0"+
    "\34\6\1\0\4\6\1\0\5\6\1\0\1\6\3\0\7\6\1\0"+
    "\u0154\6\2\0\31\6\1\0\31\6\1\0\37\6\1\0\31\6\1\0"+
    "\37\6\1\0\31\6\1\0\37\6\1\0\31\6\1\0\37\6\1\0"+
    "\31\6\1\0\10\6\2\0\62\7\u1000\0\305\6\13\0\7\7\u0529\0"+
    "\4\6\1\0\33\6\1\0\2\6\1\0\1\6\2\0\1\6\1\0"+
    "\12\6\1\0\4\6\1\0\1\6\1\0\1\6\6\0\1\6\4\0"+
    "\1\6\1\0\1\6\1\0\1\6\1\0\3\6\1\0\2\6\1\0"+
    "\1\6\2\0\1\6\1\0\1\6\1\0\1\6\1\0\1\6\1\0"+
    "\1\6\1\0\2\6\1\0\1\6\2\0\4\6\1\0\7\6\1\0"+
    "\4\6\1\0\4\6\1\0\1\6\1\0\12\6\1\0\21\6\5\0"+
    "\3\6\1\0\5\6\1\0\21\6\u1144\0\ua6d7\6\51\0\u1035\6\13\0"+
    "\336\6\u3fe2\0\u021e\6\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u06ed\0"+
    "\360\7\uffff\0\uffff\0\ufe12\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\15\0\1\1\2\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\15\7\6\1\24\1\25"+
    "\1\26\1\6\1\27\1\30\1\31\1\1\13\6\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\2\43\1\44\1\1\1\42\2\45\1\46\2\47\1\42"+
    "\2\1\1\50\1\51\1\42\1\52\2\1\1\53\3\42"+
    "\2\54\2\42\1\55\1\56\1\1\1\57\2\42\1\0"+
    "\1\60\1\0\1\61\1\0\1\62\1\63\1\64\1\65"+
    "\1\66\1\67\1\70\1\0\1\71\1\72\1\73\1\74"+
    "\1\75\1\76\1\77\1\100\1\15\1\65\1\101\1\0"+
    "\1\102\1\103\1\104\1\65\1\105\1\0\5\6\1\106"+
    "\10\6\1\107\6\6\1\110\1\111\2\0\2\112\12\6"+
    "\1\113\1\114\1\115\12\6\1\116\1\117\1\120\1\121"+
    "\1\122\1\123\1\124\1\125\1\126\2\124\1\127\1\130"+
    "\1\131\1\132\1\133\1\134\1\135\1\0\1\136\1\0"+
    "\1\137\1\0\1\140\1\141\3\0\1\142\2\0\1\143"+
    "\3\144\1\145\1\146\1\147\1\150\1\151\1\152\1\153"+
    "\1\144\2\0\1\154\2\60\2\0\1\154\2\0\1\154"+
    "\1\155\1\156\2\0\1\157\1\160\1\161\1\0\1\65"+
    "\1\162\1\163\1\164\12\6\1\165\4\6\1\166\6\6"+
    "\1\167\1\170\1\112\4\6\1\171\4\6\1\172\12\6"+
    "\1\173\1\174\1\6\1\175\1\176\1\177\2\0\1\200"+
    "\1\201\1\0\1\202\2\0\1\203\4\0\1\204\1\205"+
    "\2\0\1\60\1\154\1\206\1\0\1\207\5\6\1\210"+
    "\10\6\1\211\1\6\1\212\2\6\1\213\1\214\5\6"+
    "\1\215\6\6\1\216\5\6\1\217\1\6\1\0\1\220"+
    "\1\0\1\221\1\222\2\0\1\223\1\0\1\224\1\0"+
    "\1\6\1\225\1\6\1\226\1\227\5\6\1\230\1\231"+
    "\1\6\1\232\2\6\1\233\1\6\1\234\10\6\1\235"+
    "\5\6\2\0\3\6\1\236\5\6\1\237\1\6\1\240"+
    "\1\241\1\242\1\6\1\243\1\6\1\244\3\6\1\245"+
    "\4\6\2\0\2\6\1\246\1\247\1\6\2\0\1\250"+
    "\1\6\1\251\5\6\1\252\1\6\1\253\1\6\2\0"+
    "\1\6\1\254\1\255\2\0\1\256\3\6\1\257\2\6"+
    "\1\260\1\0\1\261\1\262\4\0\1\263\1\6\1\264"+
    "\1\6\1\265\1\266\4\0\1\267\1\270\22\0\1\271"+
    "\3\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[512];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\115\0\232\0\347\0\u0134\0\u0181\0\u01ce\0\u021b"+
    "\0\u0268\0\u02b5\0\u0302\0\u034f\0\u039c\0\u03e9\0\u0436\0\u03e9"+
    "\0\u0483\0\u04d0\0\u051d\0\u056a\0\u05b7\0\u0604\0\u0651\0\u069e"+
    "\0\u06eb\0\u0738\0\u0785\0\u07d2\0\u03e9\0\u03e9\0\u081f\0\u03e9"+
    "\0\u03e9\0\u086c\0\u08b9\0\u0906\0\u0953\0\u09a0\0\u09ed\0\u0a3a"+
    "\0\u0a87\0\u03e9\0\u03e9\0\u03e9\0\u0ad4\0\u0b21\0\u0b6e\0\u0bbb"+
    "\0\u0c08\0\u0c55\0\u0ca2\0\u0cef\0\u0d3c\0\u0d89\0\u0dd6\0\u0e23"+
    "\0\u0e70\0\u0ebd\0\u0f0a\0\u0f57\0\u03e9\0\u03e9\0\u03e9\0\u03e9"+
    "\0\u0fa4\0\u0ff1\0\u103e\0\u108b\0\u10d8\0\u1125\0\u03e9\0\u03e9"+
    "\0\u1172\0\u11bf\0\u120c\0\u03e9\0\u03e9\0\u1259\0\u03e9\0\u12a6"+
    "\0\u12f3\0\u1340\0\u03e9\0\u03e9\0\u138d\0\u03e9\0\u13da\0\u1427"+
    "\0\u03e9\0\u03e9\0\u1474\0\u14c1\0\u150e\0\u03e9\0\u155b\0\u15a8"+
    "\0\u03e9\0\u03e9\0\u15f5\0\u03e9\0\u1642\0\u168f\0\u16dc\0\u1729"+
    "\0\u1776\0\u16dc\0\u17c3\0\u03e9\0\u1810\0\u03e9\0\u185d\0\u03e9"+
    "\0\u18aa\0\u18f7\0\u1944\0\u03e9\0\u03e9\0\u1991\0\u03e9\0\u03e9"+
    "\0\u19de\0\u03e9\0\u03e9\0\u03e9\0\u03e9\0\u03e9\0\u1a2b\0\u03e9"+
    "\0\u03e9\0\u1a78\0\u1ac5\0\u1b12\0\u1b5f\0\u1bac\0\u1bf9\0\u1c46"+
    "\0\u1c93\0\u1ce0\0\u056a\0\u1d2d\0\u1d7a\0\u1dc7\0\u1e14\0\u1e61"+
    "\0\u1eae\0\u1efb\0\u1f48\0\u056a\0\u1f95\0\u1fe2\0\u202f\0\u207c"+
    "\0\u20c9\0\u2116\0\u03e9\0\u03e9\0\u2163\0\u21b0\0\u21fd\0\u224a"+
    "\0\u2297\0\u22e4\0\u2331\0\u237e\0\u23cb\0\u2418\0\u2465\0\u24b2"+
    "\0\u24ff\0\u254c\0\u056a\0\u056a\0\u2599\0\u25e6\0\u2633\0\u2680"+
    "\0\u26cd\0\u271a\0\u2767\0\u27b4\0\u2801\0\u284e\0\u289b\0\u03e9"+
    "\0\u28e8\0\u03e9\0\u2935\0\u03e9\0\u03e9\0\u03e9\0\u03e9\0\u03e9"+
    "\0\u2982\0\u29cf\0\u03e9\0\u03e9\0\u03e9\0\u03e9\0\u03e9\0\u03e9"+
    "\0\u03e9\0\u1340\0\u03e9\0\u13da\0\u03e9\0\u1427\0\u03e9\0\u03e9"+
    "\0\u2a1c\0\u2a69\0\u2ab6\0\u2b03\0\u2b50\0\u2b9d\0\u03e9\0\u03e9"+
    "\0\u2bea\0\u2c37\0\u03e9\0\u03e9\0\u03e9\0\u03e9\0\u03e9\0\u03e9"+
    "\0\u03e9\0\u2c84\0\u2cd1\0\u2d1e\0\u2d6b\0\u2db8\0\u03e9\0\u2e05"+
    "\0\u2e52\0\u2e9f\0\u2eec\0\u2f39\0\u2f86\0\u03e9\0\u03e9\0\u2fd3"+
    "\0\u3020\0\u03e9\0\u306d\0\u03e9\0\u30ba\0\u3107\0\u03e9\0\u1b5f"+
    "\0\u056a\0\u3154\0\u31a1\0\u31ee\0\u323b\0\u3288\0\u32d5\0\u3322"+
    "\0\u336f\0\u33bc\0\u3409\0\u056a\0\u3456\0\u34a3\0\u34f0\0\u353d"+
    "\0\u056a\0\u358a\0\u35d7\0\u3624\0\u3671\0\u36be\0\u370b\0\u3758"+
    "\0\u03e9\0\u03e9\0\u37a5\0\u37f2\0\u383f\0\u388c\0\u056a\0\u38d9"+
    "\0\u3926\0\u3973\0\u39c0\0\u056a\0\u3a0d\0\u3a5a\0\u3aa7\0\u3af4"+
    "\0\u3b41\0\u3b8e\0\u3bdb\0\u3c28\0\u3c75\0\u3cc2\0\u056a\0\u056a"+
    "\0\u3d0f\0\u056a\0\u03e9\0\u03e9\0\u3d5c\0\u3da9\0\u03e9\0\u03e9"+
    "\0\u3df6\0\u03e9\0\u3e43\0\u3e90\0\u3edd\0\u3f2a\0\u3f77\0\u3fc4"+
    "\0\u4011\0\u03e9\0\u03e9\0\u405e\0\u40ab\0\u2d6b\0\u40f8\0\u03e9"+
    "\0\u4145\0\u03e9\0\u4192\0\u41df\0\u422c\0\u4279\0\u42c6\0\u056a"+
    "\0\u4313\0\u4360\0\u43ad\0\u43fa\0\u4447\0\u4494\0\u44e1\0\u452e"+
    "\0\u056a\0\u457b\0\u056a\0\u45c8\0\u4615\0\u056a\0\u056a\0\u4662"+
    "\0\u46af\0\u46fc\0\u4749\0\u4796\0\u056a\0\u47e3\0\u4830\0\u487d"+
    "\0\u48ca\0\u4917\0\u4964\0\u056a\0\u49b1\0\u49fe\0\u4a4b\0\u4a98"+
    "\0\u4ae5\0\u056a\0\u4b32\0\u29cf\0\u03e9\0\u4b7f\0\u03e9\0\u03e9"+
    "\0\u4bcc\0\u2c37\0\u03e9\0\u4c19\0\u03e9\0\u4c66\0\u4cb3\0\u056a"+
    "\0\u4d00\0\u056a\0\u056a\0\u4d4d\0\u4d9a\0\u4de7\0\u4e34\0\u4e81"+
    "\0\u056a\0\u4ece\0\u4f1b\0\u056a\0\u4f68\0\u4fb5\0\u056a\0\u5002"+
    "\0\u056a\0\u504f\0\u509c\0\u50e9\0\u5136\0\u5183\0\u51d0\0\u521d"+
    "\0\u526a\0\u056a\0\u52b7\0\u5304\0\u5351\0\u539e\0\u53eb\0\u5438"+
    "\0\u5485\0\u54d2\0\u551f\0\u556c\0\u056a\0\u55b9\0\u5606\0\u5653"+
    "\0\u56a0\0\u56ed\0\u056a\0\u573a\0\u056a\0\u056a\0\u056a\0\u5787"+
    "\0\u056a\0\u57d4\0\u056a\0\u5821\0\u586e\0\u58bb\0\u056a\0\u5908"+
    "\0\u5955\0\u59a2\0\u59ef\0\u5a3c\0\u5a89\0\u5ad6\0\u5b23\0\u056a"+
    "\0\u056a\0\u5b70\0\u5bbd\0\u5c0a\0\u056a\0\u5c57\0\u056a\0\u5ca4"+
    "\0\u5cf1\0\u5d3e\0\u5d8b\0\u5dd8\0\u056a\0\u5e25\0\u056a\0\u5e72"+
    "\0\u5ebf\0\u5f0c\0\u5f59\0\u056a\0\u056a\0\u5fa6\0\u5ff3\0\u056a"+
    "\0\u6040\0\u608d\0\u60da\0\u056a\0\u6127\0\u6174\0\u056a\0\u61c1"+
    "\0\u03e9\0\u056a\0\u620e\0\u625b\0\u62a8\0\u62f5\0\u056a\0\u6342"+
    "\0\u056a\0\u638f\0\u056a\0\u03e9\0\u63dc\0\u6429\0\u6476\0\u64c3"+
    "\0\u056a\0\u056a\0\u6510\0\u655d\0\u65aa\0\u65f7\0\u6644\0\u6691"+
    "\0\u66de\0\u672b\0\u6778\0\u67c5\0\u6812\0\u685f\0\u68ac\0\u68f9"+
    "\0\u6946\0\u6993\0\u69e0\0\u6a2d\0\u03e9\0\u6a7a\0\u6ac7\0\u6b14";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[512];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\16"+
    "\1\24\1\25\1\26\1\21\1\27\1\30\1\31\1\32"+
    "\2\24\1\33\1\16\1\34\1\35\4\24\1\36\1\37"+
    "\1\40\1\41\1\42\1\43\2\24\1\44\1\33\1\24"+
    "\1\45\1\46\1\24\1\47\1\50\1\51\1\33\1\52"+
    "\1\53\1\54\1\24\1\55\1\56\1\16\1\57\1\60"+
    "\1\61\1\62\1\63\1\24\1\64\1\65\1\66\1\67"+
    "\1\24\1\70\1\24\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\102\1\103\1\104\1\16"+
    "\1\105\1\106\1\107\31\105\1\110\25\105\1\111\32\105"+
    "\1\112\1\113\1\114\32\112\1\115\24\112\1\111\32\112"+
    "\1\16\1\116\1\117\1\120\1\121\3\16\1\122\2\16"+
    "\1\120\2\16\1\123\3\122\4\16\4\122\5\16\4\122"+
    "\1\16\7\122\4\16\2\122\5\16\16\122\1\124\11\16"+
    "\1\116\1\117\10\16\1\125\2\16\1\126\132\16\1\127"+
    "\1\130\46\16\1\131\10\16\1\132\1\116\1\117\21\132"+
    "\1\133\71\132\1\116\1\117\27\132\1\134\63\132\1\135"+
    "\1\136\12\132\1\137\100\132\1\116\1\117\7\132\1\140"+
    "\71\132\1\141\10\132\1\142\1\113\1\114\57\142\1\143"+
    "\1\144\31\142\1\132\1\116\1\117\27\132\1\145\63\132"+
    "\1\135\1\136\12\132\1\146\77\132\117\0\1\20\115\0"+
    "\1\21\7\0\1\21\101\0\1\147\2\0\1\147\1\150"+
    "\1\151\25\147\1\152\26\147\1\153\32\147\33\0\1\154"+
    "\67\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\2\24\5\0\16\24\22\0\1\155\1\156\7\0"+
    "\1\157\13\0\1\157\4\0\1\157\7\0\1\157\1\160"+
    "\50\0\1\161\1\0\1\162\1\0\1\163\2\0\3\161"+
    "\4\0\4\161\1\0\1\164\3\0\4\161\1\0\7\161"+
    "\4\0\2\161\5\0\16\161\1\165\43\0\1\166\76\0"+
    "\1\167\15\0\1\170\77\0\1\171\14\0\1\172\100\0"+
    "\1\173\106\0\1\157\10\0\1\33\13\0\1\33\1\174"+
    "\3\0\1\33\2\175\1\176\4\0\1\33\3\0\2\177"+
    "\12\0\1\174\32\0\1\200\12\0\1\201\123\0\1\202"+
    "\72\0\1\157\10\0\1\203\13\0\1\204\1\174\2\205"+
    "\1\0\1\204\2\175\1\176\4\0\1\204\3\0\2\177"+
    "\12\0\1\174\27\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\3\24\1\206\1\207"+
    "\11\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\11\24\1\210\1\211\1\212\2\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\12\24\1\213\3\24\3\0\1\24\1\214\5\0\11\24"+
    "\1\215\4\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\1\24\1\216\7\24\1\217\1\220\1\221\2\24"+
    "\3\0\2\24\5\0\5\24\1\222\10\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\12\24\1\223\3\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\3\24"+
    "\1\224\12\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\1\24\1\225\5\24"+
    "\1\226\1\24\1\227\4\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\2\24\1\230\6\24\1\231\1\24"+
    "\1\232\2\24\3\0\2\24\5\0\16\24\44\0\1\233"+
    "\25\0\1\234\116\0\1\235\65\0\1\236\102\0\1\237"+
    "\13\0\1\240\4\0\1\237\7\0\1\237\47\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\1\24\1\241\14\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\1\24\1\242\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\1\24\1\243\12\24\1\244\1\24\3\0\1\24\1\245"+
    "\5\0\6\24\1\246\7\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\1\24\1\247\11\24\1\250\2\24"+
    "\3\0\1\24\1\251\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\6\24\1\252\1\24\1\253"+
    "\5\24\3\0\2\24\5\0\3\24\1\254\1\255\11\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\2\24\5\0\5\24\1\256\1\24\1\257\6\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\1\24"+
    "\1\260\11\24\1\261\2\24\3\0\2\24\5\0\1\24"+
    "\1\262\14\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\12\24\1\263\1\264\2\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\1\24\1\265\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\4\24\1\266\11\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\13\24\1\267\2\24\3\0\2\24"+
    "\5\0\16\24\44\0\1\270\54\0\1\271\37\0\1\272"+
    "\55\0\1\273\36\0\1\274\114\0\1\275\61\0\1\105"+
    "\2\0\31\105\1\0\25\105\1\0\32\105\2\0\1\107"+
    "\112\0\1\276\3\0\30\276\1\277\1\300\1\276\1\301"+
    "\1\302\5\276\1\303\3\276\1\304\7\276\1\305\3\276"+
    "\1\306\1\307\2\276\1\310\21\276\1\0\1\112\2\0"+
    "\32\112\1\0\24\112\1\0\32\112\2\0\1\114\114\0"+
    "\1\117\115\0\1\120\7\0\1\120\117\0\1\311\106\0"+
    "\2\312\3\0\1\312\1\0\5\312\2\0\4\312\1\0"+
    "\1\313\2\0\16\312\3\0\2\312\5\0\16\312\24\0"+
    "\1\125\101\0\1\314\2\0\31\314\1\315\60\314\1\316"+
    "\2\0\32\316\1\317\57\316\16\0\1\320\130\0\1\321"+
    "\64\0\1\136\127\0\1\322\103\0\1\323\3\0\1\324"+
    "\3\0\1\325\2\0\3\324\2\0\1\326\1\0\4\324"+
    "\5\0\4\324\1\0\7\324\4\0\2\324\5\0\16\324"+
    "\1\327\10\0\1\330\3\0\33\330\1\331\1\332\5\330"+
    "\1\333\3\330\1\334\7\330\1\335\1\336\2\330\1\337"+
    "\1\340\2\330\1\341\11\330\1\342\7\330\33\0\1\343"+
    "\77\0\1\344\77\0\1\147\2\0\1\147\1\345\55\147"+
    "\1\153\32\147\1\150\1\346\1\347\112\150\1\350\2\351"+
    "\1\350\1\352\1\353\54\350\1\354\32\350\1\147\2\0"+
    "\1\147\1\355\55\147\1\153\32\147\11\0\1\356\125\0"+
    "\1\157\13\0\1\157\4\0\1\157\2\175\1\176\4\0"+
    "\1\157\3\0\2\177\44\0\2\161\3\0\1\161\1\0"+
    "\5\161\2\0\4\161\4\0\16\161\3\0\2\161\5\0"+
    "\16\161\44\0\1\357\76\0\1\360\7\0\1\361\122\0"+
    "\1\362\77\0\1\363\14\0\1\364\76\0\1\365\4\0"+
    "\1\366\13\0\1\366\4\0\1\366\7\0\1\366\5\0"+
    "\1\365\66\0\1\367\72\0\1\157\10\0\1\203\13\0"+
    "\1\203\4\0\1\203\2\175\1\176\4\0\1\203\3\0"+
    "\2\177\45\0\1\157\10\0\1\203\13\0\1\204\4\0"+
    "\1\204\2\175\1\176\4\0\1\204\3\0\2\177\54\0"+
    "\1\370\1\0\1\370\3\0\3\370\5\0\1\370\3\0"+
    "\2\370\1\0\2\370\2\0\1\370\1\0\1\370\3\0"+
    "\2\370\5\0\1\370\34\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\1\24\1\371\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\7\24"+
    "\1\372\6\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\13\24\1\373\2\24"+
    "\3\0\2\24\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\4\24"+
    "\1\374\11\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\14\24\1\375\1\24\3\0\2\24\5\0\3\24"+
    "\1\376\12\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\10\24\1\377\1\u0100\4\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\2\24\5\0\4\24\1\u0101\11\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\2\24\5\0\4\24\1\u0102\11\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\12\24\1\u0103\3\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\1\24\1\u0104"+
    "\14\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\11\24\1\u0105\4\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\2\24\5\0\4\24\1\u0106\11\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\1\24\1\u0107"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\1\24\1\u0108\14\24\3\0\2\24\5\0\11\24"+
    "\1\u0109\4\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\1\24\1\u010a\3\24"+
    "\1\u010b\10\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\10\24\1\u010c\5\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\14\24"+
    "\1\u010d\1\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\3\24\1\u010e\12\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\4\24\1\u010f\11\24\3\0\2\24"+
    "\5\0\16\24\17\0\1\u0110\1\0\1\u0110\7\0\2\u0110"+
    "\4\0\4\u0110\5\0\4\u0110\1\0\7\u0110\4\0\2\u0110"+
    "\5\0\16\u0110\11\0\1\236\2\0\31\236\1\u0111\60\236"+
    "\22\0\1\237\13\0\1\237\1\u0112\3\0\1\237\7\0"+
    "\1\237\17\0\1\u0112\60\0\1\u0112\33\0\1\u0112\27\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\1\24\1\u0113\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\14\24\1\u0114\1\24\3\0\2\24"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\10\24\1\u0115\5\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\13\24"+
    "\1\u0116\2\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\14\24\1\u0117\1\24"+
    "\3\0\2\24\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\5\24"+
    "\1\u0118\10\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\11\24\1\u0119\4\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\6\24"+
    "\1\u011a\5\24\1\u011b\1\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\2\24\5\0\6\24\1\u011c\7\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\10\24\1\u011d\5\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\14\24\1\u011e\1\24\3\0\2\24"+
    "\5\0\3\24\1\u011f\12\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\14\24\1\u0120\1\24\3\0\2\24"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\5\24\1\u0121\10\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\2\24\5\0\1\u0122\15\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\4\24\1\u0123\11\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\12\24\1\u0124\3\24\3\0\2\24\5\0"+
    "\5\24\1\u0125\10\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\5\24\1\u0126"+
    "\10\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\2\24\5\0\1\24\1\u0127\14\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\14\24\1\u0128"+
    "\1\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\10\24\1\u0129\5\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\15\24\1\u012a"+
    "\44\0\1\u012b\114\0\1\u012c\101\0\1\u012d\1\0\1\u012d"+
    "\3\0\3\u012d\5\0\1\u012d\3\0\2\u012d\1\0\2\u012d"+
    "\2\0\1\u012d\1\0\1\u012d\3\0\2\u012d\5\0\1\u012d"+
    "\46\0\1\u012e\1\0\1\u012e\3\0\3\u012e\5\0\1\u012e"+
    "\3\0\2\u012e\1\0\2\u012e\2\0\1\u012e\1\0\1\u012e"+
    "\3\0\2\u012e\5\0\1\u012e\44\0\1\u012f\114\0\1\u0130"+
    "\106\0\1\u0131\6\0\3\u0131\4\0\4\u0131\5\0\4\u0131"+
    "\1\0\7\u0131\4\0\2\u0131\5\0\16\u0131\1\u0132\20\0"+
    "\2\324\3\0\1\324\1\0\5\324\2\0\4\324\4\0"+
    "\16\324\3\0\2\324\5\0\16\324\26\0\1\u0133\7\0"+
    "\1\u0134\77\0\1\u0135\6\0\3\u0135\4\0\4\u0135\5\0"+
    "\4\u0135\1\0\7\u0135\4\0\2\u0135\5\0\16\u0135\31\0"+
    "\1\u0136\1\0\1\u0136\3\0\3\u0136\5\0\1\u0136\3\0"+
    "\2\u0136\1\0\2\u0136\2\0\1\u0136\1\0\1\u0136\3\0"+
    "\2\u0136\5\0\1\u0136\46\0\1\u0137\1\0\1\u0137\3\0"+
    "\3\u0137\5\0\1\u0137\3\0\2\u0137\1\0\2\u0137\2\0"+
    "\1\u0137\1\0\1\u0137\3\0\2\u0137\5\0\1\u0137\50\0"+
    "\1\u0138\13\0\1\u0139\4\0\1\u0138\7\0\1\u0138\57\0"+
    "\1\u013a\114\0\1\u013b\117\0\1\345\15\0\2\345\1\0"+
    "\1\345\1\0\7\345\5\0\1\345\5\0\14\345\15\0"+
    "\1\347\112\0\1\350\2\351\1\350\1\352\1\u013c\54\350"+
    "\1\354\32\350\5\351\1\u013d\114\351\1\u013d\13\351\1\352"+
    "\15\351\2\352\1\351\1\352\1\351\7\352\5\351\1\352"+
    "\5\351\14\352\13\351\1\147\2\0\1\147\1\u013e\1\353"+
    "\54\147\1\153\32\147\1\350\2\351\1\350\1\u013f\1\u013c"+
    "\54\350\1\354\32\350\1\147\2\0\1\147\1\345\14\147"+
    "\1\355\15\147\2\355\1\147\1\355\1\147\7\355\5\147"+
    "\1\355\1\147\1\153\3\147\14\355\13\147\15\0\1\u0140"+
    "\125\0\1\u0141\121\0\1\u0142\103\0\1\366\13\0\1\366"+
    "\4\0\1\366\7\0\1\366\63\0\1\366\13\0\1\366"+
    "\4\0\1\366\2\175\1\176\4\0\1\366\47\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\1\24"+
    "\1\u0143\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\3\24\1\u0144"+
    "\12\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\14\24\1\u0145\1\24\3\0\2\24\5\0\3\24\1\u0146"+
    "\12\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\4\24\1\u0147\11\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\1\24\1\u0148\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\13\24\1\u0149\2\24\3\0\2\24"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\1\24\1\u014a\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\13\24\1\u014b"+
    "\2\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\4\24\1\u014c\11\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\13\24\1\u014d\2\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\2\24\5\0\3\24\1\u014e\12\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\13\24\1\u014f"+
    "\2\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\1\24\1\u0150\14\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\1\24\1\u0151\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\12\24"+
    "\1\u0152\3\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\3\24\1\u0153\12\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\1\24\1\u0154\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\1\24\1\u0155\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\1\24"+
    "\1\u0156\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\7\24\1\u0157"+
    "\6\24\17\0\3\u0110\7\0\3\u0110\3\0\4\u0110\4\0"+
    "\16\u0110\3\0\2\u0110\5\0\16\u0110\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\13\24\1\u0158\2\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\1\24\1\u0159\14\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\1\24\1\u015a\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\14\24\1\u015b\1\24"+
    "\3\0\2\24\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\14\24\1\u015c\1\24\3\0\2\24"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\11\24\1\u015d\4\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\1\24\1\u015e\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\5\24\1\u015f\10\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\11\24\1\u0160\1\u0161\3\24\3\0\2\24"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\1\24\1\u0162\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\14\24\1\u0163"+
    "\1\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\7\24\1\u0164\6\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\11\24\1\u0165\4\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\11\24\1\u0166\4\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\2\24\5\0\2\24\1\u0167\13\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\14\24\1\u0168\1\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\12\24\1\u0169"+
    "\3\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\7\24\1\u016a\6\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\2\24\5\0\5\24\1\u016b\10\24\31\0\1\u016c\1\0"+
    "\1\u016c\3\0\3\u016c\5\0\1\u016c\3\0\2\u016c\1\0"+
    "\2\u016c\2\0\1\u016c\1\0\1\u016c\3\0\2\u016c\5\0"+
    "\1\u016c\46\0\1\u016d\1\0\1\u016d\3\0\3\u016d\5\0"+
    "\1\u016d\3\0\2\u016d\1\0\2\u016d\2\0\1\u016d\1\0"+
    "\1\u016d\3\0\2\u016d\5\0\1\u016d\27\0\2\u016e\5\0"+
    "\2\u0131\1\0\1\u016e\1\0\1\u0131\1\u016f\5\u0131\2\0"+
    "\4\u0131\4\0\16\u0131\3\0\2\u0131\5\0\16\u0131\26\0"+
    "\1\u0170\125\0\1\u0171\76\0\2\u0135\3\0\1\u0135\1\0"+
    "\5\u0135\2\0\4\u0135\4\0\16\u0135\3\0\2\u0135\5\0"+
    "\16\u0135\31\0\1\u0172\1\0\1\u0172\3\0\3\u0172\5\0"+
    "\1\u0172\3\0\2\u0172\1\0\2\u0172\2\0\1\u0172\1\0"+
    "\1\u0172\3\0\2\u0172\5\0\1\u0172\46\0\1\u0173\1\0"+
    "\1\u0173\3\0\3\u0173\5\0\1\u0173\3\0\2\u0173\1\0"+
    "\2\u0173\2\0\1\u0173\1\0\1\u0173\3\0\2\u0173\5\0"+
    "\1\u0173\50\0\1\u0138\13\0\1\u0138\1\u0174\3\0\1\u0138"+
    "\7\0\1\u0138\17\0\1\u0174\11\0\1\u0175\46\0\1\u0174"+
    "\33\0\1\u0174\11\0\1\u0175\7\0\1\350\2\351\1\350"+
    "\1\u013e\1\u013c\54\350\1\354\32\350\4\351\1\347\1\u013d"+
    "\107\351\1\350\2\351\1\350\1\352\1\u013c\13\350\1\u013f"+
    "\15\350\2\u013f\1\350\1\u013f\1\350\7\u013f\5\350\1\u013f"+
    "\1\350\1\354\3\350\14\u013f\13\350\27\0\1\u0176\73\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\10\24\1\u0177"+
    "\5\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\3\24\1\u0178\12\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\5\24\1\u0179"+
    "\10\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\14\24\1\u017a\1\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\2\24\5\0\7\24\1\u017b\6\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\1\24\1\u017c\14\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\14\24\1\u017d\1\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\6\24\1\u017e\7\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\14\24\1\u017f"+
    "\1\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\14\24\1\u0180\1\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\1\24\1\u0181\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\11\24"+
    "\1\u0182\4\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\1\24\1\u0183\14\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\6\24"+
    "\1\u0184\7\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\12\24\1\u0185\3\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\2\24\5\0\4\24\1\u0186\11\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\2\24\1\u0187\13\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\1\24"+
    "\1\u0188\14\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\1\24\1\u0189\14\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\2\24\5\0\5\24\1\u018a\10\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\4\24\1\u018b\11\24"+
    "\3\0\2\24\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\3\24"+
    "\1\u018c\12\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\12\24\1\u018d\3\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\1\24\1\u018e\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\1\24\1\u018f\14\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\1\24\1\u0190"+
    "\14\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\13\24\1\u0191\2\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\1\24\1\u0192\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\5\24"+
    "\1\u0193\10\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\13\24\1\u0194\2\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\1\24\1\u0195\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\13\24\1\u0196\2\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\4\24\1\u0197"+
    "\11\24\12\0\2\u016e\10\0\1\u016e\2\0\1\u016f\125\0"+
    "\1\u0198\172\0\1\u0175\37\0\1\u0199\72\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\5\24\1\u019a\10\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\4\24\1\u019b"+
    "\11\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\11\24\1\u019c\4\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\1\24\1\u019d\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\5\24"+
    "\1\u019e\10\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\5\24\1\u019f\10\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\15\24"+
    "\1\u01a0\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\11\24\1\u01a1\4\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\2\24\5\0\5\24\1\u01a2"+
    "\10\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\10\24\1\u01a3\5\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\7\24\1\u01a4"+
    "\6\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\4\24\1\u01a5\11\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\4\24\1\u01a6\11\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\2\24\5\0\7\24\1\u01a7\6\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\2\24\5\0\10\24\1\u01a8\5\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\1\24\1\u01a9"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\6\24\1\u01aa\7\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\14\24"+
    "\1\u01ab\1\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\10\24\1\u01ac\5\24"+
    "\3\0\2\24\5\0\4\24\1\u01ad\11\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\4\24\1\u01ae\11\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\4\24\1\u01af\11\24\3\0\2\24"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\2\24\5\0\13\24\1\u01b0\2\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\4\24"+
    "\1\u01b1\11\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\14\24\1\u01b2\1\24"+
    "\3\0\2\24\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\2\24\5\0\5\24"+
    "\1\u01b3\10\24\41\0\1\u01b4\115\0\1\u01b5\71\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\2\24"+
    "\5\0\4\24\1\u01b6\11\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\1\24\1\u01b7\14\24\3\0\2\24"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\14\24\1\u01b8\1\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\4\24"+
    "\1\u01b9\11\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\12\24\1\u01ba\3\24"+
    "\3\0\2\24\5\0\16\24\12\0\3\u01bb\2\0\3\24"+
    "\2\0\1\u01bb\4\0\3\24\3\0\4\24\4\0\16\24"+
    "\1\u01bc\2\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\11\24\1\u01bd\4\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\7\24\1\u01be\6\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\2\24\5\0\3\24\1\u01bf\12\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\13\24\1\u01c0"+
    "\2\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\1\24\1\u01c1"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\13\24\1\u01c2\2\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\13\24"+
    "\1\u01c3\2\24\3\0\2\24\5\0\16\24\17\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\4\24\1\u01c4\11\24"+
    "\3\0\2\24\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\1\24\1\u01c5\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\14\24\1\u01c6\1\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\1\24\1\u01c7\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\14\24\1\u01c8\1\24\3\0\2\24"+
    "\5\0\16\24\42\0\1\u01c9\113\0\1\u01ca\72\0\3\24"+
    "\7\0\3\24\3\0\4\24\4\0\16\24\3\0\1\24"+
    "\1\u01cb\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\16\24\3\0\1\24\1\u01cc\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\2\24\5\0\4\24\1\u01cd\11\24\12\0\3\u01bb"+
    "\7\0\1\u01bb\40\0\1\u01bc\41\0\3\u01bc\5\0\1\u01ce"+
    "\1\0\1\u01bc\6\0\1\u01cf\13\0\1\u01cf\4\0\1\u01cf"+
    "\7\0\1\u01cf\47\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\16\24\3\0\1\24\1\u01d0\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\4\24\1\u01d1"+
    "\11\24\3\0\2\24\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\4\24\1\u01d2\11\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\4\24\1\u01d3\11\24\3\0\2\24\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\11\24\1\u01d4\4\24\3\0\2\24\5\0\16\24\17\0"+
    "\3\24\7\0\3\24\3\0\4\24\4\0\16\24\3\0"+
    "\1\24\1\u01d5\5\0\16\24\17\0\3\24\7\0\3\24"+
    "\3\0\4\24\4\0\16\24\3\0\1\24\1\u01d6\5\0"+
    "\16\24\17\0\3\24\7\0\3\24\3\0\4\24\4\0"+
    "\16\24\3\0\2\24\5\0\11\24\1\u01d7\4\24\41\0"+
    "\1\u01d8\111\0\1\u01d9\75\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\7\24\1\u01da\6\24\3\0\2\24\5\0"+
    "\16\24\33\0\1\u01db\13\0\1\u01db\4\0\1\u01db\7\0"+
    "\1\u01db\42\0\3\u01dc\5\0\1\u01db\1\0\1\u01dc\6\0"+
    "\1\u01cf\13\0\1\u01cf\4\0\1\u01cf\2\0\1\u01dc\4\0"+
    "\1\u01cf\1\0\1\u01dd\1\0\2\u01de\42\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\1\24\1\u01df"+
    "\5\0\16\24\17\0\3\24\7\0\3\24\3\0\4\24"+
    "\4\0\14\24\1\u01e0\1\24\3\0\2\24\5\0\16\24"+
    "\17\0\3\24\7\0\3\24\3\0\4\24\4\0\16\24"+
    "\3\0\1\24\1\u01e1\5\0\16\24\17\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\12\24\1\u01e2\3\24\3\0"+
    "\2\24\5\0\16\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\7\24\1\u01e3\6\24\3\0\2\24\5\0"+
    "\16\24\36\0\1\u01e4\70\0\3\u01dc\7\0\1\u01dc\6\0"+
    "\1\u01db\13\0\1\u01db\4\0\1\u01db\2\0\1\u01dc\4\0"+
    "\1\u01db\1\0\1\u01dd\1\0\2\u01de\35\0\3\u01dc\7\0"+
    "\1\u01dc\41\0\1\u01dd\40\0\3\u01dd\5\0\1\u01e5\1\0"+
    "\1\u01dd\6\0\1\u01e6\13\0\1\u01e6\4\0\1\u01e6\7\0"+
    "\1\u01e6\56\0\1\u01e7\4\0\1\u01e8\13\0\1\u01e8\4\0"+
    "\1\u01e8\7\0\1\u01e8\5\0\1\u01e7\41\0\3\24\7\0"+
    "\3\24\3\0\4\24\4\0\16\24\3\0\2\24\5\0"+
    "\3\24\1\u01e9\12\24\17\0\3\24\7\0\3\24\3\0"+
    "\4\24\4\0\10\24\1\u01ea\5\24\3\0\2\24\5\0"+
    "\16\24\33\0\1\u01eb\13\0\1\u01eb\4\0\1\u01eb\7\0"+
    "\1\u01eb\42\0\3\u01ec\5\0\1\u01eb\1\0\1\u01ec\6\0"+
    "\1\u01e6\13\0\1\u01e6\4\0\1\u01e6\2\0\1\u01ec\4\0"+
    "\1\u01e6\1\0\1\u01ed\1\0\2\u01ee\56\0\1\u01e8\13\0"+
    "\1\u01e8\4\0\1\u01e8\7\0\1\u01e8\42\0\3\u01dc\7\0"+
    "\1\u01dc\6\0\1\u01e8\13\0\1\u01e8\4\0\1\u01e8\2\0"+
    "\1\u01dc\4\0\1\u01e8\1\0\1\u01dd\40\0\3\u01ec\7\0"+
    "\1\u01ec\6\0\1\u01eb\13\0\1\u01eb\4\0\1\u01eb\2\0"+
    "\1\u01ec\4\0\1\u01eb\1\0\1\u01ed\1\0\2\u01ee\35\0"+
    "\3\u01ec\7\0\1\u01ec\41\0\1\u01ed\40\0\3\u01ed\5\0"+
    "\1\u01ef\1\0\1\u01ed\6\0\1\u01f0\13\0\1\u01f0\4\0"+
    "\1\u01f0\7\0\1\u01f0\56\0\1\u01f1\4\0\1\u01f2\13\0"+
    "\1\u01f2\4\0\1\u01f2\7\0\1\u01f2\5\0\1\u01f1\55\0"+
    "\1\u01f3\13\0\1\u01f3\4\0\1\u01f3\7\0\1\u01f3\42\0"+
    "\3\u01f4\5\0\1\u01f3\1\0\1\u01f4\6\0\1\u01f0\13\0"+
    "\1\u01f0\4\0\1\u01f0\2\0\1\u01f4\4\0\1\u01f0\1\0"+
    "\1\u01f5\1\0\2\u01f6\56\0\1\u01f2\13\0\1\u01f2\4\0"+
    "\1\u01f2\7\0\1\u01f2\42\0\3\u01ec\7\0\1\u01ec\6\0"+
    "\1\u01f2\13\0\1\u01f2\4\0\1\u01f2\2\0\1\u01ec\4\0"+
    "\1\u01f2\1\0\1\u01ed\40\0\3\u01f4\7\0\1\u01f4\6\0"+
    "\1\u01f3\13\0\1\u01f3\4\0\1\u01f3\2\0\1\u01f4\4\0"+
    "\1\u01f3\1\0\1\u01f5\1\0\2\u01f6\35\0\3\u01f4\7\0"+
    "\1\u01f4\41\0\1\u01f5\40\0\3\u01f5\5\0\1\u01f7\1\0"+
    "\1\u01f5\6\0\1\u01f8\13\0\1\u01f8\4\0\1\u01f8\7\0"+
    "\1\u01f8\56\0\1\u01f9\4\0\1\u01fa\13\0\1\u01fa\4\0"+
    "\1\u01fa\7\0\1\u01fa\5\0\1\u01f9\55\0\1\u01fb\13\0"+
    "\1\u01fb\4\0\1\u01fb\7\0\1\u01fb\42\0\3\u01fc\5\0"+
    "\1\u01fb\1\0\1\u01fc\6\0\1\u01f8\13\0\1\u01f8\4\0"+
    "\1\u01f8\2\0\1\u01fc\4\0\1\u01f8\2\0\1\u01fd\2\u01fe"+
    "\56\0\1\u01fa\13\0\1\u01fa\4\0\1\u01fa\7\0\1\u01fa"+
    "\42\0\3\u01f4\7\0\1\u01f4\6\0\1\u01fa\13\0\1\u01fa"+
    "\4\0\1\u01fa\2\0\1\u01f4\4\0\1\u01fa\1\0\1\u01f5"+
    "\40\0\3\u01fc\7\0\1\u01fc\6\0\1\u01fb\13\0\1\u01fb"+
    "\4\0\1\u01fb\2\0\1\u01fc\4\0\1\u01fb\2\0\1\u01fd"+
    "\2\u01fe\35\0\3\u01fc\7\0\1\u01fc\42\0\1\u01fd\53\0"+
    "\1\u01ff\4\0\1\u0200\13\0\1\u0200\4\0\1\u0200\7\0"+
    "\1\u0200\5\0\1\u01ff\55\0\1\u0200\13\0\1\u0200\4\0"+
    "\1\u0200\7\0\1\u0200\42\0\3\u01fc\7\0\1\u01fc\6\0"+
    "\1\u0200\13\0\1\u0200\4\0\1\u0200\2\0\1\u01fc\4\0"+
    "\1\u0200\2\0\1\u01fd\36\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[27489];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\15\0\1\11\1\1\1\11\14\1\2\11\1\1\2\11"+
    "\10\1\3\11\20\1\4\11\6\1\2\11\3\1\2\11"+
    "\1\1\1\11\3\1\2\11\1\1\1\11\2\1\2\11"+
    "\3\1\1\11\2\1\2\11\1\1\1\11\2\1\1\0"+
    "\1\1\1\0\1\1\1\0\1\11\1\1\1\11\1\1"+
    "\1\11\2\1\1\0\2\11\1\1\2\11\1\1\5\11"+
    "\1\0\2\11\3\1\1\0\25\1\2\11\2\0\31\1"+
    "\1\11\1\1\1\11\1\1\5\11\2\1\7\11\1\0"+
    "\1\11\1\0\1\11\1\0\2\11\3\0\1\1\2\0"+
    "\2\11\2\1\7\11\1\1\2\0\2\1\1\11\2\0"+
    "\1\1\2\0\1\1\2\11\2\0\1\11\1\1\1\11"+
    "\1\0\1\1\1\11\31\1\2\11\30\1\2\11\2\0"+
    "\2\11\1\0\1\11\2\0\1\1\4\0\2\11\2\0"+
    "\2\1\1\11\1\0\1\11\51\1\1\0\1\11\1\0"+
    "\2\11\2\0\1\11\1\0\1\11\1\0\41\1\2\0"+
    "\32\1\2\0\5\1\2\0\14\1\2\0\3\1\2\0"+
    "\10\1\1\0\1\11\1\1\4\0\5\1\1\11\4\0"+
    "\2\1\22\0\1\11\3\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[512];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */

    private String sourceCode;

    private int repeatNum = 1;

    private boolean enableWhiteSpace = false;

    private final Pattern float4Pattern = Pattern.compile("float4.*\\([\r\n \t\f]*(?<f1>[^\r\n \t\f]+)[\r\n \t\f]*,[\r\n \t\f]*(?<f2>[^\r\n \t\f]+)[\r\n \t\f]*,[\r\n \t\f]*(?<f3>[^\r\n \t\f]+)[\r\n \t\f]*,[\r\n \t\f]*(?<f4>[^\r\n \t\f]+)[\r\n \t\f]*\\)", Pattern.MULTILINE);

    public ActionScriptLexer(String sourceCode){
        this(new StringReader(sourceCode));
        this.sourceCode = sourceCode;
    }

    public void yypushbackstr(String s, int state)
    {
        int numLines = count(s, "\n");
        int newYyline = yyline - numLines;
        sourceCode = s + sourceCode.substring(yychar + yylength());
        yyreset(new StringReader(sourceCode));
        yybegin(state);
        yyline = newYyline;
    }

    public void setEnableWhiteSpace(boolean enable)
    {
        this.enableWhiteSpace = enable;
    }

    public void begin(int state)
    {
        string.setLength(0);
        yybegin(state);
    }

    public void yypushbackstr(String s)
    {
        yypushbackstr(s, YYINITIAL);
    }

    StringBuilder string = new StringBuilder();

    private static String xmlTagName = "";

    public int yychar() {
        return yychar;
    }

    private Stack<ParsedSymbol> pushedBack = new Stack<>();

    public int yyline() {
        return yyline + 1;
    }

    private List<LexListener> listeners=new ArrayList<>();

    public void addListener(LexListener listener){
        listeners.add(listener);
    }

    public void removeListener(LexListener listener){
        listeners.remove(listener);
    }

    public void informListenersLex(ParsedSymbol s){
        for(LexListener l:listeners){
            l.onLex(s);
        }
    }

    public void informListenersPushBack(ParsedSymbol s){
        for(LexListener l:listeners){
            l.onPushBack(s);
        }
    }

    public void pushback(ParsedSymbol symb) {
        pushedBack.push(symb);
        last = null;
        informListenersPushBack(symb);
    }

    ParsedSymbol last;
    public ParsedSymbol lex() throws java.io.IOException, AVM2ParseException{
        ParsedSymbol ret = null;
        if (!pushedBack.isEmpty()){
            ret = last = pushedBack.pop();
        } else {
            ret = last = yylex();
        }
        informListenersLex(ret);
        return ret;
    }

    private int count(String str, String target) {
        return (str.length() - str.replace(target, "").length()) / target.length();
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ActionScriptLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 3138) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;           
    int totalRead = 0;
    while (totalRead < requested) {
      int numRead = zzReader.read(zzBuffer, zzEndRead + totalRead, requested - totalRead);
      if (numRead == -1) {
        break;
      }
      totalRead += numRead;
    }

    if (totalRead > 0) {
      zzEndRead += totalRead;
      if (totalRead == requested) { /* possibly more input available */
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      return false;
    }

    // totalRead = 0: End of stream
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public ParsedSymbol yylex() throws java.io.IOException, AVM2ParseException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { 
          }
        case 186: break;
        case 2: 
          { yyline++;
                                    if (enableWhiteSpace) { return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_WHITESPACE, yytext()); }
          }
        case 187: break;
        case 3: 
          { if (enableWhiteSpace) { return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_WHITESPACE, yytext()); }
          }
        case 188: break;
        case 4: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.DIVIDE, yytext());
          }
        case 189: break;
        case 5: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.MULTIPLY, yytext());
          }
        case 190: break;
        case 6: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.IDENTIFIER, yytext());
          }
        case 191: break;
        case 7: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.DOT, yytext());
          }
        case 192: break;
        case 8: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.LOWER_THAN, yytext());
          }
        case 193: break;
        case 9: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.NOT, yytext());
          }
        case 194: break;
        case 10: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.MINUS, yytext());
          }
        case 195: break;
        case 11: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.GREATER_THAN, yytext());
          }
        case 196: break;
        case 12: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.COLON, yytext());
          }
        case 197: break;
        case 13: 
          { String ival = yytext();
                                    if (ival.endsWith("i") || ival.endsWith("u")) {
                                        ival = ival.substring(0, ival.length() - 1);
                                    }
                                    try{
                                        return new ParsedSymbol(SymbolGroup.INTEGER, SymbolType.INTEGER, Integer.parseInt(ival)); 
                                    } catch(NumberFormatException nfe){
                                        //its too long for an Integer var
                                        return new ParsedSymbol(SymbolGroup.DOUBLE, SymbolType.DOUBLE, Double.parseDouble(ival)); 
                                    }
          }
        case 198: break;
        case 14: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.TERNAR, yytext());
          }
        case 199: break;
        case 15: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.BRACKET_OPEN, yytext());
          }
        case 200: break;
        case 16: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.BRACKET_CLOSE, yytext());
          }
        case 201: break;
        case 17: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN, yytext());
          }
        case 202: break;
        case 18: 
          { string.setLength(0);
                                    yybegin(STRING);
          }
        case 203: break;
        case 19: 
          { string.setLength(0);
                                    yybegin(CHARLITERAL);
          }
        case 204: break;
        case 20: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.PARENT_OPEN, yytext());
          }
        case 205: break;
        case 21: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.COMMA, yytext());
          }
        case 206: break;
        case 22: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.PARENT_CLOSE, yytext());
          }
        case 207: break;
        case 23: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.PLUS, yytext());
          }
        case 208: break;
        case 24: 
          { string.setLength(0);
                                    yybegin(OIDENTIFIER);
          }
        case 209: break;
        case 25: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ATTRIBUTE, yytext());
          }
        case 210: break;
        case 26: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.CURLY_OPEN, yytext());
          }
        case 211: break;
        case 27: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.CURLY_CLOSE, yytext());
          }
        case 212: break;
        case 28: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.SEMICOLON, yytext());
          }
        case 213: break;
        case 29: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.NEGATE, yytext());
          }
        case 214: break;
        case 30: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.BITAND, yytext());
          }
        case 215: break;
        case 31: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.BITOR, yytext());
          }
        case 216: break;
        case 32: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.XOR, yytext());
          }
        case 217: break;
        case 33: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.MODULO, yytext());
          }
        case 218: break;
        case 34: 
          { string.append(yytext());
          }
        case 219: break;
        case 35: 
          { yybegin(YYINITIAL); yyline++;
          }
        case 220: break;
        case 36: 
          { yybegin(YYINITIAL);
                                     // length also includes the trailing quote
                                     String tos = string.toString();
                                     string.setLength(0);
                                     return new ParsedSymbol(SymbolGroup.STRING, SymbolType.STRING, tos);
          }
        case 221: break;
        case 37: 
          { yybegin(YYINITIAL);  yyline++;
          }
        case 222: break;
        case 38: 
          { yybegin(YYINITIAL);
                                     // length also includes the trailing quote
                                     return new ParsedSymbol(SymbolGroup.STRING, SymbolType.STRING, string.toString());
          }
        case 223: break;
        case 39: 
          { string.append(yytext());  yyline++;
          }
        case 224: break;
        case 40: 
          { yybegin(XML);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_STARTTAG_END, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 225: break;
        case 41: 
          { yybegin(YYINITIAL);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_ATTRNAMEVAR_BEGIN, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 226: break;
        case 42: 
          { yybegin(XML);
                                    pushback(new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.GREATER_THAN, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 227: break;
        case 43: 
          { yybegin(YYINITIAL);
                                      return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_ATTRVALVAR_BEGIN, yytext());
          }
        case 228: break;
        case 44: 
          { string.append(yytext()); yyline++;
          }
        case 229: break;
        case 45: 
          { yybegin(YYINITIAL);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_VAR_BEGIN, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 230: break;
        case 46: 
          { for(int r=0;r<repeatNum;r++) string.append(yytext()); repeatNum = 1;
          }
        case 231: break;
        case 47: 
          { yybegin(YYINITIAL);
                                     repeatNum = 1;
                                     // length also includes the trailing quote
                                     return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.IDENTIFIER, string.toString());
          }
        case 232: break;
        case 48: 
          { yyline += count(yytext(),"\n");
          }
        case 233: break;
        case 49: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_DIVIDE, yytext());
          }
        case 234: break;
        case 50: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_MULTIPLY, yytext());
          }
        case 235: break;
        case 51: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.DESCENDANTS, yytext());
          }
        case 236: break;
        case 52: 
          { return new ParsedSymbol(SymbolGroup.TYPENAME, SymbolType.TYPENAME, yytext());
          }
        case 237: break;
        case 53: 
          { String dval = yytext();
                                    if (dval.endsWith("m")) {
                                        dval = dval.substring(0, dval.length() - 1);
                                        return new ParsedSymbol(SymbolGroup.DECIMAL, SymbolType.DECIMAL, new Decimal128(dval));
                                    }
                                    if (dval.endsWith("f")) {
                                        dval = dval.substring(0, dval.length() - 1);
                                        return new ParsedSymbol(SymbolGroup.FLOAT, SymbolType.FLOAT, Float.parseFloat(dval));
                                    }
                                    if (dval.endsWith("d")) {
                                        dval = dval.substring(0, dval.length() - 1);
                                    }
                                    return new ParsedSymbol(SymbolGroup.DOUBLE, SymbolType.DOUBLE, Double.parseDouble(dval));
          }
        case 238: break;
        case 54: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.FILTER, yytext());
          }
        case 239: break;
        case 55: 
          { yybegin(XMLOPENTAG);
                                    string.setLength(0);
                                    return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_STARTTAG_BEGIN, yytext());
          }
        case 240: break;
        case 56: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.SHIFT_LEFT, yytext());
          }
        case 241: break;
        case 57: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.LOWER_EQUAL, yytext());
          }
        case 242: break;
        case 58: 
          { return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_STARTVARTAG_BEGIN, yytext());
          }
        case 243: break;
        case 59: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.NOT_EQUAL, yytext());
          }
        case 244: break;
        case 60: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.DECREMENT, yytext());
          }
        case 245: break;
        case 61: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_MINUS, yytext());
          }
        case 246: break;
        case 62: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.SHIFT_RIGHT, yytext());
          }
        case 247: break;
        case 63: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.GREATER_EQUAL, yytext());
          }
        case 248: break;
        case 64: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.NAMESPACE_OP, yytext());
          }
        case 249: break;
        case 65: 
          { String fval = yytext();
                                    if (fval.endsWith("f")) {
                                        fval = fval.substring(0, fval.length() - 1);
                                    }
                                    return new ParsedSymbol(SymbolGroup.FLOAT, SymbolType.FLOAT, Float.parseFloat(fval));
          }
        case 250: break;
        case 66: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.NULL_DOT, yytext());
          }
        case 251: break;
        case 67: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.NULL_COALESCE, yytext());
          }
        case 252: break;
        case 68: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.EQUALS, yytext());
          }
        case 253: break;
        case 69: 
          { try {
                                        return new ParsedSymbol(SymbolGroup.INTEGER, SymbolType.INTEGER, Integer.parseInt(yytext(), 8));
                                   } catch (NumberFormatException nfe) {
                                        //its too long for an Integer var
                                        return new ParsedSymbol(SymbolGroup.DOUBLE, SymbolType.DOUBLE, new BigInteger(yytext(), 8).doubleValue()); 
                                   }
          }
        case 254: break;
        case 70: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.DO, yytext());
          }
        case 255: break;
        case 71: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.AS, yytext());
          }
        case 256: break;
        case 72: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_PLUS, yytext());
          }
        case 257: break;
        case 73: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.INCREMENT, yytext());
          }
        case 258: break;
        case 74: 
          { return new ParsedSymbol(SymbolGroup.NAMESPACESUFFIX, SymbolType.NAMESPACESUFFIX, Integer.parseInt(yytext().substring(1)));
          }
        case 259: break;
        case 75: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.IF, yytext());
          }
        case 260: break;
        case 76: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.IS, yytext());
          }
        case 261: break;
        case 77: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.IN, yytext());
          }
        case 262: break;
        case 78: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_BITAND, yytext());
          }
        case 263: break;
        case 79: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.AND, yytext());
          }
        case 264: break;
        case 80: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_BITOR, yytext());
          }
        case 265: break;
        case 81: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.OR, yytext());
          }
        case 266: break;
        case 82: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_XOR, yytext());
          }
        case 267: break;
        case 83: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_MODULO, yytext());
          }
        case 268: break;
        case 84: 
          { /* ignore illegal character escape */
          }
        case 269: break;
        case 85: 
          { string.append('\"');
          }
        case 270: break;
        case 86: 
          { string.append('\'');
          }
        case 271: break;
        case 87: 
          { string.append('\f');
          }
        case 272: break;
        case 88: 
          { string.append('\t');
          }
        case 273: break;
        case 89: 
          { string.append('\\');
          }
        case 274: break;
        case 90: 
          { string.append('\b');
          }
        case 275: break;
        case 91: 
          { string.append('\r');
          }
        case 276: break;
        case 92: 
          { string.append('\n');
          }
        case 277: break;
        case 93: 
          { yybegin(XML);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_STARTFINISHTAG_END, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 278: break;
        case 94: 
          { yybegin(XMLOPENTAGATTRIB);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_ATTRIBUTENAME, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 279: break;
        case 95: 
          { yybegin(XMLOPENTAG);
                                        return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_ATTRIBUTEVALUE, yytext());
          }
        case 280: break;
        case 96: 
          { yybegin(XMLOPENTAG);
                                        return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_ATTRIBUTEVALUE_SINGLEQUOTED, yytext());
          }
        case 281: break;
        case 97: 
          { yybegin(XML);
                                    string.append(yytext());
                                    String tos = string.toString();
                                    string.setLength(0);
                                    return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_INSTR, tos);
          }
        case 282: break;
        case 98: 
          { yybegin(XMLOPENTAG);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_STARTTAG_BEGIN, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 283: break;
        case 99: 
          { yybegin(YYINITIAL);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_STARTVARTAG_BEGIN, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 284: break;
        case 100: 
          { throw new AVM2ParseException("Illegal escape sequence \"" + yytext() + "\"", yyline + 1);
          }
        case 285: break;
        case 101: 
          { for(int r=0;r<repeatNum;r++) string.append('\f'); repeatNum = 1;
          }
        case 286: break;
        case 102: 
          { for(int r=0;r<repeatNum;r++) string.append('\t'); repeatNum = 1;
          }
        case 287: break;
        case 103: 
          { for(int r=0;r<repeatNum;r++) string.append('\\'); repeatNum = 1;
          }
        case 288: break;
        case 104: 
          { for(int r=0;r<repeatNum;r++) string.append('\u00A7'); repeatNum = 1;
          }
        case 289: break;
        case 105: 
          { for(int r=0;r<repeatNum;r++) string.append('\b'); repeatNum = 1;
          }
        case 290: break;
        case 106: 
          { for(int r=0;r<repeatNum;r++) string.append('\r'); repeatNum = 1;
          }
        case 291: break;
        case 107: 
          { for(int r=0;r<repeatNum;r++) string.append('\n'); repeatNum = 1;
          }
        case 292: break;
        case 108: 
          { return new ParsedSymbol(SymbolGroup.REGEXP, SymbolType.REGEXP, yytext());
          }
        case 293: break;
        case 109: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.REST, yytext());
          }
        case 294: break;
        case 110: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_SHIFT_LEFT, yytext());
          }
        case 295: break;
        case 111: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.STRICT_NOT_EQUAL, yytext());
          }
        case 296: break;
        case 112: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.USHIFT_RIGHT, yytext());
          }
        case 297: break;
        case 113: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_SHIFT_RIGHT, yytext());
          }
        case 298: break;
        case 114: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.STRICT_EQUALS, yytext());
          }
        case 299: break;
        case 115: 
          { try {
                                        return new ParsedSymbol(SymbolGroup.INTEGER, SymbolType.INTEGER, Integer.parseInt(yytext().substring(2), 16));
                                    } catch (NumberFormatException nfe) {
                                        //its too long for an Integer var
                                        return new ParsedSymbol(SymbolGroup.DOUBLE, SymbolType.DOUBLE, new BigInteger(yytext().substring(2), 16).doubleValue()); 
                                    }
          }
        case 300: break;
        case 116: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.USE, yytext());
          }
        case 301: break;
        case 117: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.FOR, yytext());
          }
        case 302: break;
        case 118: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.TRY, yytext());
          }
        case 303: break;
        case 119: 
          { return new ParsedSymbol(SymbolGroup.PREPROCESSOR, SymbolType.PREPROCESSOR, yytext().substring(2));
          }
        case 304: break;
        case 120: 
          { String verbatimString = yytext();
                                    verbatimString = verbatimString.substring(2, verbatimString.length() - 1);
                                    return new ParsedSymbol(SymbolGroup.STRING, SymbolType.STRING, verbatimString);
          }
        case 305: break;
        case 121: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.SET, yytext());
          }
        case 306: break;
        case 122: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.NEW, yytext());
          }
        case 307: break;
        case 123: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.VAR, yytext());
          }
        case 308: break;
        case 124: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.GET, yytext());
          }
        case 309: break;
        case 125: 
          { return new ParsedSymbol(SymbolGroup.GLOBALCONST, SymbolType.NAN, yytext());
          }
        case 310: break;
        case 126: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_AND, yytext());
          }
        case 311: break;
        case 127: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_OR, yytext());
          }
        case 312: break;
        case 128: 
          { string.append(yytext());
                                     yybegin(XML);
                                     String ret = string.toString();
                                     string.setLength(0);
                                     return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_CDATA, ret);
          }
        case 313: break;
        case 129: 
          { string.append(yytext());
                                     yybegin(XML);
                                     String ret = string.toString();
                                     string.setLength(0);
                                     return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_COMMENT, ret);
          }
        case 314: break;
        case 130: 
          { yybegin(YYINITIAL);
                                    pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_FINISHVARTAG_BEGIN, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 315: break;
        case 131: 
          { yybegin(XMLINSTR);
                                    if (string.length() > 0){
                                       String tos = string.toString(); 
                                       string.setLength(0);
                                       string.append(yytext());
                                       return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, tos);                                       
                                    }
                                    string.append(yytext());
          }
        case 316: break;
        case 132: 
          { string.append(yytext());
                                     yybegin(YYINITIAL);
                                     String ret = string.toString();
                                     string.setLength(0);
                                     return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_CDATA, ret);
          }
        case 317: break;
        case 133: 
          { string.append(yytext());
                                     yybegin(YYINITIAL);
                                     String ret = string.toString();
                                     string.setLength(0);
                                     return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_COMMENT, ret);
          }
        case 318: break;
        case 134: 
          { string.setLength(0); string.append(yytext() ); yybegin(XMLCOMMENTALONE);
          }
        case 319: break;
        case 135: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.ASSIGN_USHIFT_RIGHT, yytext());
          }
        case 320: break;
        case 136: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.CASE, yytext());
          }
        case 321: break;
        case 137: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.TRUE, yytext());
          }
        case 322: break;
        case 138: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.THIS, yytext());
          }
        case 323: break;
        case 139: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.ELSE, yytext());
          }
        case 324: break;
        case 140: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.EACH, yytext());
          }
        case 325: break;
        case 141: 
          { return new ParsedSymbol(SymbolGroup.GLOBALCONST, SymbolType.NULL, yytext());
          }
        case 326: break;
        case 142: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.WITH, yytext());
          }
        case 327: break;
        case 143: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.VOID, yytext());
          }
        case 328: break;
        case 144: 
          { char val = (char) Integer.parseInt(yytext().substring(2), 16);
                        				   string.append(val);
          }
        case 329: break;
        case 145: 
          { pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_FINISHTAG, yytext()));
                                    if (string.length() > 0){
                                       pushback(new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, string.toString()));
                                       string.setLength(0);
                                    }
                                    return lex();
          }
        case 330: break;
        case 146: 
          { String ret = string.toString(); string.setLength(0); string.append(yytext()); yybegin(XMLCOMMENT);
                                     if (!ret.isEmpty()) return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, ret);
          }
        case 331: break;
        case 147: 
          { char val = (char) Integer.parseInt(yytext().substring(2), 16);
                        				   for(int r=0;r<repeatNum;r++) string.append(val); repeatNum = 1;
          }
        case 332: break;
        case 148: 
          { repeatNum = Integer.parseInt(yytext().substring(2, yytext().length()-1));
          }
        case 333: break;
        case 149: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.CLASS, yytext());
          }
        case 334: break;
        case 150: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.CONST, yytext());
          }
        case 335: break;
        case 151: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.CATCH, yytext());
          }
        case 336: break;
        case 152: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.FALSE, yytext());
          }
        case 337: break;
        case 153: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.FINAL, yytext());
          }
        case 338: break;
        case 154: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.THROW, yytext());
          }
        case 339: break;
        case 155: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.BREAK, yytext());
          }
        case 340: break;
        case 156: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.SUPER, yytext());
          }
        case 341: break;
        case 157: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.WHILE, yytext());
          }
        case 342: break;
        case 158: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.DELETE, yytext());
          }
        case 343: break;
        case 159: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.TYPEOF, yytext());
          }
        case 344: break;
        case 160: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.RETURN, yytext());
          }
        case 345: break;
        case 161: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.STATIC, yytext());
          }
        case 346: break;
        case 162: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.SWITCH, yytext());
          }
        case 347: break;
        case 163: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.NATIVE, yytext());
          }
        case 348: break;
        case 164: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.IMPORT, yytext());
          }
        case 349: break;
        case 165: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.PUBLIC, yytext());
          }
        case 350: break;
        case 166: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.DEFAULT, yytext());
          }
        case 351: break;
        case 167: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.DYNAMIC, yytext());
          }
        case 352: break;
        case 168: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.FINALLY, yytext());
          }
        case 353: break;
        case 169: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.EXTENDS, yytext());
          }
        case 354: break;
        case 170: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.PACKAGE, yytext());
          }
        case 355: break;
        case 171: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.PRIVATE, yytext());
          }
        case 356: break;
        case 172: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.CONTINUE, yytext());
          }
        case 357: break;
        case 173: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.FUNCTION, yytext());
          }
        case 358: break;
        case 174: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.OVERRIDE, yytext());
          }
        case 359: break;
        case 175: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.INTERNAL, yytext());
          }
        case 360: break;
        case 176: 
          { return new ParsedSymbol(SymbolGroup.GLOBALCONST, SymbolType.INFINITY, yytext());
          }
        case 361: break;
        case 177: 
          { string.setLength(0); string.append(yytext() ); yybegin(XMLCDATAALONE);
          }
        case 362: break;
        case 178: 
          { return new ParsedSymbol(SymbolGroup.GLOBALCONST, SymbolType.UNDEFINED, yytext());
          }
        case 363: break;
        case 179: 
          { return new ParsedSymbol(SymbolGroup.IDENTIFIER, SymbolType.NAMESPACE, yytext());
          }
        case 364: break;
        case 180: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.INTERFACE, yytext());
          }
        case 365: break;
        case 181: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.PROTECTED, yytext());
          }
        case 366: break;
        case 182: 
          { String ret = string.toString(); string.setLength(0); string.append(yytext() ); yybegin(XMLCDATA);
                                    if (!ret.isEmpty()) return new ParsedSymbol(SymbolGroup.XML, SymbolType.XML_TEXT, ret);
          }
        case 367: break;
        case 183: 
          { return new ParsedSymbol(SymbolGroup.KEYWORD, SymbolType.IMPLEMENTS, yytext());
          }
        case 368: break;
        case 184: 
          { return new ParsedSymbol(SymbolGroup.OPERATOR, SymbolType.INSTANCEOF, yytext());
          }
        case 369: break;
        case 185: 
          { Matcher f4Matcher = float4Pattern.matcher(yytext());
                                    f4Matcher.matches();
                                    float[] fvalues = new float[4];
                                    for (int i = 0; i < 4; i++) {
                                        String fval = f4Matcher.group("f" + (i + 1));
                                        if (fval.endsWith("f")) {
                                            fval = fval.substring(0, fval.length() - 1);
                                        }
                                        fvalues[i] = Float.parseFloat(fval);
                                    }
                                    return new ParsedSymbol(SymbolGroup.FLOAT4, SymbolType.FLOAT4, new Float4(fvalues));
          }
        case 370: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return new ParsedSymbol(SymbolGroup.EOF, SymbolType.EOF, null);
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
