/*
 *  Copyright (C) 2010-2024 JPEXS, All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3.0 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.clauses;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;

/**
 * Filter operation.
 *
 * @author JPEXS
 */
public class FilterAVM2Item extends AVM2Item {

    /**
     * Expression
     */
    public GraphTargetItem expression;

    /**
     * Collection
     */
    public GraphTargetItem collection;

    /**
     * Constructor.
     *
     * @param instruction Instruction
     * @param lineStartIns Line start instruction
     * @param collection Collection
     * @param expression Expression
     */
    public FilterAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem collection, GraphTargetItem expression) {
        super(instruction, lineStartIns, NOPRECEDENCE);
        this.expression = expression;
        this.collection = collection;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(expression);
        visitor.visit(collection);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        collection.toString(writer, localData);
        writer.append(".(");
        expression.toStringBoolean(writer, localData);
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}
