/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import java.util.Map;

public class GlyphRenumberer {
    public static ReadableFontData renumberGlyph(ReadableFontData readableFontData, Map<Integer, Integer> map) {
        return GlyphRenumberer.isCompositeGlyph(readableFontData) ? GlyphRenumberer.renumberCompositeGlyph(readableFontData, map) : readableFontData;
    }

    private static boolean isCompositeGlyph(ReadableFontData readableFontData) {
        return readableFontData.length() > 0 && readableFontData.readShort(Offset.numberOfContours.offset) < 0;
    }

    private static ReadableFontData renumberCompositeGlyph(ReadableFontData readableFontData, Map<Integer, Integer> map) {
        WritableFontData writableFontData = WritableFontData.createWritableFontData(readableFontData.length());
        readableFontData.copyTo(writableFontData);
        int n = 32;
        int n2 = Offset.headerEnd.offset;
        while ((n & 0x20) != 0) {
            n = readableFontData.readUShort(n2 + Offset.compositeFlags.offset);
            int n3 = readableFontData.readUShort(n2 + Offset.compositeGlyphIndex.offset);
            int n4 = map.get(n3);
            writableFontData.writeUShort(n2 + Offset.compositeGlyphIndex.offset, n4);
            n2 += GlyphRenumberer.compositeReferenceSize(n);
        }
        return writableFontData;
    }

    private static int compositeReferenceSize(int n) {
        int n2 = 6;
        if ((n & 1) != 0) {
            n2 += 2;
        }
        if ((n & 8) != 0) {
            n2 += 2;
        } else if ((n & 0x40) != 0) {
            n2 += 4;
        } else if ((n & 0x80) != 0) {
            n2 += 8;
        }
        return n2;
    }

    private static enum Offset {
        numberOfContours(0),
        headerEnd(10),
        compositeFlags(0),
        compositeGlyphIndex(2);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

