/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import com.google.typography.font.sfntly.math.FontMath;
import java.util.ArrayList;
import java.util.List;

final class SegmentedGrowableMemoryByteArray
extends ByteArray<SegmentedGrowableMemoryByteArray> {
    private static final int DEFAULT_BUFFER_LOW_BITS = 8;
    private List<byte[]> buffers = new ArrayList<byte[]>();
    private final int lowBits;

    public SegmentedGrowableMemoryByteArray() {
        this(8);
    }

    public SegmentedGrowableMemoryByteArray(int n) {
        super(0, Integer.MAX_VALUE, true);
        this.lowBits = n;
    }

    @Override
    protected void internalPut(int n, byte by) {
        int n2 = this.bufferIndex(n);
        int n3 = this.bufferOffset(n2, n);
        byte[] byArray = this.buffer(n2);
        byArray[n3] = by;
    }

    @Override
    protected int internalPut(int n, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        for (n4 = 0; n4 < n3; n4 += n5) {
            int n6 = this.bufferIndex(n);
            int n7 = this.bufferOffset(n6, n);
            byte[] byArray2 = this.buffer(n6);
            n5 = Math.min(n3 - n4, byArray2.length - n7);
            System.arraycopy(byArray, n2, byArray2, n7, n5);
            n += n5;
            n2 += n5;
        }
        return n4;
    }

    @Override
    protected int internalGet(int n) {
        int n2 = this.bufferIndex(n);
        int n3 = this.bufferOffset(n2, n);
        byte[] byArray = this.buffer(n2);
        return byArray[n3];
    }

    @Override
    protected int internalGet(int n, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        for (n4 = 0; n4 < n3; n4 += n5) {
            int n6 = this.bufferIndex(n);
            int n7 = this.bufferOffset(n6, n);
            byte[] byArray2 = this.buffer(n6);
            n5 = Math.min(n3 - n4, byArray2.length - n7);
            System.arraycopy(byArray2, n7, byArray, n2, n5);
            n += n5;
            n2 += n5;
        }
        return n4;
    }

    @Override
    public void close() {
        this.buffers = null;
    }

    private int bufferOffset(int n, int n2) {
        return n2 & ~(1 << Math.max(this.lowBits, n + this.lowBits - 1));
    }

    private int bufferIndex(int n) {
        return FontMath.log2(n >> this.lowBits) + 1;
    }

    private byte[] buffer(int n) {
        byte[] byArray = null;
        if (n >= this.buffers.size()) {
            for (int i = this.buffers.size(); i < n + 1; ++i) {
                int n2 = 1 << Math.max(0, i - 1) + this.lowBits;
                byArray = new byte[n2];
                this.buffers.add(byArray);
            }
        }
        byArray = this.buffers.get(n);
        return byArray;
    }
}

