/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class KeyTipManager {
    boolean isShowingKeyTips = false;
    List<KeyTipChain> keyTipChains = new ArrayList<KeyTipChain>();
    protected EventListenerList listenerList = new EventListenerList();
    protected BlockingQueue<Character> processingQueue = new LinkedBlockingQueue<Character>();
    protected ProcessingThread processingThread = new ProcessingThread();
    private JRibbonFrame rootOwner;
    private Component focusOwner;
    private static final KeyTipManager instance = new KeyTipManager();

    public static KeyTipManager defaultManager() {
        return instance;
    }

    private KeyTipManager() {
        this.processingThread.start();
    }

    public boolean isShowingKeyTips() {
        return !this.keyTipChains.isEmpty();
    }

    public void hideAllKeyTips() {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        this.keyTipChains.clear();
        this.fireKeyTipsHidden(this.rootOwner);
        this.repaintWindows();
        this.tryRestoringFocusOwner();
    }

    private void tryRestoringFocusOwner() {
        if (this.focusOwner != null && this.focusOwner.isDisplayable() && this.focusOwner.isShowing()) {
            this.focusOwner.requestFocus();
        }
    }

    public void showRootKeyTipChain(JRibbonFrame ribbonFrame) {
        if (!this.keyTipChains.isEmpty()) {
            throw new IllegalStateException("Can't call this method when key tip chains are present");
        }
        this.focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        ribbonFrame.requestFocus();
        this.rootOwner = ribbonFrame;
        JRibbon ribbon = ribbonFrame.getRibbon();
        KeyTipChain root = new KeyTipChain(ribbon);
        final JRibbonApplicationMenuButton appMenuButton = FlamingoUtilities.getApplicationMenuButton(ribbonFrame);
        if (appMenuButton != null && ribbon.getApplicationMenuKeyTip() != null) {
            final KeyTipLink appMenuButtonLink = new KeyTipLink();
            appMenuButtonLink.comp = appMenuButton;
            appMenuButtonLink.keyTipString = ribbon.getApplicationMenuKeyTip();
            appMenuButtonLink.prefAnchorPoint = appMenuButton.getUI().getKeyTipAnchorCenterPoint();
            appMenuButtonLink.onActivated = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    appMenuButton.doPopupClick();
                }
            };
            appMenuButtonLink.enabled = true;
            appMenuButtonLink.traversal = new KeyTipLinkTraversal(){

                @Override
                public KeyTipChain getNextChain() {
                    PopupPanelManager.PopupInfo last;
                    List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                    if (popups.size() > 0 && (last = popups.get(popups.size() - 1)).getPopupOriginator() == appMenuButton) {
                        JPopupPanel popupPanel = last.getPopupPanel();
                        KeyTipChain chain = new KeyTipChain(popupPanel);
                        chain.parent = appMenuButtonLink.traversal;
                        KeyTipManager.this.populateChain(last.getPopupPanel(), chain);
                        return chain;
                    }
                    return null;
                }
            };
            root.addLink(appMenuButtonLink);
        }
        for (Component taskbarComp : ribbon.getTaskbarComponents()) {
            JCommandButton jcb;
            KeyTipLink popupLink;
            if (!(taskbarComp instanceof AbstractCommandButton)) continue;
            AbstractCommandButton cb = (AbstractCommandButton)taskbarComp;
            KeyTipLink actionLink = this.getCommandButtonActionLink(cb);
            if (actionLink != null) {
                root.addLink(actionLink);
            }
            if (!(taskbarComp instanceof JCommandButton) || (popupLink = this.getCommandButtonPopupLink(jcb = (JCommandButton)taskbarComp)) == null) continue;
            root.addLink(popupLink);
        }
        RibbonUI ui = ribbon.getUI();
        if (ui instanceof BasicRibbonUI) {
            for (Map.Entry<RibbonTask, JRibbonTaskToggleButton> ttbEntry : ((BasicRibbonUI)ui).getTaskToggleButtons().entrySet()) {
                final RibbonTask task = ttbEntry.getKey();
                final JRibbonTaskToggleButton taskToggleButton = ttbEntry.getValue();
                String keyTip = task.getKeyTip();
                if (keyTip == null) continue;
                final KeyTipLink taskToggleButtonLink = new KeyTipLink();
                taskToggleButtonLink.comp = taskToggleButton;
                taskToggleButtonLink.keyTipString = keyTip;
                taskToggleButtonLink.prefAnchorPoint = new Point(taskToggleButton.getWidth() / 2, taskToggleButton.getHeight());
                taskToggleButtonLink.onActivated = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        taskToggleButton.doActionClick();
                    }
                };
                taskToggleButtonLink.enabled = true;
                taskToggleButtonLink.traversal = new KeyTipLinkTraversal(){

                    @Override
                    public KeyTipChain getNextChain() {
                        KeyTipChain taskChain = new KeyTipChain(taskToggleButton);
                        for (AbstractRibbonBand<?> band : task.getBands()) {
                            KeyTipManager.this.populateChain(band, taskChain);
                        }
                        taskChain.parent = taskToggleButtonLink.traversal;
                        return taskChain;
                    }
                };
                root.addLink(taskToggleButtonLink);
            }
        }
        this.keyTipChains.add(root);
        this.fireKeyTipsShown(ribbonFrame);
        ribbonFrame.repaint();
    }

    public Collection<KeyTipLink> getCurrentlyShownKeyTips() {
        if (this.keyTipChains.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.keyTipChains.get(this.keyTipChains.size() - 1).links);
    }

    public KeyTipChain getCurrentlyShownKeyTipChain() {
        if (this.keyTipChains.isEmpty()) {
            return null;
        }
        return this.keyTipChains.get(this.keyTipChains.size() - 1);
    }

    public void showPreviousChain() {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        this.keyTipChains.remove(this.keyTipChains.size() - 1);
        if (!this.isShowingKeyTips()) {
            this.tryRestoringFocusOwner();
        }
        this.repaintWindows();
    }

    private void addCommandButtonLinks(Component c, KeyTipChain chain) {
        JCommandButton jcb;
        KeyTipLink popupLink;
        AbstractCommandButton cb = (AbstractCommandButton)c;
        KeyTipLink actionLink = this.getCommandButtonActionLink(cb);
        if (actionLink != null) {
            chain.addLink(actionLink);
        }
        if (c instanceof JCommandButton && (popupLink = this.getCommandButtonPopupLink(jcb = (JCommandButton)c)) != null) {
            chain.addLink(popupLink);
        }
    }

    private void populateChain(final Component c, final KeyTipChain chain) {
        JRibbonComponent rc;
        KeyTipLink link;
        if (c instanceof AbstractCommandButton) {
            Rectangle compBounds = c.getBounds();
            if (c.isVisible() && c.isShowing()) {
                if (compBounds.height > 0 && compBounds.width > 0) {
                    this.addCommandButtonLinks(c, chain);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Rectangle compBounds = c.getBounds();
                            if (compBounds.height > 0 && compBounds.width > 0) {
                                KeyTipManager.this.addCommandButtonLinks(c, chain);
                            }
                        }
                    });
                }
            }
        }
        if (c instanceof JRibbonComponent && (link = this.getRibbonComponentLink(rc = (JRibbonComponent)c)) != null) {
            chain.addLink(link);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.populateChain(cont.getComponent(i), chain);
            }
        }
    }

    private KeyTipLink getCommandButtonActionLink(final AbstractCommandButton cb) {
        if (cb.getActionKeyTip() != null) {
            final KeyTipLink link = new KeyTipLink();
            link.comp = cb;
            link.keyTipString = cb.getActionKeyTip();
            link.prefAnchorPoint = cb.getUI().getKeyTipAnchorCenterPoint();
            link.onActivated = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cb.doActionClick();
                }
            };
            link.enabled = cb.getActionModel().isEnabled();
            link.traversal = cb.getClass().isAnnotationPresent(HasNextKeyTipChain.class) ? new KeyTipLinkTraversal(){

                @Override
                public KeyTipChain getNextChain() {
                    List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                    if (popups.size() > 0) {
                        PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
                        JPopupPanel popupPanel = last.getPopupPanel();
                        KeyTipChain chain = new KeyTipChain(popupPanel);
                        KeyTipManager.this.populateChain(last.getPopupPanel(), chain);
                        chain.parent = link.traversal;
                        return chain;
                    }
                    return null;
                }
            } : null;
            return link;
        }
        return null;
    }

    private KeyTipLink getRibbonComponentLink(final JRibbonComponent rc) {
        if (rc.getKeyTip() != null) {
            KeyTipLink link = new KeyTipLink();
            link.comp = rc;
            link.keyTipString = rc.getKeyTip();
            link.prefAnchorPoint = rc.getUI().getKeyTipAnchorCenterPoint();
            link.onActivated = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComponent mainComponent = rc.getMainComponent();
                    if (mainComponent instanceof AbstractButton) {
                        ((AbstractButton)mainComponent).doClick();
                    } else if (mainComponent instanceof JComboBox) {
                        ((JComboBox)mainComponent).showPopup();
                    } else if (mainComponent instanceof JSpinner) {
                        JComponent editor = ((JSpinner)mainComponent).getEditor();
                        editor.requestFocusInWindow();
                    } else {
                        mainComponent.requestFocusInWindow();
                    }
                }
            };
            link.enabled = rc.getMainComponent().isEnabled();
            link.traversal = null;
            return link;
        }
        return null;
    }

    private KeyTipLink getCommandButtonPopupLink(final JCommandButton cb) {
        if (cb.getPopupKeyTip() != null) {
            final KeyTipLink link = new KeyTipLink();
            link.comp = cb;
            link.keyTipString = cb.getPopupKeyTip();
            link.prefAnchorPoint = cb.getUI().getKeyTipAnchorCenterPoint();
            link.onActivated = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (cb instanceof JCommandMenuButton) {
                        ((JCommandMenuButton)cb).doActionRollover();
                    }
                    cb.doPopupClick();
                }
            };
            link.enabled = cb.getPopupModel().isEnabled();
            link.traversal = new KeyTipLinkTraversal(){

                @Override
                public KeyTipChain getNextChain() {
                    List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                    if (popups.size() > 0) {
                        PopupPanelManager.PopupInfo last = popups.get(popups.size() - 1);
                        JPopupPanel popupPanel = last.getPopupPanel();
                        if (popupPanel instanceof JRibbonApplicationMenuPopupPanel) {
                            JRibbonApplicationMenuPopupPanel appMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)popupPanel;
                            JPanel level1 = appMenuPopupPanel.getPanelLevel1();
                            JPanel level2 = appMenuPopupPanel.getPanelLevel2();
                            if (level2.getComponentCount() > 0) {
                                KeyTipChain chain = new KeyTipChain(level2);
                                KeyTipManager.this.populateChain(level2, chain);
                                chain.parent = link.traversal;
                                return chain;
                            }
                            KeyTipChain chain = new KeyTipChain(level1);
                            KeyTipManager.this.populateChain(level1, chain);
                            chain.parent = link.traversal;
                            return chain;
                        }
                        KeyTipChain chain = new KeyTipChain(popupPanel);
                        KeyTipManager.this.populateChain(last.getPopupPanel(), chain);
                        chain.parent = link.traversal;
                        return chain;
                    }
                    return null;
                }
            };
            return link;
        }
        return null;
    }

    public void handleKeyPress(char keyChar) {
        this.processingQueue.add(Character.valueOf(keyChar));
    }

    private void processNextKeyPress(char keyChar) {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        KeyTipChain currChain = this.keyTipChains.get(this.keyTipChains.size() - 1);
        for (final KeyTipLink link : currChain.links) {
            String keyTipString = link.keyTipString;
            if (Character.toLowerCase(keyTipString.charAt(currChain.keyTipLookupIndex)) != Character.toLowerCase(keyChar) || keyTipString.length() != currChain.keyTipLookupIndex + 1) continue;
            if (link.enabled) {
                link.onActivated.actionPerformed(new ActionEvent(link.comp, 1001, "keyTipActivated"));
                if (link.traversal != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeyTipChain next = link.traversal.getNextChain();
                            if (next != null) {
                                KeyTipChain prev = KeyTipManager.this.keyTipChains.isEmpty() ? null : KeyTipManager.this.keyTipChains.get(KeyTipManager.this.keyTipChains.size() - 1);
                                KeyTipManager.this.keyTipChains.add(next);
                                KeyTipManager.this.repaintWindows();
                                if (prev != null) {
                                    for (KeyTipLink link2 : prev.links) {
                                        if (!(link2.comp instanceof JCommandMenuButton)) continue;
                                        link2.comp.repaint();
                                    }
                                }
                            }
                        }
                    });
                } else {
                    this.hideAllKeyTips();
                }
            }
            return;
        }
        if (currChain.keyTipLookupIndex == 0) {
            KeyTipChain secondary = new KeyTipChain(currChain.chainParentComponent);
            secondary.keyTipLookupIndex = 1;
            for (KeyTipLink link : currChain.links) {
                String keyTipString = link.keyTipString;
                if (Character.toLowerCase(keyTipString.charAt(currChain.keyTipLookupIndex)) != Character.toLowerCase(keyChar) || keyTipString.length() != 2) continue;
                KeyTipLink secondaryLink = new KeyTipLink();
                secondaryLink.comp = link.comp;
                secondaryLink.enabled = link.enabled;
                secondaryLink.keyTipString = link.keyTipString;
                secondaryLink.onActivated = link.onActivated;
                secondaryLink.prefAnchorPoint = link.prefAnchorPoint;
                secondaryLink.traversal = link.traversal;
                secondary.addLink(secondaryLink);
            }
            if (secondary.links.size() > 0) {
                this.keyTipChains.add(secondary);
            }
            this.repaintWindows();
            return;
        }
    }

    private void repaintWindows() {
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        for (PopupPanelManager.PopupInfo popup : popups) {
            JPopupPanel popupPanel = popup.getPopupPanel();
            popupPanel.paintImmediately(new Rectangle(0, 0, popupPanel.getWidth(), popupPanel.getHeight()));
        }
    }

    public void addKeyTipListener(KeyTipListener keyTipListener) {
        this.listenerList.add(KeyTipListener.class, keyTipListener);
    }

    public void removeKeyTipListener(KeyTipListener keyTipListener) {
        this.listenerList.remove(KeyTipListener.class, keyTipListener);
    }

    protected void fireKeyTipsShown(JRibbonFrame ribbonFrame) {
        Object[] listeners = this.listenerList.getListenerList();
        KeyTipEvent e = new KeyTipEvent(ribbonFrame, 0);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KeyTipListener.class) continue;
            ((KeyTipListener)listeners[i + 1]).keyTipsShown(e);
        }
    }

    protected void fireKeyTipsHidden(JRibbonFrame ribbonFrame) {
        Object[] listeners = this.listenerList.getListenerList();
        KeyTipEvent e = new KeyTipEvent(ribbonFrame, 0);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KeyTipListener.class) continue;
            ((KeyTipListener)listeners[i + 1]).keyTipsHidden(e);
        }
    }

    public void refreshCurrentChain() {
        KeyTipChain curr = this.keyTipChains.get(this.keyTipChains.size() - 1);
        if (curr.parent == null) {
            return;
        }
        KeyTipChain refreshed = curr.parent.getNextChain();
        this.keyTipChains.remove(this.keyTipChains.size() - 1);
        this.keyTipChains.add(refreshed);
        this.repaintWindows();
    }

    public class KeyTipChain {
        private List<KeyTipLink> links;
        public int keyTipLookupIndex;
        public JComponent chainParentComponent;
        private KeyTipLinkTraversal parent;

        public KeyTipChain(JComponent chainParentComponent) {
            this.chainParentComponent = chainParentComponent;
            this.links = new ArrayList<KeyTipLink>();
            this.keyTipLookupIndex = 0;
        }

        public void addLink(KeyTipLink link) {
            this.links.add(link);
        }
    }

    private class ProcessingThread
    extends Thread {
        public ProcessingThread() {
            this.setName("KeyTipManager processing thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        final char keyChar = KeyTipManager.this.processingQueue.take().charValue();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                KeyTipManager.this.processNextKeyPress(keyChar);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class KeyTipLink {
        public String keyTipString;
        public JComponent comp;
        public Point prefAnchorPoint;
        public ActionListener onActivated;
        public KeyTipLinkTraversal traversal;
        public boolean enabled;
    }

    public static interface KeyTipLinkTraversal {
        public KeyTipChain getNextChain();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface HasNextKeyTipChain {
    }

    public static interface KeyTipListener
    extends EventListener {
        public void keyTipsShown(KeyTipEvent var1);

        public void keyTipsHidden(KeyTipEvent var1);
    }

    public static class KeyTipEvent
    extends AWTEvent {
        public KeyTipEvent(Object source, int id) {
            super(source, id);
        }
    }
}

