/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.IOException;
import org.doubletype.ossa.truetype.FontFormatWriter;
import org.doubletype.ossa.truetype.GlyfWriter;
import org.doubletype.ossa.truetype.HeadWriter;

public class HheaWriter
extends FontFormatWriter {
    private GlyfWriter m_glyf;
    private HeadWriter m_head;
    private int m_lineGap = 0;
    private int m_maxAdvanceWidth = 0;
    private int m_minRightSideBearing = 0;

    public HheaWriter(GlyfWriter a_glyf, HeadWriter a_head) {
        this.m_glyf = a_glyf;
        this.m_head = a_head;
    }

    public void setLineGap(int a_value) {
        this.m_lineGap = a_value;
    }

    public void setMaxAdvanceWidth(int a_value) {
        this.m_maxAdvanceWidth = a_value;
    }

    public void setMinRightSideBearing(int a_value) {
        this.m_minRightSideBearing = a_value;
    }

    @Override
    public void write() throws IOException {
        this.writeFixed32(1.0);
        this.writeFWord(this.m_head.getMax().y);
        this.writeFWord(this.m_head.getMin().y);
        this.writeFWord(this.m_lineGap);
        this.writeUFWord(this.m_maxAdvanceWidth);
        int minLeftSideBearing = this.m_head.getMin().x;
        this.writeFWord(minLeftSideBearing);
        this.writeFWord(this.m_minRightSideBearing);
        int xMaxExtent = this.m_head.getMax().x - this.m_head.getMin().x;
        this.writeFWord(xMaxExtent);
        this.writeInt16(1);
        this.writeInt16(0);
        for (int i = 0; i < 5; ++i) {
            this.writeInt16(0);
        }
        this.writeInt16(0);
        int numOfHMetrics = this.m_glyf.numOfGlyph();
        this.writeUInt16(numOfHMetrics);
        this.pad();
    }

    @Override
    protected String getTag() {
        return "hhea";
    }
}

