/*
 * Decompiled with CFR 0.152.
 */
package com.realityinteractive.imageio.tga;

import com.realityinteractive.imageio.tga.TGAHeader;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class TGAImageReader
extends ImageReader {
    private ImageInputStream inputStream;
    private TGAHeader header;

    public TGAImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            this.inputStream = null;
            this.header = null;
        }
        if (!(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Only ImageInputStreams are accepted.");
        }
        this.inputStream = (ImageInputStream)input;
        this.inputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    private synchronized TGAHeader getHeader() throws IOException {
        if (this.header != null) {
            return this.header;
        }
        if (this.inputStream == null) {
            throw new IllegalStateException("There is no ImageInputStream from which the header can be read.");
        }
        this.header = new TGAHeader(this.inputStream);
        return this.header;
    }

    private void checkImageIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("Image index out of bounds (" + imageIndex + " != 0).");
        }
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier;
        this.checkImageIndex(imageIndex);
        TGAHeader header = this.getHeader();
        switch (header.getImageType()) {
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                boolean hasAlpha = header.getSamplesPerPixel() == 4;
                int[] bandOffset = hasAlpha ? new int[]{2, 1, 0, 3} : new int[]{2, 1, 0};
                ColorSpace rgb = ColorSpace.getInstance(1000);
                imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(rgb, bandOffset, 0, hasAlpha, false);
                break;
            }
            case 3: 
            case 11: {
                throw new IllegalArgumentException("Monochrome image type not supported.");
            }
            default: {
                throw new IllegalArgumentException("The image type is not known.");
            }
        }
        ArrayList<ImageTypeSpecifier> imageSpecifiers = new ArrayList<ImageTypeSpecifier>();
        imageSpecifiers.add(imageTypeSpecifier);
        return imageSpecifiers.iterator();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.getHeader().getHeight();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.getHeader().getWidth();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        Iterator<ImageTypeSpecifier> imageTypes = this.getImageTypes(imageIndex);
        if (!imageTypes.hasNext()) {
            throw new IOException("Unsupported Image Type");
        }
        TGAHeader header = this.getHeader();
        this.checkImageReadParam(param, header);
        int width = header.getWidth();
        int height = header.getHeight();
        int[] colorMap = this.readColorMap(header);
        this.inputStream.seek(header.getPixelDataOffset());
        BufferedImage image = TGAImageReader.getDestination(param, imageTypes, width, height);
        WritableRaster imageRaster = image.getRaster();
        int numberOfImageBands = image.getSampleModel().getNumBands();
        TGAImageReader.checkReadParamBandSettings(param, header.getSamplesPerPixel(), numberOfImageBands);
        int[] destinationBands = param != null ? param.getDestinationBands() : null;
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int numberOfComponents = image.getColorModel().getNumComponents();
        WritableRaster raster = imageRaster.createWritableChild(0, 0, width, height, 0, 0, destinationBands);
        if (header.getBitsPerPixel() == 16 && hasAlpha) {
            throw new UnsupportedOperationException("This decoder does not support 1 bit alpha for 16 bit images.");
        }
        int bytesPerPixel = (header.getBitsPerPixel() + 7) / 8;
        byte[] resultData = ((DataBufferByte)raster.getDataBuffer()).getData();
        int index = 0;
        int runLength = 0;
        boolean readPixel = true;
        boolean isRaw = false;
        byte red = 0;
        byte green = 0;
        byte blue = 0;
        int alpha = -1;
        int minBufferSize = 24576;
        ByteBuffer inputBuffer = ByteBuffer.allocate(24576);
        inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ((Buffer)inputBuffer).limit(0);
        byte[] packedPixelbuffer = new byte[4];
        for (int y = 0; y < height; ++y) {
            index = header.isBottomToTop() ? height - y - 1 : y;
            index *= width * numberOfComponents;
            for (int x = 0; x < width; ++x) {
                if (header.isCompressed()) {
                    if (runLength > 0) {
                        --runLength;
                        readPixel = isRaw;
                    } else {
                        if (this.checkFillBuffer(this.inputStream, inputBuffer, bytesPerPixel + 1)) {
                            return image;
                        }
                        runLength = inputBuffer.get() & 0xFF;
                        boolean bl = isRaw = (runLength & 0x80) == 0;
                        if (!isRaw) {
                            runLength -= 128;
                        }
                        readPixel = true;
                    }
                }
                if (readPixel) {
                    this.checkFillBuffer(this.inputStream, inputBuffer, bytesPerPixel);
                    switch (bytesPerPixel) {
                        default: {
                            int data = inputBuffer.get() & 0xFF;
                            if (header.hasColorMap()) {
                                int packedPixel = colorMap[data];
                                red = (byte)packedPixel;
                                green = (byte)(packedPixel >>> 8);
                                blue = (byte)(packedPixel >>> 16);
                                alpha = (byte)(packedPixel >>> 24);
                                break;
                            }
                            green = blue = (byte)data;
                            red = blue;
                            break;
                        }
                        case 2: {
                            int data = inputBuffer.getShort() & 0xFFFF;
                            red = (byte)(data >>> 10 & 0x1F);
                            green = (byte)(data >>> 5 & 0x1F);
                            blue = (byte)(data & 0x1F);
                            red = (byte)((red << 3) + (red >>> 2));
                            green = (byte)((green << 3) + (green >>> 2));
                            blue = (byte)((blue << 3) + (blue >>> 2));
                            break;
                        }
                        case 3: {
                            inputBuffer.get(packedPixelbuffer, 0, 3);
                            red = packedPixelbuffer[2];
                            green = packedPixelbuffer[1];
                            blue = packedPixelbuffer[0];
                            break;
                        }
                        case 4: {
                            inputBuffer.get(packedPixelbuffer, 0, 4);
                            red = packedPixelbuffer[2];
                            green = packedPixelbuffer[1];
                            blue = packedPixelbuffer[0];
                            alpha = packedPixelbuffer[3];
                        }
                    }
                }
                resultData[index + 0] = blue;
                resultData[index + 1] = green;
                resultData[index + 2] = red;
                index += 3;
                if (!hasAlpha) continue;
                resultData[index] = alpha;
                ++index;
            }
        }
        return image;
    }

    private boolean checkFillBuffer(ImageInputStream input, ByteBuffer buffer, int minRemaining) throws IOException {
        int remaining = buffer.remaining();
        if (remaining < minRemaining) {
            int bytesLoaded;
            if (remaining != 0) {
                buffer.get(buffer.array(), 0, remaining);
                bytesLoaded = input.read(buffer.array(), remaining, buffer.capacity() - remaining);
            } else {
                bytesLoaded = input.read(buffer.array());
            }
            if (bytesLoaded == -1) {
                return true;
            }
            ((Buffer)buffer).position(0);
            ((Buffer)buffer).limit(remaining + bytesLoaded);
        }
        return false;
    }

    private int[] readColorMap(TGAHeader header) throws IOException {
        if (!header.hasColorMap()) {
            return null;
        }
        this.inputStream.seek(header.getColorMapDataOffset());
        int numberOfColors = header.getColorMapLength();
        int bitsPerEntry = header.getBitsPerColorMapEntry();
        int[] colorMap = new int[numberOfColors + 1];
        byte[] buffer = new byte[4];
        for (int i = 0; i < numberOfColors; ++i) {
            int red = 0;
            int green = 0;
            int blue = 0;
            switch (bitsPerEntry) {
                default: {
                    int data;
                    green = blue = (data = this.inputStream.readByte() & 0xFF);
                    red = blue;
                    break;
                }
                case 15: 
                case 16: {
                    int data = this.inputStream.readShort() & 0xFFFF;
                    red = (byte)(data >>> 10 & 0x1F);
                    green = (byte)(data >>> 5 & 0x1F);
                    blue = (byte)(data & 0x1F);
                    red = (byte)((red << 3) + (red >>> 2));
                    green = (byte)((green << 3) + (green >>> 2));
                    blue = (byte)((blue << 3) + (blue >>> 2));
                    break;
                }
                case 24: 
                case 32: {
                    this.inputStream.read(buffer, 0, 3);
                    blue = buffer[0] & 0xFF;
                    green = buffer[1] & 0xFF;
                    red = buffer[2] & 0xFF;
                }
            }
            colorMap[i] = red << 0 | green << 8 | blue << 16;
        }
        return colorMap;
    }

    private void checkImageReadParam(ImageReadParam param, TGAHeader header) throws IOException {
        if (param != null) {
            int width = header.getWidth();
            int height = header.getHeight();
            Rectangle sourceROI = param.getSourceRegion();
            if (sourceROI != null && (sourceROI.x != 0 || sourceROI.y != 0 || sourceROI.width != width || sourceROI.height != height)) {
                throw new IOException("The source region of interest is not the default.");
            }
            Rectangle destinationROI = param.getSourceRegion();
            if (destinationROI != null && (destinationROI.x != 0 || destinationROI.y != 0 || destinationROI.width != width || destinationROI.height != height)) {
                throw new IOException("The destination region of interest is not the default.");
            }
            if (param.getSourceXSubsampling() != 1 || param.getSourceYSubsampling() != 1) {
                throw new IOException("Source sub-sampling is not supported.");
            }
        }
    }
}

