/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import com.google.typography.font.tools.subsetter.GlyphStripper;
import com.google.typography.font.tools.subsetter.Subsetter;
import com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.io.IOException;
import java.util.List;

public class GlyphTableStripper
extends TableSubsetterImpl {
    public GlyphTableStripper() {
        super(Tag.glyf, Tag.loca);
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder builder) throws IOException {
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        if (glyphTable == null || locaTable == null) {
            throw new RuntimeException("Font to subset is not valid.");
        }
        ReadableFontData readableFontData = glyphTable.readFontData();
        GlyphTable.Builder builder2 = (GlyphTable.Builder)builder.newTableBuilder(Tag.glyf);
        LocaTable.Builder builder3 = (LocaTable.Builder)builder.newTableBuilder(Tag.loca);
        List<Glyph.Builder<? extends Glyph>> list = builder2.glyphBuilders();
        GlyphStripper glyphStripper = new GlyphStripper(builder2);
        for (int i = 0; i < locaTable.numGlyphs(); ++i) {
            int n = locaTable.glyphOffset(i);
            int n2 = locaTable.glyphLength(i);
            Glyph glyph = glyphTable.glyph(n, n2);
            list.add(glyphStripper.stripGlyph(glyph));
        }
        List<Integer> list2 = builder2.generateLocaList();
        builder3.setLocaList(list2);
        return true;
    }
}

