/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.sfnttool;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.tools.conversion.eot.EOTWriter;
import com.google.typography.font.tools.conversion.woff.WoffWriter;
import com.google.typography.font.tools.sfnttool.GlyphCoverage;
import com.google.typography.font.tools.subsetter.HintStripper;
import com.google.typography.font.tools.subsetter.RenumberingSubsetter;
import com.google.typography.font.tools.subsetter.Subsetter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SfntTool {
    private boolean strip = false;
    private String subsetString = null;
    private boolean woff = false;
    private boolean eot = false;
    private boolean mtx = false;

    public static void main(String[] stringArray) throws IOException {
        SfntTool sfntTool = new SfntTool();
        File file = null;
        File file2 = null;
        boolean bl = false;
        int n = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = null;
            if (stringArray[i].charAt(0) == '-') {
                string = stringArray[i].substring(1);
            }
            if (string != null) {
                if (string.equals("help") || string.equals("?")) {
                    SfntTool.printUsage();
                    System.exit(0);
                    continue;
                }
                if (string.equals("b") || string.equals("bench")) {
                    n = 10000;
                    continue;
                }
                if (string.equals("h") || string.equals("hints")) {
                    sfntTool.strip = true;
                    continue;
                }
                if (string.equals("s") || string.equals("string")) {
                    sfntTool.subsetString = stringArray[i + 1];
                    ++i;
                    continue;
                }
                if (string.equals("w") || string.equals("woff")) {
                    sfntTool.woff = true;
                    continue;
                }
                if (string.equals("e") || string.equals("eot")) {
                    sfntTool.eot = true;
                    continue;
                }
                if (string.equals("x") || string.equals("mtx")) {
                    sfntTool.mtx = true;
                    continue;
                }
                SfntTool.printUsage();
                System.exit(1);
                continue;
            }
            if (file == null) {
                file = new File(stringArray[i]);
                continue;
            }
            file2 = new File(stringArray[i]);
            break;
        }
        if (sfntTool.woff && sfntTool.eot) {
            System.out.println("WOFF and EOT options are mutually exclusive");
            System.exit(1);
        }
        if (file != null && file2 != null) {
            sfntTool.subsetFontFile(file, file2, n);
        } else {
            SfntTool.printUsage();
        }
    }

    private static final void printUsage() {
        System.out.println("Subset [-?|-h|-help] [-b] [-s string] fontfile outfile");
        System.out.println("Prototype font subsetter");
        System.out.println("\t-?,-help\tprint this help information");
        System.out.println("\t-s,-string\t String to subset");
        System.out.println("\t-b,-bench\t Benchmark (run 10000 iterations)");
        System.out.println("\t-h,-hints\t Strip hints");
        System.out.println("\t-w,-woff\t Output WOFF format");
        System.out.println("\t-e,-eot\t Output EOT format");
        System.out.println("\t-x,-mtx\t Enable Microtype Express compression for EOT format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subsetFontFile(File file, File file2, int n) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            Font[] fontArray = null;
            fontArray = fontFactory.loadFonts(byArray);
            Font font = fontArray[0];
            ArrayList<CMapTable.CMapId> arrayList = new ArrayList<CMapTable.CMapId>();
            arrayList.add(CMapTable.CMapId.WINDOWS_BMP);
            Object var10_10 = null;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Font font2 = font;
                if (this.subsetString != null) {
                    object2 = new RenumberingSubsetter(font2, fontFactory);
                    ((Subsetter)object2).setCMaps(arrayList, 1);
                    object = GlyphCoverage.getGlyphCoverage(font, this.subsetString);
                    ((Subsetter)object2).setGlyphs((List<Integer>)object);
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    hashSet.add(Tag.GDEF);
                    hashSet.add(Tag.GPOS);
                    hashSet.add(Tag.GSUB);
                    hashSet.add(Tag.kern);
                    hashSet.add(Tag.hdmx);
                    hashSet.add(Tag.vmtx);
                    hashSet.add(Tag.VDMX);
                    hashSet.add(Tag.LTSH);
                    hashSet.add(Tag.DSIG);
                    hashSet.add(Tag.intValue(new byte[]{109, 111, 114, 116}));
                    hashSet.add(Tag.intValue(new byte[]{109, 111, 114, 120}));
                    ((Subsetter)object2).setRemoveTables(hashSet);
                    font2 = ((Subsetter)object2).subset().build();
                }
                if (this.strip) {
                    object2 = new HintStripper(font2, fontFactory);
                    object = new HashSet<Integer>();
                    object.add(Tag.fpgm);
                    object.add(Tag.prep);
                    object.add(Tag.cvt);
                    object.add(Tag.hdmx);
                    object.add(Tag.VDMX);
                    object.add(Tag.LTSH);
                    object.add(Tag.DSIG);
                    ((Subsetter)object2).setRemoveTables((Set<Integer>)object);
                    font2 = ((Subsetter)object2).subset().build();
                }
                object2 = new FileOutputStream(file2);
                if (this.woff) {
                    object = new WoffWriter().convert(font2);
                    ((ReadableFontData)object).copyTo((OutputStream)object2);
                    continue;
                }
                if (this.eot) {
                    object = new EOTWriter(this.mtx).convert(font2);
                    ((ReadableFontData)object).copyTo((OutputStream)object2);
                    continue;
                }
                fontFactory.serializeFont(font2, (OutputStream)object2);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }
}

