/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphics;

import com.jpexs.graphics.PathConsumer2D;
import com.jpexs.graphics.Stroker;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;

public class ExtendedBasicStroke
implements Stroke {
    Set<Point2D> testPoints = new HashSet<Point2D>();
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int JOIN_MITER_CLIP = 3;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private final float width;
    private final int cap;
    private final int join;
    private final float limit;

    public ExtendedBasicStroke(float width, int cap, int join, float miterlimit) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("width " + width + " < 0");
        }
        if (cap < 0 || cap > 2) {
            throw new IllegalArgumentException("cap " + cap + " out of range [" + 0 + ".." + 2 + "]");
        }
        if (miterlimit < 1.0f && join == 0) {
            throw new IllegalArgumentException("miterlimit " + miterlimit + " < 1.0f while join == JOIN_MITER");
        }
        if (join < 0 || join > 3) {
            throw new IllegalArgumentException("join " + join + " out of range [" + 0 + ".." + 3 + "]");
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.limit = miterlimit;
    }

    public ExtendedBasicStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f);
    }

    public ExtendedBasicStroke(float width) {
        this(width, 2, 0, 10.0f);
    }

    public ExtendedBasicStroke() {
        this(1.0f, 2, 0, 10.0f);
    }

    @Override
    public Shape createStrokedShape(Shape s) {
        final GeneralPath path = new GeneralPath();
        PathConsumer2D p2d = new PathConsumer2D(){

            @Override
            public void moveTo(float x, float y) {
                path.moveTo(x, y);
            }

            @Override
            public void lineTo(float x, float y) {
                path.lineTo(x, y);
            }

            @Override
            public void quadTo(float x1, float y1, float x2, float y2) {
                path.quadTo(x1, y1, x2, y2);
            }

            @Override
            public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
                path.curveTo(x1, y1, x2, y2, x3, y3);
            }

            @Override
            public void closePath() {
                path.closePath();
            }

            @Override
            public void pathDone() {
            }

            @Override
            public long getNativeConsumer() {
                return 0L;
            }
        };
        Stroker stroker = new Stroker(p2d, this.width, this.cap, this.join, this.limit);
        float[] coords = new float[6];
        PathIterator pi = s.getPathIterator(new AffineTransform());
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    stroker.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    stroker.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    stroker.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    stroker.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    stroker.closePath();
                }
            }
            pi.next();
        }
        stroker.pathDone();
        return path;
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.limit;
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.width);
        hash ^= this.cap;
        hash ^= this.join;
        return hash ^= Float.floatToIntBits(this.limit);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtendedBasicStroke)) {
            return false;
        }
        ExtendedBasicStroke s = (ExtendedBasicStroke)o;
        return this.width == s.width && this.cap == s.cap && this.join == s.join && this.limit == s.limit;
    }
}

