/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class BlockCommentPosition {
    private BlockCommentPosition() {
    }

    public static boolean isOnType(DetailAST blockComment) {
        return BlockCommentPosition.isOnClass(blockComment) || BlockCommentPosition.isOnInterface(blockComment) || BlockCommentPosition.isOnEnum(blockComment) || BlockCommentPosition.isOnAnnotationDef(blockComment) || BlockCommentPosition.isOnRecord(blockComment);
    }

    public static boolean isOnClass(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 14, 69) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 14) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 14);
    }

    public static boolean isOnRecord(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 199, 200) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 199) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 199);
    }

    public static boolean isOnPackage(DetailAST blockComment) {
        boolean result = BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 16);
        if (!result) {
            DetailAST nextSibling;
            for (nextSibling = blockComment.getNextSibling(); nextSibling != null && nextSibling.getType() == 144; nextSibling = nextSibling.getNextSibling()) {
            }
            result = nextSibling != null && nextSibling.getType() == 16;
        }
        return result;
    }

    public static boolean isOnInterface(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 15, 71) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 15) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 15);
    }

    public static boolean isOnEnum(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 154, 153) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 154) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 154);
    }

    public static boolean isOnAnnotationDef(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 157, 170) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 157) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 157);
    }

    public static boolean isOnMember(DetailAST blockComment) {
        return BlockCommentPosition.isOnMethod(blockComment) || BlockCommentPosition.isOnField(blockComment) || BlockCommentPosition.isOnConstructor(blockComment) || BlockCommentPosition.isOnEnumConstant(blockComment) || BlockCommentPosition.isOnAnnotationField(blockComment) || BlockCommentPosition.isOnCompactConstructor(blockComment);
    }

    public static boolean isOnMethod(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainClassMember(blockComment, 9) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 9) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 9);
    }

    public static boolean isOnField(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainClassMember(blockComment, 10) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 10) && blockComment.getParent().getParent().getParent().getType() == 6 || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 10) && blockComment.getParent().getParent().getParent().getParent().getType() == 6;
    }

    public static boolean isOnConstructor(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainToken(blockComment, 8, 58) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 8) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 8);
    }

    public static boolean isOnCompactConstructor(DetailAST blockComment) {
        return BlockCommentPosition.isOnTokenWithModifiers(blockComment, 203) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 203);
    }

    public static boolean isOnEnumConstant(DetailAST blockComment) {
        DetailAST parent = blockComment.getParent();
        boolean result = false;
        if (parent.getType() == 155) {
            DetailAST prevSibling = BlockCommentPosition.getPrevSiblingSkipComments(blockComment);
            if (prevSibling.getType() == 158 && !prevSibling.hasChildren()) {
                result = true;
            }
        } else if (parent.getType() == 159 && parent.getParent().getParent().getType() == 155) {
            result = true;
        }
        return result;
    }

    public static boolean isOnAnnotationField(DetailAST blockComment) {
        return BlockCommentPosition.isOnPlainClassMember(blockComment, 161) || BlockCommentPosition.isOnTokenWithModifiers(blockComment, 161) || BlockCommentPosition.isOnTokenWithAnnotation(blockComment, 161);
    }

    private static boolean isOnPlainToken(DetailAST blockComment, int parentTokenType, int nextTokenType) {
        return blockComment.getParent().getType() == parentTokenType && !BlockCommentPosition.getPrevSiblingSkipComments(blockComment).hasChildren() && BlockCommentPosition.getNextSiblingSkipComments(blockComment).getType() == nextTokenType;
    }

    private static boolean isOnTokenWithModifiers(DetailAST blockComment, int tokenType) {
        return blockComment.getParent().getType() == 5 && blockComment.getParent().getParent().getType() == tokenType && BlockCommentPosition.getPrevSiblingSkipComments(blockComment) == null;
    }

    private static boolean isOnTokenWithAnnotation(DetailAST blockComment, int tokenType) {
        return blockComment.getParent().getType() == 159 && BlockCommentPosition.getPrevSiblingSkipComments(blockComment.getParent()) == null && blockComment.getParent().getParent().getParent().getType() == tokenType && BlockCommentPosition.getPrevSiblingSkipComments(blockComment) == null;
    }

    private static boolean isOnPlainClassMember(DetailAST blockComment, int memberType) {
        DetailAST parent = blockComment.getParent();
        while (parent.getType() == 59) {
            parent = parent.getParent();
        }
        return (parent.getType() == 13 || parent.getType() == 165) && parent.getParent().getType() == memberType && !parent.getPreviousSibling().hasChildren() && parent.getParent().getParent().getType() == 6;
    }

    private static DetailAST getNextSiblingSkipComments(DetailAST node) {
        DetailAST result = node.getNextSibling();
        while (result.getType() == 144 || result.getType() == 145) {
            result = result.getNextSibling();
        }
        return result;
    }

    private static DetailAST getPrevSiblingSkipComments(DetailAST node) {
        DetailAST result;
        for (result = node.getPreviousSibling(); result != null && (result.getType() == 144 || result.getType() == 145); result = result.getPreviousSibling()) {
        }
        return result;
    }
}

