/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.meta.ModuleDetails;
import com.puppycrawl.tools.checkstyle.meta.ModulePropertyDetails;
import com.puppycrawl.tools.checkstyle.meta.ModuleType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlMetaReader {
    private static final String XML_TAG_NAME = "name";
    private static final String XML_TAG_DESCRIPTION = "description";

    private XmlMetaReader() {
    }

    public static List<ModuleDetails> readAllModulesIncludingThirdPartyIfAny(String ... thirdPartyPackages) {
        Set<String> standardModuleFileNames = new Reflections("com.puppycrawl.tools.checkstyle.meta", Scanners.Resources).getResources(Pattern.compile(".*\\.xml"));
        HashSet<String> allMetadataSources = new HashSet<String>(standardModuleFileNames);
        for (String packageName : thirdPartyPackages) {
            Set<String> thirdPartyModuleFileNames = new Reflections(packageName, Scanners.Resources).getResources(Pattern.compile(".*checkstylemeta-.*\\.xml"));
            allMetadataSources.addAll(thirdPartyModuleFileNames);
        }
        ArrayList<ModuleDetails> result = new ArrayList<ModuleDetails>();
        for (String fileName : allMetadataSources) {
            ModuleDetails moduleDetails;
            ModuleType moduleType = fileName.endsWith("FileFilter.xml") ? ModuleType.FILEFILTER : (fileName.endsWith("Filter.xml") ? ModuleType.FILTER : ModuleType.CHECK);
            try {
                moduleDetails = XmlMetaReader.read(XmlMetaReader.class.getResourceAsStream("/" + fileName), moduleType);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                throw new IllegalStateException("Problem to read all modules including third party if any. Problem detected at file: " + fileName, ex);
            }
            result.add(moduleDetails);
        }
        return result;
    }

    public static ModuleDetails read(InputStream moduleMetadataStream, ModuleType moduleType) throws ParserConfigurationException, IOException, SAXException {
        ModuleDetails result = null;
        if (moduleType != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(moduleMetadataStream);
            Element root = document.getDocumentElement();
            Element element = XmlMetaReader.getDirectChildsByTag(root, "module").get(0);
            Element module = XmlMetaReader.getDirectChildsByTag(element, moduleType.getLabel()).get(0);
            result = new ModuleDetails();
            result.setModuleType(moduleType);
            XmlMetaReader.populateModule(module, result);
        }
        return result;
    }

    private static void populateModule(Element mod, ModuleDetails moduleDetails) {
        List<String> messageKeys;
        moduleDetails.setName(XmlMetaReader.getAttributeValue(mod, XML_TAG_NAME));
        moduleDetails.setFullQualifiedName(XmlMetaReader.getAttributeValue(mod, "fully-qualified-name"));
        moduleDetails.setParent(XmlMetaReader.getAttributeValue(mod, "parent"));
        moduleDetails.setDescription(XmlMetaReader.getDirectChildsByTag(mod, XML_TAG_DESCRIPTION).get(0).getFirstChild().getNodeValue());
        List<Element> properties = XmlMetaReader.getDirectChildsByTag(mod, "properties");
        if (!properties.isEmpty()) {
            List<ModulePropertyDetails> modulePropertyDetailsList = XmlMetaReader.createProperties(properties.get(0));
            moduleDetails.addToProperties(modulePropertyDetailsList);
        }
        if ((messageKeys = XmlMetaReader.getListContentByAttribute(mod, "message-keys", "message-key", "key")) != null) {
            moduleDetails.addToViolationMessages(messageKeys);
        }
    }

    private static List<ModulePropertyDetails> createProperties(Element properties) {
        ArrayList<ModulePropertyDetails> result = new ArrayList<ModulePropertyDetails>();
        NodeList propertyList = properties.getElementsByTagName("property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            ModulePropertyDetails propertyDetails = new ModulePropertyDetails();
            Element prop = (Element)propertyList.item(i);
            propertyDetails.setName(XmlMetaReader.getAttributeValue(prop, XML_TAG_NAME));
            propertyDetails.setType(XmlMetaReader.getAttributeValue(prop, "type"));
            String defaultValueTag = "default-value";
            if (prop.hasAttribute("default-value")) {
                propertyDetails.setDefaultValue(XmlMetaReader.getAttributeValue(prop, "default-value"));
            }
            String validationTypeTag = "validation-type";
            if (prop.hasAttribute("validation-type")) {
                propertyDetails.setValidationType(XmlMetaReader.getAttributeValue(prop, "validation-type"));
            }
            propertyDetails.setDescription(XmlMetaReader.getDirectChildsByTag(prop, XML_TAG_DESCRIPTION).get(0).getFirstChild().getNodeValue());
            result.add(propertyDetails);
        }
        return result;
    }

    private static List<String> getListContentByAttribute(Element element, String listParent, String listOption, String attribute) {
        List<Element> children = XmlMetaReader.getDirectChildsByTag(element, listParent);
        ArrayList<String> result = null;
        if (!children.isEmpty()) {
            NodeList nodeList = children.get(0).getElementsByTagName(listOption);
            ArrayList<String> listContent = new ArrayList<String>();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                listContent.add(XmlMetaReader.getAttributeValue((Element)nodeList.item(j), attribute));
            }
            result = listContent;
        }
        return result;
    }

    private static List<Element> getDirectChildsByTag(Element element, String sTagName) {
        NodeList children = element.getElementsByTagName(sTagName);
        ArrayList<Element> res = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getParentNode().equals(element)) continue;
            res.add((Element)children.item(i));
        }
        return res;
    }

    private static String getAttributeValue(Element element, String attribute) {
        return element.getAttributes().getNamedItem(attribute).getNodeValue();
    }
}

