/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils.ant;

import com.jpexs.jbomutils.MkBom;
import com.jpexs.jbomutils.PrintNode;
import com.jpexs.jbomutils.ant.Task;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.TarFileSet;

public class MkBomTask
extends Task {
    private Project project;
    private boolean verbose = false;
    private String destFile = null;
    private List<TarFileSet> filesets = new ArrayList<TarFileSet>();

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDestFile(String destFile) {
        this.destFile = destFile;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void addTarFileset(TarFileSet fileset) {
        this.filesets.add(fileset);
    }

    protected void validate() {
        if (this.filesets.isEmpty()) {
            throw new BuildException("fileset not set");
        }
        if (this.destFile == null) {
            throw new BuildException("destFile not set");
        }
    }

    private String[] getFileNames(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(fs.getProject());
        String[] directories = ds.getIncludedDirectories();
        String[] filesPerSe = ds.getIncludedFiles();
        String[] files = new String[directories.length + filesPerSe.length];
        System.arraycopy(directories, 0, files, 0, directories.length);
        System.arraycopy(filesPerSe, 0, files, directories.length, filesPerSe.length);
        return files;
    }

    @Override
    public void execute() {
        this.validate();
        System.out.println("MkBom: Creating BOM file to \"" + this.destFile + "\" ...");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        HashSet<String> dirs = new HashSet<String>();
        HashSet<String> files = new HashSet<String>();
        for (TarFileSet fs : this.filesets) {
            String fullPath = fs.getFullpath(this.project);
            String prefix = fs.getPrefix(this.project);
            String[] fileNames = this.getFileNames((FileSet)fs);
            long gid = fs.hasGroupIdBeenSet() ? (long)fs.getGid() : Long.MAX_VALUE;
            long uid = fs.hasUserIdBeenSet() ? (long)fs.getUid() : Long.MAX_VALUE;
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i];
                String targetName = !fullPath.isEmpty() ? fullPath : prefix + fileName;
                if ((targetName = targetName.replace('\\', '/')).isEmpty()) {
                    targetName = ".";
                }
                if (!targetName.equals(".")) {
                    String dirname;
                    String[] path_parts = ("./" + targetName).split("/");
                    String pdir = "";
                    String string = dirname = targetName.contains("/") ? targetName.substring(0, targetName.lastIndexOf("/")) : "";
                    if (!dirs.contains(dirname)) {
                        for (int p = 0; p < path_parts.length - 1; ++p) {
                            String pname = path_parts[p];
                            if (!pdir.isEmpty()) {
                                pdir = pdir + "/";
                            }
                            if (!dirs.contains(pdir = pdir + pname)) {
                                if (this.verbose) {
                                    System.out.println("MkBom: Adding parent dir \"" + pdir + "\" ...");
                                }
                                if (fullPath.isEmpty() && (pdir + "/").startsWith(prefix)) {
                                    PrintNode.print_node(output, fs.getDir(this.project).getAbsolutePath(), (prefix.equals(pdir + "/") ? prefix : pdir).replace("/", File.separator).substring(prefix.length()), pdir, uid, gid, false, fs.hasDirModeBeenSet() ? fs.getDirMode(this.project) : -1);
                                } else {
                                    PrintNode.print_custom_node(output, pdir, uid, gid, 16384 + (fs.hasDirModeBeenSet() ? fs.getDirMode(this.project) : 511));
                                }
                            }
                            dirs.add(pdir);
                            if (!pdir.equals(".")) continue;
                            pdir = "";
                        }
                    }
                }
                if (this.verbose) {
                    System.out.println("MkBom: Adding \"" + targetName + "\" ...");
                }
                if (files.contains(targetName)) continue;
                files.add(targetName);
                PrintNode.print_node(output, fs.getDir(this.project).getAbsolutePath(), fileName, targetName, uid, gid, false, fs.hasFileModeBeenSet() ? fs.getFileMode(this.project) : -1);
            }
        }
        try {
            MkBom.write_bom(new ByteArrayInputStream(output.toByteArray()), this.destFile);
            System.out.println("MkBom: File created in \"" + this.destFile + "\"");
        }
        catch (IOException ex) {
            throw new BuildException("MkBom: Cannot write to \"" + this.destFile + "\"", (Throwable)ex);
        }
    }
}

