/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils;

import com.jpexs.jbomutils.BomInputStream;
import com.jpexs.jbomutils.BomOutputStream;
import com.jpexs.jbomutils.WritableTo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Tools {
    public static final int sizeof_uint32_t = 4;
    public static final int sizeof_uint16_t = 2;

    public static String getline(InputStream is, int delim) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        while (true) {
            int v;
            if ((v = is.read()) == -1 && len == 0) {
                return null;
            }
            if (v == -1 || v == delim) break;
            ++len;
            baos.write(v);
        }
        return new String(baos.toByteArray());
    }

    public static String getline(InputStream is) throws IOException {
        return Tools.getline(is, 10);
    }

    public static BomInputStream getBIS(byte[] data) {
        return Tools.getBIS(data, 0, data.length);
    }

    public static BomInputStream getBIS(byte[] data, int offset) {
        return new BomInputStream(new ByteArrayInputStream(data, offset, data.length - offset));
    }

    public static BomInputStream getBIS(byte[] data, int offset, int len) {
        return new BomInputStream(new ByteArrayInputStream(data, offset, len));
    }

    public static byte[] getBytes(WritableTo w) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BomOutputStream bos = new BomOutputStream(baos);
            bos.write(w);
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }
}

