/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public class Stat {
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    long st_dev;
    long st_ino;
    int st_mode;
    long st_nlink;
    long st_uid;
    long st_gid;
    long st_rdev;
    long st_atim;
    long st_mtim;
    long st_ctim;
    long st_size;
    long st_blocks;
    long st_blksize;
    long st_flags;
    long st_gen;

    public static boolean S_ISREG(int m) {
        return (m & 0xF000) == 32768;
    }

    public static boolean S_ISLNK(int m) {
        return (m & 0xF000) == 40960;
    }

    public static boolean S_ISDIR(int m) {
        return (m & 0xF000) == 16384;
    }

    public static boolean S_ISCHR(int m) {
        return (m & 0xF000) == 8192;
    }

    public static boolean S_ISBLK(int m) {
        return (m & 0xF000) == 24576;
    }

    public static boolean S_ISFIFO(int m) {
        return (m & 0xF000) == 4096;
    }

    public static boolean S_ISSOCK(int m) {
        return (m & 0xF000) == 49152;
    }

    public static int stat(String path, Stat s) {
        File f = new File(path);
        Path p = f.toPath();
        try {
            s.st_mode = 0;
            BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
            if (attrs.isDirectory()) {
                s.st_mode |= 0x4000;
            }
            if (attrs.isRegularFile()) {
                s.st_mode |= 0x8000;
            }
            if (attrs.isSymbolicLink()) {
                s.st_mode |= 0xA000;
            }
            s.st_atim = attrs.lastAccessTime().toMillis();
            s.st_mtim = attrs.lastModifiedTime().toMillis();
            s.st_ctim = attrs.creationTime().toMillis();
            s.st_size = attrs.size();
            s.st_mode = s.st_mode | (f.canRead() ? 292 : 0) + (f.canWrite() ? 146 : 0) + (f.canExecute() ? 73 : 0);
        }
        catch (IOException ex) {
            return 1;
        }
        s.st_gid = 0L;
        s.st_uid = 0L;
        s.st_ino = 0L;
        return 0;
    }

    public static int lstat(String path, Stat s) {
        int s_ret = Stat.stat(path, s);
        if (s_ret != 0) {
            return s_ret;
        }
        Path p = new File(path).toPath();
        try {
            s.st_gid = ((Integer)Files.readAttributes(p, "unix:gid", new LinkOption[0]).get("gid")).intValue();
        }
        catch (IOException ex) {
            return 1;
        }
        try {
            s.st_uid = ((Integer)Files.readAttributes(p, "unix:uid", new LinkOption[0]).get("uid")).intValue();
        }
        catch (IOException ex) {
            return 1;
        }
        try {
            s.st_mode = (Integer)Files.readAttributes(p, "unix:mode", new LinkOption[0]).get("mode");
        }
        catch (IOException ex) {
            return 1;
        }
        return 0;
    }
}

