/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils;

import com.jpexs.jbomutils.Crc32;
import com.jpexs.jbomutils.Stat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrintNode {
    public static void print_node(OutputStream output, String base, String system_path, String path, long uid, long gid) {
        PrintNode.print_node(output, base, system_path, path, uid, gid, true);
    }

    public static void print_custom_node(OutputStream output, String path, long uid, long gid, int mode) {
        try {
            output.write((path + "\t" + Integer.toOctalString(mode) + "\t").getBytes());
            output.write(("" + (uid == Long.MAX_VALUE ? 0L : uid) + "/" + (uid == Long.MAX_VALUE ? 80L : uid)).getBytes());
            output.write(System.lineSeparator().getBytes());
        }
        catch (IOException ex) {
            Logger.getLogger(PrintNode.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void print_node(OutputStream output, String base, String system_path, String path, long uid, long gid, boolean recursive) {
        PrintNode.print_node(output, base, system_path, path, uid, gid, recursive, -1);
    }

    public static void print_node(OutputStream output, String base, String system_path, String path, long uid, long gid, boolean recursive, int fileMode) {
        try {
            Stat s = new Stat();
            String fullpath = base;
            int stat_ret = 0;
            boolean WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
            if (WINDOWS) {
                if (system_path.length() != 0) {
                    fullpath = fullpath + "\\" + system_path;
                }
                stat_ret = Stat.stat(fullpath, s);
            } else {
                fullpath = fullpath + "/" + system_path;
                stat_ret = Stat.lstat(fullpath, s);
            }
            if (stat_ret != 0) {
                System.err.println("Unable to find path: " + fullpath);
                System.exit(1);
            }
            output.write((path + "\t" + Integer.toOctalString(fileMode == -1 ? s.st_mode : fileMode | (Stat.S_ISDIR(s.st_mode) ? 16384 : 0)) + "\t").getBytes());
            output.write(("" + (uid == Long.MAX_VALUE ? s.st_uid : uid) + "/" + (gid == Long.MAX_VALUE ? s.st_gid : gid)).getBytes());
            if (Stat.S_ISREG(s.st_mode)) {
                output.write(("\t" + s.st_size + "\t" + Crc32.calc(new File(fullpath))).getBytes());
            }
            if (!WINDOWS && Stat.S_ISLNK(s.st_mode)) {
                String buffer = Files.readSymbolicLink(new File(fullpath).toPath()).toFile().getAbsolutePath();
                output.write(("\t" + s.st_size + "\t" + Crc32.calc(buffer) + "\t" + buffer).getBytes());
            }
            output.write(System.lineSeparator().getBytes());
            if (Stat.S_ISDIR(s.st_mode) && recursive) {
                File[] files;
                File d = new File(fullpath);
                for (File f : files = d.listFiles()) {
                    String new_path = path;
                    new_path = new_path + "/" + f.getName();
                    String new_system_path = "";
                    if (WINDOWS) {
                        new_system_path = system_path;
                        new_system_path = new_system_path + "\\" + f.getName();
                    } else {
                        new_system_path = new_path;
                    }
                    PrintNode.print_node(output, base, new_system_path, new_path, uid, gid);
                }
            }
        }
        catch (IOException ex) {
            System.err.println("Error during writing");
            System.exit(1);
        }
    }

    public static void print_node(OutputStream output, String directory, long uid, long gid) {
        Stat s;
        if (directory.isEmpty()) {
            System.err.println("Invalid path");
            System.exit(1);
        }
        if (directory.charAt(directory.length() - 1) == '/') {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (Stat.stat(directory, s = new Stat()) != 0) {
            System.err.println("Unable to find path: " + directory);
            System.exit(1);
        }
        if (!Stat.S_ISDIR(s.st_mode)) {
            System.err.println("Argument must be a directory");
            System.exit(1);
        }
        PrintNode.print_node(output, directory, "", ".", uid, gid);
    }
}

