/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils;

import com.jpexs.jbomutils.BomFile;
import com.jpexs.jbomutils.BomInfo;
import com.jpexs.jbomutils.BomInfoEntry;
import com.jpexs.jbomutils.BomInputStream;
import com.jpexs.jbomutils.BomOutputStream;
import com.jpexs.jbomutils.BomPathIndices;
import com.jpexs.jbomutils.BomPathInfo1;
import com.jpexs.jbomutils.BomPathInfo2;
import com.jpexs.jbomutils.BomPaths;
import com.jpexs.jbomutils.BomStorage;
import com.jpexs.jbomutils.BomTree;
import com.jpexs.jbomutils.BomVIndex;
import com.jpexs.jbomutils.Node;
import com.jpexs.jbomutils.PrintNode;
import com.jpexs.jbomutils.TNodeType;
import com.jpexs.jbomutils.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class MkBom {
    private static int dec_octal_to_int(int dec_rep_octal) {
        int retval = 0;
        int n = 1;
        while (dec_rep_octal > 0) {
            int digit = dec_rep_octal - dec_rep_octal / 10 * 10;
            if (digit > 7) {
                throw new RuntimeException("argument not in dec oct rep");
            }
            retval += digit * n;
            dec_rep_octal /= 10;
            n *= 8;
        }
        return retval;
    }

    public static void write_bom(InputStream is, String outputPath) throws IOException {
        String line;
        Node root = new Node();
        root.type = TNodeType.KRootNode;
        HashMap<String, Object> all_nodes = new HashMap<String, Object>();
        while ((line = Tools.getline(is)) != null) {
            Node n = new Node();
            ByteArrayInputStream ss = new ByteArrayInputStream(line.getBytes());
            String name = Tools.getline(ss, 9);
            if (name == null) {
                throw new RuntimeException("Syntax error in lsbom input");
            }
            String rest = Tools.getline(ss);
            rest = rest.replaceFirst("/", " ");
            String[] elements = rest.split("\\s");
            n.mode = MkBom.dec_octal_to_int(Integer.parseInt(elements[0]));
            n.uid = Integer.parseInt(elements[1]);
            n.gid = Integer.parseInt(elements[2]);
            n.size = 0L;
            n.checksum = 0L;
            if ((n.mode & 0xF000L) == 16384L) {
                n.type = TNodeType.KDirectoryNode;
                n.linkName = "";
            } else if ((n.mode & 0xF000L) == 32768L) {
                n.type = TNodeType.KFileNode;
                n.size = Integer.parseInt(elements[3]);
                n.checksum = Long.parseLong(elements[4]);
                n.linkName = "";
            } else if ((n.mode & 0xF000L) == 40960L) {
                n.type = TNodeType.KSymbolicLinkNode;
                n.size = Integer.parseInt(elements[3]);
                n.checksum = Long.parseLong(elements[4]);
                n.linkName = elements[5];
            } else {
                throw new RuntimeException("Node type not supported");
            }
            all_nodes.put(name, n);
        }
        for (String name : all_nodes.keySet()) {
            String element;
            ArrayList<String> path_elements = new ArrayList<String>();
            ByteArrayInputStream ss = new ByteArrayInputStream(name.getBytes());
            while ((element = Tools.getline(ss, 47)) != null) {
                path_elements.add(element);
            }
            Node parent = root;
            String full_path = "";
            for (String jt : path_elements) {
                full_path = full_path + jt;
                if (!parent.children.containsKey(jt)) {
                    if (!all_nodes.containsKey(full_path)) {
                        throw new RuntimeException("Parent directory of file/folder \"" + full_path + "\" does not appear in list");
                    }
                    parent.children.put(jt, (Node)all_nodes.get(full_path));
                }
                parent = parent.children.get(jt);
                full_path = full_path + "/";
            }
        }
        int num = all_nodes.size();
        BomStorage bom = new BomStorage();
        int bom_info_size = 12 + (num != 0 ? 1 : 0) * 16;
        BomInfo info = new BomInfo();
        info.version = 1L;
        info.numberOfPaths = num + 1;
        if (num != 0 && info.entries.isEmpty()) {
            info.entries.add(new BomInfoEntry());
        }
        if (num != 0) {
            info.entries.get((int)0).unknown2 = 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BomOutputStream bos = new BomOutputStream(baos);
        info.writeTo(bos);
        bom.addVar("BomInfo", baos.toByteArray(), bom_info_size);
        BomTree tree = new BomTree();
        tree.version = 1L;
        tree.blockSize = 4096L;
        tree.pathCount = num;
        tree.unknown3 = 0;
        int num_paths = (int)Math.ceil((double)num / 256.0);
        int path_size = 12 + num_paths * 8;
        BomPaths root_paths = new BomPaths();
        root_paths.isLeaf = 0L;
        root_paths.count = num_paths;
        root_paths.forward = 0L;
        root_paths.backward = 0L;
        root_paths.indices = new ArrayList<BomPathIndices>();
        Stack<Pair<Long, Node>> stack = new Stack<Pair<Long, Node>>();
        stack.push(new Pair<Long, Node>(0L, root));
        int j = 0;
        int k = 0;
        int current_path = 0;
        int current_path_size = 0;
        int last_file_info = 0;
        int last_paths_id = 0;
        BomPaths paths = null;
        while (stack.size() != 0) {
            Pair p = (Pair)stack.get(0);
            Node arg = (Node)p.second;
            long parent = (Long)p.first;
            stack.remove(0);
            for (String it : arg.children.keySet()) {
                Node node = arg.children.get(it);
                String s = it;
                if (k == 0) {
                    int new_paths_id = 0;
                    if (paths != null) {
                        new_paths_id = bom.addBlock(Tools.getBytes(paths), current_path_size);
                        root_paths.indices.add(new BomPathIndices());
                        root_paths.indices.get((int)current_path).index0 = new_paths_id;
                        if (last_paths_id != 0) {
                            BomPaths prev_paths = new BomPaths(new BomInputStream(new ByteArrayInputStream(bom.getBlock(last_paths_id))));
                            prev_paths.forward = new_paths_id;
                        }
                        root_paths.indices.get((int)current_path).index1 = last_file_info;
                        paths = null;
                        ++current_path;
                    }
                    int next_num = 256 < num - j ? 256 : num - j;
                    current_path_size = 12 + next_num * 8;
                    paths = new BomPaths();
                    paths.isLeaf = 1L;
                    paths.count = next_num;
                    paths.forward = 0L;
                    paths.backward = new_paths_id;
                    last_paths_id = new_paths_id;
                }
                int bom_path_info2_size = 31 + node.linkName.getBytes().length;
                BomPathInfo2 info2 = new BomPathInfo2();
                info2.type = node.type == TNodeType.KDirectoryNode ? 2 : (node.type == TNodeType.KFileNode ? 1 : 3);
                info2.unknown0 = 1;
                info2.architecture = 3;
                info2.mode = (int)node.mode;
                info2.user = node.uid;
                info2.group = node.gid;
                info2.modtime = 0L;
                info2.size = node.size;
                info2.unknown1 = 1;
                info2.checksum_devType = node.checksum;
                info2.linkName = node.linkName;
                BomPathInfo1 info1 = new BomPathInfo1();
                info1.id = j + 1;
                info1.index = bom.addBlock(Tools.getBytes(info2), bom_path_info2_size);
                paths.indices.add(new BomPathIndices());
                paths.indices.get((int)k).index0 = bom.addBlock(Tools.getBytes(info1), 8);
                int bom_file_size = 5 + s.getBytes().length;
                BomFile f = new BomFile();
                f.parent = parent;
                f.name = s;
                last_file_info = bom.addBlock(Tools.getBytes(f), bom_file_size);
                paths.indices.get((int)k).index1 = last_file_info;
                stack.add(0, new Pair<Long, Node>(Long.valueOf(j + 1), node));
                ++j;
                k = (k + 1) % 256;
            }
        }
        if (num_paths > 1) {
            root_paths.indices.get((int)current_path).index0 = new BomPaths((BomInputStream)Tools.getBIS((byte[])bom.getBlock((int)last_paths_id))).forward = (long)bom.addBlock(Tools.getBytes(paths), current_path_size);
            root_paths.indices.get((int)current_path).index1 = last_file_info;
            tree.child = bom.addBlock(Tools.getBytes(root_paths), path_size);
        } else {
            tree.child = bom.addBlock(Tools.getBytes(paths), current_path_size);
        }
        bom.addVar("Paths", Tools.getBytes(tree), 21);
        int path_size2 = 12;
        BomPaths empty_path = new BomPaths();
        empty_path.isLeaf = 1L;
        empty_path.count = 0L;
        empty_path.forward = 0L;
        empty_path.backward = 0L;
        BomTree tree2 = new BomTree();
        tree2.tree = "tree".getBytes();
        tree2.version = 1L;
        tree2.blockSize = 4096L;
        tree2.pathCount = 0L;
        tree2.unknown3 = 0;
        tree2.child = bom.addBlock(Tools.getBytes(empty_path), path_size2);
        bom.addVar("HLIndex", Tools.getBytes(tree2), 21);
        BomVIndex vindex = new BomVIndex();
        vindex.unknown0 = 1L;
        tree2.child = bom.addBlock(Tools.getBytes(empty_path), path_size2);
        tree2.blockSize = 128L;
        vindex.indexToVTree = bom.addBlock(Tools.getBytes(tree2), 21);
        vindex.unknown2 = 0L;
        vindex.unknown3 = 0;
        bom.addVar("VIndex", Tools.getBytes(vindex), 13);
        tree2.blockSize = 4096L;
        tree2.child = bom.addBlock(Tools.getBytes(empty_path), path_size2);
        bom.addVar("Size64", Tools.getBytes(tree2), 21);
        bom.write(new FileOutputStream(outputPath));
    }

    public static void usage() {
        System.out.println("Usage: java -jar bomutils.jar mkbom [-i] [-u uid] [-g gid] source target-bom-file");
        System.out.println("\t-i\tTreat source as a file in the format generated by ls4mkbom and lsbom");
        System.out.println("\t-u\tForce user ID to the specified value (incompatible with -i)");
        System.out.println("\t-g\tForce group ID to the specified value (incompatible with -i)");
    }

    public static void main(String[] args) {
        int i;
        long uid = Long.MAX_VALUE;
        long gid = Long.MAX_VALUE;
        boolean isFileListSource = false;
        block21: for (i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-i": {
                    isFileListSource = true;
                    continue block21;
                }
                case "-u": {
                    uid = Long.parseLong(args[i + 1]);
                    ++i;
                    continue block21;
                }
                case "-g": {
                    gid = Long.parseLong(args[i + 1]);
                    ++i;
                    continue block21;
                }
                case "-h": {
                    MkBom.usage();
                    System.exit(0);
                }
                case "-:": 
                case "-?": {
                    MkBom.usage();
                    System.exit(1);
                }
            }
        }
        if (i + 2 > args.length) {
            MkBom.usage();
            System.exit(1);
        }
        String source = args[i];
        String target_bom = args[i + 1];
        if (isFileListSource) {
            FileInputStream file_list = null;
            try {
                file_list = new FileInputStream(source);
            }
            catch (IOException ex) {
                System.err.println("Unable to open file list: " + source);
                System.exit(1);
            }
            if (uid != Long.MAX_VALUE || gid != Long.MAX_VALUE) {
                System.err.println("The -u and -g options cannot be used with -i");
                System.exit(1);
            }
            try {
                MkBom.write_bom(file_list, target_bom);
            }
            catch (IOException ex) {
                System.exit(1);
            }
        } else {
            ByteArrayOutputStream ss = new ByteArrayOutputStream();
            PrintNode.print_node(ss, source, uid, gid);
            String buffer = new String(ss.toByteArray());
            ByteArrayInputStream file_list = new ByteArrayInputStream(buffer.getBytes());
            try {
                MkBom.write_bom(file_list, target_bom);
            }
            catch (IOException ex) {
                System.exit(1);
            }
        }
        System.exit(0);
    }

    private static class Pair<A, B> {
        public A first;
        public B second;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }
    }
}

