/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils;

import com.jpexs.jbomutils.BomFile;
import com.jpexs.jbomutils.BomHeader;
import com.jpexs.jbomutils.BomInputStream;
import com.jpexs.jbomutils.BomPathInfo1;
import com.jpexs.jbomutils.BomPathInfo2;
import com.jpexs.jbomutils.BomPaths;
import com.jpexs.jbomutils.BomPointer;
import com.jpexs.jbomutils.BomTree;
import com.jpexs.jbomutils.BomVar;
import com.jpexs.jbomutils.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LsBom {
    public static final int LIST_FILES = 1;
    public static final int LIST_DIRS = 2;
    public static final int LIST_LINKS = 3;
    public static final int LIST_BDEVS = 4;
    public static final int LIST_CDEVS = 5;
    public static final int LIST_ALL = 31;
    static int debug = 0;
    static byte[] data;
    static List<BomPointer> indexHeader;

    public static long lookup(int i) {
        BomPointer index = indexHeader.get(i);
        int addr = (int)index.address;
        return addr;
    }

    public static void short_usage() {
        System.out.println("Usage: lsbom [-h] [-s] [-f] [-d] [-l] [-b] [-c] [-m] [-x]\n\t[-p parameters] bom ...");
    }

    public static void usage_error(String msg) {
        System.out.println(msg);
        LsBom.short_usage();
        System.exit(1);
    }

    public static void usage() {
        LsBom.short_usage();
        System.out.print("\n\t-h              print full usage\n\t-s              print pathnames only\n\t-f              list files\n\t-d              list directories\n\t-l              list symbolic links\n\t-b              list block devices\n\t-c              list character devices\n\t-m              print modified times\n\t-x              suppress modes for directories and symlinks\n\t-p parameters   print only some of the results.  EACH OPTION CAN ONLY BE USED ONCE\n\t\tParameters:\n\t\t\tf    file name\n\t\t\tF    file name with quotes (i.e. \"/usr/bin/lsbom\")\n\t\t\tm    file mode (permissions)\n\t\t\tM    symbolic file mode\n\t\t\tg    group id\n\t\t\tG    group name\n\t\t\tu    user id\n\t\t\tU    user name\n\t\t\tt    mod time\n\t\t\tT    formatted mod time\n\t\t\ts    file size\n\t\t\tS    formatted size\n\t\t\tc    32-bit checksum\n\t\t\t/    user id/group id\n\t\t\t?    user name/group name\n\t\t\tl    link name\n\t\t\tL    quoted link name\n\t\t\t0    device type\n\t\t\t1    device major\n\t\t\t2    device minor\n");
    }

    public static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int i;
        boolean suppressDirSimModes = false;
        boolean suppressDevSize = false;
        boolean pathsOnly = false;
        int listType = 0;
        String params = "";
        int optind = 0;
        block81: for (i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-h": {
                    LsBom.usage();
                    System.exit(0);
                }
                case "-s": {
                    pathsOnly = true;
                    break;
                }
                case "-f": {
                    listType |= 1;
                    break;
                }
                case "-d": {
                    listType |= 2;
                    break;
                }
                case "-l": {
                    listType |= 3;
                    break;
                }
                case "-b": {
                    listType |= 4;
                    break;
                }
                case "-c": {
                    listType |= 5;
                    break;
                }
                case "-m": {
                    params = params + "T";
                    break;
                }
                case "-x": {
                    suppressDirSimModes = true;
                    break;
                }
                case "-a": {
                    LsBom.usage_error("--arch not supported");
                    break;
                }
                case "-p": {
                    if (15 < args[i + 1].length()) {
                        LsBom.usage_error("Too many parameters");
                    }
                    params = args[i + 1];
                    ++i;
                    break;
                }
                case "-:": 
                case "-?": {
                    LsBom.short_usage();
                    System.exit(1);
                }
                default: {
                    break block81;
                }
            }
            optind = i + 1;
        }
        if (optind == args.length) {
            LsBom.usage();
            System.exit(1);
        }
        if (listType == 0) {
            listType = 31;
        }
        if (params.isEmpty()) {
            params = "fm/scl0";
            suppressDevSize = true;
        }
        i = optind;
        while (i < args.length) {
            try (FileInputStream f = new FileInputStream(args[i]);){
                long length = new File(args[i]).length();
                data = new byte[(int)length];
                ((InputStream)f).read(data);
            }
            catch (FileNotFoundException ex) {
                System.err.println("Unable to open file: \"" + args[i] + "\"");
                System.exit(1);
            }
            catch (IOException ex) {
                System.err.println("Failed to read BOM file");
                System.exit(1);
            }
            try {
                BomInputStream bis = Tools.getBIS(data);
                BomHeader header = new BomHeader(bis);
                if (!new String(header.magic).equals("BOMStore")) {
                    System.err.println("Not a BOM file: " + args[i]);
                    System.exit(1);
                }
                bis = Tools.getBIS(data, (int)header.indexOffset);
                int table_len = (int)bis.readUI32();
                indexHeader = new ArrayList<BomPointer>();
                for (int j = 0; j < table_len; ++j) {
                    indexHeader.add(new BomPointer(bis));
                }
                bis = Tools.getBIS(data, (int)header.varsOffset);
                int var_count = (int)bis.readUI32();
                ArrayList<BomVar> vars = new ArrayList<BomVar>();
                for (int j = 0; j < var_count; ++j) {
                    vars.add(new BomVar(bis));
                }
                for (BomVar var : vars) {
                    BomTree tree = new BomTree(Tools.getBIS(data, (int)LsBom.lookup((int)var.index)));
                    String name = var.name;
                    if (!name.equals("Paths")) continue;
                    BomPaths paths = new BomPaths(Tools.getBIS(data, (int)LsBom.lookup((int)tree.child)));
                    HashMap<Long, String> filenames = new HashMap<Long, String>();
                    HashMap<Long, Long> parents = new HashMap<Long, Long>();
                    while (paths.isLeaf == 0L) {
                        paths = new BomPaths(Tools.getBIS(data, (int)LsBom.lookup((int)paths.indices.get((int)0).index0)));
                    }
                    while (paths != null) {
                        int j = 0;
                        while ((long)j < paths.count) {
                            block111: {
                                long index0 = paths.indices.get((int)j).index0;
                                long index1 = paths.indices.get((int)j).index1;
                                BomFile file = new BomFile(Tools.getBIS(data, (int)LsBom.lookup((int)index1)));
                                BomPathInfo1 info1 = new BomPathInfo1(Tools.getBIS(data, (int)LsBom.lookup((int)index0)));
                                BomPathInfo2 info2 = new BomPathInfo2(Tools.getBIS(data, (int)LsBom.lookup((int)info1.index)));
                                String filename = file.name;
                                filenames.put(info1.id, filename);
                                if (file.parent > 0L) {
                                    parents.put(info1.id, file.parent);
                                }
                                Long it = (Long)parents.get(info1.id);
                                while (it != null) {
                                    filename = (String)filenames.get(it) + "/" + filename;
                                    it = (Long)parents.get(it);
                                }
                                switch (info2.type) {
                                    case 1: {
                                        if ((1 & listType) != 0) break;
                                        break block111;
                                    }
                                    case 2: {
                                        if ((2 & listType) != 0) break;
                                        break block111;
                                    }
                                    case 3: {
                                        if ((3 & listType) != 0) break;
                                        break block111;
                                    }
                                    case 4: {
                                        boolean isBlock;
                                        int mode = info2.mode;
                                        boolean bl = isBlock = (mode & 0x4000) > 0;
                                        if (isBlock && (4 & listType) == 0 || !isBlock && (5 & listType) == 0) break block111;
                                    }
                                }
                                if (pathsOnly) {
                                    System.out.print(filename + '\n');
                                } else {
                                    boolean printed = true;
                                    block90: for (int k = 0; k < params.length(); ++k) {
                                        if (k > 0 && printed) {
                                            System.out.print('\t');
                                        }
                                        printed = true;
                                        switch (params.charAt(k)) {
                                            case 'f': {
                                                System.out.print(filename);
                                                continue block90;
                                            }
                                            case 'F': {
                                                System.out.print('\"' + filename + '\"');
                                                continue block90;
                                            }
                                            case 'g': {
                                                System.out.print(info2.group);
                                                continue block90;
                                            }
                                            case 'G': {
                                                LsBom.error("Group name not yet supported");
                                                continue block90;
                                            }
                                            case 'u': {
                                                System.out.print(info2.user);
                                                continue block90;
                                            }
                                            case 'U': {
                                                LsBom.error("User name not yet supported");
                                                continue block90;
                                            }
                                            case '/': {
                                                System.out.print("" + info2.user + '/' + info2.group);
                                                continue block90;
                                            }
                                            case '?': {
                                                LsBom.error("User/group name not yet supported");
                                                continue block90;
                                            }
                                            default: {
                                                if (!suppressDirSimModes || info2.type != 2 && info2.type != 3) {
                                                    switch (params.charAt(k)) {
                                                        case 'm': {
                                                            System.out.print(Integer.toOctalString(info2.mode));
                                                            continue block90;
                                                        }
                                                        case 'M': {
                                                            LsBom.error("Symbolic mode not yet supported");
                                                            break;
                                                        }
                                                    }
                                                    if (info2.type == 1 || info2.type == 3) {
                                                        switch (params.charAt(j)) {
                                                            case 't': {
                                                                System.out.print(info2.modtime);
                                                                continue block90;
                                                            }
                                                            case 'T': {
                                                                LsBom.error("Formated mod time not yet supported");
                                                                break;
                                                            }
                                                            case 'c': {
                                                                System.out.print(info2.checksum_devType);
                                                                continue block90;
                                                            }
                                                        }
                                                    }
                                                    if (!(info2.type == 2 || suppressDevSize && info2.type == 4)) {
                                                        switch (params.charAt(j)) {
                                                            case 's': {
                                                                System.out.print(info2.size);
                                                                continue block90;
                                                            }
                                                            case 'S': {
                                                                LsBom.error("Formated size not yet supported");
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    if (info2.type == 3) {
                                                        switch (params.charAt(j)) {
                                                            case 'l': {
                                                                System.out.print(info2.linkName);
                                                                continue block90;
                                                            }
                                                            case 'L': {
                                                                System.out.print('\"' + info2.linkName + '\"');
                                                                continue block90;
                                                            }
                                                        }
                                                    }
                                                    if (info2.type == 4) {
                                                        long devType = info2.checksum_devType;
                                                        switch (params.charAt(j)) {
                                                            case '0': {
                                                                System.out.print(devType);
                                                                continue block90;
                                                            }
                                                            case '1': {
                                                                System.out.print(devType >> 24);
                                                                continue block90;
                                                            }
                                                            case '2': {
                                                                System.out.print(devType & 0xFFL);
                                                                continue block90;
                                                            }
                                                        }
                                                    }
                                                }
                                                printed = false;
                                            }
                                        }
                                    }
                                    System.out.print("\n");
                                }
                            }
                            ++j;
                        }
                        if (paths.forward == 0L) {
                            paths = null;
                            continue;
                        }
                        paths = new BomPaths(Tools.getBIS(data, (int)paths.forward));
                    }
                }
            }
            catch (IOException ex) {
                System.exit(1);
            }
            ++i;
        }
        return;
    }
}

