/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils;

import com.jpexs.jbomutils.BomFile;
import com.jpexs.jbomutils.BomHeader;
import com.jpexs.jbomutils.BomInfo;
import com.jpexs.jbomutils.BomInputStream;
import com.jpexs.jbomutils.BomPaths;
import com.jpexs.jbomutils.BomPointer;
import com.jpexs.jbomutils.BomTree;
import com.jpexs.jbomutils.BomVIndex;
import com.jpexs.jbomutils.BomVar;
import com.jpexs.jbomutils.Tools;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DumpBom {
    public static void print_paths(BomPaths paths, byte[] buffer, List<BomPointer> block_table, int id) {
        try {
            System.out.println("");
            System.out.println("path id=" + id);
            System.out.println("paths.isLeaf = " + paths.isLeaf);
            System.out.println("paths.count = " + paths.count);
            System.out.println("paths.forward = " + paths.forward);
            System.out.println("paths.backward = " + paths.backward);
            int i = 0;
            while ((long)i < paths.count) {
                BomPointer ptr = block_table.get((int)paths.indices.get((int)i).index1);
                BomFile file = new BomFile(Tools.getBIS(buffer, (int)ptr.address, (int)((long)buffer.length - ptr.address)));
                System.out.println("path.indices[" + i + "].index0 = " + paths.indices.get((int)i).index0);
                System.out.println("path.indices[" + i + "].index1.parent = " + file.parent);
                System.out.println("path.indices[" + i + "].index1.name = " + file.name);
                ++i;
            }
            if (paths.isLeaf == 0L) {
                BomPointer child_ptr = block_table.get((int)paths.indices.get((int)0).index0);
                BomPaths child_paths = new BomPaths(Tools.getBIS(buffer, (int)child_ptr.address, (int)((long)buffer.length - child_ptr.address)));
                DumpBom.print_paths(child_paths, buffer, block_table, (int)paths.indices.get((int)0).index0);
            }
            if (paths.forward > 0L) {
                BomPointer sibling_ptr = block_table.get((int)paths.forward);
                BomPaths sibling_paths = new BomPaths(Tools.getBIS(buffer, (int)sibling_ptr.address, (int)((long)buffer.length - sibling_ptr.address)));
                DumpBom.print_paths(sibling_paths, buffer, block_table, (int)paths.forward);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public static void print_tree(BomTree tree, byte[] buffer, List<BomPointer> block_table) {
        try {
            System.out.println("tree.tree = " + new String(tree.tree));
            System.out.println("tree.version = " + tree.version);
            System.out.println("tree.child = " + tree.child);
            System.out.println("tree.blockSize = " + tree.blockSize);
            System.out.println("tree.pathCount = " + tree.pathCount);
            System.out.println("tree.unknown3 = " + tree.unknown3);
            BomPointer child_ptr = block_table.get((int)tree.child);
            BomPaths paths = new BomPaths(Tools.getBIS(buffer, (int)child_ptr.address, (int)((long)buffer.length - child_ptr.address)));
            DumpBom.print_paths(paths, buffer, block_table, (int)tree.child);
        }
        catch (IOException ex) {
            Logger.getLogger(DumpBom.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void usage() {
        System.out.println("Usage: java -jar bomutils.jar dumpbom bomfile");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            DumpBom.usage();
            System.exit(1);
        }
        byte[] buffer = null;
        long file_length = 0L;
        File f = new File(args[0]);
        try (DataInputStream bom_file = new DataInputStream(new FileInputStream(f));){
            file_length = f.length();
            buffer = new byte[(int)file_length];
            bom_file.readFully(buffer);
        }
        catch (IOException ex) {
            System.err.println("Unable to read bomfile");
            System.exit(1);
        }
        System.out.println(args[0]);
        System.out.println("file_length = " + file_length);
        try {
            int i;
            System.out.println("Header:");
            System.out.println("-----------------------------------------------------");
            BomHeader header = new BomHeader(Tools.getBIS(buffer, 0, 32));
            ArrayList<BomPointer> block_table = new ArrayList<BomPointer>();
            BomInputStream bis = Tools.getBIS(buffer, (int)header.indexOffset, (int)((long)buffer.length - header.indexOffset));
            int blk_count = (int)bis.readUI32();
            for (int i2 = 0; i2 < blk_count; ++i2) {
                block_table.add(new BomPointer(bis));
            }
            int numberOfNonNullEntries = 0;
            for (int i3 = 0; i3 < block_table.size(); ++i3) {
                if (((BomPointer)block_table.get((int)i3)).address == 0L) continue;
                ++numberOfNonNullEntries;
            }
            System.out.println("magic = \"" + new String(header.magic) + "\"");
            System.out.println("version = " + header.version);
            System.out.println("numberOfBlocks = " + header.numberOfBlocks);
            System.out.println("indexOffset = " + header.indexOffset);
            System.out.println("indexLength = " + header.indexLength);
            System.out.println("varsOffset = " + header.varsOffset);
            System.out.println("varsLength = " + header.varsLength);
            System.out.println("(calculated number of blocks = " + numberOfNonNullEntries + ")");
            System.out.println();
            System.out.println("Index Table:");
            System.out.println("-----------------------------------------------------");
            System.out.println("numberOfBlockTableEntries = " + block_table.size());
            int free_list_pos = (int)(header.indexOffset + 4L + (long)(block_table.size() * 8));
            bis = Tools.getBIS(buffer, free_list_pos, buffer.length - free_list_pos);
            ArrayList<BomPointer> free_list = new ArrayList<BomPointer>();
            int numberOfFreeListPointers = (int)bis.readUI32();
            System.out.println();
            System.out.println("Free List:");
            System.out.println("-----------------------------------------------------");
            System.out.println("numberOfFreeListPointers = " + numberOfFreeListPointers);
            for (int i4 = 0; i4 < numberOfFreeListPointers; ++i4) {
                free_list.add(new BomPointer(bis));
            }
            System.out.println();
            System.out.println("Variables:");
            System.out.println("-----------------------------------------------------");
            ArrayList<BomVar> vars = new ArrayList<BomVar>();
            bis = Tools.getBIS(buffer, (int)header.varsOffset, (int)header.varsLength);
            int var_count = (int)bis.readUI32();
            int total_length = 0;
            total_length += 4;
            for (i = 0; i < var_count; ++i) {
                BomVar var = new BomVar(bis);
                vars.add(var);
                total_length += 4;
                total_length += var.name.getBytes().length + 1;
            }
            System.out.println("vars.count = " + vars.size());
            System.out.println("( calculated length = " + total_length + ")");
            for (i = 0; i < vars.size(); ++i) {
                if (i != 0) {
                    System.out.print(",");
                }
                System.out.print("\"" + ((BomVar)vars.get((int)i)).name + "\"");
            }
            System.out.println();
            for (int i5 = 0; i5 < var_count; ++i5) {
                BomVar var = (BomVar)vars.get(i5);
                String name = var.name;
                BomPointer ptr = (BomPointer)block_table.get((int)var.index);
                System.out.println();
                System.out.println("\"" + name + "\" (file offset: 0x" + Long.toHexString(ptr.address) + " length: " + ptr.length + " )");
                System.out.println("-----------------------------------------------------");
                if (name.equals("Paths") || name.equals("HLIndex") || name.equals("Size64")) {
                    BomTree tree = new BomTree(Tools.getBIS(buffer, (int)ptr.address, 21));
                    DumpBom.print_tree(tree, buffer, block_table);
                    continue;
                }
                if (name.equals("BomInfo")) {
                    BomInfo info = new BomInfo(Tools.getBIS(buffer, (int)ptr.address));
                    System.out.println("info.version = " + info.version);
                    System.out.println("info.numberOfPaths = " + info.numberOfPaths);
                    System.out.println("info.numberOfInfoEntries = " + info.entries.size());
                    for (int j = 0; j < info.entries.size(); ++j) {
                        System.out.println("info.entries[" + j + "].unknown0 = " + info.entries.get((int)j).unknown0);
                        System.out.println("info.entries[" + j + "].unknown1 = " + info.entries.get((int)j).unknown1);
                        System.out.println("info.entries[" + j + "].unknown2 = " + info.entries.get((int)j).unknown2);
                        System.out.println("info.entries[" + j + "].unknown3 = " + info.entries.get((int)j).unknown3);
                    }
                    continue;
                }
                if (name.equals("VIndex")) {
                    BomVIndex vindex = new BomVIndex(Tools.getBIS(buffer, (int)ptr.address));
                    System.out.println("vindex.unknown0 = " + vindex.unknown0);
                    System.out.println("vindex.indexToVTree = " + vindex.indexToVTree);
                    System.out.println("vindex.unknown2 = " + vindex.unknown2);
                    System.out.println("vindex.unknown3 = " + vindex.unknown3);
                    System.out.println();
                    BomPointer v_ptr = (BomPointer)block_table.get((int)vindex.indexToVTree);
                    BomTree tree = new BomTree(Tools.getBIS(buffer, (int)v_ptr.address));
                    DumpBom.print_tree(tree, buffer, block_table);
                    continue;
                }
                int j = 0;
                bis = Tools.getBIS(buffer, (int)ptr.address);
                while ((long)j < ptr.length / 4L) {
                    System.out.println("0x" + String.format("%08X", bis.readUI32()));
                    ++j;
                }
                j *= 4;
                while ((long)j < ptr.length) {
                    System.out.println("0x" + String.format("%02X", buffer[(int)(ptr.address + (long)j)]));
                    ++j;
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        System.exit(0);
    }
}

