/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.jbomutils;

import com.jpexs.jbomutils.BomHeader;
import com.jpexs.jbomutils.BomOutputStream;
import com.jpexs.jbomutils.BomPointer;
import com.jpexs.jbomutils.BomVar;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BomStorage {
    private long size_of_header = 512L;
    private BomHeader header = new BomHeader();
    private long size_of_vars = 4L;
    private long num_vars = 0L;
    private List<BomVar> vars;
    private long size_of_block_table = 4L + this.num_block_entries * 8L;
    private long num_block_entries = 1L;
    private List<BomPointer> block_table = new ArrayList<BomPointer>();
    private long size_of_free_list = 20L;
    private long num_free_list_entries = 0L;
    private List<BomPointer> free_list = new ArrayList<BomPointer>();
    private long entry_size = 0L;
    byte[] entries;

    public BomStorage() {
        this.vars = new ArrayList<BomVar>();
        this.header = new BomHeader();
        this.header.numberOfBlocks = 0L;
        this.header.indexOffset = this.size_of_header + this.size_of_vars + this.entry_size;
        this.header.indexLength = this.size_of_block_table + this.size_of_free_list;
        this.header.varsOffset = this.size_of_header;
        this.header.varsLength = this.size_of_vars;
        this.block_table.add(new BomPointer());
        this.block_table.get((int)0).address = 0L;
        this.block_table.get((int)0).length = 0L;
        this.vars = new ArrayList<BomVar>();
        for (int i = 0; i < 2; ++i) {
            this.free_list.add(new BomPointer());
            this.free_list.get((int)i).address = 0L;
            this.free_list.get((int)i).length = 0L;
        }
    }

    public byte[] getBlock(int id) {
        return Arrays.copyOfRange(this.entries, (int)this.block_table.get((int)id).address, (int)this.block_table.get((int)id).address + (int)this.block_table.get((int)id).length);
    }

    public int getBlockAddr(int id) {
        return (int)this.block_table.get((int)id).address;
    }

    public int getBlockLength(int id) {
        return (int)this.block_table.get((int)id).length;
    }

    public int addBlock(byte[] data, int length) {
        this.entries = this.entries == null ? new byte[length] : Arrays.copyOf(this.entries, length + (int)this.entry_size);
        for (int i = 0; i < length; ++i) {
            this.entries[(int)this.entry_size + i] = data[i];
        }
        this.size_of_block_table = 4L + (this.num_block_entries + 1L) * 8L;
        this.block_table.add(new BomPointer());
        this.block_table.get((int)((int)this.num_block_entries)).address = this.entry_size;
        this.block_table.get((int)((int)this.num_block_entries)).length = length;
        ++this.num_block_entries;
        this.entry_size += (long)length;
        ++this.header.numberOfBlocks;
        this.header.indexLength = this.size_of_block_table + this.size_of_free_list;
        return (int)this.num_block_entries - 1;
    }

    public void addVar(String name, byte[] data, int length) {
        int new_size = 5 + name.length();
        BomVar var = new BomVar();
        this.size_of_vars += (long)new_size;
        var.index = this.addBlock(data, length);
        var.name = name;
        this.vars.add(var);
        this.header.indexOffset = this.size_of_header + this.size_of_vars + this.entry_size;
        this.header.varsLength = this.size_of_vars;
    }

    public void write(OutputStream bom_file) throws IOException {
        BomOutputStream bos = new BomOutputStream(bom_file);
        bos.write(this.header);
        bos.writeUI32(this.vars.size());
        for (BomVar v : this.vars) {
            bos.write(v);
        }
        if (this.entries != null) {
            bos.write(this.entries, 0, (int)this.entry_size);
        }
        ArrayList temp = (ArrayList)((ArrayList)this.block_table).clone();
        for (int i = 0; i < temp.size(); ++i) {
            if (((BomPointer)temp.get((int)i)).length == 0L) continue;
            ((BomPointer)temp.get((int)i)).address = ((BomPointer)temp.get((int)i)).address + this.size_of_header + this.size_of_vars;
        }
        bos.writeUI32(temp.size());
        for (BomPointer t : temp) {
            bos.write(t);
        }
        bos.writeUI32(this.free_list.size() - 2);
        for (BomPointer f : this.free_list) {
            bos.write(f);
        }
    }
}

