/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.uploader;

import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Uploader {
    private static List<String> types = new ArrayList<String>();
    private static List<String> names = new ArrayList<String>();
    private static List<String> values = new ArrayList<String>();
    private static List<String> labels = new ArrayList<String>();

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("1");
            System.exit(1);
        }
        String charset = "UTF-8";
        String requestURL = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-field")) {
                types.add("field");
                names.add(args[i + 1]);
                values.add(args[i + 2]);
                labels.add("");
                i += 2;
            }
            if (args[i].equals("-emptyfield")) {
                types.add("field");
                names.add(args[i + 1]);
                values.add("");
                labels.add("");
                i += 2;
            }
            if (args[i].equals("-textarea")) {
                types.add("textarea");
                names.add(args[i + 1]);
                labels.add(args[i + 2]);
                values.add("");
                i += 2;
            }
            if (!args[i].equals("-file")) continue;
            types.add("file");
            names.add(args[i + 1]);
            values.add(args[i + 2]);
            labels.add("");
            i += 2;
        }
        ArrayList<JTextArea> texts = new ArrayList<JTextArea>();
        ArrayList<JLabel> textLabels = new ArrayList<JLabel>();
        ArrayList<Integer> textIndices = new ArrayList<Integer>();
        for (int i = 0; i < types.size(); ++i) {
            if (!types.get(i).equals("textarea")) continue;
            JTextArea t = new JTextArea();
            t.setPreferredSize(new Dimension(400, 100));
            texts.add(t);
            textLabels.add(new JLabel(labels.get(i)));
            textIndices.add(i);
        }
        if (!texts.isEmpty()) {
            JPanel pan = new JPanel();
            pan.setLayout(new BoxLayout(pan, 1));
            for (int i = 0; i < texts.size(); ++i) {
                ((JLabel)textLabels.get(i)).setAlignmentX(0.0f);
                pan.add((Component)textLabels.get(i));
                ((JTextArea)texts.get(i)).setAlignmentX(0.0f);
                pan.add((Component)texts.get(i));
            }
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (JOptionPane.showConfirmDialog(null, pan, "Enter values", 2, -1) != 0) {
                System.exit(1);
            }
            for (int i = 0; i < texts.size(); ++i) {
                int index = (Integer)textIndices.get(i);
                types.set(index, "field");
                values.set(index, ((JTextArea)texts.get(i)).getText());
            }
        }
        try {
            MultipartUtility multipart = new MultipartUtility(requestURL, charset);
            for (int i = 0; i < types.size(); ++i) {
                if (types.get(i).equals("field")) {
                    multipart.addFormField(names.get(i), values.get(i));
                }
                if (!types.get(i).equals("file")) continue;
                multipart.addFilePart(names.get(i), new File(values.get(i)));
            }
            ArrayList<String> response = new ArrayList<String>();
            boolean ok = multipart.finish(response);
            for (String line : response) {
                if (ok) {
                    System.out.println(line);
                    continue;
                }
                System.err.println(line);
            }
            System.exit(ok ? 0 : 1);
        }
        catch (IOException ex) {
            System.exit(1);
        }
    }

    private static class MultipartUtility {
        private final String boundary;
        private static final String LINE_FEED = "\r\n";
        private HttpURLConnection httpConn;
        private String charset;
        private OutputStream outputStream;
        private PrintWriter writer;

        public MultipartUtility(String requestURL, String charset) throws IOException {
            this.charset = charset;
            this.boundary = Long.toHexString(System.currentTimeMillis());
            URL url = new URL(requestURL);
            this.httpConn = (HttpURLConnection)url.openConnection();
            this.httpConn.setUseCaches(false);
            this.httpConn.setDoOutput(true);
            this.httpConn.setDoInput(true);
            this.httpConn.setRequestProperty("User-Agent", "JPEXS Uploader");
            this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
            this.outputStream = this.httpConn.getOutputStream();
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
        }

        public void addFormField(String name, String value) {
            this.writer.append("--" + this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
            this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.append(value).append(LINE_FEED);
            this.writer.flush();
        }

        public void addFilePart(String fieldName, File uploadFile) throws IOException {
            String fileName = uploadFile.getName();
            this.writer.append("--" + this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
            this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
            this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.flush();
            FileInputStream inputStream = new FileInputStream(uploadFile);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
            }
            this.outputStream.flush();
            inputStream.close();
            this.writer.append(LINE_FEED);
            this.writer.flush();
        }

        public boolean finish(List<String> response) throws IOException {
            response.clear();
            this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
            this.writer.close();
            int status = this.httpConn.getResponseCode();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.add(line);
            }
            reader.close();
            this.httpConn.disconnect();
            return status == 200;
        }
    }
}

