/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.flamingo.ribbon.ui.RibbonBorderShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.colorscheme.ShiftColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class RibbonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> imageCache = new LazyResettableHashMap("Substance.Flamingo.RibbonBackgroundDelegate");

    private static synchronized BufferedImage getTaskToggleButtonBackground(JRibbonTaskToggleButton button, int width, int height) {
        JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, (Component)button);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)button.getUI();
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        ComponentState currState = ComponentState.getState((ButtonModel)button.getActionModel(), (JComponent)button);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map activeStates = modelStateInfo.getStateContributionMap();
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)button);
        SubstanceColorScheme baseFillScheme = skin.getColorScheme((Component)button, ColorSchemeAssociationKind.TAB, currState);
        SubstanceColorScheme baseBorderScheme = skin.getColorScheme((Component)ribbon, ColorSchemeAssociationKind.TAB_BORDER, currState);
        SubstanceFillPainter fillPainter = skin.getFillPainter();
        SubstanceBorderPainter borderPainter = skin.getBorderPainter();
        JRibbon parent = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, (Component)button);
        RibbonTask selectedTask = parent.getSelectedTask();
        AbstractRibbonBand band = selectedTask.getBandCount() == 0 ? null : selectedTask.getBand(0);
        Color bgColor = band != null ? band.getBackground() : parent.getBackground();
        HashMapKey baseKey = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), button.getParent().getBackground().getRGB(), button.getActionModel().isSelected(), button.getContextualGroupHueColor(), button.getActionModel().isSelected(), ribbon.isMinimized(), skin.getSelectedTabFadeStart(), skin.getSelectedTabFadeEnd(), bgColor});
        BufferedImage baseLayer = (BufferedImage)imageCache.get(baseKey);
        if (baseLayer == null) {
            baseLayer = RibbonBackgroundDelegate.getSingleLayer(button, width, height, ribbon, baseFillScheme, baseBorderScheme, fillPainter, borderPainter);
            imageCache.put(baseKey, (Object)baseLayer);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)baseLayer, 0, 0, null);
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState == currState || (contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)button, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.TAB, (ComponentState)activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)ribbon, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.TAB_BORDER, (ComponentState)activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), button.getParent().getBackground().getRGB(), button.getActionModel().isSelected(), button.getContextualGroupHueColor(), button.getActionModel().isSelected(), ribbon.isMinimized(), skin.getSelectedTabFadeStart(), skin.getSelectedTabFadeEnd(), bgColor});
            BufferedImage layer = (BufferedImage)imageCache.get(key);
            if (layer == null) {
                layer = RibbonBackgroundDelegate.getSingleLayer(button, width, height, ribbon, fillScheme, borderScheme, fillPainter, borderPainter);
                imageCache.put(key, (Object)layer);
            }
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            g2d.drawImage((Image)layer, 0, 0, null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getSingleLayer(JRibbonTaskToggleButton button, int width, int height, JRibbon ribbon, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter) {
        HashSet<SubstanceConstants.Side> bottom = new HashSet<SubstanceConstants.Side>();
        bottom.add(SubstanceConstants.Side.BOTTOM);
        Color contextualGroupHueColor = button.getContextualGroupHueColor();
        if (contextualGroupHueColor != null) {
            fillScheme = ShiftColorScheme.getShiftedScheme((SubstanceColorScheme)fillScheme, (Color)contextualGroupHueColor, (double)0.25, null, (double)0.0);
        }
        float radius = RibbonBorderShaper.getRibbonToggleButtonRadius((JComponent)button);
        int borderDelta = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)button)));
        int borderInsets = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)button)) / 2.0);
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((int)width, (int)(height + 2 + borderDelta), (float)radius, bottom, (int)borderInsets);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)width, (int)(height + 2));
        Graphics2D graphics = result.createGraphics();
        fillPainter.paintContourBackground((Graphics)graphics, (Component)button, width, height + 2 + borderDelta, (Shape)contour, false, fillScheme, true);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth((int)SubstanceSizeUtils.getComponentFontSize((Component)button));
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline((int)width, (int)(height + 2 + borderDelta), (float)radius, bottom, (int)(borderThickness + borderInsets));
        borderPainter.paintBorder((Graphics)graphics, (Component)button, width, height + 2, (Shape)contour, (Shape)contourInner, borderScheme);
        graphics.dispose();
        if (button.getActionModel().isSelected() && button.getContextualGroupHueColor() == null) {
            AbstractRibbonBand band;
            int fw = result.getWidth();
            int fh = result.getHeight();
            BufferedImage fade = SubstanceCoreUtilities.getBlankImage((int)fw, (int)fh);
            Graphics2D fadeGraphics = fade.createGraphics();
            JRibbon parent = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, (Component)button);
            RibbonTask selectedTask = parent.getSelectedTask();
            AbstractRibbonBand abstractRibbonBand = band = selectedTask.getBandCount() == 0 ? null : selectedTask.getBand(0);
            if (band != null) {
                fadeGraphics.setColor(band.getBackground());
            } else {
                fadeGraphics.setColor(parent.getBackground());
            }
            fadeGraphics.fillRect(0, 0, fw, fh);
            SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)button);
            if (skin.getWatermark() != null) {
                skin.getWatermark().drawWatermarkImage((Graphics)fadeGraphics, (Component)button, 0, 0, fw, fh);
            }
            borderPainter.paintBorder((Graphics)fadeGraphics, (Component)button, width, height + 2, (Shape)contour, (Shape)contourInner, borderScheme);
            result = SubstanceCoreUtilities.blendImagesVertical((BufferedImage)result, (BufferedImage)fade, (double)skin.getSelectedTabFadeStart(), (double)skin.getSelectedTabFadeEnd());
        }
        return result;
    }

    public void updateTaskToggleButtonBackground(Graphics g, JRibbonTaskToggleButton button) {
        Graphics2D g2d = (Graphics2D)g.create();
        int width = button.getWidth();
        int height = button.getHeight();
        BufferedImage ribbonBackground = RibbonBackgroundDelegate.getTaskToggleButtonBackground(button, width, height);
        TransitionAwareUI ui = (TransitionAwareUI)button.getUI();
        StateTransitionTracker stateTransitionTracker = ui.getTransitionTracker();
        float extraActionAlpha = 0.0f;
        for (Map.Entry activeEntry : stateTransitionTracker.getModelStateInfo().getStateContributionMap().entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
            extraActionAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
        }
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)button, (float)extraActionAlpha, (Graphics)g));
        g2d.drawImage((Image)ribbonBackground, 0, 0, null);
        g2d.dispose();
    }
}

