/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.flamingo.common.ui.SubstanceCommandToggleButtonUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceCommandToggleMenuButtonUI
extends SubstanceCommandToggleButtonUI {
    protected Set lafWidgets;

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installComponents() {
        super.installComponents();
    }

    @Override
    protected void installComponents() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installListeners() {
        super.installListeners();
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installDefaults() {
        super.installDefaults();
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    protected void uninstallComponents() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleMenuButtonUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceCommandToggleMenuButtonUI();
    }

    @Override
    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        SubstanceColorScheme fillScheme;
        ComponentState currState;
        boolean isSelected = this.commandButton.getActionModel().isSelected();
        if (isSelected) {
            Graphics2D g2d = (Graphics2D)g.create();
            Rectangle extended = new Rectangle(iconRect.x - 1, iconRect.y - 1, iconRect.width + 1, iconRect.height + 1);
            currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
            fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)this.commandButton);
            fillPainter.paintContourBackground((Graphics)g2d, (Component)this.commandButton, extended.width, extended.height, (Shape)extended, false, fillScheme, false);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)currState);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.commandButton);
            borderPainter.paintBorder((Graphics)g2d, (Component)this.commandButton, extended.width, extended.height, (Shape)extended, null, borderScheme);
            g2d.dispose();
        }
        super.paintButtonIcon(g, iconRect);
        Icon iconToPaint = this.getIconToPaint();
        if (isSelected && iconToPaint == null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
            fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            g2d.setColor(fillScheme.getForegroundColor());
            int iw = iconRect.width;
            int ih = iconRect.height;
            GeneralPath path = new GeneralPath();
            path.moveTo(0.2f * (float)iw, 0.5f * (float)ih);
            path.lineTo(0.42f * (float)iw, 0.8f * (float)ih);
            path.lineTo(0.8f * (float)iw, 0.2f * (float)ih);
            g2d.translate(iconRect.x, iconRect.y);
            BasicStroke stroke = new BasicStroke(0.12f * (float)iw, 1, 1);
            g2d.setStroke(stroke);
            g2d.draw(path);
            g2d.dispose();
        }
    }

    @Override
    protected boolean isPaintingBackground() {
        boolean isActionRollover = this.commandButton.getActionModel().isRollover();
        if (isActionRollover || !this.commandButton.isFlat()) {
            return true;
        }
        return this.getActionTransitionTracker().getFacetStrength(ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected Color getForegroundColor(StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)modelStateInfo.getCurrModelState());
            fgColor = SubstanceCommandToggleMenuButtonUI.getMenuButtonForegroundColor(this.commandButton, modelStateInfo);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
        }
        return fgColor;
    }

    private static Color getMenuButtonForegroundColor(AbstractCommandButton menuButton, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        Map activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        ColorSchemeAssociationKind currAssocKind = ColorSchemeAssociationKind.FILL;
        if (!currState.isDisabled() && currState != ComponentState.ENABLED && !currState.isFacetActive(ComponentStateFacet.ROLLOVER)) {
            currAssocKind = ColorSchemeAssociationKind.HIGHLIGHT;
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (ColorSchemeAssociationKind)currAssocKind, (ComponentState)currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            float alpha = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
            ColorSchemeAssociationKind assocKind = ColorSchemeAssociationKind.FILL;
            if (!activeState.isDisabled() && activeState != ComponentState.ENABLED && !activeState.isFacetActive(ComponentStateFacet.ROLLOVER)) {
                assocKind = ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (ColorSchemeAssociationKind)assocKind, (ComponentState)activeState);
            Color activeForeground = activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }
}

