/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import org.apache.ant.compress.resources.CommonsCompressArchiveScanner;
import org.apache.ant.compress.resources.CommonsCompressFileSet;
import org.apache.ant.compress.resources.TarResource;
import org.apache.ant.compress.util.TarStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;

public class TarFileSet
extends CommonsCompressFileSet {
    private boolean userNameSet;
    private boolean groupNameSet;
    private String userName = "";
    private String groupName = "";

    public TarFileSet() {
    }

    protected TarFileSet(FileSet fileset) {
        super(fileset);
    }

    protected TarFileSet(TarFileSet fileset) {
        super(fileset);
    }

    protected TarFileSet(CommonsCompressFileSet fileset) {
        super(fileset);
    }

    public void setUserName(String userName) {
        this.checkCommonsCompressFileSetAttributesAllowed();
        this.userNameSet = true;
        this.userName = userName;
    }

    public String getUserName() {
        if (this.isReference()) {
            return ((TarFileSet)((Object)this.getCheckedRef())).getUserName();
        }
        return this.userName;
    }

    public boolean hasUserNameBeenSet() {
        return this.userNameSet;
    }

    public void setGroup(String groupName) {
        this.checkCommonsCompressFileSetAttributesAllowed();
        this.groupNameSet = true;
        this.groupName = groupName;
    }

    public String getGroup() {
        if (this.isReference()) {
            return ((TarFileSet)((Object)this.getCheckedRef())).getGroup();
        }
        return this.groupName;
    }

    public boolean hasGroupBeenSet() {
        return this.groupNameSet;
    }

    protected ArchiveScanner newArchiveScanner() {
        CommonsCompressArchiveScanner cs = new CommonsCompressArchiveScanner(new TarStreamFactory(), new CommonsCompressArchiveScanner.ResourceBuilder(){

            public Resource buildResource(Resource archive, String encoding, ArchiveEntry entry) {
                return new TarResource(archive, encoding, (TarArchiveEntry)entry);
            }
        }, this.getSkipUnreadableEntries(), this.getProject());
        cs.setEncoding(this.getEncoding());
        return cs;
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.userNameSet || this.groupNameSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected void configureFileSet(ArchiveFileSet zfs) {
        super.configureFileSet(zfs);
        if (zfs instanceof TarFileSet) {
            TarFileSet tfs = (TarFileSet)zfs;
            tfs.setUserName(this.userName);
            tfs.setGroup(this.groupName);
        }
    }

    protected CommonsCompressFileSet newFileSet(FileSet fs) {
        if (fs instanceof TarFileSet) {
            return new TarFileSet((TarFileSet)fs);
        }
        if (fs instanceof CommonsCompressFileSet) {
            return new TarFileSet((CommonsCompressFileSet)fs);
        }
        return new TarFileSet(fs);
    }
}

