/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.javactivex.example;

import com.jpexs.javactivex.ActiveX;
import com.jpexs.javactivex.Reference;
import com.jpexs.javactivex.example.controls.browser.WebBrowser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class WebBrowserExample
extends Frame {
    private WebBrowser browser;
    private final Panel axPanel = new Panel();

    public WebBrowserExample() {
        this.setSize(800, 600);
        this.setTitle("Sample ActiveX Component in Java - WebBrowser");
        this.setLayout(new BorderLayout());
        this.browser = ActiveX.createObject(WebBrowser.class, this.axPanel);
        this.add((Component)this.axPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Panel controlsPanel = new Panel(new BorderLayout());
        Button testButton = new Button("Test");
        Button goButton = new Button("GO!");
        final TextField tf = new TextField("http://www.google.com/");
        final ActionListener navAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebBrowserExample.this.browser.Navigate(tf.getText());
            }
        };
        tf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    navAction.actionPerformed(null);
                }
            }
        });
        testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Reference<Integer> i1 = new Reference<Integer>(800);
                Reference<Integer> i2 = new Reference<Integer>(600);
                System.out.println("exec");
                WebBrowserExample.this.browser.ClientToWindow(i1, i2);
                System.out.println("i1:" + i1);
                System.out.println("i2:" + i2);
            }
        });
        controlsPanel.add((Component)tf, "Center");
        controlsPanel.add((Component)testButton, "West");
        controlsPanel.add((Component)goButton, "East");
        controlsPanel.setBackground(Color.YELLOW);
        this.add((Component)controlsPanel, "North");
        goButton.addActionListener(navAction);
    }

    public static void main(String[] args) {
        new WebBrowserExample().setVisible(true);
    }
}

