/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.streams;

import com.jpexs.flash.fla.converter.streams.InputStorageInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DirectoryInputStorage
implements InputStorageInterface {
    private final File inputDirectory;

    public DirectoryInputStorage(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    @Override
    public InputStream readFile(String fileName) throws IOException {
        if (!this.inputDirectory.toPath().resolve(fileName).toFile().exists()) {
            return null;
        }
        return new FileInputStream(this.inputDirectory.toPath().resolve(fileName).toFile());
    }

    @Override
    public boolean fileExists(String fileName) {
        return this.inputDirectory.toPath().resolve(fileName).toFile().exists();
    }

    @Override
    public void close() throws Exception {
    }
}

