/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.streams;

import com.jpexs.cfb.CompoundFileBinary;
import com.jpexs.flash.fla.converter.streams.OutputStorageInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class CfbOutputStorage
implements OutputStorageInterface {
    private CompoundFileBinary cfb;

    public CfbOutputStorage(File cfbFile) throws IOException {
        this.cfb = new CompoundFileBinary(cfbFile, true);
    }

    @Override
    public OutputStream getOutputStream(final String fileName) throws IOException {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return new OutputStream(){
            private boolean closed = false;

            @Override
            public void write(int b) throws IOException {
                baos.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                baos.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                baos.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    CfbOutputStorage.this.cfb.addFile(fileName, baos.toByteArray());
                }
                this.closed = true;
            }
        };
    }

    @Override
    public void storeData(String fileName, byte[] data) throws IOException {
        this.cfb.addFile(fileName, data);
    }

    @Override
    public void storeFile(String fileName, File file) throws IOException {
        this.cfb.addFile(fileName, file);
    }

    @Override
    public void close() throws Exception {
        this.cfb.close();
    }
}

