/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.cfb;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DirectoryEntry
implements Comparable<DirectoryEntry> {
    public long fileOffset;
    public long directorySector;
    public long streamId;
    public String name;
    public int objectType;
    public int colorFlag;
    public long leftSiblingId;
    public long rightSiblingId;
    public long childId;
    public byte[] clsId;
    public long stateBits;
    public Date creationTime;
    public Date modifiedTime;
    public long startingSectorLocation;
    public long streamSize;

    public DirectoryEntry(long fileOffset, long directorySector, long streamId, String name, int objectType, int colorFlag, long leftSiblingId, long rightSiblingId, long childId, byte[] clsId, long stateBits, Date creationTime, Date modifiedTime, long startingSectorLocation, long streamSize) {
        this.fileOffset = fileOffset;
        this.directorySector = directorySector;
        this.streamId = streamId;
        this.name = name;
        this.objectType = objectType;
        this.colorFlag = colorFlag;
        this.leftSiblingId = leftSiblingId;
        this.rightSiblingId = rightSiblingId;
        this.childId = childId;
        this.clsId = clsId;
        this.stateBits = stateBits;
        this.creationTime = creationTime;
        this.modifiedTime = modifiedTime;
        this.startingSectorLocation = startingSectorLocation;
        this.streamSize = streamSize;
    }

    public String getFilename() {
        String fileName = "";
        for (int n = 0; n < this.name.length(); ++n) {
            char c = this.name.charAt(n);
            fileName = c < ' ' ? fileName + "[" + c + "]" : fileName + c;
        }
        return fileName;
    }

    public String toString() {
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String objectTypeStr = "";
        switch (this.objectType) {
            case 0: {
                objectTypeStr = "unknown";
                break;
            }
            case 1: {
                objectTypeStr = "storage_object";
                break;
            }
            case 2: {
                objectTypeStr = "stream_object";
                break;
            }
            case 5: {
                objectTypeStr = "root_storage_object";
            }
        }
        String colorStr = this.colorFlag == 1 ? "black" : "red";
        return "" + this.streamId + ": \"" + this.getFilename() + "\" - type " + objectTypeStr + ", color " + colorStr + ", leftSibling " + this.streamIdToString(this.leftSiblingId) + ", rightSibling " + this.streamIdToString(this.rightSiblingId) + ", child " + this.streamIdToString(this.childId) + ", sector " + this.startingSectorLocation + ", size: " + this.streamSize + ", created " + (this.creationTime == null ? "-" : sdt.format(this.creationTime)) + ", modified " + (this.modifiedTime == null ? "-" : sdt.format(this.modifiedTime));
    }

    private String streamIdToString(long streamId) {
        if (streamId == 0xFFFFFFFFL) {
            return "NOSTREAM";
        }
        return "" + streamId;
    }

    @Override
    public int compareTo(DirectoryEntry entry) {
        int lenDelta = this.name.length() - entry.name.length();
        if (lenDelta != 0) {
            return lenDelta;
        }
        return this.name.toUpperCase().compareTo(entry.name.toUpperCase());
    }
}

