/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.extractor;

import com.jpexs.cfb.CompoundFileBinary;
import com.jpexs.cfb.DirectoryEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlaCfbExtractor {
    public static void initLog() {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT %1$tL] [%4$-7s] %5$s %n");
        FlaCfbExtractor.setLoggingLevel(Level.FINE);
    }

    public static void setLoggingLevel(Level targetLevel) {
        Logger root = Logger.getLogger("");
        root.setLevel(targetLevel);
        for (Handler handler : root.getHandlers()) {
            handler.setLevel(targetLevel);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            return;
        }
        String inputDir = args[0];
        for (File file : new File(inputDir).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".fla");
            }
        })) {
            System.out.println("========== Extracting " + file);
            CompoundFileBinary cfb = new CompoundFileBinary(file);
            String outDir = inputDir + "/" + file.getName().replace(".fla", "") + "/";
            new File(outDir).mkdir();
            for (DirectoryEntry de : cfb.getDirectoryEntries()) {
                int cnt;
                System.out.println("" + de);
                if (de.objectType != 2) continue;
                InputStream is = cfb.getEntryStream(de);
                String outFile = outDir + de.getFilename();
                FileOutputStream fos = new FileOutputStream(outFile);
                byte[] buf = new byte[4096];
                while ((cnt = is.read(buf)) > 0) {
                    fos.write(buf, 0, cnt);
                }
                fos.close();
            }
            cfb.close();
        }
    }
}

