/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.streams;

import com.jpexs.flash.fla.converter.streams.OutputStorageInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class DirectoryOutputStorage
implements OutputStorageInterface {
    private final File outputDir;

    public DirectoryOutputStorage(File outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public OutputStream getOutputStream(String fileName) throws IOException {
        return new FileOutputStream(this.outputDir.toPath().resolve(fileName).toFile());
    }

    @Override
    public void storeData(String fileName, byte[] data) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.outputDir.toPath().resolve(fileName).toFile());){
            fos.write(data);
        }
    }

    @Override
    public void storeFile(String fileName, File file) throws IOException {
        Files.copy(file.toPath(), this.outputDir.toPath().resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void close() throws Exception {
    }
}

