/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.filters;

import com.jpexs.flash.fla.converter.FlaWriter;
import com.jpexs.flash.fla.converter.filters.FilterInterface;
import java.awt.Color;
import java.io.IOException;

public class BevelFilter
implements FilterInterface {
    private float blurX = 5.0f;
    private float blurY = 5.0f;
    private float strength = 1.0f;
    private int quality = 1;
    private Color shadowColor = Color.black;
    private Color highlightColor = Color.white;
    private float angle = 45.0f;
    private float distance = 5.0f;
    private boolean knockout = false;
    private int type = 1;
    private boolean enabled = true;
    public static final int TYPE_INNER = 1;
    public static final int TYPE_OUTER = 2;
    public static final int TYPE_FULL = 3;

    public BevelFilter(float blurX, float blurY, float strength, int quality, Color shadowColor, Color highlightColor, float angle, float distance, boolean knockout, int type, boolean enabled) {
        this.blurX = blurX;
        this.blurY = blurY;
        this.strength = strength;
        this.quality = quality;
        this.shadowColor = shadowColor;
        this.highlightColor = highlightColor;
        this.angle = angle;
        this.distance = distance;
        this.knockout = knockout;
        this.type = type;
        this.enabled = enabled;
    }

    public float getBlurX() {
        return this.blurX;
    }

    public float getBlurY() {
        return this.blurY;
    }

    public float getStrength() {
        return this.strength;
    }

    public int getQuality() {
        return this.quality;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDistance() {
        return this.distance;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void write(FlaWriter os) throws IOException {
        os.write(new byte[]{3, 3, 4, 1, (byte)(this.enabled ? 1 : 0), 0, 0, 0, (byte)this.shadowColor.getRed(), (byte)this.shadowColor.getGreen(), (byte)this.shadowColor.getBlue(), (byte)this.shadowColor.getAlpha()});
        os.writeFloat(this.distance);
        os.writeFloat(this.blurX);
        os.writeFloat(this.blurY);
        os.writeFloat((float)((double)this.angle * 3.1415927410125732 / 180.0));
        int strengthPercent = Math.round(this.strength * 100.0f);
        os.write(new byte[]{(byte)(this.type == 1 ? 1 : 0), 0, 0, 0, (byte)(this.knockout ? 1 : 0), 0, 0, 0, (byte)this.quality, 0, 0, 0, (byte)(strengthPercent & 0xFF), (byte)(strengthPercent >> 8 & 0xFF), 0, 0, 0, 0, 0, 0, (byte)this.highlightColor.getRed(), (byte)this.highlightColor.getGreen(), (byte)this.highlightColor.getBlue(), (byte)this.highlightColor.getAlpha(), (byte)(this.type == 3 ? 1 : 0), 0, 0, 0});
    }
}

