/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter;

import com.jpexs.flash.fla.converter.AbstractConverter;
import com.jpexs.flash.fla.converter.FlaFormatVersion;
import com.jpexs.flash.fla.converter.FlaWriter;
import com.jpexs.flash.fla.converter.GradientEntry;
import com.jpexs.flash.fla.converter.Matrix;
import com.jpexs.flash.fla.converter.coloreffects.AdvancedColorEffect;
import com.jpexs.flash.fla.converter.coloreffects.AlphaColorEffect;
import com.jpexs.flash.fla.converter.coloreffects.BrightnessColorEffect;
import com.jpexs.flash.fla.converter.coloreffects.ColorEffectInterface;
import com.jpexs.flash.fla.converter.coloreffects.NoColorEffect;
import com.jpexs.flash.fla.converter.coloreffects.TintColorEffect;
import com.jpexs.flash.fla.converter.filters.AdjustColorFilter;
import com.jpexs.flash.fla.converter.filters.BevelFilter;
import com.jpexs.flash.fla.converter.filters.BlurFilter;
import com.jpexs.flash.fla.converter.filters.DropShadowFilter;
import com.jpexs.flash.fla.converter.filters.FilterInterface;
import com.jpexs.flash.fla.converter.filters.GlowFilter;
import com.jpexs.flash.fla.converter.filters.GradientBevelFilter;
import com.jpexs.flash.fla.converter.filters.GradientGlowFilter;
import com.jpexs.helpers.Reference;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TimelineConverter
extends AbstractConverter {
    private static final Pattern CUBICS_PATTERN = Pattern.compile("^!(?<mx>[0-9]+) +(?<my>[0-9]+) *\\(((?<pBCPx>[0-9]+) *, *(?<pBCPy>[0-9]+))? *; *(?<x1>[0-9]+),(?<y1>[0-9]+) +(?<x2>[0-9]+),(?<y2>[0-9]+) +(?<ex>[0-9]+),(?<ey>[0-9]+) *(?<xy>([QqPp]? *[0-9]+ +[0-9]+)+) *\\)((?<nBCPx>[0-9]+) *, *(?<nBCPy>[0-9]+))? *; *$");
    private static final Pattern CUBICS_XY_PATTERN = Pattern.compile("(?<letter>[QqPp]?) *(?<x>[0-9]+) +(?<y>[0-9]+)");
    private final String title;
    static int textCount = 0;

    public TimelineConverter(FlaFormatVersion flaFormatVersion, String title) {
        super(flaFormatVersion);
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    private void handleFill(Element fillStyleVal, Element document, FlaWriter fg) throws IOException {
        block6 : switch (fillStyleVal.getNodeName()) {
            case "SolidColor": {
                Color color = this.parseColorWithAlpha(fillStyleVal);
                fg.writeSolidFill(color);
                break;
            }
            case "LinearGradient": 
            case "RadialGradient": {
                Node focalPointRatioAttr;
                Matrix gradientMatrix = this.parseMatrix(this.getSubElementByName(fillStyleVal, "matrix"));
                double focalPointRatio = 0.0;
                if ("RadialGradient".equals(fillStyleVal.getNodeName()) && (focalPointRatioAttr = fillStyleVal.getAttributes().getNamedItem("focalPointRatio")) != null) {
                    focalPointRatio = Double.parseDouble(focalPointRatioAttr.getTextContent());
                }
                List<Element> gradientEntries = this.getAllSubElementsByName(fillStyleVal, "GradientEntry");
                Color[] colors = new Color[gradientEntries.size()];
                double[] ratios = new double[gradientEntries.size()];
                for (int en = 0; en < gradientEntries.size(); ++en) {
                    Element gradientEntry = gradientEntries.get(en);
                    colors[en] = this.parseColorWithAlpha(gradientEntry);
                    double ratio = 0.0;
                    if (gradientEntry.hasAttribute("ratio")) {
                        ratio = Double.parseDouble(gradientEntry.getAttribute("ratio"));
                    }
                    ratios[en] = ratio;
                }
                boolean linearRGB = false;
                Node interpolationMethodAttr = fillStyleVal.getAttributes().getNamedItem("interpolationMethod");
                if (interpolationMethodAttr != null && "linearRGB".equals(interpolationMethodAttr.getTextContent())) {
                    linearRGB = true;
                }
                int spreadMethod = 0;
                Node spreadMethodAttr = fillStyleVal.getAttributes().getNamedItem("spreadMethod");
                if (spreadMethodAttr != null) {
                    if ("reflect".equals(spreadMethodAttr.getTextContent())) {
                        spreadMethod = 4;
                    }
                    if ("repeat".equals(spreadMethodAttr.getTextContent())) {
                        spreadMethod = 8;
                    }
                }
                int type = 16;
                if ("RadialGradient".equals(fillStyleVal.getNodeName())) {
                    type = 18;
                }
                fg.writeGradientFill(colors, ratios, type, linearRGB, spreadMethod, gradientMatrix, focalPointRatio);
                break;
            }
            case "BitmapFill": {
                Node bitmapPathAttr = fillStyleVal.getAttributes().getNamedItem("bitmapPath");
                if (bitmapPathAttr == null) break;
                String bitmapPath = bitmapPathAttr.getTextContent();
                List<Element> mediaElements = this.getMedia(document);
                int mediaId = 0;
                for (Element e : mediaElements) {
                    boolean allowSmoothing;
                    String name;
                    ++mediaId;
                    if (!"DOMBitmapItem".equals(e.getNodeName()) || (name = e.getAttribute("name")) == null || !bitmapPath.equals(name)) continue;
                    Matrix bitmapMatrix = this.parseMatrix(this.getSubElementByName(fillStyleVal, "matrix"));
                    boolean bitmapIsClipped = false;
                    Node bitmapIsClippedAttr = fillStyleVal.getAttributes().getNamedItem("bitmapIsClipped");
                    if (bitmapIsClippedAttr != null) {
                        bitmapIsClipped = "true".equals(bitmapIsClippedAttr.getTextContent());
                    }
                    int type = (allowSmoothing = "true".equals(e.getAttribute("allowSmoothing"))) ? (bitmapIsClipped ? 65 : 64) : (bitmapIsClipped ? 67 : 66);
                    fg.writeBitmapFill(type, bitmapMatrix, mediaId);
                    break block6;
                }
                break;
            }
        }
    }

    private List<GradientEntry> parseGradientEntries(Element element) {
        ArrayList<GradientEntry> ret = new ArrayList<GradientEntry>();
        List<Element> entries = this.getAllSubElementsByName(element, "GradientEntry");
        for (Element entry : entries) {
            Color color = this.parseColorWithAlpha(entry);
            float ratio = 0.0f;
            if (entry.hasAttribute("ratio")) {
                ratio = Float.parseFloat(entry.getAttribute("ratio"));
            }
            ret.add(new GradientEntry(color, ratio));
        }
        return ret;
    }

    protected void handleVideoInstance(Element videoInstance, Element document, FlaWriter fg, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount) throws IOException {
        this.useClass("CPicVideoStream", fg, definedClasses, totalObjectCount);
        fg.write(this.flaFormatVersion.getVideoStreamVersion());
        this.instanceHeader(videoInstance, fg, this.flaFormatVersion.getVideoType(), true);
        long frameLeft = 0L;
        if (videoInstance.hasAttribute("frameLeft")) {
            frameLeft = Long.parseLong(videoInstance.getAttribute("frameLeft"));
        }
        long frameRight = 0L;
        if (videoInstance.hasAttribute("frameRight")) {
            frameRight = Long.parseLong(videoInstance.getAttribute("frameRight"));
        }
        long frameTop = 0L;
        if (videoInstance.hasAttribute("frameTop")) {
            frameTop = Long.parseLong(videoInstance.getAttribute("frameTop"));
        }
        long frameBottom = 0L;
        if (videoInstance.hasAttribute("frameBottom")) {
            frameBottom = Long.parseLong(videoInstance.getAttribute("frameBottom"));
        }
        String name = "";
        if (videoInstance.hasAttribute("name")) {
            name = videoInstance.getAttribute("name");
        }
        String libraryItemName = videoInstance.getAttribute("libraryItemName");
        List<Element> mediaItems = this.getMedia(document);
        int videoId = 0;
        for (int i = 0; i < mediaItems.size(); ++i) {
            Element mediaItem = mediaItems.get(i);
            if (!"DOMVideoItem".equals(mediaItem.getTagName()) || !mediaItem.hasAttribute("name") || !libraryItemName.equals(mediaItem.getAttribute("name"))) continue;
            videoId = i + 1;
            break;
        }
        fg.writeUI32(frameLeft);
        fg.writeUI32(frameRight);
        fg.writeUI32(frameTop);
        fg.writeUI32(frameBottom);
        fg.write(0);
        fg.writeBomString("");
        fg.writeBomString(name);
        fg.write(1, 0, 0, 0);
        fg.writeUI16(videoId);
    }

    protected void handleBitmapInstance(Element bitmapInstance, Element document, FlaWriter fg, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount) throws IOException {
        if (!bitmapInstance.hasAttribute("libraryItemName")) {
            return;
        }
        String libraryItemName = bitmapInstance.getAttribute("libraryItemName");
        List<Element> mediaItems = this.getMedia(document);
        int bitmapId = 0;
        for (int i = 0; i < mediaItems.size(); ++i) {
            Element mediaItem = mediaItems.get(i);
            if (!"DOMBitmapItem".equals(mediaItem.getTagName()) || !mediaItem.hasAttribute("name") || !libraryItemName.equals(mediaItem.getAttribute("name"))) continue;
            bitmapId = i + 1;
            break;
        }
        if (bitmapId == 0) {
            return;
        }
        this.useClass("CPicBitmap", fg, definedClasses, totalObjectCount);
        fg.write(this.flaFormatVersion.getBitmapVersion());
        this.instanceHeader(bitmapInstance, fg, this.flaFormatVersion.getBitmapType(), true);
        fg.writeUI16(bitmapId);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            fg.write(0);
        }
    }

    protected void handleGroup(Element element, Element document, FlaWriter fg, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount, Reference<Integer> copiedComponentPathRef, boolean motionTweenEnd) throws IOException {
        Element membersElement = this.getSubElementByName(element, "members");
        if (membersElement != null) {
            List<Element> members = this.getAllSubElements(membersElement);
            this.useClass("CPicShape", fg, definedClasses, totalObjectCount);
            fg.write(this.flaFormatVersion.getGroupVersion());
            boolean selected = false;
            if (element.hasAttribute("selected")) {
                selected = "true".equals(element.getAttribute("selected"));
            }
            boolean locked = false;
            if (element.hasAttribute("locked")) {
                locked = "true".equals(element.getAttribute("locked"));
            }
            fg.write((selected ? 2 : 0) + (locked ? 4 : 0));
            this.handleElements(members, document, fg, definedClasses, totalObjectCount, copiedComponentPathRef, motionTweenEnd, false);
        }
    }

    protected void handleElements(List<Element> elements, Element document, FlaWriter fg, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount, Reference<Integer> copiedComponentPathRef, boolean motionTweenEnd, boolean allowWritingShapeHeader) throws IOException {
        block18: for (int instanceIndex = 0; instanceIndex < elements.size(); ++instanceIndex) {
            Element element = elements.get(instanceIndex);
            switch (element.getTagName()) {
                case "DOMSymbolInstance": {
                    this.handleSymbolInstance(element, document, fg, definedClasses, totalObjectCount, copiedComponentPathRef, motionTweenEnd);
                    continue block18;
                }
                case "DOMBitmapInstance": {
                    this.handleBitmapInstance(element, document, fg, definedClasses, totalObjectCount);
                    continue block18;
                }
                case "DOMVideoInstance": {
                    this.handleVideoInstance(element, document, fg, definedClasses, totalObjectCount);
                    continue block18;
                }
                case "DOMStaticText": 
                case "DOMDynamicText": 
                case "DOMInputText": {
                    this.handleText(element, document, fg, definedClasses, totalObjectCount);
                    continue block18;
                }
                case "DOMTLFText": {
                    Logger.getLogger(TimelineConverter.class.getName()).warning("DOMTLFText element is not supported");
                    continue block18;
                }
                case "DOMGroup": {
                    this.handleGroup(element, document, fg, definedClasses, totalObjectCount, copiedComponentPathRef, motionTweenEnd);
                }
            }
        }
        boolean hasShape = false;
        boolean isFloating = false;
        Element shapeElement = null;
        for (int e = 0; e < elements.size(); ++e) {
            Element element = elements.get(e);
            if (!"DOMShape".equals(element.getNodeName())) continue;
            if (element.getAttribute("isFloating").equals("true")) {
                this.useClass("CPicShape", fg, definedClasses, totalObjectCount);
                fg.write(this.flaFormatVersion.getGroupVersion());
                boolean selected = false;
                if (element.hasAttribute("selected")) {
                    selected = "true".equals(element.getAttribute("selected"));
                }
                boolean locked = false;
                if (element.hasAttribute("locked")) {
                    locked = "true".equals(element.getAttribute("locked"));
                }
                isFloating = true;
                fg.write((selected ? 2 : 0) + (locked ? 4 : 0) + (isFloating ? 1 : 0));
                shapeElement = element;
            }
            this.handleShape(element, document, fg, false, definedClasses, totalObjectCount);
            hasShape = true;
            break;
        }
        if (!hasShape || isFloating) {
            this.instanceHeader(shapeElement, fg, this.flaFormatVersion.getShapeType(), false);
            fg.write(5);
            fg.writeUI32(0L);
            fg.write(0, 0);
            fg.write(0, 0);
            fg.write(0);
            fg.writeUI32(0L);
        }
    }

    protected List<FilterInterface> parseFilters(Element filtersElement) {
        ArrayList<FilterInterface> filterList = new ArrayList<FilterInterface>();
        if (filtersElement == null) {
            return filterList;
        }
        List<Element> filters = this.getAllSubElements(filtersElement);
        for (Element filter : filters) {
            boolean enabled = true;
            if (filter.hasAttribute("isEnabled")) {
                enabled = !"false".equals(filter.getAttribute("isEnabled"));
            }
            switch (filter.getNodeName()) {
                case "DropShadowFilter": {
                    float blurX = 5.0f;
                    float blurY = 5.0f;
                    float strength = 1.0f;
                    int quality = 1;
                    float angle = 45.0f;
                    float distance = 5.0f;
                    boolean knockout = false;
                    boolean inner = false;
                    boolean hideObject = false;
                    Color color = Color.black;
                    if (filter.hasAttribute("blurX")) {
                        blurX = Float.parseFloat(filter.getAttribute("blurX"));
                    }
                    if (filter.hasAttribute("blurY")) {
                        blurY = Float.parseFloat(filter.getAttribute("blurY"));
                    }
                    if (filter.hasAttribute("strength")) {
                        strength = Float.parseFloat(filter.getAttribute("strength"));
                    }
                    if (filter.hasAttribute("quality")) {
                        quality = Integer.parseInt(filter.getAttribute("quality"));
                    }
                    if (filter.hasAttribute("angle")) {
                        angle = Float.parseFloat(filter.getAttribute("angle"));
                    }
                    if (filter.hasAttribute("distance")) {
                        distance = Float.parseFloat(filter.getAttribute("distance"));
                    }
                    if (filter.hasAttribute("knockout")) {
                        knockout = "true".equals(filter.getAttribute("knockout"));
                    }
                    if (filter.hasAttribute("inner")) {
                        inner = "true".equals(filter.getAttribute("inner"));
                    }
                    if (filter.hasAttribute("hideObject")) {
                        hideObject = "true".equals(filter.getAttribute("hideObject"));
                    }
                    color = this.parseColorWithAlpha(filter, color);
                    filterList.add(new DropShadowFilter(blurX, blurY, strength, quality, angle, distance, knockout, inner, hideObject, color, enabled));
                    break;
                }
                case "BlurFilter": {
                    float blurX = 5.0f;
                    float blurY = 5.0f;
                    int quality = 1;
                    if (filter.hasAttribute("blurX")) {
                        blurX = Float.parseFloat(filter.getAttribute("blurX"));
                    }
                    if (filter.hasAttribute("blurY")) {
                        blurY = Float.parseFloat(filter.getAttribute("blurY"));
                    }
                    if (filter.hasAttribute("quality")) {
                        quality = Integer.parseInt(filter.getAttribute("quality"));
                    }
                    filterList.add(new BlurFilter(blurX, blurY, quality, enabled));
                    break;
                }
                case "GlowFilter": {
                    float blurX = 5.0f;
                    float blurY = 5.0f;
                    Color color = Color.red;
                    boolean inner = false;
                    boolean knockout = false;
                    int quality = 1;
                    float strength = 1.0f;
                    if (filter.hasAttribute("blurX")) {
                        blurX = Float.parseFloat(filter.getAttribute("blurX"));
                    }
                    if (filter.hasAttribute("blurY")) {
                        blurY = Float.parseFloat(filter.getAttribute("blurY"));
                    }
                    if (filter.hasAttribute("strength")) {
                        strength = Float.parseFloat(filter.getAttribute("strength"));
                    }
                    color = this.parseColorWithAlpha(filter, color);
                    if (filter.hasAttribute("inner")) {
                        inner = "true".equals(filter.getAttribute("inner"));
                    }
                    if (filter.hasAttribute("knockout")) {
                        knockout = "true".equals(filter.getAttribute("knockout"));
                    }
                    if (filter.hasAttribute("quality")) {
                        quality = Integer.parseInt(filter.getAttribute("quality"));
                    }
                    filterList.add(new GlowFilter(blurX, blurY, color, inner, knockout, quality, strength, enabled));
                    break;
                }
                case "BevelFilter": {
                    float blurX = 5.0f;
                    float blurY = 5.0f;
                    float strength = 1.0f;
                    int quality = 1;
                    Color shadowColor = Color.black;
                    Color highlightColor = Color.white;
                    float angle = 45.0f;
                    float distance = 5.0f;
                    boolean knockout = false;
                    int type = 1;
                    if (filter.hasAttribute("blurX")) {
                        blurX = Float.parseFloat(filter.getAttribute("blurX"));
                    }
                    if (filter.hasAttribute("blurY")) {
                        blurY = Float.parseFloat(filter.getAttribute("blurY"));
                    }
                    if (filter.hasAttribute("strength")) {
                        strength = Float.parseFloat(filter.getAttribute("strength"));
                    }
                    if (filter.hasAttribute("quality")) {
                        quality = Integer.parseInt(filter.getAttribute("quality"));
                    }
                    shadowColor = this.parseColorWithAlpha(filter, shadowColor, "shadowColor", "shadowAlpha");
                    highlightColor = this.parseColorWithAlpha(filter, highlightColor, "highlightColor", "highlightAlpha");
                    if (filter.hasAttribute("angle")) {
                        angle = Float.parseFloat(filter.getAttribute("angle"));
                    }
                    if (filter.hasAttribute("distance")) {
                        distance = Float.parseFloat(filter.getAttribute("distance"));
                    }
                    if (filter.hasAttribute("knockout")) {
                        knockout = "true".equals(filter.getAttribute("knockout"));
                    }
                    if (filter.hasAttribute("type")) {
                        switch (filter.getAttribute("type")) {
                            case "outer": {
                                type = 2;
                                break;
                            }
                            case "full": {
                                type = 3;
                            }
                        }
                    }
                    filterList.add(new BevelFilter(blurX, blurY, strength, quality, shadowColor, highlightColor, angle, distance, knockout, type, enabled));
                    break;
                }
                case "GradientGlowFilter": 
                case "GradientBevelFilter": {
                    int type;
                    float blurX = 5.0f;
                    float blurY = 5.0f;
                    float strength = 1.0f;
                    int quality = 1;
                    float angle = 45.0f;
                    float distance = 5.0f;
                    boolean knockout = false;
                    int n = type = "GradientGlowFilter".equals(filter.getNodeName()) ? 1 : 1;
                    if (filter.hasAttribute("blurX")) {
                        blurX = Float.parseFloat(filter.getAttribute("blurX"));
                    }
                    if (filter.hasAttribute("blurY")) {
                        blurY = Float.parseFloat(filter.getAttribute("blurY"));
                    }
                    if (filter.hasAttribute("strength")) {
                        strength = Float.parseFloat(filter.getAttribute("strength"));
                    }
                    if (filter.hasAttribute("quality")) {
                        quality = Integer.parseInt(filter.getAttribute("quality"));
                    }
                    if (filter.hasAttribute("angle")) {
                        angle = Float.parseFloat(filter.getAttribute("angle"));
                    }
                    if (filter.hasAttribute("distance")) {
                        distance = Float.parseFloat(filter.getAttribute("distance"));
                    }
                    if (filter.hasAttribute("knockout")) {
                        knockout = "true".equals(filter.getAttribute("knockout"));
                    }
                    if (filter.hasAttribute("type")) {
                        switch (filter.getAttribute("type")) {
                            case "outer": {
                                type = 2;
                                break;
                            }
                            case "full": {
                                type = 3;
                            }
                        }
                    }
                    List<GradientEntry> gradientEntries = this.parseGradientEntries(filter);
                    if ("GradientGlowFilter".equals(filter.getNodeName())) {
                        filterList.add(new GradientGlowFilter(blurX, blurY, strength, quality, angle, distance, knockout, type, gradientEntries, enabled));
                        break;
                    }
                    filterList.add(new GradientBevelFilter(blurX, blurY, strength, quality, angle, distance, knockout, type, gradientEntries, enabled));
                    break;
                }
                case "AdjustColorFilter": {
                    float brightness = 0.0f;
                    float contrast = 0.0f;
                    float saturation = 0.0f;
                    float hue = 0.0f;
                    if (filter.hasAttribute("brightness")) {
                        brightness = Float.parseFloat(filter.getAttribute("brightness"));
                    }
                    if (filter.hasAttribute("contrast")) {
                        contrast = Float.parseFloat(filter.getAttribute("contrast"));
                    }
                    if (filter.hasAttribute("saturation")) {
                        saturation = Float.parseFloat(filter.getAttribute("saturation"));
                    }
                    if (filter.hasAttribute("hue")) {
                        hue = Float.parseFloat(filter.getAttribute("hue"));
                    }
                    filterList.add(new AdjustColorFilter(brightness, contrast, saturation, hue, enabled));
                }
            }
        }
        return filterList;
    }

    protected void handleSymbolInstance(Element symbolInstance, Element document, FlaWriter fg, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount, Reference<Integer> copiedComponentPathRef, boolean motionTweenEnd) throws IOException {
        Element scriptElement;
        if (!symbolInstance.hasAttribute("libraryItemName")) {
            return;
        }
        String libraryItemName = symbolInstance.getAttribute("libraryItemName");
        List<Element> includes = this.getSymbols(document);
        int libraryItemIndex = -1;
        for (int e = 0; e < includes.size(); ++e) {
            Object include = includes.get(e);
            if (!include.hasAttribute("href")) continue;
            String href = include.getAttribute("href");
            String nameNoXml = href;
            if (nameNoXml.endsWith(".xml")) {
                nameNoXml = nameNoXml.substring(0, nameNoXml.length() - 4);
            }
            if (!nameNoXml.equals(libraryItemName)) continue;
            libraryItemIndex = e + 1;
            break;
        }
        if (libraryItemIndex == -1) {
            return;
        }
        int symbolType = 0;
        if (symbolInstance.hasAttribute("symbolType")) {
            switch (symbolInstance.getAttribute("symbolType")) {
                case "button": {
                    symbolType = 1;
                    break;
                }
                case "graphic": {
                    symbolType = 2;
                }
            }
        }
        boolean trackAsMenu = false;
        int loop = 1;
        int firstFrame = 0;
        if (symbolType == 1) {
            this.useClass("CPicButton", fg, definedClasses, totalObjectCount);
            if (symbolInstance.hasAttribute("trackAsMenu")) {
                trackAsMenu = "true".equals(symbolInstance.getAttribute("trackAsMenu"));
            }
        } else if (symbolType == 2) {
            this.useClass("CPicSymbol", fg, definedClasses, totalObjectCount);
            if (symbolInstance.hasAttribute("loop")) {
                switch (symbolInstance.getAttribute("loop")) {
                    case "loop": {
                        loop = 1;
                        break;
                    }
                    case "play once": {
                        loop = 2;
                        break;
                    }
                    case "single frame": {
                        loop = 3;
                    }
                }
            }
            if (symbolInstance.hasAttribute("firstFrame")) {
                firstFrame = Integer.parseInt(symbolInstance.getAttribute("firstFrame"));
            }
        } else {
            this.useClass("CPicSprite", fg, definedClasses, totalObjectCount);
        }
        String instanceName = "";
        if (symbolType != 2 && symbolInstance.hasAttribute("name")) {
            instanceName = symbolInstance.getAttribute("name");
        }
        double centerPoint3DX = 0.0;
        if (symbolInstance.hasAttribute("centerPoint3DX")) {
            centerPoint3DX = Double.parseDouble(symbolInstance.getAttribute("centerPoint3DX"));
        }
        double centerPoint3DY = 0.0;
        if (symbolInstance.hasAttribute("centerPoint3DY")) {
            centerPoint3DY = Double.parseDouble(symbolInstance.getAttribute("centerPoint3DY"));
        }
        double centerPoint3DZ = 0.0;
        if (symbolInstance.hasAttribute("centerPoint3DZ")) {
            centerPoint3DZ = Double.parseDouble(symbolInstance.getAttribute("centerPoint3DZ"));
        }
        ColorEffectInterface colorEffect = new NoColorEffect();
        Element colorElement = this.getSubElementByName(symbolInstance, "color");
        if (colorElement != null && (colorElement = this.getSubElementByName(colorElement, "Color")) != null) {
            if (colorElement.hasAttribute("brightness")) {
                double brightness = Double.parseDouble(colorElement.getAttribute("brightness"));
                colorEffect = new BrightnessColorEffect(brightness);
            } else if (colorElement.hasAttribute("tintColor") || colorElement.hasAttribute("tintMultiplier")) {
                Color tintColor = Color.black;
                if (colorElement.hasAttribute("tintColor")) {
                    tintColor = this.parseColor(colorElement.getAttribute("tintColor"));
                }
                double tintMultiplier = 0.0;
                if (colorElement.hasAttribute("tintMultiplier")) {
                    tintMultiplier = Double.parseDouble(colorElement.getAttribute("tintMultiplier"));
                }
                colorEffect = new TintColorEffect(tintMultiplier, tintColor);
            } else if (colorElement.hasAttribute("redMultiplier") || colorElement.hasAttribute("greenMultiplier") || colorElement.hasAttribute("blueMultiplier") || colorElement.hasAttribute("alphaOffset") || colorElement.hasAttribute("redOffset") || colorElement.hasAttribute("greenOffset") || colorElement.hasAttribute("blueOffset")) {
                double alphaMultiplier = 1.0;
                double redMultiplier = 1.0;
                double greenMultiplier = 1.0;
                double blueMultiplier = 1.0;
                int alphaOffset = 0;
                int redOffset = 0;
                int greenOffset = 0;
                int blueOffset = 0;
                if (colorElement.hasAttribute("alphaMultiplier")) {
                    alphaMultiplier = Double.parseDouble(colorElement.getAttribute("alphaMultiplier"));
                }
                if (colorElement.hasAttribute("redMultiplier")) {
                    redMultiplier = Double.parseDouble(colorElement.getAttribute("redMultiplier"));
                }
                if (colorElement.hasAttribute("greenMultiplier")) {
                    greenMultiplier = Double.parseDouble(colorElement.getAttribute("greenMultiplier"));
                }
                if (colorElement.hasAttribute("blueMultiplier")) {
                    blueMultiplier = Double.parseDouble(colorElement.getAttribute("blueMultiplier"));
                }
                if (colorElement.hasAttribute("alphaOffset")) {
                    alphaOffset = Integer.parseInt(colorElement.getAttribute("alphaOffset"));
                }
                if (colorElement.hasAttribute("redOffset")) {
                    redOffset = Integer.parseInt(colorElement.getAttribute("redOffset"));
                }
                if (colorElement.hasAttribute("greenOffset")) {
                    greenOffset = Integer.parseInt(colorElement.getAttribute("greenOffset"));
                }
                if (colorElement.hasAttribute("blueOffset")) {
                    blueOffset = Integer.parseInt(colorElement.getAttribute("blueOffset"));
                }
                colorEffect = new AdvancedColorEffect(alphaMultiplier, redMultiplier, greenMultiplier, blueMultiplier, alphaOffset, redOffset, greenOffset, blueOffset);
            } else if (colorElement.hasAttribute("alphaMultiplier")) {
                double alphaMultiplier = Double.parseDouble(colorElement.getAttribute("alphaMultiplier"));
                colorEffect = new AlphaColorEffect(alphaMultiplier);
            }
        }
        int blendMode = this.getAttributeAsInt(symbolInstance, "blendMode", Arrays.asList("", "normal", "layer", "multiply", "screen", "lighten", "darken", "difference", "add", "subtract", "invert", "alpha", "erase", "overlay", "hardlight"), "normal");
        List<FilterInterface> filters = this.parseFilters(this.getSubElementByName(symbolInstance, "filters"));
        String actionScript = "";
        Element actionscriptElement = this.getSubElementByName(symbolInstance, "Actionscript");
        if (actionscriptElement != null && (scriptElement = this.getSubElementByName(actionscriptElement, "script")) != null) {
            actionScript = scriptElement.getTextContent();
        }
        if (symbolType == 0) {
            copiedComponentPathRef.setVal(copiedComponentPathRef.getVal() + 1);
        }
        int symbolInstanceId = fg.generateRandomId();
        long centerPoint3DXLong = Math.round(centerPoint3DX * 20.0);
        long centerPoint3DYLong = Math.round(centerPoint3DY * 20.0);
        long centerPoint3DZLong = Math.round(centerPoint3DZ * 20.0);
        fg.write(this.flaFormatVersion.getSpriteVersion());
        this.instanceHeader(symbolInstance, fg, this.flaFormatVersion.getSymbolType(), true);
        fg.write(firstFrame & 0xFF, firstFrame >> 8 & 0xFF);
        block18 : switch (symbolType) {
            case 0: {
                fg.write(2);
                break;
            }
            case 1: {
                fg.write(0);
                break;
            }
            case 2: {
                switch (loop) {
                    case 1: {
                        fg.write(0);
                        break block18;
                    }
                    case 2: {
                        fg.write(1);
                        break block18;
                    }
                    case 3: {
                        fg.write(2);
                    }
                }
            }
        }
        fg.write(0, 1);
        int redMultiplier = colorEffect.getRedMultiplier();
        int greenMultiplier = colorEffect.getGreenMultiplier();
        int blueMultiplier = colorEffect.getBlueMultiplier();
        int alphaMultiplier = colorEffect.getAlphaMultiplier();
        int redOffset = colorEffect.getRedOffset();
        int greenOffset = colorEffect.getGreenOffset();
        int blueOffset = colorEffect.getBlueOffset();
        int alphaOffset = colorEffect.getAlphaOffset();
        Color effectColor = colorEffect.getValueColor();
        fg.write(this.debugRandom ? 88 : alphaMultiplier & 0xFF, alphaMultiplier >> 8 & 0xFF, alphaOffset & 0xFF, alphaOffset >> 8 & 0xFF, this.debugRandom ? 88 : redMultiplier & 0xFF, redMultiplier >> 8 & 0xFF, redOffset & 0xFF, redOffset >> 8 & 0xFF, this.debugRandom ? 88 : greenMultiplier & 0xFF, greenMultiplier >> 8 & 0xFF, greenOffset & 0xFF, greenOffset >> 8 & 0xFF, this.debugRandom ? 88 : blueMultiplier & 0xFF, blueMultiplier >> 8 & 0xFF, blueOffset & 0xFF, blueOffset >> 8 & 0xFF, colorEffect.getType(), 0);
        if (colorEffect instanceof NoColorEffect && this.debugRandom) {
            fg.write(88, 88);
            fg.write(88, 88, 88, 88);
        } else {
            fg.writeUI16(colorEffect.getValuePercent());
            fg.write(effectColor.getRed(), effectColor.getGreen(), effectColor.getBlue(), effectColor.getAlpha());
        }
        fg.writeBomString("");
        if (this.debugRandom) {
            fg.write(88, 88);
        } else {
            fg.writeUI16(libraryItemIndex);
        }
        fg.write(0, 0);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            fg.write(0, 0, 0);
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            if (!filters.isEmpty()) {
                fg.write(1, filters.size(), 0, 0, 0);
                for (FilterInterface filter : filters) {
                    filter.write(fg);
                }
            } else {
                fg.write(0);
            }
            fg.write(blendMode, 0, 0);
        }
        if (this.flaFormatVersion == FlaFormatVersion.CS4) {
            float[] matrix3D = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            if (symbolInstance.hasAttribute("matrix3D")) {
                String matrix3DStr = symbolInstance.getAttribute("matrix3D");
                String[] matrixParts = matrix3DStr.trim().split(" ", -1);
                if (matrixParts.length != 16) {
                    Logger.getLogger(TimelineConverter.class.getName()).warning("matrix3D attribute has incorrect number of parts");
                } else {
                    for (int i = 0; i < 16; ++i) {
                        matrix3D[i] = Float.parseFloat(matrixParts[i]);
                    }
                }
            }
            for (int i = 0; i < 16; ++i) {
                fg.writeFloat(matrix3D[i]);
            }
            double rotationX = 0.0;
            if (symbolInstance.hasAttribute("rotationX")) {
                rotationX = Double.parseDouble(symbolInstance.getAttribute("rotationX"));
            }
            double rotationY = 0.0;
            if (symbolInstance.hasAttribute("rotationY")) {
                rotationY = Double.parseDouble(symbolInstance.getAttribute("rotationY"));
            }
            double rotationZ = 0.0;
            if (symbolInstance.hasAttribute("rotationZ")) {
                rotationZ = Double.parseDouble(symbolInstance.getAttribute("rotationZ"));
            }
            fg.writeDouble(rotationX);
            fg.writeDouble(rotationY);
            fg.writeDouble(rotationZ);
            if (symbolType != 0) {
                fg.write(0, 0, 0, 128, 0, 0, 0, 128);
            } else {
                fg.write((int)(centerPoint3DXLong & 0xFFL), (int)(centerPoint3DXLong >> 8 & 0xFFL), (int)(centerPoint3DXLong >> 16 & 0xFFL), (int)(centerPoint3DXLong >> 24 & 0xFFL), (int)(centerPoint3DYLong & 0xFFL), (int)(centerPoint3DYLong >> 8 & 0xFFL), (int)(centerPoint3DYLong >> 16 & 0xFFL), (int)(centerPoint3DYLong >> 24 & 0xFFL));
            }
            fg.write((int)(centerPoint3DZLong & 0xFFL), (int)(centerPoint3DZLong >> 8 & 0xFFL), (int)(centerPoint3DZLong >> 16 & 0xFFL), (int)(centerPoint3DZLong >> 24 & 0xFFL));
            fg.write(0, 0);
        }
        if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F5.ordinal()) {
            fg.write(0, 0);
            fg.write(1, 0, 0, 0, 0);
            fg.write(1, 0, 0, 0);
        }
        if (symbolType == 2) {
            return;
        }
        fg.write(symbolType == 1 ? this.flaFormatVersion.getButtonVersion() : this.flaFormatVersion.getSpriteVersionG(), this.flaFormatVersion.getSpriteVersionB(), 0, 0, 0, 1, 0, 0, 0);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
            fg.write(symbolInstanceId & 0xFF, symbolInstanceId >> 8 & 0xFF);
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                fg.write(0, 0, 0, 0);
            }
            fg.write(0, 0, 0, 0, 0, 0);
        }
        fg.writeBomString(actionScript);
        if (symbolType == 1) {
            fg.write(trackAsMenu ? 1 : 0);
            if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F5.ordinal()) {
                return;
            }
        }
        fg.writeBomString(instanceName);
        if (symbolType == 1) {
            this.writeAccessibleData(fg, symbolInstance, false);
            fg.write(0, 0, 0, 0);
            return;
        }
        if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F5.ordinal()) {
            fg.write(1, 0, 0, 0, 0);
        } else {
            fg.write(2, 0, 0, 0, 0, this.debugRandom ? 85 : 1, 0, 0, 0);
            this.writeAccessibleData(fg, symbolInstance, false);
            fg.write(0, 0, 0, 0, 0, 0, 0, 0);
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
            fg.write(1, this.debugRandom ? 85 : 0, 0, 0, 0);
            String componentTxt = "<component metaDataFetched='true' schemaUrl='' schemaOperation='' sceneRootLabel='Scene 1' oldCopiedComponentPath='" + copiedComponentPathRef.getVal() + "'>\n</component>\n";
            if (this.debugRandom) {
                componentTxt = "YYY";
            }
            fg.writeBomString(componentTxt);
        }
    }

    private void instanceHeader(Element element, FlaWriter fg, int instanceType, boolean isInstance) throws IOException {
        Matrix placeMatrix = this.parseMatrix(this.getSubElementByName(element, "matrix"));
        boolean selected = false;
        if (element != null && element.hasAttribute("selected")) {
            selected = "true".equals(element.getAttribute("selected"));
        }
        boolean locked = false;
        if (element != null && element.hasAttribute("locked")) {
            locked = "true".equals(element.getAttribute("locked"));
        }
        boolean cacheAsBitmap = false;
        if (element != null && "DOMSymbolInstance".equals(element.getTagName()) && element.hasAttribute("cacheAsBitmap")) {
            cacheAsBitmap = "true".equals(element.getAttribute("cacheAsBitmap"));
        }
        Double transformationPointX = null;
        Double transformationPointY = null;
        Element transformationPointElement = this.getSubElementByName(element, "transformationPoint");
        if (transformationPointElement != null) {
            Element pointElement = this.getSubElementByName(transformationPointElement, "Point");
            transformationPointX = 0.0;
            if (pointElement.hasAttribute("x")) {
                transformationPointX = Double.valueOf(pointElement.getAttribute("x"));
            }
            transformationPointY = 0.0;
            if (pointElement.hasAttribute("y")) {
                transformationPointY = Double.valueOf(pointElement.getAttribute("y"));
            }
        }
        if (isInstance) {
            fg.write((selected ? 2 : 0) + (locked ? 4 : 0));
        }
        fg.write(0, 0);
        if (transformationPointX == null) {
            fg.write(0, 0, 0, 128);
            fg.write(0, 0, 0, 128);
        } else {
            Point2D.Double transformationPoint = new Point2D.Double(transformationPointX, transformationPointY);
            Point2D transformationPointTransformed = placeMatrix.transform(transformationPoint);
            long tptX = Math.round(transformationPointTransformed.getX() * 20.0);
            long tptY = Math.round(transformationPointTransformed.getY() * 20.0);
            if (this.debugRandom) {
                fg.write(88, 88, 88, 88);
                fg.write(88, 88, 88, 88);
            } else {
                fg.write((int)(tptX & 0xFFL), (int)(tptX >> 8 & 0xFFL), (int)(tptX >> 16 & 0xFFL), (int)(tptX >> 24 & 0xFFL), (int)(tptY & 0xFFL), (int)(tptY >> 8 & 0xFFL), (int)(tptY >> 16 & 0xFFL), (int)(tptY >> 24 & 0xFFL));
            }
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            fg.write(0, cacheAsBitmap ? 1 : 0);
        }
        fg.write(instanceType);
        fg.writeMatrix(placeMatrix);
    }

    /*
     * WARNING - void declaration
     */
    private void handleText(Element element, Element document, FlaWriter fg, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount) throws IOException {
        if ("DOMStaticText".equals(element.getTagName()) || "DOMDynamicText".equals(element.getTagName()) || "DOMInputText".equals(element.getTagName())) {
            void var45_61;
            int n;
            int n2;
            this.useClass("CPicText", fg, definedClasses, totalObjectCount);
            boolean isDynamic = "DOMDynamicText".equals(element.getTagName());
            boolean isInput = "DOMInputText".equals(element.getTagName());
            boolean isStatic = "DOMStaticText".equals(element.getTagName());
            String instanceName = "";
            if (!isStatic && element.hasAttribute("name")) {
                instanceName = element.getAttribute("name");
            }
            int maxCharacters = 0;
            if (isInput && element.hasAttribute("maxCharacters")) {
                maxCharacters = Integer.parseInt(element.getAttribute("maxCharacters"));
            }
            boolean renderAsHTML = false;
            boolean border = false;
            boolean multiline = false;
            boolean wrap = false;
            boolean password = false;
            String variableName = "";
            if (isDynamic || isInput) {
                if (element.hasAttribute("renderAsHTML")) {
                    renderAsHTML = "true".equals(element.getAttribute("renderAsHTML"));
                }
                if (element.hasAttribute("border")) {
                    border = "true".equals(element.getAttribute("border"));
                }
                if (element.hasAttribute("lineType")) {
                    switch (element.getAttribute("lineType")) {
                        case "multiline": {
                            multiline = true;
                            wrap = true;
                            break;
                        }
                        case "multiline no wrap": {
                            multiline = true;
                            break;
                        }
                        case "password": {
                            if (!isInput) break;
                            password = true;
                        }
                    }
                }
                if (element.hasAttribute("variableName")) {
                    variableName = element.getAttribute("variableName");
                }
            }
            boolean FONTRENDERING_DEVICE = false;
            boolean FONTRENDERING_BITMAP = true;
            int FONTRENDERING_STANDARD = 2;
            int FONTRENDERING_DEFAULT = 3;
            int FONTRENDERING_CUSTOM = 4;
            int fontRenderingMode = 3;
            boolean isSelectable = true;
            float left = 0.0f;
            float width = 0.0f;
            float top = 0.0f;
            float height = 0.0f;
            float antiAliasSharpness = 0.0f;
            float antiAliasThickness = 0.0f;
            if (element.hasAttribute("antiAliasSharpness")) {
                antiAliasSharpness = Float.parseFloat(element.getAttribute("antiAliasSharpness"));
            }
            if (element.hasAttribute("antiAliasThickness")) {
                antiAliasThickness = Float.parseFloat(element.getAttribute("antiAliasThickness"));
            }
            if (element.hasAttribute("fontRenderingMode")) {
                switch (element.getAttribute("fontRenderingMode")) {
                    case "device": {
                        fontRenderingMode = 0;
                        break;
                    }
                    case "bitmap": {
                        fontRenderingMode = 1;
                        break;
                    }
                    case "standard": {
                        fontRenderingMode = 2;
                        break;
                    }
                    case "customThicknessSharpness": {
                        fontRenderingMode = 4;
                    }
                }
            }
            if (element.hasAttribute("left")) {
                left = Float.parseFloat(element.getAttribute("left"));
            }
            if (element.hasAttribute("width")) {
                width = Float.parseFloat(element.getAttribute("width"));
            }
            if (element.hasAttribute("top")) {
                top = Float.parseFloat(element.getAttribute("top"));
            }
            if (element.hasAttribute("height")) {
                height = Float.parseFloat(element.getAttribute("height"));
            }
            if (!isInput && element.hasAttribute("isSelectable")) {
                isSelectable = !"false".equals(element.getAttribute("isSelectable"));
            }
            boolean vertical = false;
            boolean rightToLeft = false;
            if (!isInput && element.hasAttribute("orientation")) {
                switch (element.getAttribute("orientation")) {
                    case "vertical right to left": {
                        vertical = true;
                        rightToLeft = true;
                        break;
                    }
                    case "vertical left to right": {
                        vertical = true;
                    }
                }
            }
            boolean scrollable = false;
            if (element.hasAttribute("scrollable")) {
                scrollable = "true".equals(element.getAttribute("scrollable"));
            }
            fg.write(this.flaFormatVersion.getTextVersionC());
            this.instanceHeader(element, fg, this.flaFormatVersion.getTextVersion(), true);
            fg.writeUI32(Math.round(left * 20.0f));
            if (this.debugRandom) {
                fg.write(88, 88, 88, 88);
            } else {
                fg.writeUI32(Math.round((left + width) * 20.0f));
            }
            fg.writeUI32(Math.round(top * 20.0f));
            if (this.debugRandom) {
                fg.write(88, 88, 88, 88);
            } else {
                fg.writeUI32(Math.round((top + height) * 20.0f));
            }
            boolean autoExpand = false;
            if (element.hasAttribute("autoExpand")) {
                autoExpand = "true".equals(element.getAttribute("autoExpand"));
            }
            fg.write(autoExpand ? 1 : 0, 0);
            Element fontsElement = this.getSubElementByName(document, "fonts");
            List<Object> domFontItems = new ArrayList();
            if (fontsElement != null) {
                domFontItems = this.getAllSubElementsByName(fontsElement, "DOMFontItem");
            }
            Element textRunsElement = this.getSubElementByName(element, "textRuns");
            List<Object> domTextRuns = new ArrayList();
            if (textRunsElement != null) {
                domTextRuns = this.getAllSubElementsByName(textRunsElement, "DOMTextRun");
            }
            int textFlags = (!isStatic ? 1 : 0) + (isDynamic ? 2 : 0) + (password ? 4 : 0) + (border ? 64 : 0) + (wrap ? 8 : 0) + (multiline ? 16 : 0) + (isDynamic && renderAsHTML && !isSelectable ? 128 : 0);
            if (this.flaFormatVersion.ordinal() < FlaFormatVersion.MX2004.ordinal()) {
                block52: for (Element element2 : domTextRuns) {
                    Element domTextAttrs;
                    Element textAttrsElement = this.getSubElementByName(element2, "textAttrs");
                    if (textAttrsElement == null || (domTextAttrs = this.getSubElementByName(textAttrsElement, "DOMTextAttrs")) == null || !domTextAttrs.hasAttribute("face")) continue;
                    String face = domTextAttrs.getAttribute("face");
                    for (Element element3 : domFontItems) {
                        if (!face.equals(element3.getAttribute("font")) && !face.equals(element3.getAttribute("name") + "*")) continue;
                        if (!element3.hasAttribute("embeddedCharacters")) break block52;
                        textFlags |= 0x20;
                        break block52;
                    }
                }
            }
            fg.write(textFlags);
            ArrayList<String> allEmbedRanges = new ArrayList<String>();
            boolean bl = false;
            String embeddedCharacters = "";
            HashMap<String, String> faceToRealFace = new HashMap<String, String>();
            for (Object textRun : domTextRuns) {
                Element domTextAttrs;
                Element element4 = this.getSubElementByName((Node)textRun, "textAttrs");
                if (element4 == null || (domTextAttrs = this.getSubElementByName(element4, "DOMTextAttrs")) == null || !domTextAttrs.hasAttribute("face")) continue;
                String face = domTextAttrs.getAttribute("face");
                for (Element element5 : domFontItems) {
                    String[] rangesParts;
                    if (!face.equals(element5.getAttribute("font")) && !face.equals(element5.getAttribute("name") + "*")) continue;
                    faceToRealFace.put(face, element5.getAttribute("font"));
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                        n3 |= 1;
                    } else if (element5.hasAttribute("linkageExportForAS") && "true".equals(element5.getAttribute("linkageExportForAS"))) {
                        n3 |= 1;
                    }
                    if (element5.hasAttribute("embeddedCharacters")) {
                        embeddedCharacters = element5.getAttribute("embeddedCharacters");
                        n3 |= 0x20;
                    }
                    if (!element5.hasAttribute("embedRanges")) continue;
                    String embedRanges = element5.getAttribute("embedRanges");
                    for (String part : rangesParts = embedRanges.split("\\|", -1)) {
                        if (part.isEmpty()) continue;
                        int rangeId = Integer.parseInt(part);
                        if (rangeId >= 1 && rangeId <= 4) {
                            n3 |= 1 << rangeId;
                        }
                        if (allEmbedRanges.contains(part)) continue;
                        allEmbedRanges.add(part);
                    }
                }
            }
            boolean isEmpty = true;
            for (Element element6 : domTextRuns) {
                String characters = "";
                Element charactersElement = this.getSubElementByName(element6, "characters");
                if (charactersElement != null) {
                    characters = charactersElement.getTextContent();
                }
                if (characters.isEmpty()) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                int n3;
                n2 = n3 | 0x40;
            }
            if (renderAsHTML) {
                n = n2 | 0x80;
            }
            fg.write(n);
            if (!isStatic) {
                fg.write(0);
            } else {
                int flags = 0;
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal() && fontRenderingMode == 0) {
                    flags |= 2;
                }
                if (isSelectable) {
                    flags |= 1;
                }
                fg.write(flags);
            }
            fg.write(0);
            fg.writeUI16(maxCharacters);
            fg.writeBomString(variableName);
            if (!embeddedCharacters.isEmpty()) {
                fg.writeBomString(embeddedCharacters);
            }
            if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                fg.write(0);
            }
            List<FilterInterface> filters = this.parseFilters(this.getSubElementByName(element, "filters"));
            boolean bl2 = false;
            while (var45_61 < domTextRuns.size()) {
                Element domTextAttrs;
                Element element7;
                Element textRun = (Element)domTextRuns.get((int)var45_61);
                String characters = "";
                Element charactersElement = this.getSubElementByName(textRun, "characters");
                if (charactersElement != null) {
                    characters = charactersElement.getTextContent();
                }
                if (!(characters.isEmpty() && domTextRuns.size() != 1 || (element7 = this.getSubElementByName(textRun, "textAttrs")) == null || (domTextAttrs = this.getSubElementByName(element7, "DOMTextAttrs")) == null)) {
                    Element domTextAttrs2;
                    Element textRun2;
                    Element textAttrsElement2;
                    for (void r2 = var45_61 + true; r2 < domTextRuns.size() && (textAttrsElement2 = this.getSubElementByName(textRun2 = (Element)domTextRuns.get((int)r2), "textAttrs")) != null && (domTextAttrs2 = this.getSubElementByName(textAttrsElement2, "DOMTextAttrs")) != null && TimelineConverter.areAttributesEqual(domTextAttrs, domTextAttrs2); ++r2) {
                        String characters2 = "";
                        Element charactersElement2 = this.getSubElementByName(textRun2, "characters");
                        if (charactersElement2 != null) {
                            characters2 = charactersElement2.getTextContent();
                        }
                        characters = characters + characters2;
                        ++var45_61;
                    }
                    String face = "TimesNewRomanPSMT";
                    if (domTextAttrs.hasAttribute("face")) {
                        face = domTextAttrs.getAttribute("face");
                    }
                    String realFace = face;
                    if (faceToRealFace.containsKey(face)) {
                        realFace = (String)faceToRealFace.get(face);
                    }
                    Font font = (Font)psNameToFontName.get(realFace);
                    String fontFamily = "";
                    boolean bold = false;
                    boolean italic = false;
                    if (font != null) {
                        fontFamily = font.getFamily();
                        String fontNameLowercase = font.getFontName(Locale.US).toLowerCase();
                        bold = fontNameLowercase.contains("bold");
                        italic = fontNameLowercase.contains("italic") || fontNameLowercase.contains("oblique");
                    } else if (this.debugRandom) {
                        fontFamily = "YYY";
                    }
                    Color fillColor = this.parseColorWithAlpha(domTextAttrs, Color.black, "fillColor", "alpha");
                    float size = 12.0f;
                    if (domTextAttrs.hasAttribute("size")) {
                        size = Float.parseFloat(domTextAttrs.getAttribute("size"));
                    }
                    int bitmapSize = Math.round(size * 20.0f);
                    float lineSpacing = 2.0f;
                    if (domTextAttrs.hasAttribute("lineSpacing")) {
                        lineSpacing = Float.parseFloat(domTextAttrs.getAttribute("lineSpacing"));
                    }
                    float letterSpacing = 0.0f;
                    if (domTextAttrs.hasAttribute("letterSpacing")) {
                        letterSpacing = Float.parseFloat(domTextAttrs.getAttribute("letterSpacing"));
                    }
                    boolean autoKern = true;
                    if (domTextAttrs.hasAttribute("autoKern")) {
                        autoKern = !"false".equals(domTextAttrs.getAttribute("autoKern"));
                    }
                    boolean ALIGN_LEFT = false;
                    boolean ALIGN_RIGHT = true;
                    int ALIGN_CENTER = 2;
                    int ALIGN_JUSTIFY = 3;
                    int alignment = 0;
                    if (domTextAttrs.hasAttribute("alignment")) {
                        switch (domTextAttrs.getAttribute("alignment")) {
                            case "right": {
                                alignment = 1;
                                break;
                            }
                            case "center": {
                                alignment = 2;
                                break;
                            }
                            case "justify": {
                                alignment = 3;
                            }
                        }
                    }
                    if (fontRenderingMode == 0) {
                        autoKern = false;
                    }
                    boolean CHARACTERPOSITION_NORMAL = false;
                    boolean CHARACTERPOSITION_SUPERSCRIPT = true;
                    int CHARACTERPOSITION_SUBSCRIPT = 2;
                    int characterPosition = 0;
                    if (!isSelectable && domTextAttrs.hasAttribute("characterPosition")) {
                        switch (domTextAttrs.getAttribute("characterPosition")) {
                            case "superscript": {
                                characterPosition = 1;
                                break;
                            }
                            case "subscript": {
                                characterPosition = 2;
                            }
                        }
                    }
                    float indent = 0.0f;
                    if (domTextAttrs.hasAttribute("indent")) {
                        indent = Float.parseFloat(domTextAttrs.getAttribute("indent"));
                    }
                    float leftMargin = 0.0f;
                    if (domTextAttrs.hasAttribute("leftMargin")) {
                        leftMargin = Float.parseFloat(domTextAttrs.getAttribute("leftMargin"));
                    }
                    float rightMargin = 0.0f;
                    if (domTextAttrs.hasAttribute("rightMargin")) {
                        rightMargin = Float.parseFloat(domTextAttrs.getAttribute("rightMargin"));
                    }
                    boolean rotation = false;
                    if (domTextAttrs.hasAttribute("rotation")) {
                        rotation = "true".equals(domTextAttrs.getAttribute("rotation"));
                    }
                    String url = "";
                    String target = "";
                    if (domTextAttrs.hasAttribute("url")) {
                        url = domTextAttrs.getAttribute("url");
                        if (domTextAttrs.hasAttribute("target")) {
                            target = domTextAttrs.getAttribute("target");
                        }
                    }
                    if (!characters.isEmpty()) {
                        fg.writeUI16(characters.length());
                    }
                    fg.write(this.flaFormatVersion.getTextVersionB());
                    fg.writeUI16(bitmapSize);
                    if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                        fg.writeBomString(fontFamily);
                    } else {
                        fg.writeString(fontFamily);
                    }
                    if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                        fg.writeBomString(face);
                        fg.write(0, 0, 0, 64);
                    }
                    fg.write(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), fillColor.getAlpha());
                    fg.write(this.debugRandom ? 85 : 18, 0);
                    int[] nArray = new int[6];
                    int n4 = this.debugRandom ? 88 : (nArray[0] = bold ? 1 : 0);
                    nArray[1] = this.debugRandom ? 88 : (italic ? 1 : 0);
                    nArray[2] = 0;
                    nArray[3] = autoKern ? 1 : 0;
                    nArray[4] = characterPosition;
                    nArray[5] = alignment;
                    fg.write(nArray);
                    fg.writeUI16(Math.round(lineSpacing * 20.0f));
                    fg.writeUI16(Math.round(indent * 20.0f));
                    fg.writeUI16(Math.round(leftMargin * 20.0f));
                    fg.writeUI16(Math.round(rightMargin * 20.0f));
                    fg.writeUI16(Math.round(letterSpacing * 20.0f));
                    if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                        fg.writeBomString(url);
                    } else {
                        fg.writeString(url);
                    }
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                        fg.write(vertical ? 1 : 0);
                        fg.write(rightToLeft ? 1 : 0);
                        fg.write(rotation ? 1 : 0);
                        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                            fg.write(fontRenderingMode == 1 ? 1 : 0);
                        }
                        if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                            fg.writeBomString(target);
                        } else {
                            fg.writeString(target);
                        }
                    }
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                        fg.write(2);
                        switch (fontRenderingMode) {
                            case 3: {
                                fg.write(1);
                                break;
                            }
                            case 4: {
                                fg.write(2);
                                break;
                            }
                            default: {
                                fg.write(0);
                            }
                        }
                        if (this.flaFormatVersion == FlaFormatVersion.CS4 || fontRenderingMode != 0) {
                            fg.writeFloat(antiAliasThickness);
                            fg.writeFloat(antiAliasSharpness);
                        } else {
                            fg.write(0, 0, 0, 0);
                            fg.write(0, 0, 0, 0);
                        }
                        if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                            fg.writeBomString(url);
                        } else {
                            fg.writeString(url);
                        }
                    }
                    if (this.flaFormatVersion.isUnicode()) {
                        fg.write(characters.getBytes("UTF-16LE"));
                    } else {
                        fg.write(characters.getBytes());
                    }
                }
                ++var45_61;
            }
            fg.write(0, 0);
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                fg.writeBomString(instanceName);
                this.writeAccessibleData(fg, element, false);
                fg.write(0, 0, 0, 0, scrollable ? 1 : 0, 0, 0, 0);
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX2004.ordinal()) {
                fg.writeBomString("");
                fg.writeBomString(String.join((CharSequence)"|", allEmbedRanges));
            }
            if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                if (!filters.isEmpty()) {
                    fg.write(1);
                    fg.writeUI32(filters.size());
                    for (FilterInterface filter : filters) {
                        filter.write(fg);
                    }
                } else {
                    fg.write(0);
                }
                fg.write(0, 0);
            }
        }
    }

    private void writeMorphStrokeStylePart(FlaWriter fg, Element strokeStyleElement) throws IOException {
        if (strokeStyleElement == null) {
            fg.write(0, 0, 0, 0);
            fg.write(0, 0, 0, 0);
            fg.writeUI16(0);
            return;
        }
        Element element = this.getFirstSubElement(strokeStyleElement);
        Element fill = this.getSubElementByName(element, "fill");
        Element fillElement = this.getFirstSubElement(fill);
        boolean isTransparent = false;
        if ("SolidColor".equals(fillElement.getTagName())) {
            Color color = this.parseColorWithAlpha(fillElement);
            fg.write(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            isTransparent = color.equals(new Color(0, 0, 0, 0));
        } else {
            fg.write(0, 0, 0, this.debugRandom ? 85 : 0);
        }
        float weight = 1.0f;
        if (element.hasAttribute("weight")) {
            weight = Float.parseFloat(element.getAttribute("weight"));
        }
        if (weight == 0.1f && isTransparent) {
            weight = 0.0f;
        }
        fg.writeUI32(Math.round(weight * 20.0f));
        fg.writeUI16(0);
    }

    private void writeMorphFillStylePart(Element document, FlaWriter fg, Element fillStyleElement) throws IOException {
        Element element = this.getFirstSubElement(fillStyleElement);
        block6 : switch (element.getTagName()) {
            case "SolidColor": {
                Color color = this.parseColorWithAlpha(element);
                fg.write(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                fg.writeUI16(0);
                break;
            }
            case "LinearGradient": 
            case "RadialGradient": {
                Matrix matrix = this.parseMatrix(this.getSubElementByName(element, "matrix"));
                List<Element> gradientEntries = this.getAllSubElementsByName(element, "GradientEntry");
                fg.write(0, 0, 0, this.debugRandom ? 85 : 0);
                if ("LinearGradient".equals(element.getTagName())) {
                    fg.writeUI16(16);
                } else {
                    fg.writeUI16(18);
                }
                fg.writeMatrix(matrix);
                fg.write(gradientEntries.size());
                for (Element gradEntry : gradientEntries) {
                    Color color = this.parseColorWithAlpha(gradEntry);
                    float ratio = 0.0f;
                    if (gradEntry.hasAttribute("ratio")) {
                        ratio = Float.parseFloat(gradEntry.getAttribute("ratio"));
                    }
                    fg.write(Math.round(ratio * 255.0f));
                    fg.write(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                }
                break;
            }
            case "BitmapFill": {
                Node bitmapPathAttr = element.getAttributes().getNamedItem("bitmapPath");
                if (bitmapPathAttr == null) break;
                String bitmapPath = bitmapPathAttr.getTextContent();
                List<Element> mediaElements = this.getMedia(document);
                int mediaId = 0;
                for (Element e : mediaElements) {
                    boolean allowSmoothing;
                    String name;
                    ++mediaId;
                    if (!"DOMBitmapItem".equals(e.getNodeName()) || (name = e.getAttribute("name")) == null || !bitmapPath.equals(name)) continue;
                    Matrix bitmapMatrix = this.parseMatrix(this.getSubElementByName(element, "matrix"));
                    boolean bitmapIsClipped = false;
                    Node bitmapIsClippedAttr = element.getAttributes().getNamedItem("bitmapIsClipped");
                    if (bitmapIsClippedAttr != null) {
                        bitmapIsClipped = "true".equals(bitmapIsClippedAttr.getTextContent());
                    }
                    int type = (allowSmoothing = "true".equals(e.getAttribute("allowSmoothing"))) ? (bitmapIsClipped ? 65 : 64) : (bitmapIsClipped ? 67 : 66);
                    fg.write(255, 0, 0, 255);
                    fg.write(type, 0);
                    fg.writeMatrix(bitmapMatrix);
                    if (this.debugRandom) {
                        fg.write(88, 88);
                        break block6;
                    }
                    fg.writeUI16(mediaId);
                    break block6;
                }
                break;
            }
        }
    }

    private void handleShape(Element element, Element document, FlaWriter fg, boolean inGroup, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount) throws IOException {
        this.instanceHeader(element, fg, this.flaFormatVersion.getShapeType(), false);
        fg.write(5);
        Element fillsNode = this.getSubElementByName(element, "fills");
        List<Object> fillStyles = new ArrayList();
        if (fillsNode != null) {
            fillStyles = this.getAllSubElementsByName(fillsNode, "FillStyle");
        }
        Comparator<Node> indexComparator = new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                Node indexAttr1Node = o1.getAttributes().getNamedItem("index");
                int index1 = 0;
                if (indexAttr1Node != null) {
                    index1 = Integer.parseInt(indexAttr1Node.getTextContent());
                }
                Node indexAttr2Node = o2.getAttributes().getNamedItem("index");
                int index2 = 0;
                if (indexAttr2Node != null) {
                    index2 = Integer.parseInt(indexAttr2Node.getTextContent());
                }
                return index1 - index2;
            }
        };
        fillStyles.sort(indexComparator);
        Element strokesNode = this.getSubElementByName(element, "strokes");
        List<Object> strokeStyles = new ArrayList<Node>();
        if (strokesNode != null) {
            strokeStyles = this.getAllSubElementsByName(strokesNode, "StrokeStyle");
        }
        strokeStyles.sort(indexComparator);
        Element edgesNode = this.getSubElementByName(element, "edges");
        List<Object> edges = new ArrayList();
        if (edgesNode != null) {
            edges = this.getAllSubElementsByName(edgesNode, "Edge");
        }
        int totalEdgeCount = 0;
        for (Element element2 : edges) {
            if (!element2.hasAttribute("edges")) continue;
            totalEdgeCount += FlaWriter.getEdgesCount(element2.getAttribute("edges"));
        }
        if (this.debugRandom) {
            fg.writeDebugNote("ECOUNT");
        } else {
            fg.writeUI32(totalEdgeCount);
        }
        fg.write(fillStyles.size(), 0);
        for (Node node : fillStyles) {
            Element element3 = this.getFirstSubElement(node);
            this.handleFill(element3, document, fg);
        }
        fg.write(strokeStyles.size(), 0);
        for (Node node : strokeStyles) {
            Element fill;
            Node scaleModeAttr;
            Element element4 = this.getFirstSubElement(node);
            int scaleMode = FlaWriter.SCALEMODE_NONE;
            double weight = 1.0;
            Node weightAttr = element4.getAttributes().getNamedItem("weight");
            if (weightAttr != null) {
                weight = Double.parseDouble(weightAttr.getTextContent());
            }
            float miterLimit = 3.0f;
            Node miterLimitAttr = element4.getAttributes().getNamedItem("miterLimit");
            if (miterLimitAttr != null) {
                miterLimit = Float.parseFloat(miterLimitAttr.getTextContent());
            }
            int styleParam1 = 0;
            int styleParam2 = 0;
            int joints = FlaWriter.JOINSTYLE_ROUND;
            int caps = FlaWriter.CAPSTYLE_ROUND;
            boolean pixelHinting = false;
            Node pixelHintingAttr = element4.getAttributes().getNamedItem("pixelHinting");
            if (pixelHintingAttr != null && "true".equals(pixelHintingAttr.getTextContent())) {
                pixelHinting = true;
            }
            if ((scaleModeAttr = element4.getAttributes().getNamedItem("scaleMode")) != null) {
                if ("normal".equals(scaleModeAttr.getTextContent())) {
                    scaleMode = FlaWriter.SCALEMODE_NORMAL;
                }
                if ("horizontal".equals(scaleModeAttr.getTextContent())) {
                    scaleMode = FlaWriter.SCALEMODE_HORIZONTAL;
                }
                if ("vertical".equals(scaleModeAttr.getTextContent())) {
                    scaleMode = FlaWriter.SCALEMODE_VERTICAL;
                }
            }
            switch (element4.getNodeName()) {
                case "SolidStroke": {
                    Node jointsAttr;
                    styleParam1 = 0;
                    styleParam2 = 0;
                    Node capsAttr = element4.getAttributes().getNamedItem("caps");
                    if (capsAttr != null) {
                        if ("none".equals(capsAttr.getTextContent())) {
                            caps = FlaWriter.CAPSTYLE_NONE;
                        }
                        if ("square".equals(capsAttr.getTextContent())) {
                            caps = FlaWriter.CAPSTYLE_SQUARE;
                        }
                    }
                    if ((jointsAttr = element4.getAttributes().getNamedItem("joints")) == null) break;
                    if ("bevel".equals(jointsAttr.getTextContent())) {
                        joints = FlaWriter.JOINSTYLE_BEVEL;
                    }
                    if (!"miter".equals(jointsAttr.getTextContent())) break;
                    joints = FlaWriter.JOINSTYLE_MITER;
                    break;
                }
                case "DashedStroke": {
                    Node dash2Attr;
                    double dash1 = 6.0;
                    double dash2 = 6.0;
                    Node dash1Attr = element4.getAttributes().getNamedItem("dash1");
                    if (dash1Attr != null) {
                        dash1 = Double.parseDouble(dash1Attr.getTextContent());
                    }
                    if ((dash2Attr = element4.getAttributes().getNamedItem("dash2")) != null) {
                        dash2 = Double.parseDouble(dash2Attr.getTextContent());
                    }
                    if (dash1 < 0.25 || dash1 > 300.0) {
                        throw new IllegalArgumentException("DashedStroke.dash1 is invalid");
                    }
                    if (dash2 < 0.25 || dash2 > 300.0) {
                        throw new IllegalArgumentException("DashedStroke.dash2 is invalid");
                    }
                    styleParam1 = (int)Math.round(dash1 * 20.0);
                    styleParam2 = (int)Math.round(dash2 * 20.0);
                    break;
                }
                case "DottedStroke": {
                    double dotSpace = 3.0;
                    Node dotSpaceAttr = element4.getAttributes().getNamedItem("dotSpace");
                    if (dotSpaceAttr != null) {
                        dotSpace = Double.parseDouble(dotSpaceAttr.getTextContent());
                    }
                    if (dotSpace < 0.0 || dotSpace > 300.0) {
                        throw new IllegalArgumentException("DottedStroke.dotSpace is invalid");
                    }
                    styleParam2 = (int)(16L * Math.round(dotSpace * 10.0) + 2L);
                    break;
                }
                case "RaggedStroke": {
                    int pattern = this.getAttributeAsInt(element4, "pattern", Arrays.asList("solid", "simple", "random", "dotted", "random dotted", "triple dotted", "random tripple dotted"), "simple");
                    int waveHeight = this.getAttributeAsInt(element4, "waveHeight", Arrays.asList("flat", "wavy", "very wavy", "wild"), "wavy");
                    int waveLength = this.getAttributeAsInt(element4, "waveLength", Arrays.asList("very short", "short", "medium", "long"), "short");
                    styleParam2 = 8 * pattern + 64 * waveHeight + 256 * waveLength + 3;
                    break;
                }
                case "StippleStroke": {
                    int dotSize = this.getAttributeAsInt(element4, "dotSize", Arrays.asList("tiny", "small", "medium", "large"), "small");
                    int variation = this.getAttributeAsInt(element4, "variation", Arrays.asList("one size", "small variation", "varied sizes", "random sizes"), "varied sizes");
                    int density = this.getAttributeAsInt(element4, "density", Arrays.asList("very dense", "dense", "sparse", "very sparse"), "sparse");
                    styleParam2 = 8 * dotSize + 32 * variation + 128 * density + 4;
                    break;
                }
                case "HatchedStroke": {
                    int hatchThickness = this.getAttributeAsInt(element4, "hatchThickness", Arrays.asList("hairline", "thin", "medium", "thick"), "hairline");
                    int space = this.getAttributeAsInt(element4, "space", Arrays.asList("very close", "close", "distant", "very distant"), "distant");
                    int jiggle = this.getAttributeAsInt(element4, "jiggle", Arrays.asList("none", "bounce", "loose", "wild"), "none");
                    int rotate = this.getAttributeAsInt(element4, "rotate", Arrays.asList("none", "slight", "medium", "free"), "none");
                    int curve = this.getAttributeAsInt(element4, "curve", Arrays.asList("straight", "slight curve", "medium curve", "very curved"), "straight");
                    int length = this.getAttributeAsInt(element4, "length", Arrays.asList("equal", "slight variation", "medium variation", "random"), "equal");
                    styleParam2 = 8 * hatchThickness + 32 * space + 512 * jiggle + 128 * rotate + 2048 * curve + 8192 * length + 5;
                }
            }
            Node sharpCornersAttr = element4.getAttributes().getNamedItem("sharpCorners");
            if (sharpCornersAttr != null && "true".equals(sharpCornersAttr.getTextContent()) && this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                styleParam2 += 32768;
            }
            if ((fill = this.getSubElementByName(element4, "fill")) == null) continue;
            Element fillStyleVal = this.getFirstSubElement(fill);
            Color baseColor = new Color(0, 0, 0, this.debugRandom ? 85 : 0);
            if ("SolidColor".equals(fillStyleVal.getNodeName())) {
                baseColor = this.parseColorWithAlpha(fillStyleVal);
            } else if ("BitmapFill".equals(fillStyleVal.getNodeName())) {
                baseColor = Color.red;
            }
            fg.writeStrokeBegin(baseColor, weight, pixelHinting, scaleMode, caps, joints, miterLimit, styleParam1, styleParam2);
            if (this.flaFormatVersion.ordinal() < FlaFormatVersion.F8.ordinal()) continue;
            this.handleFill(fillStyleVal, document, fg);
        }
        if (this.debugRandom) {
            fg.writeDebugNote("EDGES");
        } else {
            fg.beginShape();
            for (Element element5 : edges) {
                Node edgesAttrNode;
                Node fillStyle1StyleAttr;
                Node fillStyle0StyleAttr;
                int n = 0;
                int fillStyle0 = 0;
                int fillStyle1 = 0;
                Node strokeStyleAttr = element5.getAttributes().getNamedItem("strokeStyle");
                if (strokeStyleAttr != null) {
                    n = Integer.parseInt(strokeStyleAttr.getTextContent());
                }
                if ((fillStyle0StyleAttr = element5.getAttributes().getNamedItem("fillStyle0")) != null) {
                    fillStyle0 = Integer.parseInt(fillStyle0StyleAttr.getTextContent());
                }
                if ((fillStyle1StyleAttr = element5.getAttributes().getNamedItem("fillStyle1")) != null) {
                    fillStyle1 = Integer.parseInt(fillStyle1StyleAttr.getTextContent());
                }
                if ((edgesAttrNode = element5.getAttributes().getNamedItem("edges")) == null) continue;
                String edgesStr = edgesAttrNode.getTextContent();
                fg.writeEdges(edgesStr, n, fillStyle0, fillStyle1);
            }
        }
        fg.write(0);
        int totalCubicsCount = 0;
        for (Element element6 : edges) {
            if (!element6.hasAttribute("cubics")) continue;
            ++totalCubicsCount;
        }
        fg.writeUI32(totalCubicsCount);
        for (Element element7 : edges) {
            if (!element7.hasAttribute("cubics")) continue;
            String cubics = element7.getAttribute("cubics");
            Matcher cubicsMatcher = CUBICS_PATTERN.matcher(cubics);
            if (!cubicsMatcher.matches()) {
                Logger.getLogger(TimelineConverter.class.getName()).warning("Cubics pattern does not match for input string " + cubics);
                continue;
            }
            int mx = Integer.parseInt(cubicsMatcher.group("mx"));
            int my = Integer.parseInt(cubicsMatcher.group("my"));
            int x1 = Integer.parseInt(cubicsMatcher.group("x1"));
            int y1 = Integer.parseInt(cubicsMatcher.group("y1"));
            int x2 = Integer.parseInt(cubicsMatcher.group("x2"));
            int y2 = Integer.parseInt(cubicsMatcher.group("y2"));
            int ex = Integer.parseInt(cubicsMatcher.group("ex"));
            int ey = Integer.parseInt(cubicsMatcher.group("ey"));
            Integer pBCPx = null;
            if (cubicsMatcher.group("pBCPx") != null) {
                pBCPx = Integer.parseInt(cubicsMatcher.group("pBCPx"));
            }
            Integer pBCPy = null;
            if (cubicsMatcher.group("pBCPy") != null) {
                pBCPy = Integer.parseInt(cubicsMatcher.group("pBCPy"));
            }
            Integer nBCPx = null;
            if (cubicsMatcher.group("nBCPx") != null) {
                nBCPx = Integer.parseInt(cubicsMatcher.group("nBCPx"));
            }
            Integer nBCPy = null;
            if (cubicsMatcher.group("nBCPy") != null) {
                nBCPy = Integer.parseInt(cubicsMatcher.group("nBCPy"));
            }
            String xy = cubicsMatcher.group("xy");
            Matcher m2 = CUBICS_XY_PATTERN.matcher(xy);
            ArrayList<String> letterList = new ArrayList<String>();
            ArrayList<Integer> xList = new ArrayList<Integer>();
            ArrayList<Integer> yList = new ArrayList<Integer>();
            String lastLetter = "q";
            while (m2.find()) {
                xList.add(Integer.parseInt(m2.group("x")));
                yList.add(Integer.parseInt(m2.group("y")));
                String letter = m2.group("letter");
                if (letter == null || letter.isEmpty()) {
                    letter = lastLetter;
                }
                lastLetter = letter;
                letterList.add(letter);
            }
            fg.writeUI32(mx);
            fg.writeUI32(my);
            fg.writeUI32(x1);
            fg.writeUI32(y1);
            fg.writeUI32(x2);
            fg.writeUI32(y2);
            fg.writeUI32(ex);
            fg.writeUI32(ey);
            if (this.flaFormatVersion.ordinal() < FlaFormatVersion.CS3.ordinal()) continue;
            fg.write(letterList.size());
            block35: for (int i = 0; i < letterList.size(); ++i) {
                fg.writeUI32(((Integer)xList.get(i)).intValue());
                fg.writeUI32(((Integer)yList.get(i)).intValue());
                switch ((String)letterList.get(i)) {
                    case "Q": {
                        fg.write(1, 0);
                        continue block35;
                    }
                    case "q": {
                        fg.write(0, 0);
                        continue block35;
                    }
                    case "P": {
                        fg.write(1, 1);
                        continue block35;
                    }
                    case "p": {
                        fg.write(0, 1);
                    }
                }
            }
            int pnFlags = 0;
            if (pBCPx != null) {
                pnFlags |= 1;
            }
            if (nBCPx != null) {
                pnFlags |= 2;
            }
            fg.write(pnFlags);
            if (pBCPx != null) {
                fg.writeUI32(pBCPx.intValue());
                fg.writeUI32(pBCPy.intValue());
            }
            if (nBCPx == null) continue;
            fg.writeUI32(nBCPx.intValue());
            fg.writeUI32(nBCPy.intValue());
        }
    }

    private boolean isZeroAlphaStroke(Element element) {
        if (element == null) {
            return false;
        }
        if ((element = this.getFirstSubElement(element)) == null) {
            return false;
        }
        if (!element.getTagName().equals("SolidStroke")) {
            return false;
        }
        if ((element = this.getSubElementByName(element, "fill")) == null) {
            return false;
        }
        if ((element = this.getFirstSubElement(element)) == null) {
            return false;
        }
        if (!element.getTagName().equals("SolidColor")) {
            return false;
        }
        String color = element.getAttribute("color");
        if (!color.equals("") && !color.equals("#000000")) {
            return false;
        }
        return element.getAttribute("alpha").equals("0");
    }

    private void writeLayerContents(Element layer, Element document, FlaWriter fg, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount, Reference<Integer> copiedComponentPathRef, Reference<Integer> totalFramesCountRef, Integer overrideLayerType) throws IOException {
        Element framesNode;
        this.useClass("CPicLayer", fg, definedClasses, totalObjectCount);
        fg.write(this.flaFormatVersion.getLayerVersion());
        fg.write(0);
        int layerType = 0;
        if (layer.hasAttribute("layerType")) {
            String layerTypeStr;
            switch (layerTypeStr = layer.getAttribute("layerType")) {
                case "folder": {
                    if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                        layerType = 3;
                        break;
                    }
                    layerType = 1;
                    break;
                }
                case "mask": {
                    layerType = 4;
                    break;
                }
                case "guide": {
                    layerType = 1;
                }
            }
        }
        if (overrideLayerType != null) {
            layerType = overrideLayerType;
        }
        if ((framesNode = this.getSubElementByName(layer, "frames")) != null) {
            List<Element> frames = this.getAllSubElementsByName(framesNode, "DOMFrame");
            String prevTweenType = "";
            for (int f = 0; f < frames.size(); ++f) {
                Element motionObjectXML;
                Element scriptElement;
                this.useClass("CPicFrame", fg, definedClasses, totalObjectCount);
                fg.write(this.flaFormatVersion.getFrameVersion());
                fg.write(0);
                totalFramesCountRef.setVal(totalFramesCountRef.getVal() + 1);
                Element frame = frames.get(f);
                Element elementsNode = this.getSubElementByName(frame, "elements");
                String tweenType = frame.getAttribute("tweenType");
                List<Element> elements = new ArrayList<Element>();
                if (elementsNode != null) {
                    elements = this.getAllSubElements(elementsNode);
                }
                this.handleElements(elements, document, fg, definedClasses, totalObjectCount, copiedComponentPathRef, prevTweenType.equals("motion"), true);
                prevTweenType = tweenType;
                int keyMode = FlaWriter.KEYMODE_STANDARD;
                if (frame.hasAttribute("keyMode")) {
                    keyMode = Integer.parseInt(frame.getAttribute("keyMode"));
                }
                if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F8.ordinal()) {
                    keyMode &= 0xFFFFDFFF;
                }
                int duration = 1;
                if (frame.hasAttribute("duration")) {
                    duration = Integer.parseInt(frame.getAttribute("duration"));
                }
                String actionScript = "";
                Element actionscriptElement = this.getSubElementByName(frame, "Actionscript");
                if (actionscriptElement != null && (scriptElement = this.getSubElementByName(actionscriptElement, "script")) != null && !(actionScript = scriptElement.getTextContent()).isEmpty() && this.flaFormatVersion.ordinal() <= FlaFormatVersion.MX.ordinal() && !actionScript.endsWith("\n")) {
                    actionScript = actionScript + "\n";
                }
                int acceleration = 0;
                if (frame.hasAttribute("acceleration")) {
                    acceleration = Integer.parseInt(frame.getAttribute("acceleration"));
                }
                String name = "";
                if (frame.hasAttribute("name")) {
                    name = frame.getAttribute("name");
                }
                boolean comment = false;
                boolean anchor = false;
                if (frame.hasAttribute("labelType")) {
                    switch (frame.getAttribute("labelType")) {
                        case "comment": {
                            comment = true;
                            break;
                        }
                        case "anchor": {
                            anchor = true;
                        }
                    }
                }
                int motionTweenRotate = 0;
                if (frame.hasAttribute("motionTweenRotate")) {
                    switch (frame.getAttribute("motionTweenRotate")) {
                        case "clockwise": {
                            motionTweenRotate = 1;
                            break;
                        }
                        case "counter-clockwise": {
                            motionTweenRotate = 2;
                            break;
                        }
                        case "none": {
                            break;
                        }
                    }
                }
                int motionTweenRotateTimes = 0;
                if (motionTweenRotate != 0 && frame.hasAttribute("motionTweenRotateTimes")) {
                    motionTweenRotateTimes = Integer.parseInt(frame.getAttribute("motionTweenRotateTimes"));
                }
                int frameId = fg.generateRandomId();
                fg.write(this.flaFormatVersion.getFrameVersionB());
                fg.writeUI16(duration);
                fg.writeUI16(keyMode);
                fg.writeUI16(acceleration);
                int soundId = 0;
                if (frame.hasAttribute("soundName")) {
                    String soundName = frame.getAttribute("soundName");
                    List<Element> media = this.getMedia(document);
                    for (int i = 0; i < media.size(); ++i) {
                        String mediaName;
                        Element mediaItem = media.get(i);
                        if (!mediaItem.hasAttribute("name") || !soundName.equals(mediaName = mediaItem.getAttribute("name"))) continue;
                        soundId = i + 1;
                        break;
                    }
                }
                if (soundId > 0) {
                    fg.writeUI16(soundId);
                    Element soundEnvelope = this.getSubElementByName(frame, "SoundEnvelope");
                    if (soundEnvelope == null) {
                        fg.writeUI16(1);
                        fg.writeUI32(0L);
                        fg.writeUI16(32768);
                        fg.writeUI16(32768);
                    } else {
                        List<Element> soundEnvelopePoints = this.getAllSubElementsByName(soundEnvelope, "SoundEnvelopePoint");
                        fg.writeUI16(soundEnvelopePoints.size());
                        for (Element soundEnvelopePoint : soundEnvelopePoints) {
                            long mark44 = 0L;
                            if (soundEnvelopePoint.hasAttribute("mark44")) {
                                mark44 = Long.parseLong(soundEnvelopePoint.getAttribute("mark44"));
                            }
                            int level0 = 0;
                            if (soundEnvelopePoint.hasAttribute("level0")) {
                                level0 = Integer.parseInt(soundEnvelopePoint.getAttribute("level0"));
                            }
                            int level1 = 0;
                            if (soundEnvelopePoint.hasAttribute("level1")) {
                                level1 = Integer.parseInt(soundEnvelopePoint.getAttribute("level1"));
                            }
                            fg.writeUI32(mark44);
                            fg.writeUI16(level0);
                            fg.writeUI16(level1);
                        }
                    }
                } else {
                    fg.write(0, 0, 0, 0);
                }
                long inPoint44 = 0L;
                if (soundId > 0 && frame.hasAttribute("inPoint44")) {
                    inPoint44 = Long.parseLong(frame.getAttribute("inPoint44"));
                }
                long outPoint44 = 0x3FFFFFFFL;
                if (soundId > 0 && frame.hasAttribute("outPoint44")) {
                    outPoint44 = Long.parseLong(frame.getAttribute("outPoint44"));
                }
                int soundZoomLevel = -1;
                if (frame.hasAttribute("soundZoomLevel")) {
                    soundZoomLevel = Integer.parseInt(frame.getAttribute("soundZoomLevel"));
                }
                int soundSync = 0;
                if (frame.hasAttribute("soundSync")) {
                    switch (frame.getAttribute("soundSync")) {
                        case "start": {
                            soundSync = 1;
                            break;
                        }
                        case "stop": {
                            soundSync = 2;
                            break;
                        }
                        case "stream": {
                            soundSync = 3;
                        }
                    }
                }
                int soundLoop = 1;
                if (frame.hasAttribute("soundLoop")) {
                    soundLoop = Integer.parseInt(frame.getAttribute("soundLoop"));
                }
                boolean loop = false;
                if (frame.hasAttribute("soundLoopMode")) {
                    loop = "loop".equals(frame.getAttribute("soundLoopMode"));
                }
                if (loop) {
                    soundLoop = Short.MAX_VALUE;
                }
                fg.writeUI16(soundLoop);
                fg.write(soundSync);
                fg.writeUI32(inPoint44);
                fg.writeUI32(outPoint44);
                fg.writeUI16(soundZoomLevel);
                fg.writeBomString(name);
                if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F5.ordinal()) {
                    // empty if block
                }
                fg.write(this.flaFormatVersion.getFrameVersionC(), 0, 0, 0, 1, 0, 0, 0);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                    fg.write(frameId >> 8 & 0xFF, frameId & 0xFF);
                    fg.write(0, 0, 0, 0, 0, 0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal()) {
                    fg.write(0, 0, 0, 0);
                }
                fg.writeBomString(actionScript);
                fg.write(motionTweenRotate, 0, 0, 0);
                fg.writeUI16(motionTweenRotateTimes);
                fg.write(0, 0);
                fg.write(comment ? 1 : 0, 0, 0, 0);
                Element morphShape = this.getSubElementByName(frame, "MorphShape");
                if (morphShape == null) {
                    fg.write(0, 0);
                } else {
                    this.useClass("CPicMorphShape", fg, definedClasses, totalObjectCount);
                    fg.write(2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                    List<Object> fillStyles1 = new ArrayList();
                    List<Element> fillStyles2 = new ArrayList();
                    List<Object> strokeStyles1 = new ArrayList();
                    List<Object> strokeStyles2 = new ArrayList();
                    if (f + 1 < frames.size()) {
                        Element domShape2;
                        Element nextFrame = frames.get(f + 1);
                        Element domShape1 = this.getSubElementByName(elementsNode, "DOMShape");
                        Element nextFrameElementsNode = this.getSubElementByName(nextFrame, "elements");
                        if (domShape1 != null && nextFrameElementsNode != null && (domShape2 = this.getSubElementByName(nextFrameElementsNode, "DOMShape")) != null) {
                            Element fills1 = this.getSubElementByName(domShape1, "fills");
                            Element fills2 = this.getSubElementByName(domShape2, "fills");
                            Element strokes1 = this.getSubElementByName(domShape1, "strokes");
                            Element strokes2 = this.getSubElementByName(domShape2, "strokes");
                            if (fills1 != null) {
                                fillStyles1 = this.getAllSubElementsByName(fills1, "FillStyle");
                            }
                            if (fills2 != null) {
                                fillStyles2 = this.getAllSubElementsByName(fills2, "FillStyle");
                            }
                            if (strokes1 != null) {
                                strokeStyles1 = this.getAllSubElementsByName(strokes1, "StrokeStyle");
                            }
                            if (strokes2 != null) {
                                strokeStyles2 = this.getAllSubElementsByName(strokes2, "StrokeStyle");
                            }
                        }
                    }
                    ArrayList<Element> fills = new ArrayList<Element>();
                    ArrayList<Element> strokes = new ArrayList<Element>();
                    if (!fillStyles1.isEmpty()) {
                        int maxNumFills = Math.max(fillStyles1.size(), fillStyles2.size());
                        for (int i = 0; i < maxNumFills; ++i) {
                            Element fill1 = fillStyles1.size() > i ? (Element)fillStyles1.get(i) : null;
                            Element fill2 = fillStyles2.size() > i ? (Element)fillStyles2.get(i) : null;
                            fills.add(fill1);
                            if (TimelineConverter.areElementsEqual(fill1, fill2, false) && this.flaFormatVersion.ordinal() > FlaFormatVersion.MX.ordinal()) continue;
                            fills.add(fill2);
                        }
                    }
                    if (!strokeStyles1.isEmpty() || !strokeStyles2.isEmpty()) {
                        int maxNumStrokes = Math.max(strokeStyles1.size(), strokeStyles2.size());
                        for (int i = 0; i < maxNumStrokes; ++i) {
                            Element stroke1 = strokeStyles1.size() > i ? (Element)strokeStyles1.get(i) : null;
                            Element stroke2 = strokeStyles2.size() > i ? (Element)strokeStyles2.get(i) : null;
                            strokes.add(stroke1);
                            if (TimelineConverter.areElementsEqual(stroke1, stroke2, false) && this.flaFormatVersion.ordinal() > FlaFormatVersion.MX.ordinal()) continue;
                            strokes.add(stroke2);
                        }
                    }
                    Element morphSegmentsElement = this.getSubElementByName(morphShape, "morphSegments");
                    List<Element> morphSegments = this.getAllSubElementsByName(morphSegmentsElement, "MorphSegment");
                    fg.writeUI16(morphSegments.size());
                    for (Element morphSegment : morphSegments) {
                        this.useClass("CMorphSegment", fg, definedClasses, totalObjectCount);
                        Point2D startpointA = fg.parsePoint(morphSegment.getAttribute("startPointA"));
                        Point2D startpointB = fg.parsePoint(morphSegment.getAttribute("startPointB"));
                        int strokeIndex1 = -1;
                        if (morphSegment.hasAttribute("strokeIndex1")) {
                            strokeIndex1 = Integer.parseInt(morphSegment.getAttribute("strokeIndex1"));
                        }
                        int strokeIndex2 = -1;
                        if (morphSegment.hasAttribute("strokeIndex2")) {
                            strokeIndex2 = Integer.parseInt(morphSegment.getAttribute("strokeIndex2"));
                        }
                        int fillIndex1 = -1;
                        if (morphSegment.hasAttribute("fillIndex1")) {
                            fillIndex1 = Integer.parseInt(morphSegment.getAttribute("fillIndex1"));
                        }
                        int fillIndex2 = -1;
                        if (morphSegment.hasAttribute("fillIndex2")) {
                            fillIndex2 = Integer.parseInt(morphSegment.getAttribute("fillIndex2"));
                        }
                        fg.writeUI32(strokeIndex1);
                        fg.writeUI32(strokeIndex2);
                        fg.writeUI32(fillIndex1);
                        fg.writeUI32(fillIndex2);
                        fg.writePoint(startpointA);
                        fg.writePoint(startpointB);
                        List<Element> morphCurvesList = this.getAllSubElementsByName(morphSegment, "MorphCurves");
                        fg.writeUI16(morphCurvesList.size());
                        for (Element morphCurves : morphCurvesList) {
                            this.useClass("CMorphCurve", fg, definedClasses, totalObjectCount);
                            Point2D controlPointA = fg.parsePoint(morphCurves.getAttribute("controlPointA"));
                            Point2D anchorPointA = fg.parsePoint(morphCurves.getAttribute("anchorPointA"));
                            Point2D controlPointB = fg.parsePoint(morphCurves.getAttribute("controlPointB"));
                            Point2D anchorPointB = fg.parsePoint(morphCurves.getAttribute("anchorPointB"));
                            boolean isLine = false;
                            if (morphCurves.hasAttribute("isLine")) {
                                isLine = "true".equals(morphCurves.getAttribute("isLine"));
                            }
                            fg.writePoint(controlPointA);
                            fg.writePoint(anchorPointA);
                            fg.writePoint(controlPointB);
                            fg.writePoint(anchorPointB);
                            fg.write(isLine ? 1 : 0);
                            fg.write(0, 0, 0);
                        }
                    }
                    fg.writeUI16(0);
                    fg.writeUI16(fills.size());
                    for (Element fill : fills) {
                        this.writeMorphFillStylePart(document, fg, fill);
                    }
                    if (strokeStyles1.isEmpty() && strokeStyles2.isEmpty()) {
                        if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.MX.ordinal()) {
                            fg.writeUI16(2);
                            fg.writeUI32(0L);
                            fg.writeUI32(0L);
                            fg.writeUI16(0);
                            fg.writeUI32(0L);
                            fg.writeUI32(0L);
                            fg.writeUI16(0);
                        } else {
                            fg.writeUI16(1);
                            fg.writeUI32(0L);
                            fg.writeUI32(0L);
                            fg.writeUI16(0);
                        }
                    } else {
                        fg.writeUI16(strokes.size());
                        for (Element stroke : strokes) {
                            this.writeMorphStrokeStylePart(fg, stroke);
                        }
                    }
                }
                int shapeTweenBlend = 0;
                if (frame.hasAttribute("shapeTweenBlend")) {
                    switch (frame.getAttribute("shapeTweenBlend")) {
                        case "angular": {
                            shapeTweenBlend = 1;
                        }
                    }
                }
                fg.write(shapeTweenBlend);
                boolean useSingleEaseCurve = true;
                if (frame.hasAttribute("useSingleEaseCurve")) {
                    useSingleEaseCurve = !"false".equals(frame.getAttribute("useSingleEaseCurve"));
                }
                int soundEffect = this.getAttributeAsInt(frame, "soundEffect", Arrays.asList("none", "left channel", "right channel", "fade left to right", "fade right to left", "fade in", "fade out", "custom"), "none");
                fg.write(0, 0, 0, 0, 0);
                fg.writeBomString("");
                fg.write(1, 0, 0, 0, soundEffect, 0, 0, 0);
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
                    fg.write(anchor ? 1 : 0, 0, 0, 0);
                }
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
                    fg.write(useSingleEaseCurve ? 1 : 0, 0, 0, 0);
                    boolean hasCustomEase = false;
                    if (frame.hasAttribute("hasCustomEase")) {
                        hasCustomEase = "true".equals(frame.getAttribute("hasCustomEase"));
                    }
                    fg.writeUI32(hasCustomEase ? 1L : 0L);
                    if (hasCustomEase) {
                        Element tweensElement = this.getSubElementByName(frame, "tweens");
                        List<String> properties = Arrays.asList("position", "rotation", "scale", "color", "filters", "all");
                        if (tweensElement == null) {
                            for (int i = 0; i < properties.size(); ++i) {
                                fg.writeUI32(0L);
                            }
                        } else {
                            List<Element> customEaseElements = this.getAllSubElementsByName(tweensElement, "CustomEase");
                            HashMap<String, Element> targetToCustomEase = new HashMap<String, Element>();
                            for (Element el : customEaseElements) {
                                if (!el.hasAttribute("target")) continue;
                                targetToCustomEase.put(el.getAttribute("target"), el);
                            }
                            for (String property : properties) {
                                if (!targetToCustomEase.containsKey(property)) {
                                    fg.writeUI32(0L);
                                    continue;
                                }
                                List<Element> points = this.getAllSubElementsByName((Node)targetToCustomEase.get(property), "Point");
                                int numPoints = 2 + (points.size() - 4) / 3;
                                fg.writeUI32(numPoints);
                                for (int p = 0; p < points.size(); ++p) {
                                    Element point = points.get(p);
                                    double x = 0.0;
                                    if (point.hasAttribute("x")) {
                                        x = Double.parseDouble(point.getAttribute("x"));
                                    }
                                    double y = 0.0;
                                    if (point.hasAttribute("y")) {
                                        y = Double.parseDouble(point.getAttribute("y"));
                                    }
                                    if (x < 0.0) {
                                        x = 0.0;
                                    }
                                    if (y < 0.0) {
                                        y = 0.0;
                                    }
                                    if (p == 0 || p == points.size() - 1) {
                                        if (this.debugRandom) {
                                            fg.write(88, 88, 88, 88, 88, 88, 88, 88);
                                            fg.write(88, 88, 88, 88, 88, 88, 88, 88);
                                        } else {
                                            fg.writeDouble(x);
                                            fg.writeDouble(y);
                                        }
                                    }
                                    if (this.debugRandom) {
                                        fg.write(88, 88, 88, 88, 88, 88, 88, 88);
                                        fg.write(88, 88, 88, 88, 88, 88, 88, 88);
                                        continue;
                                    }
                                    fg.writeDouble(x);
                                    fg.writeDouble(y);
                                }
                            }
                        }
                    }
                }
                if ((motionObjectXML = this.getSubElementByName(frame, "motionObjectXML")) == null) continue;
                if (this.flaFormatVersion == FlaFormatVersion.CS4) {
                    fg.writeBomString(TimelineConverter.getInnerXml(motionObjectXML));
                    long visibleAnimationKeyframes = 0x1FFFFFL;
                    if (frame.hasAttribute("visibleAnimationKeyframes")) {
                        visibleAnimationKeyframes = Long.parseLong(frame.getAttribute("visibleAnimationKeyframes"));
                    }
                    fg.writeUI32(visibleAnimationKeyframes);
                    String tweenInstanceName = "";
                    if (frame.hasAttribute("tweenInstanceName")) {
                        tweenInstanceName = frame.getAttribute("tweenInstanceName");
                    }
                    fg.writeBomString(tweenInstanceName);
                    continue;
                }
                Logger.getLogger(TimelineConverter.class.getName()).warning("Motion objects are not supported in Flash lower than CS4");
            }
        }
        String layerName = "Layer";
        Node layerNameAttr = layer.getAttributes().getNamedItem("name");
        if (layerNameAttr != null) {
            layerName = layerNameAttr.getTextContent();
        }
        Node outlineAttr = layer.getAttributes().getNamedItem("outline");
        Node useOutlineViewAttr = layer.getAttributes().getNamedItem("useOutlineView");
        boolean showOutlines = false;
        if (outlineAttr != null && useOutlineViewAttr != null) {
            showOutlines = "true".equals(outlineAttr.getTextContent()) && "true".equals(useOutlineViewAttr.getTextContent());
        }
        Color color = Color.BLACK;
        Node colorAttr = layer.getAttributes().getNamedItem("color");
        if (colorAttr != null) {
            color = this.parseColor(colorAttr.getTextContent());
        }
        boolean hiddenLayer = false;
        Node visibleAttr = layer.getAttributes().getNamedItem("visible");
        if (visibleAttr != null) {
            hiddenLayer = "false".equals(visibleAttr.getTextContent());
        }
        boolean lockedLayer = false;
        Node lockedAttr = layer.getAttributes().getNamedItem("locked");
        if (lockedAttr != null) {
            lockedLayer = "true".equals(lockedAttr.getTextContent());
        }
        boolean isSelected = false;
        Node isSelectedAttr = layer.getAttributes().getNamedItem("isSelected");
        if (isSelectedAttr != null) {
            isSelected = "true".equals(isSelectedAttr.getTextContent());
        }
        int heightMultiplier = 1;
        if (layer.hasAttribute("heightMultiplier")) {
            heightMultiplier = Integer.parseInt(layer.getAttribute("heightMultiplier"));
        }
        fg.write(0, 0, 0, 0, 0, 128, 0, 0, 0, 128);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            fg.write(0, 0);
        }
        fg.write(this.flaFormatVersion.getLayerVersionB());
        fg.writeBomString(layerName);
        fg.write(isSelected ? 1 : 0);
        fg.write(hiddenLayer ? 1 : 0);
        fg.write(lockedLayer ? 1 : 0);
        fg.write(255, 255, 255, 255);
        fg.write(color.getRed());
        fg.write(color.getGreen());
        fg.write(color.getBlue());
        fg.write(255);
        fg.write(showOutlines ? 1 : 0);
        fg.write(0, 0, 0, heightMultiplier, 0, 0, 0);
        fg.write(layerType);
    }

    private static boolean areElementsEqual(Element elem1, Element elem2, boolean includeAttributes) {
        if (elem1 == elem2) {
            return true;
        }
        if (elem1 == null || elem2 == null) {
            return false;
        }
        if (!elem1.getTagName().equals(elem2.getTagName())) {
            return false;
        }
        if (includeAttributes && !TimelineConverter.areAttributesEqual(elem1, elem2)) {
            return false;
        }
        NodeList children1 = elem1.getChildNodes();
        NodeList children2 = elem2.getChildNodes();
        if (children1.getLength() != children2.getLength()) {
            return false;
        }
        for (int i = 0; i < children1.getLength(); ++i) {
            Node child1 = children1.item(i);
            Node child2 = children2.item(i);
            if (!(child1.getNodeType() == 1 && child2.getNodeType() == 1 ? !TimelineConverter.areElementsEqual((Element)child1, (Element)child2, true) : !child1.isEqualNode(child2))) continue;
            return false;
        }
        return true;
    }

    private static boolean areAttributesEqual(Element elem1, Element elem2) {
        NamedNodeMap attributes1 = elem1.getAttributes();
        NamedNodeMap attributes2 = elem2.getAttributes();
        if (attributes1.getLength() != attributes2.getLength()) {
            return false;
        }
        for (int i = 0; i < attributes1.getLength(); ++i) {
            Node attr1 = attributes1.item(i);
            Node attr2 = attributes2.getNamedItem(attr1.getNodeName());
            if (attr2 != null && attr1.getNodeValue().equals(attr2.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static String getInnerXml(Element element) {
        StringBuilder innerXml = new StringBuilder();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "no");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(writer));
                innerXml.append(writer.toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return innerXml.toString();
    }

    private void writeLayer(Element document, FlaWriter fg, List<Element> layers, int layerIndex, Set<Integer> writtenLayers, Map<String, Integer> definedClasses, Reference<Integer> totalObjectCount, Reference<Integer> copiedComponentPathRef, Reference<Integer> totalFramesCountRef, Map<Integer, Integer> layerIndexToNValue, boolean hasChildren) throws IOException {
        String layerTypeStr;
        if (writtenLayers.contains(layerIndex)) {
            return;
        }
        writtenLayers.add(layerIndex);
        Element layer = layers.get(layerIndex);
        boolean autoNamed = true;
        if (layer.hasAttribute("autoNamed")) {
            autoNamed = !"false".equals(layer.getAttribute("autoNamed"));
        }
        boolean canHaveSubLayers = false;
        boolean isNormalLayer = false;
        switch (layerTypeStr = layer.getAttribute("layerType")) {
            case "folder": {
                canHaveSubLayers = true;
                if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) break;
                layerTypeStr = "";
                canHaveSubLayers = false;
                break;
            }
            case "mask": 
            case "guide": {
                canHaveSubLayers = true;
                break;
            }
            default: {
                layerTypeStr = "";
                isNormalLayer = true;
            }
        }
        boolean open = true;
        if (layer.hasAttribute("open")) {
            open = !"false".equals(layer.getAttribute("open"));
        }
        int parentLayerIndex = -1;
        if (layer.hasAttribute("parentLayerIndex")) {
            parentLayerIndex = Integer.parseInt(layer.getAttribute("parentLayerIndex"));
        }
        Integer overrideLayerType = null;
        String parentLayerType = "-";
        if (parentLayerIndex > -1 && this.flaFormatVersion.ordinal() < FlaFormatVersion.MX.ordinal()) {
            parentLayerType = layers.get(parentLayerIndex).getAttribute("layerType");
            if (parentLayerType.equals("folder")) {
                parentLayerType = "";
                parentLayerIndex = -1;
            }
            if (parentLayerType.equals("guide") && isNormalLayer) {
                overrideLayerType = 2;
            }
        }
        int animationType = 0;
        if (layer.hasAttribute("animationType")) {
            switch (layer.getAttribute("animationType")) {
                case "motion object": {
                    animationType = 1;
                    break;
                }
            }
        }
        int nValue = 1 + definedClasses.size() + totalObjectCount.getVal();
        layerIndexToNValue.put(layerIndex, nValue);
        this.writeLayerContents(layer, document, fg, definedClasses, totalObjectCount, copiedComponentPathRef, totalFramesCountRef, overrideLayerType);
        if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F5.ordinal() && parentLayerType.equals("mask")) {
            fg.write(0, 0);
        }
        if (parentLayerIndex > -1 && !writtenLayers.contains(parentLayerIndex)) {
            this.writeLayer(document, fg, layers, parentLayerIndex, writtenLayers, definedClasses, totalObjectCount, copiedComponentPathRef, totalFramesCountRef, layerIndexToNValue, true);
        } else {
            if (parentLayerIndex > -1) {
                fg.writeEncodedUI(layerIndexToNValue.get(parentLayerIndex));
            } else {
                fg.writeUI16(0);
            }
            if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F5.ordinal()) {
                if (parentLayerType.equals("mask")) {
                    fg.write(0);
                } else if (parentLayerType.equals("guide")) {
                    fg.write(0, 0, 0);
                } else if (layerTypeStr.equals("")) {
                    fg.write(0, 0, 0);
                }
            }
        }
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.MX.ordinal()) {
            fg.write(open ? 1 : 0);
            fg.write(autoNamed ? 1 : 0);
        } else if (layerTypeStr.equals("mask")) {
            fg.write(0, 0, 1);
            if (hasChildren) {
                fg.write(0);
            }
        } else if (layerTypeStr.equals("guide")) {
            fg.write(0, 0, 0);
            if (hasChildren) {
                fg.write(0, 0, 0);
            }
        }
        if (this.flaFormatVersion == FlaFormatVersion.CS4) {
            fg.write(animationType);
        }
        if (isNormalLayer) {
            int pi = parentLayerIndex;
            int li = layerIndex;
            while (pi > -1 && li == pi + 1) {
                fg.writeEncodedUI(layerIndexToNValue.get(pi));
                Element player = layers.get(pi);
                li = pi;
                if (player.hasAttribute("parentLayerIndex")) {
                    pi = Integer.parseInt(player.getAttribute("parentLayerIndex"));
                    continue;
                }
                pi = -1;
            }
        }
        if (this.flaFormatVersion.ordinal() <= FlaFormatVersion.F5.ordinal()) {
            // empty if block
        }
    }

    public void convert(Element domTimeLine, Element document, OutputStream os) throws SAXException, IOException, ParserConfigurationException {
        FlaWriter fg = new FlaWriter(os, this.flaFormatVersion);
        fg.setTitle(this.getTitle());
        fg.setDebugRandom(this.debugRandom);
        HashMap<String, Integer> definedClasses = new HashMap<String, Integer>();
        Reference<Integer> totalObjectCount = new Reference<Integer>(0);
        fg.write(1);
        this.useClass("CPicPage", fg, definedClasses, totalObjectCount);
        fg.write(this.flaFormatVersion.getPageVersion());
        fg.write(0);
        int nextLayerId = 1;
        int nextFolderId = 1;
        Reference<Integer> copiedComponentPathRef = new Reference<Integer>(0);
        Reference<Integer> totalFramesCountRef = new Reference<Integer>(0);
        Element layersNode = this.getSubElementByName(domTimeLine, "layers");
        if (layersNode != null) {
            List<Element> layers = this.getAllSubElementsByName(layersNode, "DOMLayer");
            HashMap<Integer, Integer> layerIndexToNValue = new HashMap<Integer, Integer>();
            HashSet<Integer> writtenLayers = new HashSet<Integer>();
            for (int layerIndex = layers.size() - 1; layerIndex >= 0; --layerIndex) {
                this.writeLayer(document, fg, layers, layerIndex, writtenLayers, definedClasses, totalObjectCount, copiedComponentPathRef, totalFramesCountRef, layerIndexToNValue, false);
            }
        }
        int currentFrame = 0;
        if (domTimeLine.hasAttribute("currentFrame")) {
            currentFrame = Integer.parseInt(domTimeLine.getAttribute("currentFrame"));
        }
        if (this.debugRandom) {
            nextLayerId = 88;
            nextFolderId = 88;
        }
        fg.write(0, 0, 0, 0, 0, 128, 0, 0, 0, 128);
        if (this.flaFormatVersion.ordinal() >= FlaFormatVersion.F8.ordinal()) {
            fg.write(0, 0, 7, nextLayerId, 0, nextFolderId, 0, currentFrame, 0, 0, 0);
        } else if (this.flaFormatVersion == FlaFormatVersion.MX2004) {
            fg.write(5);
            if (this.debugRandom) {
                fg.write(85, 85, 85, 85);
            } else {
                fg.write(2, 0, 1, 0);
            }
        } else {
            fg.write(3);
            if (this.debugRandom) {
                fg.write(85, 85);
            } else {
                fg.write(2, 0);
            }
        }
        if (domTimeLine.hasAttribute("guides")) {
            String guidesXml = domTimeLine.getAttribute("guides");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document guidesDocument = docBuilder.parse(new ByteArrayInputStream(guidesXml.getBytes("UTF-8")));
            Element guidesRoot = guidesDocument.getDocumentElement();
            List<Element> guidelines = this.getAllSubElementsByName(guidesRoot, "guideline");
            fg.writeUI32(guidelines.size());
            for (Element guideline : guidelines) {
                int direction = 0;
                if (guideline.hasAttribute("direction") && "v".equals(guideline.getAttribute("direction"))) {
                    direction = 1;
                }
                long value = Long.parseLong(guideline.getTextContent()) * 20L;
                fg.writeUI32(direction);
                fg.writeUI32(value);
            }
        } else {
            fg.write(0, 0, 0, 0);
        }
    }
}

