/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash.messages.in;

import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.InDebuggerMessage;
import java.util.ArrayList;
import java.util.List;

public class InBreakAtExt
extends InDebuggerMessage {
    public static final int ID = 27;
    public int file;
    public int line;
    public List<Integer> files;
    public List<Integer> lines;
    public List<Long> ids;
    public List<String> stacks;

    @Override
    public String toString() {
        return super.toString() + "(file=" + this.file + ", line=" + this.line + ", items.count=" + this.files.size() + ")";
    }

    public InBreakAtExt(DebuggerConnection c, byte[] data) {
        super(c, 27, data);
        if (!this.wideLines) {
            this.file = this.readWord();
            this.line = this.readWord();
        } else {
            this.file = (int)this.readDWord();
            this.line = (int)this.readDWord();
        }
        long num = this.readDWord();
        this.files = new ArrayList<Integer>();
        this.lines = new ArrayList<Integer>();
        this.ids = new ArrayList<Long>();
        this.stacks = new ArrayList<String>();
        for (long i = 0L; i < num; ++i) {
            int line_i;
            int file_i;
            if (!this.wideLines) {
                file_i = this.readWord();
                line_i = this.readWord();
            } else {
                file_i = (int)this.readDWord();
                line_i = (int)this.readDWord();
            }
            long id = this.readPtr(c);
            String stack = this.readString();
            this.files.add(file_i);
            this.lines.add(line_i);
            this.ids.add(id);
            this.stacks.add(stack);
        }
    }
}

