/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

import com.jpexs.debugger.flash.DebugMessageListener;
import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.debugger.flash.InDebuggerMessage;
import com.jpexs.debugger.flash.OutDebuggerMessage;
import com.jpexs.debugger.flash.messages.in.InExit;
import com.jpexs.debugger.flash.messages.out.OutSetActiveIsolate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebuggerConnection
extends Thread {
    private final InputStream is;
    private final OutputStream os;
    private final Socket s;
    private boolean isClosed = false;
    private static final String DEBUG_MESSAGES = "$debug_messages";
    private static final String DEBUG_MESSAGE_SIZE = "$debug_message_size";
    private static final String DEBUG_MESSAGE_FILE = "$debug_message_file";
    private static final String DEBUG_MESSAGE_FILE_SIZE = "$debug_message_file_size";
    private static final String CONSOLE_ERRORS = "$console_errors";
    private static final String FLASH_PREFIX = "$flash_";
    public static final int PREF_RESPONSE_TIMEOUT = 750;
    public int playerVersion = 0;
    public int sizeOfPtr = 4;
    public boolean squelchEnabled = false;
    public Map<String, String> parameters = new HashMap<String, String>();
    public Map<String, String> options = new HashMap<String, String>();
    public boolean wideLines = false;
    private final Object listenersLock = new Object();
    protected List<DebugMessageListener> messageListeners = new ArrayList<DebugMessageListener>();
    public static final int DEFAULT_ISOLATE_ID = 1;
    public int activeIsolateId = -1;
    public boolean isAS3 = false;
    public boolean isPaused = false;
    private static ExecutorService pool = null;
    final DebuggerCommands dc;
    private List<InDebuggerMessage> received = new ArrayList<InDebuggerMessage>();
    private List<Class<? extends InDebuggerMessage>> dropped = new ArrayList<Class<? extends InDebuggerMessage>>();
    private final Object receivedLock = new Object();

    private static ExecutorService getPool() {
        if (pool == null) {
            pool = Executors.newFixedThreadPool(10);
        }
        return pool;
    }

    public void disconnect() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(final DebugMessageListener l) {
        ArrayList<InDebuggerMessage> list;
        Object object = this.receivedLock;
        synchronized (object) {
            list = new ArrayList<InDebuggerMessage>(this.received);
        }
        for (final InDebuggerMessage msg : list) {
            DebuggerConnection.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    DebuggerConnection.this.handle(l, msg);
                }
            });
        }
        object = this.listenersLock;
        synchronized (object) {
            this.messageListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(DebugMessageListener l) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.messageListeners.remove(l);
        }
    }

    public DebuggerConnection(Socket s) throws IOException {
        this.s = s;
        this.is = new BufferedInputStream(s.getInputStream());
        this.os = new BufferedOutputStream(s.getOutputStream());
        this.dc = new DebuggerCommands(this);
    }

    private boolean handle(DebugMessageListener<InDebuggerMessage> l, InDebuggerMessage msg) {
        try {
            Class actualType = (Class)((ParameterizedType)l.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            boolean canHandle = actualType.isAssignableFrom(msg.getClass());
            if (!canHandle) {
                return false;
            }
            l.message(msg);
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(DebuggerConnection.class.getName()).log(Level.SEVERE, "handle error", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends InDebuggerMessage> void dropMessageClass(Class<E> msgType) {
        Object object = this.receivedLock;
        synchronized (object) {
            this.dropped.add(msgType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropMessage(InDebuggerMessage msg) {
        Object object = this.receivedLock;
        synchronized (object) {
            this.received.remove(msg);
        }
    }

    public <E extends InDebuggerMessage> E getMessage(Class<E> msgType) throws IOException {
        return this.getMessage(msgType, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E extends InDebuggerMessage> E getMessage(Class<E> msgType, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        long maxFinishTime = startTime + timeout;
        Object object = this.receivedLock;
        synchronized (object) {
            block6: while (true) {
                int i = 0;
                while (true) {
                    block15: {
                        InDebuggerMessage msg;
                        if (i < this.received.size()) {
                            msg = this.received.get(i);
                        } else {
                            long currentTime = System.currentTimeMillis();
                            long remainingTime = maxFinishTime - currentTime;
                            if (timeout > 0L && remainingTime <= 0L) {
                                return null;
                            }
                            try {
                                if (timeout > 0L) {
                                    this.receivedLock.wait(remainingTime);
                                } else {
                                    this.receivedLock.wait();
                                }
                                DebuggerConnection debuggerConnection = this;
                                synchronized (debuggerConnection) {
                                    boolean cls = this.isClosed;
                                    if (!cls) continue block6;
                                }
                                throw new IOException("Disconnected");
                            }
                            catch (InterruptedException ex) {
                                throw new IOException("Disconnected");
                            }
                        }
                        for (int d = 0; d < this.dropped.size(); ++d) {
                            Class<? extends InDebuggerMessage> dc = this.dropped.get(d);
                            if (!msgType.isAssignableFrom(dc)) continue;
                            this.received.remove(i);
                            this.dropped.remove(d);
                            --i;
                            break block15;
                        }
                        if (msgType.isAssignableFrom(msg.getClass())) {
                            this.received.remove(i);
                            return (E)msg;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners(final InDebuggerMessage msg) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (final DebugMessageListener listener : this.messageListeners) {
                DebuggerConnection.getPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        DebuggerConnection.this.handle(listener, msg);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            Object object;
            try {
                InDebuggerMessage msg = this.readMessage();
                if (msg instanceof InExit) {
                    object = this;
                    synchronized (object) {
                        this.isClosed = true;
                        this.disconnect();
                        break;
                    }
                }
                Logger.getLogger(DebuggerConnection.class.getName()).log(Level.FINER, "Received: {0}", msg);
                msg.exec();
                this.fireListeners(msg);
                object = this.receivedLock;
                synchronized (object) {
                    this.received.add(msg);
                    this.receivedLock.notifyAll();
                    continue;
                }
            }
            catch (IOException ex) {
                object = this;
                synchronized (object) {
                    this.isClosed = true;
                }
                this.received.clear();
                this.disconnect();
            }
            break;
        }
    }

    protected InDebuggerMessage readMessage() throws IOException {
        int cnt;
        int size = (int)this.readDword();
        if (size < 0) {
            throw new IOException("Socket closed");
        }
        int type = (int)this.readDword();
        byte[] buf = new byte[size];
        for (int offset = 0; offset < size && (cnt = this.is.read(buf, offset, size - offset)) > 0; offset += cnt) {
        }
        return InDebuggerMessage.getInstance(this, type, buf);
    }

    public synchronized void writeMessage(OutDebuggerMessage v) throws IOException {
        int targetIsolate;
        Logger.getLogger(DebuggerConnection.class.getName()).log(Level.FINER, "Sending: {0}", v);
        if (v.type != OutSetActiveIsolate.ID && (targetIsolate = v.targetIsolate) != this.activeIsolateId) {
            this.activeIsolateId = targetIsolate;
            Logger.getLogger(DebuggerConnection.class.getName()).log(Level.FINER, "Isolate do not match, switching isolate");
            this.writeMessage(new OutSetActiveIsolate(this, (long)targetIsolate));
        }
        byte[] data = v.getData();
        Logger.getLogger(DebuggerConnection.class.getName()).log(Level.FINEST, "Writing data");
        this.writeDword(data.length);
        this.writeDword(v.type);
        this.os.write(data);
        this.os.flush();
        Logger.getLogger(DebuggerConnection.class.getName()).log(Level.FINEST, "Sent: {0}", v);
    }

    public <E extends InDebuggerMessage> E sendMessage(OutDebuggerMessage v, Class<E> cls) throws IOException {
        this.writeMessage(v);
        return this.getMessage(cls, 0L);
    }

    public <E extends InDebuggerMessage> E sendMessageWithTimeout(OutDebuggerMessage v, Class<E> cls) throws IOException {
        this.writeMessage(v);
        return this.getMessage(cls, 750L);
    }

    public <E extends InDebuggerMessage> E sendMessage(OutDebuggerMessage v, Class<E> cls, long timeout) throws IOException {
        this.writeMessage(v);
        return this.getMessage(cls, timeout);
    }

    public <E extends InDebuggerMessage> void sendMessageIgnoreResult(OutDebuggerMessage v, Class<E> cls) throws IOException {
        this.writeMessage(v);
        this.dropMessageClass(cls);
    }

    protected long readDword() throws IOException {
        int b1 = this.is.read();
        int b2 = this.is.read();
        int b3 = this.is.read();
        int b4 = this.is.read();
        return (b4 << 24) + (b3 << 16) + (b2 << 8) + b1;
    }

    protected void writeDword(long val) throws IOException {
        int b1 = (int)(val & 0xFFL);
        int b2 = (int)(val >> 8 & 0xFFL);
        int b3 = (int)(val >> 16 & 0xFFL);
        int b4 = (int)(val >> 24 & 0xFFL);
        this.os.write(b1);
        this.os.write(b2);
        this.os.write(b3);
        this.os.write(b4);
    }
}

