/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InBreakAtExt;
import com.jpexs.debugger.flash.messages.in.InCallFunction;
import com.jpexs.debugger.flash.messages.in.InConstantPool;
import com.jpexs.debugger.flash.messages.in.InContinue;
import com.jpexs.debugger.flash.messages.in.InFrame;
import com.jpexs.debugger.flash.messages.in.InGetActions;
import com.jpexs.debugger.flash.messages.in.InGetFncNames;
import com.jpexs.debugger.flash.messages.in.InGetVariable;
import com.jpexs.debugger.flash.messages.in.InOption;
import com.jpexs.debugger.flash.messages.in.InSetBreakpoint;
import com.jpexs.debugger.flash.messages.in.InSetVariable;
import com.jpexs.debugger.flash.messages.in.InSetVariable2;
import com.jpexs.debugger.flash.messages.in.InSquelch;
import com.jpexs.debugger.flash.messages.in.InSwfInfo;
import com.jpexs.debugger.flash.messages.in.InWatch2;
import com.jpexs.debugger.flash.messages.out.OutAddWatch2;
import com.jpexs.debugger.flash.messages.out.OutCallFunction;
import com.jpexs.debugger.flash.messages.out.OutConstantPool;
import com.jpexs.debugger.flash.messages.out.OutContinue;
import com.jpexs.debugger.flash.messages.out.OutExit;
import com.jpexs.debugger.flash.messages.out.OutGetActions;
import com.jpexs.debugger.flash.messages.out.OutGetFncNames;
import com.jpexs.debugger.flash.messages.out.OutGetFrame;
import com.jpexs.debugger.flash.messages.out.OutGetOption;
import com.jpexs.debugger.flash.messages.out.OutGetVariable;
import com.jpexs.debugger.flash.messages.out.OutGetVariableWhichInvokesGetter;
import com.jpexs.debugger.flash.messages.out.OutRemoveBreakpoints;
import com.jpexs.debugger.flash.messages.out.OutRemoveWatch2;
import com.jpexs.debugger.flash.messages.out.OutSetActiveIsolate;
import com.jpexs.debugger.flash.messages.out.OutSetBreakpoints;
import com.jpexs.debugger.flash.messages.out.OutSetOption;
import com.jpexs.debugger.flash.messages.out.OutSetSquelch;
import com.jpexs.debugger.flash.messages.out.OutSetVariable;
import com.jpexs.debugger.flash.messages.out.OutStepContinue;
import com.jpexs.debugger.flash.messages.out.OutStepInto;
import com.jpexs.debugger.flash.messages.out.OutStepOut;
import com.jpexs.debugger.flash.messages.out.OutStepOver;
import com.jpexs.debugger.flash.messages.out.OutStopDebug;
import com.jpexs.debugger.flash.messages.out.OutSwfInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DebuggerCommands {
    private DebuggerConnection connection;

    public DebuggerConnection getConnection() {
        return this.connection;
    }

    public DebuggerCommands(DebuggerConnection connection) {
        this.connection = connection;
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void stepInto() throws IOException {
        this.connection.sendMessage(new OutStepInto(this.connection), InContinue.class);
    }

    public void stepOut() throws IOException {
        this.connection.sendMessage(new OutStepOut(this.connection), InContinue.class);
    }

    public void stepOver() throws IOException {
        this.connection.sendMessage(new OutStepOver(this.connection), InContinue.class);
    }

    public void stepContinue() throws IOException {
        this.connection.sendMessage(new OutStepContinue(this.connection), InContinue.class);
    }

    public List<InGetFncNames.FunctionName> getFunctionNames(int file, int line) throws IOException {
        if (this.connection.playerVersion >= 9) {
            InGetFncNames ifn = this.connection.sendMessage(new OutGetFncNames(this.connection, file, line), InGetFncNames.class);
            return ifn.names;
        }
        return null;
    }

    public boolean removeBreakPoint(int file, int line) throws IOException {
        this.connection.writeMessage(new OutRemoveBreakpoints(this.connection, file, line));
        return true;
    }

    public byte[] getActions(int swfIndex, int offset, int length) throws IOException {
        InGetActions iga = this.connection.sendMessage(new OutGetActions(this.connection, swfIndex, offset, length), InGetActions.class);
        return iga.actionData;
    }

    public List<InSwfInfo.SwfInfo> getSwfInfo(int swfIndex) throws IOException {
        InSwfInfo isi = this.connection.sendMessage(new OutSwfInfo(this.connection, swfIndex), InSwfInfo.class);
        return isi.swfInfos;
    }

    public void exit(boolean requestTerminate) throws IOException {
        this.connection.writeMessage(new OutExit(this.connection, requestTerminate));
    }

    public void sendContinue() throws IOException {
        this.connection.sendMessageIgnoreResult(new OutContinue(this.connection), InContinue.class);
    }

    public InSetBreakpoint addBreakPoints(List<Integer> files, List<Integer> lines) throws IOException {
        return this.connection.sendMessage(new OutSetBreakpoints(this.connection, files, lines), InSetBreakpoint.class);
    }

    public boolean addBreakPoint(int file, int line) throws IOException {
        ArrayList<Integer> files = new ArrayList<Integer>();
        ArrayList<Integer> lines = new ArrayList<Integer>();
        files.add(file);
        lines.add(line);
        InSetBreakpoint bp = this.addBreakPoints(files, lines);
        for (int i = 0; i < bp.lines.size(); ++i) {
            if (bp.files.get(i) != file || bp.lines.get(i) != line) continue;
            return true;
        }
        return false;
    }

    public InConstantPool getConstantPool(int poolId) throws IOException {
        return this.connection.sendMessage(new OutConstantPool(this.connection, poolId), InConstantPool.class);
    }

    public InFrame getFrame(int depth) throws IOException {
        if (!this.connection.squelchEnabled) {
            return null;
        }
        return this.connection.sendMessage(new OutGetFrame(this.connection, depth), InFrame.class);
    }

    public InCallFunction callFunction(boolean isConstructor, String funcName, String thisType, String thisValue, List<String> argTypes, List<String> argValues) throws IOException {
        return this.connection.sendMessage(new OutCallFunction(this.connection, isConstructor, funcName, thisType, thisValue, argTypes, argValues), InCallFunction.class);
    }

    public InGetVariable getVariable(long id, String name, boolean fireGetter, boolean getChildrenToo) throws IOException {
        int flags = 4;
        if (fireGetter) {
            flags |= 1;
        }
        if (getChildrenToo) {
            flags |= 0xA;
        }
        return this.connection.sendMessage(fireGetter ? new OutGetVariableWhichInvokesGetter(this.connection, id, name, flags) : new OutGetVariable(this.connection, id, name, flags), InGetVariable.class);
    }

    public void setVariable(long id, String name, int type, String value) throws IOException {
        this.squelch(false);
        OutSetVariable osv = new OutSetVariable(this.connection, id, name, Variable.typeNameFor(type), value);
        if (type == 2) {
            InSetVariable inSetVariable = this.connection.sendMessage(osv, InSetVariable.class);
        } else {
            InSetVariable2 inSetVariable2 = this.connection.sendMessage(osv, InSetVariable2.class);
        }
        this.squelch(true);
    }

    public boolean squelch(boolean on) throws IOException {
        InSquelch isq = this.connection.sendMessage(new OutSetSquelch(this.connection, on), InSquelch.class);
        return isq.state;
    }

    public Watch addWatch(long varId, String memberName, int flags, int tag) throws IOException {
        InWatch2 iw2 = this.connection.sendMessage(new OutAddWatch2(this.connection, varId, memberName, flags, tag), InWatch2.class);
        if (iw2.success > 0) {
            return new Watch(memberName, varId, tag, iw2.flags);
        }
        return null;
    }

    public boolean removeWatch(long varId, String memberName) throws IOException {
        InWatch2 iw2 = this.connection.sendMessage(new OutRemoveWatch2(this.connection, varId, memberName), InWatch2.class);
        return iw2.success == 1;
    }

    public void setActiveIsolate(long isolate) throws IOException {
        this.connection.writeMessage(new OutSetActiveIsolate(this.connection, isolate));
    }

    public void setOption(String name, String value) throws IOException {
        InOption io = this.connection.sendMessage(new OutSetOption(this.connection, name, value), InOption.class);
    }

    public String getOption(String name, String defaultValue) throws IOException {
        InOption io = this.connection.sendMessage(new OutGetOption(this.connection, name), InOption.class);
        String v = io.v;
        if (v.isEmpty()) {
            return defaultValue;
        }
        return v;
    }

    public void debuggerSetWideLine() throws IOException {
        this.setOption("wide_line_debugger", "on");
    }

    public boolean playerIsWideLine() throws IOException {
        return this.getOption(InOption.OPTION_WIDE_LINE_PLAYER, "off").equals("on");
    }

    public boolean playerCanCallFunctions() throws IOException {
        return this.getOption(InOption.OPTION_CAN_CALL_FUNCTIONS, "off").equals("on");
    }

    public boolean playerConcurrency() throws IOException {
        return this.getOption(InOption.OPTION_CONCURRENT_PLAYER, "off").equals("on");
    }

    public boolean playerCanBreakOnAllExceptions() throws IOException {
        return this.getOption(InOption.OPTION_CAN_BREAK_ON_ALL_EXCEPTIONS, "off").equals("on");
    }

    public boolean playerCanTerminate() throws IOException {
        return this.getOption(InOption.OPTION_CAN_TERMINATE, "off").equals("on");
    }

    public boolean playerSupportsWatchpoints() throws IOException {
        return this.getOption(InOption.OPTION_CAN_SET_WATCHPOINTS, "off").equals("on");
    }

    public void stopWarning() throws IOException {
        this.setOption("disable_script_stuck_dialog", "on");
        this.setOption("disable_script_stuck", "on");
    }

    public void setOption(String name, boolean val) throws IOException {
        this.setOption(name, val ? "on" : "off");
    }

    public void setStopOnFault() throws IOException {
        this.setOption("break_on_fault", true);
    }

    public void setEnumerateOverride() throws IOException {
        this.setOption("enumerate_override", true);
    }

    public void setNotifyFailure() throws IOException {
        this.setOption("notify_on_failure", true);
    }

    public void setInvokeSetters() throws IOException {
        this.setOption("invoke_setters", true);
    }

    public void setSwfLoadNotify() throws IOException {
        this.setOption("swf_load_messages", true);
    }

    public void consoleErrorsAsTrace(boolean on) throws IOException {
        this.setOption("console_errors", on);
    }

    public void setGetterTimeout(int timeout) throws IOException {
        this.setOption("getter_timeout", "" + timeout);
    }

    public void setSetterTimeout(int timeout) throws IOException {
        this.setOption("setter_timeout", "" + timeout);
    }

    public boolean suspend() throws IOException {
        for (int tries = 30; tries > 0; --tries) {
            InBreakAtExt iba = this.connection.sendMessageWithTimeout(new OutStopDebug(this.connection), InBreakAtExt.class);
            if (iba == null) continue;
            return true;
        }
        return false;
    }

    public static class Watch {
        public String varName;
        public long varId;
        public int tag;
        public int flags;

        public Watch(String varName, long varId, int tag, int flags) {
            this.varName = varName;
            this.varId = varId;
            this.tag = tag;
            this.flags = flags;
        }
    }
}

