/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.xar.nodes;

import com.jpexs.xar.Xar;
import com.jpexs.xar.checksum.CheckSum;
import com.jpexs.xar.encoding.Encoding;
import com.jpexs.xar.nodes.DirectoryNode;
import com.jpexs.xar.nodes.FileNode;
import com.jpexs.xar.nodes.SymLinkNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;

public abstract class Node {
    Formatter FMT = new Formatter();
    public int id;
    public String name;
    public Map<String, Node> subnodes = new TreeMap<String, Node>();
    public long ctime;
    public long mtime;
    public long atime;
    public int gid;
    public int uid;
    public int mode;
    public String userName;
    public String group;
    public String type;

    public Node(int id, String name, String type) {
        this.id = id;
        this.ctime = -1L;
        this.mtime = -1L;
        this.atime = -1L;
        this.mode = -1;
        this.group = null;
        this.userName = null;
        this.gid = -1;
        this.uid = -1;
        this.name = name;
        this.type = type;
    }

    public Node(int id, String name, String type, long ctime, long mtime, long atime, int mode, String group, int gid, String user, int uid) {
        this.id = id;
        this.name = name;
        this.userName = user;
        this.group = group;
        this.gid = gid;
        this.uid = uid;
        this.ctime = ctime;
        this.mtime = mtime;
        this.atime = atime;
        this.mode = mode;
        this.type = type;
    }

    protected String basicInfo() {
        return (this.ctime > -1L ? "<ctime>" + Xar.DATE_FORMAT.format(new Date(this.ctime)) + "</ctime>" : "") + (this.mtime > -1L ? "<mtime>" + Xar.DATE_FORMAT.format(new Date(this.mtime)) + "</mtime>" : "") + (this.atime > -1L ? "<atime>" + Xar.DATE_FORMAT.format(new Date(this.atime)) + "</atime>" : "") + (this.group != null ? "<group>" + this.group + "</group>" : "") + (this.gid > -1 ? "<gid>" + this.gid + "</gid>" : "") + (this.userName != null ? "<user>" + this.userName + "</user>" : "") + (this.uid > -1 ? "<uid>" + this.uid + "</uid>" : "") + (this.mode > -1 ? "<mode>" + this.FMT.format("%04o", this.mode) + "</mode>" : "") + "<type>" + this.type + "</type>" + "<name>" + this.name + "</name>";
    }

    public static Node getInstance(String name, File file, CheckSum checksum, Encoding encoding) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        long ctime = attrs.creationTime().toMillis();
        long mtime = attrs.lastModifiedTime().toMillis();
        long atime = attrs.lastAccessTime().toMillis();
        if (attrs.isSymbolicLink()) {
            String linkTarget = Files.readSymbolicLink(file.toPath()).toFile().getAbsolutePath();
            return new SymLinkNode(name, file.isDirectory() ? "directory" : "file", linkTarget, ctime, mtime, atime, -1, null, -1, null, -1);
        }
        if (file.isDirectory()) {
            return new DirectoryNode(name, ctime, mtime, atime, -1, null, -1, null, -1);
        }
        return new FileNode(name, new FileInputStream(file), encoding, checksum, ctime, mtime, atime, -1, null, -1, null, -1);
    }
}

