/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.xar.nodes;

import com.jpexs.xar.Xar;
import com.jpexs.xar.checksum.CheckSum;
import com.jpexs.xar.encoding.Encoding;
import com.jpexs.xar.nodes.Node;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileNode
extends Node {
    public byte[] data;
    public byte[] compressedData;
    public int length;
    public int size;
    public String encodingStyle;
    public long offset;
    public String archivedChecksum = "";
    public String extractedChecksum = "";
    public String cksum_alg;

    public String toString() {
        return "<file id=\"" + this.id + "\">" + "<data>" + "<length>" + this.length + "</length>" + "<encoding style=\"" + this.encodingStyle + "\" />" + "<offset>" + this.offset + "</offset>" + "<size>" + this.size + "</size>" + "<archived-checksum style=\"" + this.cksum_alg + "\">" + this.archivedChecksum + "</archived-checksum>" + "<extracted-checksum style=\"" + this.cksum_alg + "\">" + this.extractedChecksum + "</extracted-checksum>" + "</data>" + this.basicInfo() + "</file>";
    }

    public FileNode(String name, InputStream is, Encoding encoding, CheckSum checksum, long ctime, long mtime, long atime, int mode, String group, int gid, String user, int uid) throws IOException {
        super(-1, name, "file", ctime, mtime, atime, mode, group, gid, user, uid);
        int cnt;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((cnt = is.read(buf)) > 0) {
            baos.write(buf, 0, cnt);
        }
        is.close();
        this.init(baos.toByteArray(), null, encoding, checksum, 0L);
    }

    public FileNode(String name, byte[] data, byte[] compressedData, Encoding encoding, CheckSum checksum, long offset) {
        this(name, data, compressedData, encoding, checksum, offset, -1L, -1L, -1L, -1, null, -1, null, -1);
    }

    private void init(byte[] data, byte[] compressedData, Encoding encoding, CheckSum checksum, long offset) {
        ByteArrayOutputStream baos;
        if (data == null) {
            baos = new ByteArrayOutputStream();
            InputStream is = new ByteArrayInputStream(compressedData);
            try {
                int cnt;
                is = encoding.decodeInputStream(is);
                byte[] buf = new byte[1024];
                while ((cnt = is.read(buf)) > 0) {
                    baos.write(buf, 0, cnt);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            data = baos.toByteArray();
        }
        this.data = data;
        if (compressedData == null) {
            baos = new ByteArrayOutputStream();
            OutputStream os = baos;
            try {
                os = encoding.encodeOutputStream(os);
                os.write(data);
                os.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            compressedData = baos.toByteArray();
        }
        this.encodingStyle = encoding.getName();
        this.compressedData = compressedData;
        this.cksum_alg = checksum.getName();
        this.offset = offset;
        this.length = compressedData.length;
        this.size = data.length;
        this.archivedChecksum = Xar.byteToHex(checksum.checkSum(compressedData));
        this.extractedChecksum = Xar.byteToHex(checksum.checkSum(data));
    }

    public FileNode(String name, byte[] data, byte[] compressedData, Encoding encoding, CheckSum checksum, long offset, long ctime, long mtime, long atime, int mode, String group, int gid, String user, int uid) {
        super(-1, name, "file", ctime, mtime, atime, mode, group, gid, user, uid);
        this.init(data, compressedData, encoding, checksum, offset);
    }
}

